/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.common.iface.LTSOutput;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import synthesis.BasicMSC;
import synthesis.FSPLabel;
import synthesis.Instance;
import synthesis.MyOutput;
import synthesis.Node;
import synthesis.Specification;

public class ControllerSynthesiser {
    private static final String SYSNAME = "ImpliedScenarioProperty";
    private static final String SYSVERSION = "v3.0";
    private boolean Error = false;

    public int synthesise(Specification S, MyOutput OutStream, String ControllerName, LTSOutput o) throws Exception {
        return this.BuildFSP(S, OutStream, ControllerName, o);
    }

    private int BuildFSP(Specification S, MyOutput Out, String ControllerName, LTSOutput o) throws Exception {
        boolean dbg = false;
        boolean dbg2 = false;
        HashSet Nodes = new HashSet();
        HashMap Transitions = new HashMap();
        HashMap<Integer, String> Components = new HashMap<Integer, String>();
        Iterator ItComponents = S.components().iterator();
        int CompId = 0;
        while (ItComponents.hasNext()) {
            String CompName = (String)ItComponents.next();
            Components.put(new Integer(CompId), CompName);
            if (dbg2) {
                o.outln(String.valueOf(CompId) + "-" + CompName);
            }
            ++CompId;
        }
        Node Init = this.BuildLTS(Nodes, Transitions, S, Components, o);
        if (dbg) {
            o.outln("Number of Nodes:" + Nodes.size());
        }
        int Size = Nodes.size();
        HashMap<Node, Integer> NodeIds = new HashMap<Node, Integer>();
        Iterator<Object> ItNodes = Nodes.iterator();
        int a = 1;
        while (ItNodes.hasNext()) {
            Node Aux = (Node)ItNodes.next();
            NodeIds.put(Aux, new Integer(a));
            ++a;
        }
        Out.println("Coordinator = N" + NodeIds.get(Init) + ",");
        ItNodes = Transitions.keySet().iterator();
        while (ItNodes.hasNext()) {
            Node N = (Node)ItNodes.next();
            Iterator ItTransitions = ((Set)Transitions.get(N)).iterator();
            if (!ItTransitions.hasNext()) {
                Out.print("N" + NodeIds.get(N) + " = STOP");
            } else {
                Out.print("N" + NodeIds.get(N) + " = (");
                while (ItTransitions.hasNext()) {
                    Vector t = (Vector)ItTransitions.next();
                    FSPLabel l = new FSPLabel();
                    l.setComponentLabel((String)Components.get(t.get(0)));
                    Out.print("s_" + l.getLabel() + "_" + ((BasicMSC)t.get((int)1)).name + " -> N" + NodeIds.get((Node)t.get(2)));
                    if (!ItTransitions.hasNext()) continue;
                    Out.print("|");
                }
                Out.print(")");
            }
            if (ItNodes.hasNext()) {
                Out.println(",");
                continue;
            }
            Out.println(".");
        }
        return Size;
    }

    private Node BuildLTS(Set Nodes, Map Transitions, Specification S, Map Components, LTSOutput o) throws Exception {
        boolean dbg = false;
        boolean dbg2 = false;
        boolean benchmark = false;
        FileOutputStream fout = null;
        PrintStream BenchOut = null;
        if (benchmark) {
            fout = new FileOutputStream("benchmark.csv");
            BenchOut = new PrintStream(fout);
        }
        HashMap Remaining = new HashMap();
        int NodeId = 0;
        BasicMSC BInit = null;
        BasicMSC Aux = null;
        BInit = new BasicMSC();
        BInit.name = "BInit";
        Iterator ItComps = S.components().iterator();
        while (ItComps.hasNext()) {
            BInit.addInstance((String)ItComps.next(), new Instance());
        }
        Aux = BInit;
        if (dbg) {
            o.outln("Configure Init");
        }
        Node Init = new Node(S.components().size(), Aux);
        Init.Id = NodeId++;
        Nodes.add(Init);
        int MaxHistoryLength = 0;
        MaxHistoryLength = this.addToRemaining(Remaining, Init, MaxHistoryLength);
        Node N = this.getNextFromRemaining(Remaining, MaxHistoryLength);
        while (N != null) {
            int numConts = 0;
            if (dbg) {
                o.outln("Nodes = " + Nodes.size() + " Remaining = " + Remaining.size() + " Nodes in Transitions = " + Transitions.keySet().size());
            }
            if (dbg2) {
                o.outln("Processing node:" + N.Id);
            }
            int c = 0;
            while (c < S.components().size()) {
                if (dbg) {
                    o.outln("Looking at component " + Components.get(new Integer(c)));
                }
                HashSet<Node> NewNodes = new HashSet<Node>();
                if (!N.isFirst(c)) {
                    if (dbg) {
                        o.outln("No pica en punta");
                    }
                    Node M = N.Clone();
                    M.Id = NodeId++;
                    if (M.Move(c, Components, BenchOut, o)) {
                        Node aux;
                        Node ShortM = M.eliminateLoop(o);
                        if (ShortM != null) {
                            M = ShortM;
                        }
                        if ((aux = this.AlreadyExists(Nodes, M, Components, o)) == null) {
                            NewNodes.add(M);
                        } else {
                            NewNodes.add(aux);
                        }
                    }
                } else {
                    BasicMSC b;
                    if (dbg) {
                        o.outln("Looking at continuations");
                    }
                    Set Continuations = (b = N.getLocation(c)) == BInit ? S.getContinuationsInit() : S.getContinuations(b);
                    Iterator ItContinuations = Continuations.iterator();
                    while (ItContinuations.hasNext()) {
                        BasicMSC NextB = (BasicMSC)ItContinuations.next();
                        if (dbg) {
                            o.outln("Cloning");
                        }
                        Node M = N.Clone();
                        M.Id = NodeId++;
                        if (dbg) {
                            o.outln("Moving");
                        }
                        if (M.Move(c, NextB, Components, BenchOut, o)) {
                            Node aux;
                            Node ShortM = M.eliminateLoop(o);
                            if (ShortM != null) {
                                M = ShortM;
                            }
                            if ((aux = this.AlreadyExists(Nodes, M, Components, o)) == null) {
                                NewNodes.add(M);
                            } else {
                                NewNodes.add(aux);
                            }
                        }
                        if (!dbg) continue;
                        o.outln("Moved");
                    }
                }
                if (dbg) {
                    o.outln("Size of NewNodes = " + NewNodes.size());
                }
                Iterator ItNewNodes = NewNodes.iterator();
                while (ItNewNodes.hasNext()) {
                    Node M = (Node)ItNewNodes.next();
                    if (!Nodes.contains(M)) {
                        Nodes.add(M);
                        if (dbg) {
                            M.print(o);
                        }
                        MaxHistoryLength = this.addToRemaining(Remaining, M, MaxHistoryLength);
                    }
                    ++numConts;
                    this.AddTransition(Transitions, N, M, c, M.getLocation(c), o);
                }
                ++c;
            }
            this.RemoveFromRemaining(N, Remaining, MaxHistoryLength);
            N = this.getNextFromRemaining(Remaining, MaxHistoryLength);
        }
        if (benchmark) {
            BenchOut.close();
            fout.close();
        }
        return Init;
    }

    private Node AlreadyExists(Set Nodes, Node ShortM, Map Components, LTSOutput o) {
        boolean dbg = false;
        if (dbg) {
            o.outln("");
        }
        if (dbg) {
            o.outln("!!!Looking for replacement of :" + ShortM.Id);
        }
        if (dbg) {
            ShortM.print(o);
        }
        Iterator I = Nodes.iterator();
        while (I.hasNext()) {
            Node N = (Node)I.next();
            if (!ShortM.Equals(N)) continue;
            return N;
        }
        return null;
    }

    private void RemoveFromRemaining(Node N, Map Remaining, int MaxHistoryLength) {
        int i = 0;
        while (i <= MaxHistoryLength) {
            Set RemSet;
            Integer IntI = new Integer(i);
            if (Remaining.keySet().contains(IntI) && (RemSet = (Set)Remaining.get(IntI)).contains(N)) {
                RemSet.remove(N);
                return;
            }
            ++i;
        }
    }

    private int addToRemaining(Map Remaining, Node N, int MaxHistoryLength) {
        int Size = N.SizeOfDestiny();
        Integer IntSize = new Integer(Size);
        Set<Node> RemSet = null;
        if (Remaining.keySet().contains(IntSize)) {
            RemSet = (Set)Remaining.get(IntSize);
        } else {
            RemSet = new HashSet();
            if (MaxHistoryLength < Size) {
                MaxHistoryLength = Size;
            }
            Remaining.put(IntSize, RemSet);
        }
        RemSet.add(N);
        return MaxHistoryLength;
    }

    private Node getNextFromRemaining(Map Remaining, int MaxHistoryLength) {
        int i = 0;
        while (i <= MaxHistoryLength) {
            Set RemSet;
            Iterator It;
            Integer IntI = new Integer(i);
            if (Remaining.keySet().contains(IntI) && (It = (RemSet = (Set)Remaining.get(IntI)).iterator()).hasNext()) {
                return (Node)It.next();
            }
            ++i;
        }
        return null;
    }

    private void AddTransition(Map T, Node N, Node M, int c, BasicMSC b, LTSOutput o) {
        if (!T.keySet().contains(N)) {
            T.put(N, new HashSet());
        }
        if (!T.keySet().contains(M)) {
            T.put(M, new HashSet());
        }
        Set S = (Set)T.get(N);
        Vector<Object> v = new Vector<Object>(4);
        v.add(0, new Integer(c));
        v.add(1, b);
        v.add(2, M);
        S.add(v);
    }
}

