/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.common.iface.LTSOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import synthesis.ConditionEvent;
import synthesis.Event;
import synthesis.Instance;
import synthesis.MyOutput;
import synthesis.StringSet;

public class LTS {
    private HashMap delta;
    private Vector Inputs;
    private int max;
    private Integer actual;
    private int totalTransitions;

    public LTS() {
        this.max = 100;
        this.delta = new HashMap();
        this.totalTransitions = 0;
    }

    public void print(MyOutput Out) {
        Iterator I = this.delta.keySet().iterator();
        while (I.hasNext()) {
            Integer from = (Integer)I.next();
            Iterator J = ((Set)this.delta.get(from)).iterator();
            while (J.hasNext()) {
                Vector v = (Vector)J.next();
                Out.println(String.valueOf(from.toString()) + "--" + (String)v.get(0) + "->" + ((Integer)v.get(1)).toString());
            }
        }
    }

    public void print(LTSOutput Out) {
        Iterator I = this.delta.keySet().iterator();
        while (I.hasNext()) {
            Integer from = (Integer)I.next();
            Iterator J = ((Set)this.delta.get(from)).iterator();
            while (J.hasNext()) {
                Vector v = (Vector)J.next();
                Out.outln(String.valueOf(from.toString()) + "--" + (String)v.get(0) + "->" + ((Integer)v.get(1)).toString());
            }
        }
    }

    public LTS(int s) {
        this.max = s;
        this.delta = new HashMap();
        this.Inputs = new Vector(s);
        this.actual = new Integer(0);
        this.totalTransitions = 0;
        this.delta.put(this.actual, new HashSet());
        this.Inputs.add(0, new Integer(0));
        int i = 1;
        while (i < this.max) {
            Integer Aux = new Integer(i);
            this.delta.put(Aux, new HashSet());
            this.Inputs.add(i, new Integer(0));
            ++i;
        }
    }

    public Integer getState(int i) {
        return this.getKey(i);
    }

    private Integer getKey(int i) {
        boolean found = false;
        Integer retVal = null;
        Iterator I = this.delta.keySet().iterator();
        while (I.hasNext() && !found) {
            retVal = (Integer)I.next();
            boolean bl = found = retVal == i;
        }
        if (found) {
            return retVal;
        }
        return null;
    }

    public void addTransition(int from, String lbl, int to) {
        Integer i = this.getKey(from);
        Integer j = this.getKey(to);
        Vector<Object> v = new Vector<Object>(3);
        v.add(0, lbl);
        v.add(1, j);
        v.add(2, i);
        HashSet s = (HashSet)this.delta.get(i);
        s.add(v);
        int Aux = (Integer)this.Inputs.get(to);
        this.Inputs.set(to, new Integer(Aux + 1));
        ++this.totalTransitions;
    }

    public int numberOfTransitions() {
        return this.totalTransitions;
    }

    public void reset() {
        this.actual = this.getKey(0);
    }

    public boolean step(String lbl) {
        Iterator I = ((Set)this.delta.get(this.actual)).iterator();
        boolean found = false;
        Vector v = null;
        while (I.hasNext() && !found) {
            v = (Vector)I.next();
            found = ((String)v.get(0)).equals(lbl);
        }
        if (found) {
            this.actual = (Integer)v.get(1);
            return true;
        }
        return false;
    }

    public boolean step(String lbl, Integer i) {
        Iterator I = ((Set)this.delta.get(this.actual)).iterator();
        boolean found = false;
        Vector v = null;
        while (I.hasNext() && !found) {
            v = (Vector)I.next();
            boolean bl = found = ((String)v.get(0)).equals(lbl) && (Integer)v.get(1) == i;
        }
        if (found) {
            this.actual = (Integer)v.get(1);
            return true;
        }
        return false;
    }

    public void step(Vector v) {
        this.actual = (Integer)v.get(1);
    }

    public boolean run(Vector trace) {
        return this.run_oc(trace, 0);
    }

    private boolean run_oc(Vector trace, int pos) {
        boolean moved;
        Iterator i = this.enabledTransitions().iterator();
        Integer RememberActual = this.actual;
        if (pos == trace.size()) {
            moved = true;
        } else {
            moved = false;
            while (i.hasNext() && !moved) {
                if (RememberActual != this.actual) {
                    this.setActual(RememberActual);
                }
                if (!(moved = this.step((String)trace.get(pos), (Integer)((Vector)i.next()).get(1)))) continue;
                boolean bl = moved = moved && this.run_oc(trace, pos + 1);
            }
        }
        return moved;
    }

    public Set getStates() {
        return this.delta.keySet();
    }

    public void setActual(Integer a) {
        this.actual = a;
    }

    private Integer getActual() {
        return this.actual;
    }

    public int getActualState() {
        return this.getActual();
    }

    public Set enabledTransitions() {
        return (Set)this.delta.get(this.actual);
    }

    public int numberOfInputs(int s) {
        return (Integer)this.Inputs.get(s);
    }

    public int numberOfOutputs(int s) {
        try {
            return ((Set)this.delta.get(this.getKey(s))).size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public Map pathsWithNoMoreThanNCycles(int MAX, LTSOutput o) {
        this.reset();
        return this.pathsWithNoMoreThanNCycles(this.actual, MAX, o);
    }

    public Map pathsWithNoMoreThanNCycles(Integer node, int MAX, LTSOutput o) {
        boolean dbg = true;
        HashMap Paths = new HashMap();
        if (dbg) {
            o.outln("Generating paths without cycles");
        }
        Paths.put(new Vector(), "");
        while (this.extendPathsWithNoMoreThanNCycles(Paths, node, MAX, o)) {
            if (!dbg) continue;
            o.outln("Extended paths");
        }
        if (dbg) {
            Iterator I = Paths.keySet().iterator();
            while (I.hasNext()) {
                Vector Path2 = (Vector)I.next();
                String line = "Path:";
                int i = 0;
                while (i < Path2.size()) {
                    line = String.valueOf(line) + (String)((Vector)Path2.get(i)).get(0) + ", ";
                    ++i;
                }
                line = ((String)Paths.get(Path2)).equals("Loop") ? String.valueOf(line) + ": LOOP" : String.valueOf(line) + ": Deadlock";
                o.outln(line);
            }
        }
        return Paths;
    }

    public void pathCovers(HashSet Paths) {
        HashSet Covered = new HashSet();
        Vector initialTrace = new Vector();
        Paths.add(initialTrace);
        while (this.extendCoverTraces(Covered, Paths)) {
        }
    }

    private Set ExtendPrefix(Set Paths, Set Prefixes) {
        Iterator I = Paths.iterator();
        while (I.hasNext()) {
            Vector LastStep;
            Integer Last;
            Vector trace = (Vector)I.next();
            if (trace.size() == 0) {
                this.reset();
                Last = this.actual;
            } else {
                LastStep = (Vector)trace.get(trace.size() - 1);
                Last = (Integer)LastStep.get(1);
            }
            HashSet<Vector> Covered = new HashSet<Vector>();
            boolean TriedEverything = false;
            while (!TriedEverything && Prefixes.contains(Last)) {
                Iterator J = ((Set)this.delta.get(Last)).iterator();
                boolean Extended = false;
                while (J.hasNext() && !Extended) {
                    Vector v = (Vector)J.next();
                    if (Covered.contains(v)) continue;
                    Covered.add(v);
                    Extended = true;
                    trace.add(trace.size(), v);
                }
                if (!J.hasNext()) {
                    TriedEverything = true;
                }
                LastStep = (Vector)trace.get(trace.size() - 1);
                Last = (Integer)LastStep.get(1);
            }
        }
        return Paths;
    }

    private boolean extendCoverTraces(Set Covered, Set Paths) {
        boolean found = false;
        Vector v = null;
        Vector Copy = null;
        boolean extended = false;
        Iterator I = Paths.iterator();
        while (I.hasNext() && !extended) {
            Integer Last;
            Vector trace = (Vector)I.next();
            if (trace.size() == 0) {
                this.reset();
                Last = this.actual;
            } else {
                Vector LastStep = (Vector)trace.get(trace.size() - 1);
                Last = (Integer)LastStep.get(1);
            }
            Iterator J = ((Set)this.delta.get(Last)).iterator();
            while (J.hasNext()) {
                v = (Vector)J.next();
                if (Covered.contains(v)) continue;
                extended = true;
                Covered.add(v);
                if (Copy == null) {
                    Copy = (Vector)trace.clone();
                    trace.add(trace.size(), v);
                    continue;
                }
                Vector Copy2 = (Vector)Copy.clone();
                Copy2.add(Copy2.size(), v);
                Paths.add(Copy2);
            }
        }
        return extended;
    }

    private boolean extendPathsWithNoMoreThanNCycles(Map Paths, Integer initialNode, int MAX, LTSOutput o) {
        boolean extended = false;
        boolean dbg = false;
        Iterator I = Paths.keySet().iterator();
        while (I.hasNext() && !extended) {
            Integer Last;
            Vector trace = (Vector)I.next();
            if (dbg) {
                o.outln("Got a trace out of " + Paths.keySet().size());
            }
            if (((String)Paths.get(trace)).equals("Loop")) continue;
            if (dbg) {
                o.outln("Not a loop");
            }
            Vector Original = (Vector)trace.clone();
            if (trace.size() == 0) {
                Last = initialNode;
            } else {
                Vector LastStep = (Vector)trace.get(trace.size() - 1);
                Last = (Integer)LastStep.get(1);
            }
            if (dbg) {
                o.outln("Last node is:" + Last);
            }
            Iterator J = ((Set)this.delta.get(Last)).iterator();
            while (J.hasNext()) {
                Integer node;
                Vector v = (Vector)J.next();
                if (dbg) {
                    o.outln("Got a transition:" + (String)v.get(0));
                }
                if (extended) {
                    if (dbg) {
                        o.outln("Copying trace");
                    }
                    trace = (Vector)Original.clone();
                } else {
                    extended = true;
                }
                Paths.remove(trace);
                trace.add(trace.size(), v);
                if (dbg) {
                    o.outln("Added to trace");
                }
                int found = (node = (Integer)v.get(1)).intValue() == initialNode.intValue() ? 1 : 0;
                int pos = 0;
                while (pos < trace.size() && found != MAX + 1) {
                    if (node == ((Vector)trace.get(pos)).get(1)) {
                        ++found;
                    }
                    ++pos;
                }
                if (found == MAX + 1) {
                    if (dbg) {
                        o.outln("Its a loop! Looped at " + node);
                    }
                    Paths.put(trace, "Loop");
                    if (!dbg) continue;
                    o.outln("Trace is clasified as " + (String)Paths.get(trace));
                    continue;
                }
                Paths.put(trace, "");
            }
        }
        return extended;
    }

    public boolean ExtendPath(Vector trace, StringSet Accept, LTSOutput o) {
        Vector LastStep = (Vector)trace.get(trace.size() - 1);
        return this.ocExtendPath(trace, Accept, (Integer)LastStep.get(1), 0, o);
    }

    private boolean ocExtendPath(Vector trace, StringSet Accept, int StartingState, int Count, LTSOutput o) {
        Vector v = null;
        boolean found = false;
        if (++Count > 10) {
            o.outln("Supero!!");
        }
        Vector LastStep = (Vector)trace.get(trace.size() - 1);
        Integer Last = (Integer)LastStep.get(1);
        o.outln("Started in " + StartingState + ". Extending from state " + Last);
        Iterator J = ((Set)this.delta.get(Last)).iterator();
        while (J.hasNext() && !found) {
            v = (Vector)J.next();
            if (!Accept.contains((String)v.get(0))) continue;
            trace.add(trace.size(), v);
            found = true;
        }
        if (!found) {
            o.outln("Starting to backtrack");
            int Size = trace.size();
            J = ((Set)this.delta.get(Last)).iterator();
            while (J.hasNext() && !found) {
                v = (Vector)J.next();
                if (!Accept.contains((String)v.get(0)) && ((Integer)v.get(1)).intValue() == Last.intValue()) {
                    o.outln("Loop that doesn't change anything");
                    continue;
                }
                if ((Integer)v.get(1) == StartingState) {
                    o.outln("Back to the beginning");
                    continue;
                }
                trace.add(trace.size(), v);
                found = this.ocExtendPath(trace, Accept, StartingState, Count, o);
                if (found) continue;
                trace.setSize(Size);
            }
        }
        return found;
    }

    private void printTrace(Vector A) {
        System.out.println("New Trace");
        int j = 0;
        while (j < A.size()) {
            System.out.println("lbl : " + (String)((Vector)A.get(j)).get(0) + " State " + (Integer)((Vector)A.get(j)).get(1));
            ++j;
        }
    }

    public boolean getPath(Vector Path2, Instance I, int Pos, HashSet Covered, LTSOutput o) {
        boolean found;
        if (Pos < I.size()) {
            Event next = I.get(Pos);
            if (!(next instanceof ConditionEvent)) {
                found = false;
                HashSet Copy = (HashSet)Covered.clone();
                HashSet<Vector> TryLater = new HashSet<Vector>();
                Integer InitialState = this.getActual();
                int j = 1;
                while (j <= 2) {
                    Iterator Transitions = j == 1 ? this.enabledTransitions().iterator() : TryLater.iterator();
                    while (Transitions.hasNext() && !found) {
                        Vector t = (Vector)Transitions.next();
                        String lbl = (String)t.get(0);
                        if (!lbl.equals(next.getLabel())) continue;
                        if (j == 1 && Covered.contains(t)) {
                            TryLater.add(t);
                            continue;
                        }
                        this.step(t);
                        Covered.add(t);
                        found = this.getPath(Path2, I, Pos + 1, Covered, o);
                        if (found) {
                            Path2.insertElementAt(t, 0);
                            continue;
                        }
                        this.setActual(InitialState);
                        Covered.clear();
                        Covered.addAll(Copy);
                    }
                    ++j;
                }
            } else {
                found = this.getPath(Path2, I, Pos + 1, Covered, o);
            }
        } else {
            found = true;
        }
        return found;
    }
}

