/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.common.iface.LTSOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import synthesis.AltProduction;
import synthesis.BasicMSC;
import synthesis.ConditionEvent;
import synthesis.Event;
import synthesis.Grammar;
import synthesis.Instance;
import synthesis.MyOutput;
import synthesis.Production;
import synthesis.Specification;
import synthesis.StringIterator;
import synthesis.StringRelation;
import synthesis.StringSet;

public class Synthesiser {
    static final String SYSNAME = "Synthesiser (with state labels)";
    static final String SYSVERSION = "v1.3";
    static final String INIT = "Init";
    static final String FINAL = "Final";
    static final String TAU = "_tau";
    static final String ENDPREFIX = "E_";
    static final String BEGINPREFIX = "B_";
    static final String CONDPREFIX = "C_";
    boolean LateSemantics;

    public Synthesiser(boolean LS) {
        this.LateSemantics = LS;
    }

    public void synthesiseFSP(Specification S, StringBuffer FSPOut, LTSOutput ErrorOut) throws Exception {
        MyOutput Output2 = new MyOutput(FSPOut);
        long start = System.currentTimeMillis();
        Output2.println("//Automatically generated by Synthesiser (with state labels) v1.3");
        if (S != null) {
            this.getFSPSpecification(S, Output2);
            long synthesisTime = System.currentTimeMillis() - start;
            ErrorOut.outln("Total synthesis time: " + synthesisTime + " milliseconds.");
        }
    }

    public void getFSPSpecification(Specification S, MyOutput Output2) throws Exception {
        String parallelComposition = "||System = (";
        boolean first = true;
        Iterator Components = S.components().iterator();
        StringRelation CR = this.getCommonIsContinuationOfRelation(S);
        while (Components.hasNext()) {
            String name = (String)Components.next();
            if (!first) {
                parallelComposition = String.valueOf(parallelComposition) + " || ";
            } else {
                first = false;
            }
            parallelComposition = String.valueOf(parallelComposition) + name;
            Map I = S.getComponentInstances(name);
            StringRelation R = this.getIsContinuationOfRelation(CR, I);
            Set P = this.getAltProductions(this.getFSPProductions(this.getProductions(I), R));
            this.cleanUp(name, P);
            this.outputFSP(name, P, Output2);
        }
        parallelComposition = String.valueOf(parallelComposition) + ").";
        Output2.println(parallelComposition);
    }

    public void printhMSCs(MyOutput Output2, Specification S) throws Exception {
        BasicMSC B;
        String line = "deterministic DetHMSC = (";
        Iterator J = S.getContinuationsInit().iterator();
        boolean first = true;
        while (J.hasNext()) {
            B = (BasicMSC)J.next();
            if (first) {
                first = false;
            } else {
                line = String.valueOf(line) + " | ";
            }
            line = String.valueOf(line) + "init -> " + B.name;
        }
        line = String.valueOf(line) + "),";
        Output2.println(line);
        J = S.getbMSCs().iterator();
        first = true;
        while (J.hasNext()) {
            if (first) {
                first = false;
            } else {
                line = String.valueOf(line) + ",";
                Output2.println(line);
            }
            B = (BasicMSC)J.next();
            Iterator K = S.getContinuations(B).iterator();
            if (K.hasNext()) {
                line = String.valueOf(B.name) + " = (";
                boolean Kfirst = true;
                while (K.hasNext()) {
                    BasicMSC KB = (BasicMSC)K.next();
                    if (Kfirst) {
                        Kfirst = false;
                    } else {
                        line = String.valueOf(line) + " | ";
                    }
                    line = String.valueOf(line) + "_" + B.name + " -> " + KB.name;
                }
                line = String.valueOf(line) + ")";
                continue;
            }
            line = String.valueOf(B.name) + " = STOP";
        }
        line = String.valueOf(line) + ".";
        Output2.println(line);
        Output2.println("property ||HSMC = DetHMSC\\{init}.");
        String parallelComposition = "deterministic ||ComposedHMSC = (";
        first = true;
        J = S.components().iterator();
        while (J.hasNext()) {
            String name = (String)J.next();
            line = "deterministic ||Det" + name + " = DetHMSC@{";
            if (first) {
                first = false;
            } else {
                parallelComposition = String.valueOf(parallelComposition) + " || ";
            }
            parallelComposition = String.valueOf(parallelComposition) + "Det" + name;
            Map M = S.getComponentInstances(name);
            Iterator K = M.keySet().iterator();
            boolean Kfirst = true;
            while (K.hasNext()) {
                String bMSCName = (String)K.next();
                Instance I = (Instance)M.get(bMSCName);
                if (I.size() <= 0) continue;
                if (Kfirst) {
                    Kfirst = false;
                } else {
                    line = String.valueOf(line) + ", ";
                }
                line = String.valueOf(line) + "_" + bMSCName;
            }
            line = String.valueOf(line) + "}.";
            Output2.println(line);
        }
        parallelComposition = String.valueOf(parallelComposition) + ").";
        Output2.println(parallelComposition);
        Output2.println("||Check = (HSMC || ComposedHMSC).");
    }

    private Set getProductions(Map Instances) {
        HashSet<Production> retVal = new HashSet<Production>();
        Iterator Scenarios = Instances.keySet().iterator();
        Production P = new Production();
        while (Scenarios.hasNext()) {
            Event e;
            String ScenarioName = (String)Scenarios.next();
            ListIterator Events = ((Instance)Instances.get(ScenarioName)).iterator();
            if (Events.hasNext()) {
                e = (Event)Events.next();
                if (e instanceof ConditionEvent) {
                    if (e.getLabel().equals(INIT)) {
                        P.add(e.getLabel());
                    } else {
                        P.add(CONDPREFIX + e.getLabel());
                    }
                } else {
                    P.add(BEGINPREFIX + ScenarioName);
                    Events = ((Instance)Instances.get(ScenarioName)).iterator();
                }
            }
            boolean foundMessageEvents = false;
            while (Events.hasNext()) {
                e = (Event)Events.next();
                if (e instanceof ConditionEvent) {
                    if (!foundMessageEvents) {
                        P.add(TAU);
                    }
                    String SAux = e.getLabel().equals(INIT) ? e.getLabel() : CONDPREFIX + e.getLabel();
                    P.add(SAux);
                    retVal.add(P);
                    P = new Production();
                    P.add(SAux);
                    foundMessageEvents = false;
                    continue;
                }
                P.add(e.getLabel());
                foundMessageEvents = true;
            }
            if (foundMessageEvents) {
                P.add(ENDPREFIX + ScenarioName);
                retVal.add(P);
            }
            P = new Production();
        }
        return retVal;
    }

    private Set getFSPProductions(Set Productions, StringRelation IsAContinuationOf) {
        HashSet retVal = new HashSet();
        HashSet<Production> Intermediate = new HashSet<Production>();
        StringIterator FirstCont = null;
        Iterator I = Productions.iterator();
        while (I.hasNext()) {
            Production p = (Production)I.next();
            StringSet Temp = IsAContinuationOf.getImage(p.first());
            if (Temp.isEmpty()) {
                Temp = new StringSet();
                Temp.add(p.first());
                FirstCont = Temp.stringIterator();
            } else {
                FirstCont = Temp.stringIterator();
            }
            while (FirstCont.hasNext()) {
                String s = FirstCont.nextString();
                Production PAux = (Production)p.clone();
                PAux.set(0, s);
                Intermediate.add(PAux);
            }
        }
        return Intermediate;
    }

    private Set getAltProductions(Set Q) {
        HashSet<AltProduction> retVal = new HashSet<AltProduction>();
        AltProduction AP = new AltProduction("");
        Iterator Productions = Q.iterator();
        while (Productions.hasNext()) {
            Production P = (Production)Productions.next();
            Iterator AltProductions = retVal.iterator();
            boolean found = false;
            while (AltProductions.hasNext()) {
                AP = (AltProduction)AltProductions.next();
                if (!P.first().equals(AP.first)) continue;
                found = true;
                break;
            }
            if (!found) {
                AP = new AltProduction(P.first());
                AP.addAlternative(P);
                retVal.add(AP);
                continue;
            }
            found = false;
            Iterator Alternatives = AP.getAlternatives().iterator();
            while (Alternatives.hasNext()) {
                Production A = (Production)Alternatives.next();
                if (!P.equals(A)) continue;
                found = true;
                break;
            }
            if (found) continue;
            AP.addAlternative(P);
        }
        return retVal;
    }

    private void cleanUp(String ComponentName, Set AP) {
        Grammar G = new Grammar(AP, INIT);
        boolean changed = true;
        String retVal = "";
        int Cycles = 0;
        while (changed) {
            ++Cycles;
            changed = G.removeUnreachableNonTerminals();
            boolean aux = G.removeTrivialProductions();
            changed = changed || aux;
            aux = G.removeRecursiveAlternatives();
            changed = changed || aux;
            aux = G.replaceTrivialAlternatives();
            changed = changed || aux;
            aux = G.removeDuplicateAlternatives();
            changed = changed || aux;
            aux = G.removeEquivalentProductions();
            boolean bl = changed = changed || aux;
        }
    }

    private void outputFSP(String ComponentName, Set Q, MyOutput Output2) {
        boolean hasFinal = false;
        boolean hasTau = false;
        int TOTALTABS = 6;
        String TABS = "\t\t\t\t\t\t";
        int TABLENGTH = 4;
        if (this.LateSemantics) {
            Output2.print("deterministic ");
        }
        Output2.print("minimal " + ComponentName);
        Output2.print(" = Init");
        Iterator I = Q.iterator();
        while (I.hasNext()) {
            AltProduction AP = (AltProduction)I.next();
            Output2.println(",");
            Output2.print(AP.first);
            int a = 1;
            while (a < TOTALTABS - AP.first.length() / TABLENGTH) {
                Output2.print("\t");
                ++a;
            }
            Iterator A = AP.getAlternatives().iterator();
            if (A.hasNext()) {
                Output2.print(" = (");
                boolean first = true;
                while (A.hasNext()) {
                    if (first) {
                        first = false;
                    } else {
                        Output2.println(" | ");
                        Output2.print(TABS);
                    }
                    Production p = (Production)A.next();
                    int a2 = 1;
                    while (a2 < p.size()) {
                        String toprint = p.get(a2);
                        if (toprint.equals(TAU)) {
                            hasTau = true;
                        }
                        Output2.print(toprint);
                        if (a2 < p.size() - 1) {
                            Output2.print(" -> ");
                        }
                        ++a2;
                    }
                    boolean bl = hasFinal = hasFinal || p.last().equals(FINAL);
                }
                Output2.print(")");
                continue;
            }
            Output2.print("=STOP");
        }
        if (hasFinal) {
            Output2.println(",");
            Output2.print(FINAL);
            int a = 1;
            while (a < TOTALTABS - FINAL.length() / TABLENGTH) {
                Output2.print("\t");
                ++a;
            }
            Output2.println(" = (_tau->STOP)\\{_tau}.");
        } else if (hasTau) {
            Output2.println("\\{_tau}.");
        } else {
            Output2.println(".");
        }
        Output2.println("");
    }

    private StringRelation getIsContinuationOfRelation(StringRelation M, Map Instances) {
        Iterator Scenarios = Instances.keySet().iterator();
        StringRelation R = (StringRelation)M.clone();
        while (Scenarios.hasNext()) {
            String ScenarioName = (String)Scenarios.next();
            Instance I = (Instance)Instances.get(ScenarioName);
            if (I.size() > 0) {
                Event e = I.get(0);
                if (e instanceof ConditionEvent) {
                    if (e.getLabel().equals(INIT)) {
                        R.add(e.getLabel(), BEGINPREFIX + ScenarioName);
                        R.add(BEGINPREFIX + ScenarioName, e.getLabel());
                    } else {
                        R.add(CONDPREFIX + e.getLabel(), BEGINPREFIX + ScenarioName);
                        R.add(BEGINPREFIX + ScenarioName, CONDPREFIX + e.getLabel());
                    }
                }
                if (!((e = I.get(I.size() - 1)) instanceof ConditionEvent)) continue;
                if (e.getLabel().equals(INIT)) {
                    R.add(ENDPREFIX + ScenarioName, e.getLabel());
                    R.add(e.getLabel(), ENDPREFIX + ScenarioName);
                    continue;
                }
                R.add(ENDPREFIX + ScenarioName, CONDPREFIX + e.getLabel());
                R.add(CONDPREFIX + e.getLabel(), ENDPREFIX + ScenarioName);
                continue;
            }
            R.add(ENDPREFIX + ScenarioName, BEGINPREFIX + ScenarioName);
        }
        R.transitiveClosure();
        return R;
    }

    private StringRelation getCommonIsContinuationOfRelation(Specification S) {
        Map bMSCMap = this.buildBMSCRelation(S);
        StringRelation labelMap = this.buildRelation(bMSCMap, S);
        return labelMap;
    }

    private Map buildBMSCRelation(Specification S) {
        HashMap retVal = new HashMap();
        Iterator bMSCs = S.getbMSCs().iterator();
        while (bMSCs.hasNext()) {
            BasicMSC b = (BasicMSC)bMSCs.next();
            if (!retVal.containsKey(b)) {
                retVal.put(b, new HashSet());
            }
            Iterator Continuations = S.getContinuations(b).iterator();
            while (Continuations.hasNext()) {
                BasicMSC c = (BasicMSC)Continuations.next();
                if (!retVal.containsKey(c)) {
                    retVal.put(c, new HashSet());
                }
                ((Set)retVal.get(c)).add(b);
            }
        }
        return retVal;
    }

    private StringRelation buildRelation(Map M, Specification S) {
        StringRelation retVal = new StringRelation();
        Iterator Keys = M.keySet().iterator();
        while (Keys.hasNext()) {
            BasicMSC b = (BasicMSC)Keys.next();
            String s = BEGINPREFIX + b.name;
            String t = ENDPREFIX + b.name;
            retVal.add(s, s);
            retVal.add(t, t);
            Iterator mapsto = ((Set)M.get(b)).iterator();
            while (mapsto.hasNext()) {
                BasicMSC c = (BasicMSC)mapsto.next();
                retVal.add(s, ENDPREFIX + c.name);
            }
            if (!S.getContinuationsInit().contains(b)) continue;
            retVal.add(s, INIT);
        }
        this.addFinal(retVal, S);
        retVal.add(INIT, INIT);
        return retVal;
    }

    private void addFinal(StringRelation R, Specification Spec) {
        Iterator I = Spec.getContinuationsFinal().iterator();
        while (I.hasNext()) {
            BasicMSC b = (BasicMSC)I.next();
            R.add(FINAL, ENDPREFIX + b.name);
        }
    }
}

