/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mscedit.ProbabilisticTransition;
import mscedit.Transition;
import mscedit.Visitor;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class HMSC {
    private Element o_root;

    public HMSC() {
        this.o_root = new Element("hmsc");
    }

    public HMSC(Element p_root) {
        this.o_root = p_root;
    }

    public HMSC addTransition(String p_from, String p_to) {
        Element x_transition = new Element("transition");
        x_transition.addContent(new Element("from").setText(p_from));
        x_transition.addContent(new Element("to").setText(p_to));
        this.o_root.addContent(x_transition);
        return this;
    }

    public List getTransitions() {
        ArrayList<Transition> x_transitions = new ArrayList<Transition>();
        List x_elems = this.o_root.getChildren("transition");
        Iterator i = x_elems.iterator();
        while (i.hasNext()) {
            Element x_elem = (Element)i.next();
            if (this.isWeighted()) {
                x_transitions.add(new ProbabilisticTransition(x_elem));
                continue;
            }
            x_transitions.add(new Transition(x_elem));
        }
        return x_transitions;
    }

    public HMSC deleteTransition(String p_from, String p_to) {
        List x_transitions = this.o_root.getChildren("transition");
        Iterator i = x_transitions.iterator();
        while (i.hasNext()) {
            Transition x_trans = new Transition((Element)i.next());
            if (!x_trans.getFrom().equals(p_from) || !x_trans.getTo().equals(p_to)) continue;
            i.remove();
            break;
        }
        return this;
    }

    public HMSC setTransitionWeight(String p_from, String p_to, String p_weight) {
        List x_transitions = this.getTransitions();
        Iterator i = x_transitions.iterator();
        while (i.hasNext()) {
            Transition x_trans = (Transition)i.next();
            if (!x_trans.getFrom().equals(p_from) || !x_trans.getTo().equals(p_to)) continue;
            x_trans.setWeight(p_weight);
        }
        this.o_root.setAttribute("weighted", "true");
        return this;
    }

    public Element asXML() {
        return this.o_root;
    }

    public void apply(Visitor v) {
        v.caseAHMSC(this);
    }

    public void reverseTransition(String p_from, String p_to) {
        List x_transitions = this.getTransitions();
        Iterator i = x_transitions.iterator();
        while (i.hasNext()) {
            Transition x_trans = (Transition)i.next();
            if (!x_trans.getFrom().equals(p_from) || !x_trans.getTo().equals(p_to)) continue;
            x_trans.setFrom(p_to);
            x_trans.setTo(p_from);
            break;
        }
    }

    public HMSC addBMSC(String p_name, int p_x, int p_y) {
        Element x_bmsc = new Element("bmsc");
        x_bmsc.setAttribute("name", p_name);
        x_bmsc.setAttribute("x", String.valueOf(p_x));
        x_bmsc.setAttribute("y", String.valueOf(p_y));
        this.o_root.addContent(x_bmsc);
        return this;
    }

    public List getBMSCs() {
        return this.o_root.getChildren("bmsc");
    }

    public void moveBMSC(String p_name, int p_x, int p_y) {
        List x_bmscs = this.getBMSCs();
        Iterator i = x_bmscs.iterator();
        while (i.hasNext()) {
            Element x_bmsc = (Element)i.next();
            if (!x_bmsc.getAttribute("name").getValue().equals(p_name)) continue;
            x_bmsc.setAttribute("x", String.valueOf(p_x));
            x_bmsc.setAttribute("y", String.valueOf(p_y));
            break;
        }
    }

    public void renameBMSC(String p_oldname, String p_newname) {
        List x_bmscs = this.getBMSCs();
        Iterator i = x_bmscs.iterator();
        while (i.hasNext()) {
            Element x_bmsc = (Element)i.next();
            if (!x_bmsc.getAttribute("name").getValue().equals(p_oldname)) continue;
            x_bmsc.setAttribute("name", p_newname);
            break;
        }
        List x_transitions = this.getTransitions();
        Iterator i2 = x_transitions.iterator();
        while (i2.hasNext()) {
            Transition x_trans = (Transition)i2.next();
            if (x_trans.getFrom().equals(p_oldname)) {
                x_trans.setFrom(p_newname);
            }
            if (!x_trans.getTo().equals(p_oldname)) continue;
            x_trans.setTo(p_newname);
        }
    }

    public void deleteBMSC(String p_name) {
        if (p_name.equals("init")) {
            return;
        }
        List x_bmscs = this.getBMSCs();
        Iterator i = x_bmscs.iterator();
        while (i.hasNext()) {
            Element x_bmsc = (Element)i.next();
            if (!x_bmsc.getAttribute("name").getValue().equals(p_name)) continue;
            i.remove();
        }
        List x_transitions = this.o_root.getChildren("transition");
        Iterator i2 = x_transitions.iterator();
        while (i2.hasNext()) {
            Transition x_trans = new Transition((Element)i2.next());
            if (!x_trans.getFrom().equals(p_name) && !x_trans.getTo().equals(p_name)) continue;
            i2.remove();
        }
    }

    public boolean isWeighted() {
        Attribute x_weighted = this.o_root.getAttribute("weighted");
        try {
            return x_weighted != null && x_weighted.getBooleanValue();
        }
        catch (DataConversionException e) {
            return false;
        }
    }
}

