/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import mscedit.BMSCGraphic;
import mscedit.EditorCanvas;
import mscedit.Glyph;
import mscedit.HMSC;
import mscedit.Transition;
import mscedit.TransitionGraphic;
import mscedit.WeightedTransitionGraphic;
import mscedit.XMLGui;
import org.jdom.Element;

class HMSCEditorCanvas
extends EditorCanvas {
    private HMSC o_msc;
    private Vector o_bmsc_glyphs;
    private Vector o_transition_glyphs;

    public HMSCEditorCanvas() {
    }

    public HMSCEditorCanvas(XMLGui p_gui) {
        this.o_gui = p_gui;
        this.o_msc = new HMSC();
        this.rebuild();
    }

    public HMSCEditorCanvas(XMLGui p_gui, HMSC p_hmsc) {
        this.o_gui = p_gui;
        this.o_msc = p_hmsc;
        this.rebuild();
    }

    public Dimension getPreferredSize() {
        double x_scale = Glyph.getScale();
        if (this.o_bmsc_glyphs == null) {
            return new Dimension(500, 400);
        }
        if (this.o_bmsc_glyphs.size() < 5) {
            return new Dimension((int)(x_scale * 500.0), (int)(x_scale * 400.0));
        }
        if (this.o_bmsc_glyphs.size() < 12) {
            return new Dimension((int)(x_scale * 750.0), (int)(x_scale * 600.0));
        }
        return new Dimension(4000, 4000);
    }

    public HMSC getHMSC() {
        return this.o_msc;
    }

    public void fileDraw(Graphics g) {
        this.paintComponent(g);
    }

    void changeLinkName(String p_to, String p_from) {
    }

    void reverseSelectedLink() {
    }

    void negateSelectedLink() {
    }

    public void rebuild() {
        this.o_bmsc_glyphs = new Vector();
        this.o_transition_glyphs = new Vector();
        if (this.o_msc != null) {
            List x_transitions;
            List x_bmscs = this.o_msc.getBMSCs();
            if (x_bmscs != null) {
                Iterator i = x_bmscs.iterator();
                while (i.hasNext()) {
                    Element x_bmsc = (Element)i.next();
                    this.o_bmsc_glyphs.add(new BMSCGraphic(x_bmsc.getAttribute("name").getValue(), Integer.parseInt(x_bmsc.getAttribute("x").getValue()), Integer.parseInt(x_bmsc.getAttribute("y").getValue())));
                }
            }
            if ((x_transitions = this.o_msc.getTransitions()) != null) {
                Iterator i = x_transitions.iterator();
                while (i.hasNext()) {
                    Transition x_trans = (Transition)i.next();
                    String x_to = x_trans.getTo();
                    String x_from = x_trans.getFrom();
                    if (this.o_msc.isWeighted()) {
                        String x_weight = String.valueOf(x_trans.getWeight());
                        this.o_transition_glyphs.add(new WeightedTransitionGraphic(x_from, x_to, this.locate(x_from), this.locate(x_to), x_weight));
                        continue;
                    }
                    this.o_transition_glyphs.add(new TransitionGraphic(x_from, x_to, this.locate(x_from), this.locate(x_to)));
                }
            }
        }
        this.repaint();
    }

    void moveBMSC(String p_name, int p_x, int p_y) {
        this.o_msc.moveBMSC(p_name, p_x, p_y);
    }

    private Point locate(String p_name) {
        Iterator i = this.o_bmsc_glyphs.iterator();
        while (i.hasNext()) {
            BMSCGraphic x_bgr = (BMSCGraphic)i.next();
            if (!x_bgr.getName().equals(p_name)) continue;
            return x_bgr.getCentre();
        }
        return null;
    }

    public void addBMSC(String p_name, int p_x, int p_y) {
        this.o_msc.addBMSC(p_name, p_x, p_y);
    }

    void addTransition(String p_from, String p_to) {
        this.o_msc.addTransition(p_from, p_to);
        this.setCursor(new Cursor(0));
        this.rebuild();
    }

    void addInstance(String p_name) {
    }

    void addLink(String p_from, String p_to, String p_name, int p_timeindex) {
    }

    void addNegativeLink(String p_from, String p_to, String p_name, int p_timeindex) {
    }

    void delete() {
        if (this.o_selected != null && this.o_selected instanceof TransitionGraphic) {
            this.o_msc.deleteTransition(((TransitionGraphic)this.o_selected).getFrom(), ((TransitionGraphic)this.o_selected).getTo());
        } else if (this.o_selected != null && this.o_selected instanceof BMSCGraphic) {
            this.o_gui.deleteBMSC(((BMSCGraphic)this.o_selected).getName());
        }
        this.rebuild();
    }

    void deleteBMSC(String p_name) {
        this.o_msc.deleteBMSC(p_name);
    }

    void tidy() {
    }

    boolean inAddLinkMode() {
        return this.o_gui.inAddLinkMode();
    }

    void setAddLinkMode(boolean p_addlink) {
        this.o_gui.setAddLinkMode(p_addlink);
    }

    String getBMSCAt(int p_x, int p_y) {
        BMSCGraphic x_gr = this.getBMSCGraphicAt(p_x, p_y);
        if (x_gr != null) {
            return x_gr.getName();
        }
        return null;
    }

    BMSCGraphic getBMSCGraphicAt(int p_x, int p_y) {
        Iterator i = this.o_bmsc_glyphs.iterator();
        while (i.hasNext()) {
            BMSCGraphic x_bmsc_gr = (BMSCGraphic)i.next();
            if (!x_bmsc_gr.contains(p_x, p_y)) continue;
            return x_bmsc_gr;
        }
        return null;
    }

    TransitionGraphic getTransitionAt(int p_x, int p_y) {
        Iterator i = this.o_transition_glyphs.iterator();
        while (i.hasNext()) {
            TransitionGraphic x_trans_gr = (TransitionGraphic)i.next();
            if (!x_trans_gr.contains(p_x, p_y)) continue;
            return x_trans_gr;
        }
        return null;
    }

    public void paintComponent(Graphics g) {
        Glyph x_glyph;
        Graphics2D x_g2d = (Graphics2D)g;
        x_g2d.setColor(Color.white);
        x_g2d.fillRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        x_g2d.setColor(Color.black);
        Iterator i = this.o_bmsc_glyphs.iterator();
        while (i.hasNext()) {
            x_glyph = (Glyph)i.next();
            if (x_glyph == this.o_selected) {
                g.setColor(Color.red);
                x_glyph.draw(g);
                g.setColor(Color.black);
                continue;
            }
            x_glyph.draw(g);
        }
        i = this.o_transition_glyphs.iterator();
        while (i.hasNext()) {
            x_glyph = (Glyph)i.next();
            if (x_glyph == this.o_selected) {
                g.setColor(Color.red);
                x_glyph.draw(g);
                g.setColor(Color.black);
                continue;
            }
            x_glyph.draw(g);
        }
    }

    public void addWeight(String p_weight) {
        String x_from = ((TransitionGraphic)this.o_selected).getFrom();
        String x_to = ((TransitionGraphic)this.o_selected).getTo();
        this.o_msc.setTransitionWeight(x_from, x_to, p_weight);
        this.rebuild();
    }
}

