/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import synthesis.AltProduction;
import synthesis.Production;

class Grammar {
    private Set AP;
    private String InitialSymbol;

    public Grammar(Set S, String Init) {
        this.AP = S;
        this.InitialSymbol = Init;
    }

    public Set getAltProductions() {
        return this.AP;
    }

    public boolean removeUnreachableNonTerminals() {
        Iterator A;
        boolean retVal = false;
        HashSet<String> Reachable = new HashSet<String>();
        Iterator P = this.AP.iterator();
        while (P.hasNext()) {
            A = ((AltProduction)P.next()).alternatives.iterator();
            while (A.hasNext()) {
                Reachable.add(((Production)A.next()).last());
            }
        }
        P = this.AP.iterator();
        while (P.hasNext()) {
            AltProduction ap = (AltProduction)P.next();
            A = Reachable.iterator();
            boolean found = false;
            while (A.hasNext() && !found) {
                found = ap.first.equals(A.next());
            }
            if (found || ap.first.equals(this.InitialSymbol)) continue;
            P.remove();
            retVal = true;
        }
        return retVal;
    }

    public boolean removeTrivialProductions() {
        HashMap TrivialMap = new HashMap();
        Iterator P = this.AP.iterator();
        boolean retVal = false;
        while (P.hasNext()) {
            Production p;
            AltProduction ap = (AltProduction)P.next();
            if (ap.alternatives.size() != 1 || (p = (Production)ap.alternatives.iterator().next()).size() > 2) continue;
            retVal = true;
            if (!ap.first.equals(p.last())) {
                if (ap.first.equals(this.InitialSymbol)) {
                    this.renameNonTerminal(ap.first, p.last());
                    this.renameNonTerminal(p.last(), this.InitialSymbol);
                } else {
                    this.renameNonTerminal(ap.first, p.last());
                }
            }
            P.remove();
        }
        return retVal;
    }

    public boolean removeRecursiveAlternatives() {
        Iterator P = this.AP.iterator();
        boolean retVal = false;
        while (P.hasNext()) {
            AltProduction ap = (AltProduction)P.next();
            Iterator A = ap.alternatives.iterator();
            while (A.hasNext()) {
                Production p = (Production)A.next();
                if (p.size() > 2 || !ap.first.equals(p.last())) continue;
                retVal = true;
                A.remove();
            }
        }
        return retVal;
    }

    public boolean replaceTrivialAlternatives() {
        Iterator P = this.AP.iterator();
        boolean retVal = false;
        while (P.hasNext()) {
            AltProduction ap = (AltProduction)P.next();
            Iterator A = ap.alternatives.iterator();
            boolean cont = A.hasNext();
            while (cont) {
                Production p = (Production)A.next();
                if (p.size() <= 2) {
                    cont = false;
                    String s = p.last();
                    A.remove();
                    retVal = true;
                    Iterator P2 = this.AP.iterator();
                    while (P2.hasNext()) {
                        AltProduction ap2 = (AltProduction)P2.next();
                        if (!ap2.first.equals(p.last())) continue;
                        Iterator A2 = ap2.alternatives.iterator();
                        while (A2.hasNext()) {
                            ap.alternatives.add(A2.next());
                        }
                        A = ap.alternatives.iterator();
                    }
                    continue;
                }
                cont = A.hasNext();
            }
        }
        return retVal;
    }

    public boolean removeDuplicateAlternatives() {
        Iterator P = this.AP.iterator();
        boolean retVal = false;
        while (P.hasNext()) {
            AltProduction ap = (AltProduction)P.next();
            boolean aux = ap.removeDuplicateAlternatives();
            boolean bl = retVal = retVal || aux;
        }
        return retVal;
    }

    public boolean removeEquivalentProductions() {
        Iterator Q;
        Iterator P = this.AP.iterator();
        HashSet<AltProduction> Aux = new HashSet<AltProduction>();
        boolean retVal = false;
        while (P.hasNext()) {
            AltProduction ap = (AltProduction)P.next();
            Q = this.AP.iterator();
            while (Q.hasNext()) {
                AltProduction ap2 = (AltProduction)Q.next();
                if (ap == ap2 || Aux.contains(ap) || ap2.first.equals(this.InitialSymbol) || !ap.equivalentTo(ap2)) continue;
                this.renameNonTerminal(ap2.first, ap.first);
                Aux.add(ap2);
            }
        }
        Q = Aux.iterator();
        while (Q.hasNext()) {
            this.AP.remove(Q.next());
            retVal = true;
        }
        return retVal;
    }

    private void renameNonTerminal(String a, String b) {
        Iterator P = this.AP.iterator();
        while (P.hasNext()) {
            AltProduction ap = (AltProduction)P.next();
            Iterator A = ap.alternatives.iterator();
            if (ap.first.equals(a)) {
                ap.first = b;
            }
            while (A.hasNext()) {
                Production p = (Production)A.next();
                if (!p.last().equals(a)) continue;
                p.set(p.size() - 1, b);
            }
        }
    }
}

