/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.common.iface.LTSOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import synthesis.ConstraintSynthesiser;
import synthesis.ControllerSynthesiser;
import synthesis.FSPLabel;
import synthesis.ImplementationSynthesiser;
import synthesis.Instance;
import synthesis.MyOutput;
import synthesis.Specification;
import synthesis.SpecificationLoader;
import synthesis.StringSet;

public class ImpliedScenarioSynthesiser {
    private LTSOutput o;
    private Specification S = null;

    public ImpliedScenarioSynthesiser(LTSOutput _o) {
        this.o = _o;
    }

    public String run(mscedit.Specification XMLSpec) {
        boolean dbg = false;
        SpecificationLoader SL = new SpecificationLoader();
        try {
            this.S = SL.getSpecification(XMLSpec, this.o);
            if (dbg) {
                this.o.outln("Specification Loaded!");
            }
        }
        catch (Exception e) {
            this.o.outln("Error loading specification");
            return null;
        }
        StringBuffer FSPOut = new StringBuffer();
        try {
            this.synthesiseEverything(this.S, FSPOut, this.o);
            return FSPOut.toString();
        }
        catch (Exception e) {
            this.o.outln(e.toString());
            this.o.outln("Error synthesising FSP specification");
            return null;
        }
    }

    public void synthesiseEverything(Specification S, StringBuffer FSPOut, LTSOutput ErrorOut) throws Exception {
        if (S.containsConditions()) {
            throw new Exception("State labels are not allowed!");
        }
        MyOutput Output2 = new MyOutput(FSPOut);
        long start = System.currentTimeMillis();
        Output2.println("//------------------------------------------------------------------");
        Output2.println("//--------------------------- Coordinator --------------------------");
        Output2.println("//------------------------------------------------------------------");
        ControllerSynthesiser controllerGen = new ControllerSynthesiser();
        int nodes = controllerGen.synthesise(S, Output2, "Coordinator", ErrorOut);
        ErrorOut.outln("Coordinator model synthesis time: " + (System.currentTimeMillis() - start) + "ms. Nodes: " + nodes);
        start = System.currentTimeMillis();
        Output2.println("//------------------------------------------------------------------");
        Output2.println("//----------------------- Constraint Model -------------------");
        Output2.println("//------------------------------------------------------------------");
        ConstraintSynthesiser constraintGen = new ConstraintSynthesiser();
        constraintGen.printConstraints(Output2, S, "ConstraintModel", ErrorOut);
        ErrorOut.outln("Constraint model synthesis time: " + (System.currentTimeMillis() - start) + "ms.");
        start = System.currentTimeMillis();
        Output2.println("//------------------------------------------------------------------");
        Output2.println("//------------------------ Architecture Model ----------------------");
        Output2.println("//------------------------------------------------------------------");
        S.AddScenarioMessages();
        Set ScenarioMessages = S.getScenarioMessages();
        String Hide = this.BuildHide(ScenarioMessages);
        ImplementationSynthesiser gen = new ImplementationSynthesiser();
        gen.synthesise(S, Output2, "WCoordAct", "ComponentsWCoordAct", ErrorOut);
        String parallelComposition = "||ArchitectureModel = (";
        boolean first = true;
        Iterator I = S.components().iterator();
        while (I.hasNext()) {
            String name = (String)I.next();
            FSPLabel l = new FSPLabel();
            l.setComponentLabel(name);
            Output2.println("deterministic ||" + l.getLabel() + " = " + l.getLabel() + "WCoordAct\\{" + Hide + "}.");
            if (!first) {
                parallelComposition = String.valueOf(parallelComposition) + " || ";
            } else {
                first = false;
            }
            FSPLabel Fl = new FSPLabel();
            Fl.setComponentLabel(name);
            parallelComposition = String.valueOf(parallelComposition) + Fl.getLabel();
        }
        parallelComposition = String.valueOf(parallelComposition) + ").";
        Output2.println(parallelComposition);
        Output2.println("");
        S.RemoveScenarioMessages();
        ErrorOut.outln("Architecture behaviour model synthesis time: " + (System.currentTimeMillis() - start) + "ms.");
        Output2.println("//------------------------------------------------------------------");
        Output2.println("//----------------------------- Trace Model ------------------------");
        Output2.println("//------------------------------------------------------------------");
        Output2.println("deterministic ||TraceModel = (ComponentsWCoordAct || Coordinator) \\{" + Hide + "}.");
        Output2.println("//------------------------------------------------------------------");
        Output2.println("//---------------------- Properties & Checks -----------------------");
        Output2.println("//------------------------------------------------------------------");
        Output2.println("||ConstrainedArchitectureModel = (ArchitectureModel || ConstraintModel).");
        Output2.println("property ||PTraceModel= TraceModel.");
        Output2.println("property ||PConstraintModel = ConstraintModel.");
        Output2.println("||ConsistencyCheck = (TraceModel|| PConstraintModel).");
        Output2.println("||ImpliedScenarioCheck = (PTraceModel || ConstrainedArchitectureModel).");
    }

    private String BuildHide(Set Messages) {
        String S = "";
        Iterator I = Messages.iterator();
        while (I.hasNext()) {
            S = String.valueOf(S) + (String)I.next();
            if (!I.hasNext()) continue;
            S = String.valueOf(S) + ",";
        }
        return S;
    }

    public Set getMessageLabels(String p_name, mscedit.Specification p_spec, LTSOutput p_err) {
        SpecificationLoader SL = new SpecificationLoader();
        try {
            this.S = SL.getSpecification(p_spec, p_err);
        }
        catch (Exception e) {
            p_err.outln("Error loading specification");
            return null;
        }
        StringSet Msgs = new StringSet();
        Iterator I = this.S.components().iterator();
        while (I.hasNext()) {
            String instanceName = (String)I.next();
            int ColonPosition = instanceName.indexOf(":");
            if ((ColonPosition >= 0 || !instanceName.equals(p_name)) && !instanceName.substring(ColonPosition + 1).equals(p_name)) continue;
            Map Instances = new HashMap();
            try {
                Instances = this.S.getComponentInstances(instanceName);
            }
            catch (Exception e) {
                p_err.outln("Error with Component name:" + instanceName);
            }
            Iterator J = Instances.keySet().iterator();
            while (J.hasNext()) {
                String bMSC = (String)J.next();
                Instance Inst = (Instance)Instances.get(bMSC);
                Msgs.addAll(Inst.getAlphabet());
            }
        }
        return Msgs;
    }

    public String getFSPforComponent(String p_name, mscedit.Specification p_spec, LTSOutput p_err, Map PortNames) {
        SpecificationLoader SL = new SpecificationLoader();
        try {
            this.S = SL.getSpecification(p_spec, p_err);
        }
        catch (Exception e) {
            p_err.outln("Error loading specification");
            return null;
        }
        StringBuffer x_fsp = new StringBuffer();
        MyOutput Output2 = new MyOutput(x_fsp);
        ImplementationSynthesiser gen = new ImplementationSynthesiser();
        try {
            gen.printComponentClass(this.S, p_name, "", Output2, p_err, PortNames);
        }
        catch (Exception p_e) {
            p_err.outln(p_e.getMessage());
        }
        return x_fsp.toString();
    }
}

