/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.common.iface.LTSOutput;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import synthesis.AbstractNegScenario;
import synthesis.AfterUntilNegScenario;
import synthesis.BasicMSC;
import synthesis.BasicNegScenario;
import synthesis.ComponentInstanceNotFound;
import synthesis.Instance;
import synthesis.MyOutput;
import synthesis.NegScenario;
import synthesis.StringSet;

public class Specification {
    private HashSet Final = new HashSet();
    private HashSet Initial = new HashSet();
    private HashMap H = new HashMap();
    private HashMap NegScenarios = new HashMap();

    public void addbMSC(BasicMSC A) {
        if (!this.H.keySet().contains(A)) {
            this.H.put(A, new HashSet());
        }
    }

    public void addNegbMSC(String name, BasicMSC When, StringSet WScope, String disallowed, BasicMSC Until, StringSet UScope) {
        NegScenario n = Until == null ? new AbstractNegScenario(name, When, WScope, disallowed) : new AfterUntilNegScenario(name, When, WScope, disallowed, Until, UScope);
        this.NegScenarios.put(name, n);
    }

    public void addBasicNegbMSC(String name, BasicMSC precondition, String disallowed) {
        BasicNegScenario n = new BasicNegScenario(name, precondition, disallowed);
        this.NegScenarios.put(name, n);
    }

    public void addRelation(BasicMSC A, BasicMSC B) {
        if (!((Set)this.H.get(A)).contains(B)) {
            ((Set)this.H.get(A)).add(B);
        }
    }

    public void addRelationInit(BasicMSC B) {
        if (!this.Initial.contains(B)) {
            this.Initial.add(B);
        }
    }

    public void addRelationFinal(BasicMSC A) {
        if (!this.Final.contains(A)) {
            this.Final.add(A);
        }
    }

    public Set getbMSCs() {
        return this.H.keySet();
    }

    public Set getNegbMSCs() {
        return this.NegScenarios.keySet();
    }

    public NegScenario getNegbMSC(String name) {
        return (NegScenario)this.NegScenarios.get(name);
    }

    public void removebMSC(BasicMSC A) {
        this.H.remove(A);
    }

    public Set getContinuationsInit() {
        return this.Initial;
    }

    public Set getContinuationsFinal() {
        return this.Final;
    }

    public Set getContinuations(BasicMSC A) {
        return (Set)this.H.get(A);
    }

    public BasicMSC getBMsc(String S) throws Exception {
        BasicMSC retVal = new BasicMSC();
        boolean found = false;
        Iterator I = this.H.keySet().iterator();
        while (I.hasNext()) {
            retVal = (BasicMSC)I.next();
            if (!retVal.name.equals(S)) continue;
            found = true;
            break;
        }
        if (found) {
            return retVal;
        }
        throw new Exception("BMSc Not Found");
    }

    public boolean containsBMsc(String S) {
        boolean retVal = false;
        Iterator I = this.H.keySet().iterator();
        while (I.hasNext() && !retVal) {
            BasicMSC aux = (BasicMSC)I.next();
            retVal = aux.name.equals(S);
        }
        if (!retVal) {
            I = this.NegScenarios.keySet().iterator();
            while (I.hasNext() && !retVal) {
                retVal = ((String)I.next()).equals(S);
            }
        }
        return retVal;
    }

    public boolean hasSamePositiveBehaviour(Specification S, LTSOutput o) {
        try {
            boolean equivalent = true;
            equivalent = this.getbMSCs().size() == S.getbMSCs().size();
            Iterator I = this.getbMSCs().iterator();
            while (I.hasNext() && equivalent) {
                BasicMSC b1 = (BasicMSC)I.next();
                if (S.containsBMsc(b1.name)) {
                    BasicMSC b2 = S.getBMsc(b1.name);
                    equivalent = b1.isTheSameAs(b2, o);
                    if (equivalent) {
                        equivalent = this.getContinuations(b1).size() == S.getContinuations(b2).size();
                    }
                    Iterator J = this.getContinuations(b1).iterator();
                    while (J.hasNext() && equivalent) {
                        String name1 = ((BasicMSC)J.next()).name;
                        Iterator K = S.getContinuations(b2).iterator();
                        boolean found = false;
                        while (K.hasNext() && !found) {
                            String name2 = ((BasicMSC)K.next()).name;
                            found = name1.equals(name2);
                        }
                        equivalent = found;
                    }
                    continue;
                }
                equivalent = false;
            }
            Iterator J = this.getContinuationsInit().iterator();
            while (J.hasNext() && equivalent) {
                String name1 = ((BasicMSC)J.next()).name;
                Iterator K = S.getContinuationsInit().iterator();
                boolean found = false;
                while (K.hasNext() && !found) {
                    String name2 = ((BasicMSC)K.next()).name;
                    found = name1.equals(name2);
                }
                equivalent = found;
            }
            return equivalent;
        }
        catch (Exception e) {
            throw new Error();
        }
    }

    public Set components() {
        Iterator I = this.H.keySet().iterator();
        if (I.hasNext()) {
            return ((BasicMSC)I.next()).components();
        }
        return new HashSet();
    }

    public Map getComponentInstances(String name) throws Exception {
        HashMap<String, Instance> S = new HashMap<String, Instance>();
        Iterator I = this.H.keySet().iterator();
        while (I.hasNext()) {
            BasicMSC b = (BasicMSC)I.next();
            try {
                S.put(b.name, b.componentInstance(name));
            }
            catch (ComponentInstanceNotFound e) {
                throw new Exception("Component instance '" + name + "' cannot be found in bMSC '" + b.name + "'.");
            }
        }
        return S;
    }

    public boolean containsConditions() throws Exception {
        boolean Contains = false;
        Iterator I = this.H.keySet().iterator();
        while (I.hasNext() && !Contains) {
            BasicMSC b = (BasicMSC)I.next();
            Contains = b.containsConditions();
        }
        return Contains;
    }

    public void removeConditions() throws Exception {
        Iterator I = this.H.keySet().iterator();
        while (I.hasNext()) {
            BasicMSC b = (BasicMSC)I.next();
            b.removeConditions();
        }
    }

    public void checkConsistency() throws Exception {
        boolean retVal = true;
        this.consistentLabels();
        this.consistentEvents();
        this.bMSCLabels();
    }

    private Map consistentLabels() throws Exception {
        HashMap M = new HashMap();
        Iterator I = this.getbMSCs().iterator();
        while (I.hasNext()) {
            ((BasicMSC)I.next()).consistentLabels(M);
        }
        I = this.getNegbMSCs().iterator();
        while (I.hasNext()) {
            String aux = (String)I.next();
            NegScenario n = this.getNegbMSC(aux);
            if (n instanceof BasicNegScenario) {
                ((BasicNegScenario)n).precondition().consistentLabels(M);
                continue;
            }
            if (n instanceof AbstractNegScenario) {
                ((AbstractNegScenario)n).precondition().consistentLabels(M);
                continue;
            }
            if (n instanceof AfterUntilNegScenario) {
                ((AfterUntilNegScenario)n).after().consistentLabels(M);
                ((AfterUntilNegScenario)n).until().consistentLabels(M);
                continue;
            }
            throw new Exception("Unknown negative scenario");
        }
        return M;
    }

    private void bMSCLabels() throws Exception {
        Iterator I = this.getbMSCs().iterator();
        if (I.hasNext()) {
            BasicMSC B = (BasicMSC)I.next();
            Iterator J = B.components().iterator();
            while (J.hasNext()) {
                String aux = (String)J.next();
                if (!this.containsBMsc(aux)) continue;
                throw new Exception("Label " + aux + " is used for a bMSC and a message");
            }
        }
    }

    public Map getLabelMap() {
        try {
            Map M = this.consistentLabels();
            return M;
        }
        catch (Exception e) {
            return new HashMap();
        }
    }

    public StringSet alphabet() {
        StringSet L = new StringSet();
        Iterator I = this.getbMSCs().iterator();
        while (I.hasNext()) {
            ((BasicMSC)I.next()).addToAlphabet(L);
        }
        return L;
    }

    private void consistentEvents() throws Exception {
        Iterator I = this.getbMSCs().iterator();
        while (I.hasNext()) {
            ((BasicMSC)I.next()).consistentEvents();
        }
    }

    private void sameComponents() throws ComponentInstanceNotFound {
        BasicMSC B = null;
        Iterator I = this.getbMSCs().iterator();
        while (I.hasNext()) {
            if (B == null) {
                B = (BasicMSC)I.next();
                continue;
            }
            BasicMSC A = (BasicMSC)I.next();
            try {
                B.hasAllComponentsIn(A);
            }
            catch (ComponentInstanceNotFound e) {
                throw new ComponentInstanceNotFound("bMSC" + A.name + " does not contain an instance for " + e.getMessage());
            }
            try {
                A.hasAllComponentsIn(B);
            }
            catch (ComponentInstanceNotFound e) {
                throw new ComponentInstanceNotFound("bMSC" + B.name + " does not contain an instance for " + e.getMessage());
            }
        }
    }

    public void print(MyOutput Out) {
        BasicMSC b;
        Iterator I = this.getbMSCs().iterator();
        while (I.hasNext()) {
            b = (BasicMSC)I.next();
            b.print(Out);
        }
        Out.println("hmsc;");
        I = this.getContinuationsInit().iterator();
        while (I.hasNext()) {
            b = (BasicMSC)I.next();
            Out.println("Init -> " + b.name + ";");
        }
        I = this.getContinuationsFinal().iterator();
        while (I.hasNext()) {
            b = (BasicMSC)I.next();
            Out.println(String.valueOf(b.name) + " -> Stop;");
        }
        Iterator J = this.getbMSCs().iterator();
        while (J.hasNext()) {
            BasicMSC c = (BasicMSC)J.next();
            I = this.getContinuations(c).iterator();
            while (I.hasNext()) {
                b = (BasicMSC)I.next();
                Out.println(String.valueOf(c.name) + " -> " + b.name + ";");
            }
        }
        Out.println("endhmsc");
    }

    public void printLatex(StringBuffer buff) {
        BasicMSC b;
        MyOutput Out = new MyOutput(buff);
        Out.println("\\documentclass{article}");
        Out.println("\\usepackage{msc}");
        Out.println("\\begin{document}");
        Iterator I = this.getbMSCs().iterator();
        while (I.hasNext()) {
            b = (BasicMSC)I.next();
            b.printLatex(Out);
        }
        Out.println("hmsc;");
        Out.println("");
        Out.println("");
        I = this.getContinuationsInit().iterator();
        while (I.hasNext()) {
            b = (BasicMSC)I.next();
            Out.println("Init $\\Rightarrow$ " + b.name.replace('_', '.') + ";");
            Out.println("");
            Out.println("");
        }
        Iterator J = this.getbMSCs().iterator();
        while (J.hasNext()) {
            BasicMSC c = (BasicMSC)J.next();
            I = this.getContinuations(c).iterator();
            while (I.hasNext()) {
                b = (BasicMSC)I.next();
                Out.println(String.valueOf(c.name.replace('_', '.')) + " $\\Rightarrow$ " + b.name.replace('_', '.') + ";");
                Out.println("");
                Out.println("");
            }
        }
        I = this.getContinuationsFinal().iterator();
        while (I.hasNext()) {
            b = (BasicMSC)I.next();
            Out.println(String.valueOf(b.name.replace('_', '.')) + " $\\Rightarrow$ Stop;");
            Out.println("");
            Out.println("");
        }
        Out.println("endhmsc");
        Out.println("");
        Out.println("");
        Out.println("\\end{document}");
    }

    public boolean identicalbMSCs(BasicMSC B1, BasicMSC B2, LTSOutput o) throws Exception {
        boolean equivalent = true;
        equivalent = B1.isTheSameAs(B2, o);
        return equivalent;
    }

    public void replaceAndDelete(BasicMSC B1, BasicMSC B2, LTSOutput o) {
        if (this.Initial.contains(B1)) {
            this.addRelationInit(B2);
            this.Initial.remove(B1);
        }
        if (this.Final.contains(B1)) {
            this.addRelationInit(B2);
            this.Final.remove(B1);
        }
        Iterator I = this.getbMSCs().iterator();
        while (I.hasNext()) {
            BasicMSC B = (BasicMSC)I.next();
            Set S = (Set)this.H.get(B);
            if (!S.contains(B1)) continue;
            S.add(B2);
            S.remove(B1);
        }
        this.H.remove(B1);
    }

    public void AddScenarioMessages() {
        Iterator I = this.getbMSCs().iterator();
        while (I.hasNext()) {
            BasicMSC b = (BasicMSC)I.next();
            b.AddScenarioEvents();
        }
    }

    public Set RemoveScenarioMessages() {
        HashSet S = new HashSet();
        Iterator I = this.getbMSCs().iterator();
        while (I.hasNext()) {
            BasicMSC b = (BasicMSC)I.next();
            b.RemoveScenarioEvents(S);
        }
        return S;
    }

    public Set getScenarioMessages() {
        HashSet S = new HashSet();
        Iterator I = this.getbMSCs().iterator();
        while (I.hasNext()) {
            BasicMSC b = (BasicMSC)I.next();
            b.getScenarioEvents(S);
        }
        return S;
    }

    public void RemoveLabelsNotIn(StringSet s) {
        Iterator I = this.getbMSCs().iterator();
        while (I.hasNext()) {
            BasicMSC b = (BasicMSC)I.next();
            b.RemoveLabelsNotIn(s);
        }
    }

    public boolean Normalised(LTSOutput o) throws Exception {
        Iterator I = this.getbMSCs().iterator();
        while (I.hasNext()) {
            BasicMSC b = (BasicMSC)I.next();
            Set Cont = this.getContinuations(b);
            if (Cont.size() <= 1) continue;
            Iterator J1 = Cont.iterator();
            while (J1.hasNext()) {
                BasicMSC b1 = (BasicMSC)J1.next();
                Iterator J2 = Cont.iterator();
                while (J2.hasNext()) {
                    BasicMSC b2 = (BasicMSC)J2.next();
                    if (b1 == b2 || !b1.hasCommonFirstMoves(b2, o)) continue;
                    o.outln(String.valueOf(b1.name) + " and " + b2.name + " have common initial messages.");
                    return false;
                }
            }
        }
        return true;
    }

    public void eliminateEmptyScenarios(LTSOutput o) throws Exception {
        boolean dbg = false;
        if (dbg) {
            o.outln("eliminating");
        }
        Iterator I = this.getbMSCs().iterator();
        while (I.hasNext()) {
            BasicMSC b = (BasicMSC)I.next();
            if (dbg) {
                o.outln("got " + b.name);
            }
            boolean found = false;
            if (b.empty()) {
                found = true;
                if (dbg) {
                    o.outln("its empty!");
                }
                Set S = this.getContinuations(b);
                Iterator J = this.getbMSCs().iterator();
                while (J.hasNext()) {
                    BasicMSC c = (BasicMSC)J.next();
                    if (dbg) {
                        o.outln("looking at " + c.name);
                    }
                    if (!this.getContinuations(c).contains(b)) continue;
                    if (dbg) {
                        o.outln("adding  continuations");
                    }
                    Iterator s = S.iterator();
                    while (s.hasNext()) {
                        this.getContinuations(c).add(s.next());
                    }
                    if (dbg) {
                        o.outln("removing continuations");
                    }
                    this.getContinuations(c).remove(b);
                }
                if (this.getContinuationsInit().contains(b)) {
                    if (dbg) {
                        o.outln("adding from Init");
                    }
                    Iterator s = S.iterator();
                    while (s.hasNext()) {
                        this.getContinuationsInit().add(s.next());
                    }
                    if (dbg) {
                        o.outln("removing continuations");
                    }
                    this.getContinuationsInit().remove(b);
                }
            }
            if (!found) continue;
            this.removebMSC(b);
            I = this.getbMSCs().iterator();
        }
    }

    private boolean DetectCycle(BasicMSC A, Set Partition, LTSOutput o) {
        Iterator I = this.getContinuations(A).iterator();
        boolean found = false;
        while (I.hasNext() && !found) {
            found = this.DetectCycleRec(A, (BasicMSC)I.next(), Partition, o);
        }
        return found;
    }

    private boolean DetectCycleRec(BasicMSC A, BasicMSC B, Set Partition, LTSOutput o) {
        if (A == B) {
            return true;
        }
        if (B.OverlapsPartition(Partition)) {
            return false;
        }
        Iterator I = this.getContinuations(B).iterator();
        boolean found = false;
        while (I.hasNext() && !found) {
            found = this.DetectCycleRec(A, (BasicMSC)I.next(), Partition, o);
        }
        return found;
    }

    private void CheckRegularLanguage(BasicMSC A, Set Partitions, LTSOutput o) throws Exception {
        boolean dbg = false;
        if (dbg) {
            o.outln(String.valueOf(A.name) + "can be partitionedVerticaly in a non-trivial way");
        }
        Iterator Part = Partitions.iterator();
        boolean found = false;
        while (Part.hasNext() && !found) {
            Set Partition = (Set)Part.next();
            if (Partition.size() <= 1) continue;
            if (dbg) {
                o.outln("Checking cycle for a partition");
            }
            found = this.DetectCycle(A, Partition, o);
        }
        if (found) {
            throw new Exception("Non regular language: Loop from bMSC " + A.name);
        }
    }

    private void CheckRegularLanguage(LTSOutput o) throws Exception {
        Iterator I = this.getbMSCs().iterator();
        while (I.hasNext()) {
            HashSet Partitions;
            BasicMSC A = (BasicMSC)I.next();
            if (!A.PartitionVerticaly(Partitions = new HashSet(), o)) continue;
            this.CheckRegularLanguage(A, Partitions, o);
        }
    }

    public void Interleave(LTSOutput o) throws Exception {
        this.CheckRegularLanguage(o);
        HashMap Postponed = new HashMap();
        HashMap VisitedAsA = new HashMap();
        HashMap VisitedAsB = new HashMap();
        int id = 0;
        while (this.FindAndApplyRules(Postponed, VisitedAsA, VisitedAsB, id++, o)) {
        }
    }

    private boolean FindAndApplyRules(Map Postponed, Map VisitedAsA, Map VisitedAsB, int id, LTSOutput o) throws Exception {
        boolean dbg = false;
        if (dbg) {
            o.outln("Finding and Applying rules");
        }
        boolean appliedRule = true;
        boolean loops = false;
        Iterator I = this.getbMSCs().iterator();
        appliedRule = false;
        if (dbg) {
            o.outln("Starting cylce I");
        }
        while (I.hasNext() && !appliedRule) {
            BasicMSC A = (BasicMSC)I.next();
            Set Cont = this.getContinuations(A);
            Iterator J1 = Cont.iterator();
            while (J1.hasNext() && !appliedRule) {
                BasicMSC B;
                if (dbg) {
                    o.outln("About to apply rule");
                }
                if (A != (B = (BasicMSC)J1.next())) {
                    if (this.PreConditionSequence(A, B, Postponed)) {
                        appliedRule = this.ApplySequenceRules(A, B, Postponed, VisitedAsA, VisitedAsB, id, o);
                    }
                } else {
                    appliedRule = this.ApplyRuleLoop(A, Postponed, VisitedAsA, VisitedAsB, id, o);
                }
                if (!dbg) continue;
                o.outln("Finished applying rule");
            }
            if (!dbg) continue;
            o.outln("Finished cylce J1");
        }
        if (dbg) {
            o.outln("Finished cylce I");
        }
        return appliedRule;
    }

    private boolean PreConditionSequence(BasicMSC A, BasicMSC B, Map Postponed) {
        if (this.getContinuations(A).contains(A) && Postponed.keySet().contains(A) && !((Set)Postponed.get(A)).contains(A)) {
            return false;
        }
        return !this.getContinuations(B).contains(B) || !Postponed.keySet().contains(B) || ((Set)Postponed.get(B)).contains(B);
    }

    private boolean ApplyRuleLoop(BasicMSC A, Map Postponed, Map VisitedAsA, Map VisitedAsB, int Id, LTSOutput o) throws Exception {
        boolean dbg = true;
        boolean dbg2 = true;
        if (!Postponed.keySet().contains(A)) {
            Postponed.put(A, new HashSet());
        }
        if (((Set)Postponed.get(A)).contains(A)) {
            return false;
        }
        if (dbg) {
            o.outln("");
        }
        if (dbg) {
            o.outln("ApplyRuleLoop" + A.name + ", " + A.name);
        }
        StringSet Postponables = new StringSet();
        BasicMSC A_P = (BasicMSC)A.clone();
        A_P.name = A.name + "_P" + Id;
        BasicMSC P_A = (BasicMSC)A.clone();
        P_A.name = "P_" + A.name + Id;
        BasicMSC P = new BasicMSC();
        P.copyComponents(A);
        P.name = "P" + Id;
        boolean found = true;
        while (found) {
            found = false;
            Set FirstMoves = P_A.getFirstMoves(o);
            Set LastMoves = A_P.getLastMoves(o);
            Iterator LM = LastMoves.iterator();
            while (LM.hasNext() && !found) {
                Vector move = (Vector)LM.next();
                String C1 = (String)move.get(0);
                String label = (String)move.get(1);
                String C2 = (String)move.get(2);
                Iterator FM = FirstMoves.iterator();
                while (FM.hasNext() && !found) {
                    Vector m = (Vector)FM.next();
                    if (C1.equals((String)m.get(0)) || C1.equals((String)m.get(2)) || C2.equals((String)m.get(0)) || C2.equals((String)m.get(2))) continue;
                    if (dbg) {
                        o.outln("Found postponable action " + label);
                    }
                    A_P.removeLastMessage(C1, label, C2);
                    P_A.addMessage(C1, label, C2);
                    P.addMessage(C1, label, C2);
                    Postponables.add(label);
                    found = true;
                }
            }
        }
        if (Postponables.size() == 0) {
            ((Set)Postponed.get(A)).add(A);
            return true;
        }
        if (A_P.getFirstMoves(o).size() == 0) {
            if (A.getFirstMoves(o).size() == 1) {
                this.MarkAsPostponed(Postponed, A, A, o);
                return true;
            }
            throw new Exception("Non regular language: Loop in bMSC " + A.name);
        }
        BasicMSC P_A_P = (BasicMSC)P.clone();
        P_A_P.append(A_P);
        P_A_P.name = "P_" + A.name + "_P" + Id;
        Iterator I = this.getbMSCs().iterator();
        while (I.hasNext()) {
            BasicMSC X = (BasicMSC)I.next();
            if (X == A || !this.getContinuations(X).contains(A)) continue;
            if (dbg) {
                o.outln("// Adding (1)" + X.name + " -> " + A_P.name);
            }
            this.addRelation(X, A_P);
        }
        if (this.getContinuationsInit().contains(A)) {
            if (dbg) {
                o.outln("// Adding Init -> " + A_P.name);
            }
            this.addRelationInit(A_P);
        }
        if (dbg) {
            o.outln("// Adding bMSCs " + P_A_P.name + ", " + A_P.name + ", " + P_A.name + ", " + P.name);
        }
        this.addbMSC(P_A_P);
        this.addbMSC(A_P);
        this.addbMSC(P_A);
        this.addbMSC(P);
        Iterator J = this.getContinuations(A).iterator();
        while (J.hasNext()) {
            BasicMSC Aux = (BasicMSC)J.next();
            if (Aux == A) continue;
            if (dbg) {
                o.outln("// Adding " + P_A.name + " -> " + Aux.name);
            }
            this.addRelation(P_A, Aux);
            if (dbg) {
                o.outln("// Adding " + P.name + " -> " + Aux.name);
            }
            this.addRelation(P, Aux);
        }
        if (dbg) {
            o.outln("// Adding " + P.name + " -> " + A.name);
        }
        this.addRelation(P, A);
        if (dbg) {
            o.outln("// Adding " + A.name + " -> " + A_P.name);
        }
        this.addRelation(A, A_P);
        if (dbg) {
            o.outln("// Adding " + A_P.name + " -> " + P_A.name);
        }
        this.addRelation(A_P, P_A);
        if (dbg) {
            o.outln("// Adding " + P_A.name + " -> " + A.name);
        }
        this.addRelation(P_A, A);
        if (dbg) {
            o.outln("// Adding " + A_P.name + " -> " + P_A_P.name);
        }
        this.addRelation(A_P, P_A_P);
        if (dbg) {
            o.outln("// Adding " + P_A_P.name + " -> " + P_A_P.name);
        }
        this.addRelation(P_A_P, P_A_P);
        if (dbg) {
            o.outln("// Adding " + P_A_P.name + " -> " + P.name);
        }
        this.addRelation(P_A_P, P);
        if (dbg) {
            o.outln("// Adding " + P_A_P.name + " -> " + P_A.name);
        }
        this.addRelation(P_A_P, P_A);
        if (dbg) {
            o.outln("// Adding " + P_A.name + " -> " + A_P.name);
        }
        this.addRelation(P_A, A_P);
        if (dbg) {
            o.outln("Updating postponed map (" + A.name + "," + A.name + ")");
        }
        ((Set)Postponed.get(A)).add(A);
        if (dbg) {
            o.outln("Updating postponed map (" + A.name + "," + A_P.name + ")");
        }
        ((Set)Postponed.get(A)).add(A_P);
        if (dbg) {
            o.outln("Updating postponed map (" + P.name + "," + A.name + ")");
        }
        Postponed.put(P, new HashSet());
        ((Set)Postponed.get(P)).add(A);
        if (dbg) {
            o.outln("Updating postponed map (" + P_A.name + "," + A.name + ")");
        }
        Postponed.put(P_A, new HashSet());
        ((Set)Postponed.get(P_A)).add(A);
        if (dbg) {
            o.outln("Updating postponed map (" + A_P.name + "," + P_A.name + ")");
        }
        Postponed.put(A_P, new HashSet());
        ((Set)Postponed.get(A_P)).add(P_A);
        if (dbg) {
            o.outln("Updating postponed map (" + A_P.name + "," + P_A_P.name + ")");
        }
        ((Set)Postponed.get(A_P)).add(P_A_P);
        if (dbg) {
            o.outln("Updating postponed map (" + P_A_P.name + "," + P_A_P.name + ")");
        }
        Postponed.put(P_A_P, new HashSet());
        ((Set)Postponed.get(P_A_P)).add(P_A_P);
        if (dbg) {
            o.outln("Updating postponed map (" + P_A_P.name + "," + P.name + ")");
        }
        ((Set)Postponed.get(P_A_P)).add(P);
        if (dbg) {
            o.outln("Updating postponed map (" + P_A_P.name + "," + P_A.name + ")");
        }
        ((Set)Postponed.get(P_A_P)).add(P_A);
        if (dbg) {
            o.outln("Updating postponed map (" + P_A.name + "," + A_P.name + ")");
        }
        ((Set)Postponed.get(P_A)).add(A_P);
        if (dbg) {
            o.outln("Register that " + A.name + " has been visited as B that the result is " + P_A.name + ".");
        }
        Vector<Object> v = new Vector<Object>(2);
        v.add(0, Postponables);
        v.add(1, P_A);
        if (!VisitedAsB.keySet().contains(A)) {
            VisitedAsB.put(A, new HashSet());
        }
        ((Set)VisitedAsB.get(A)).add(v);
        if (dbg) {
            o.outln("Register that " + A.name + " has been visited as A and that the resutl is " + A_P.name);
        }
        v = new Vector(2);
        v.add(0, Postponables);
        v.add(1, A_P);
        if (!VisitedAsA.keySet().contains(A)) {
            VisitedAsA.put(A, new HashSet());
        }
        ((Set)VisitedAsA.get(A)).add(v);
        if (dbg2) {
            o.outln("AppliedLoopRule (" + Id + ") to " + A.name);
        }
        return true;
    }

    private void MarkAsPostponed(Map Postponed, BasicMSC A, BasicMSC B, LTSOutput o) {
        boolean dbg = true;
        if (dbg) {
            o.outln("Marked as postponed (" + A.name + " -> " + B.name + ")");
        }
        if (!Postponed.keySet().contains(A)) {
            Postponed.put(A, new HashSet());
        }
        ((Set)Postponed.get(A)).add(B);
    }

    private boolean HasBeenPostponed(Map Postponed, BasicMSC A, BasicMSC B) {
        if (!Postponed.keySet().contains(A)) {
            return false;
        }
        return ((Set)Postponed.get(A)).contains(B);
    }

    private boolean ApplySequenceRules(BasicMSC A, BasicMSC B, Map Postponed, Map VisitedAsA, Map VisitedAsB, int Id, LTSOutput o) throws Exception {
        boolean dbg = false;
        if (dbg) {
            o.outln("1");
        }
        if (this.HasBeenPostponed(Postponed, A, B)) {
            return false;
        }
        if (dbg) {
            o.outln("2");
        }
        if (this.getContinuations(B).contains(A)) {
            return this.ApplyRuleSequenceAndBack(A, B, Postponed, VisitedAsA, VisitedAsB, Id, o);
        }
        return this.ApplyRuleSequence(A, B, Postponed, VisitedAsA, VisitedAsB, Id, o);
    }

    private boolean ApplyRuleSequence(BasicMSC A, BasicMSC B, Map Postponed, Map VisitedAsA, Map VisitedAsB, int Id, LTSOutput o) throws Exception {
        Vector<BasicMSC> v;
        BasicMSC PAP;
        Iterator It_Prev_P_A_P;
        boolean dbg = true;
        boolean dbg2 = true;
        if (dbg) {
            o.outln("");
        }
        if (dbg) {
            o.outln("ApplyRuleSequence " + A.name + ", " + B.name);
        }
        StringSet Postponables = new StringSet();
        HashSet Prev_P_A_P = new HashSet();
        HashSet Prev_P_B_P = new HashSet();
        BasicMSC A_P = (BasicMSC)A.clone();
        A_P.name = A.name + "_P" + Id;
        BasicMSC P = new BasicMSC();
        P.copyComponents(A);
        P.name = "P" + Id;
        BasicMSC P_B = (BasicMSC)B.clone();
        P_B.name = "P_" + B.name + Id;
        boolean found = true;
        while (found) {
            found = false;
            Set FirstMoves = P_B.getFirstMoves(o);
            Set LastMoves = A_P.getLastMoves(o);
            Iterator LM = LastMoves.iterator();
            while (LM.hasNext() && !found) {
                Vector move = (Vector)LM.next();
                String C1 = (String)move.get(0);
                String label = (String)move.get(1);
                String C2 = (String)move.get(2);
                Iterator FM = FirstMoves.iterator();
                while (FM.hasNext() && !found) {
                    Vector m = (Vector)FM.next();
                    if (C1.equals((String)m.get(0)) || C1.equals((String)m.get(2)) || C2.equals((String)m.get(0)) || C2.equals((String)m.get(2))) continue;
                    Vector Ids = A_P.getIdOfLastMessage(C1, label, C2);
                    int Id1 = (Integer)Ids.get(0);
                    int Id2 = (Integer)Ids.get(1);
                    if (B.hasEventId(Id1) || B.hasEventId(Id2)) continue;
                    if (dbg) {
                        o.outln("Found postponable action " + label);
                    }
                    A_P.removeLastMessage(C1, label, C2);
                    P_B.addMessage(C1, label, C2, Id1, Id2);
                    P.addMessage(C1, label, C2, Id1, Id2);
                    found = true;
                }
            }
        }
        if (P.empty()) {
            this.MarkAsPostponed(Postponed, A, B, o);
            return true;
        }
        if (!VisitedAsA.keySet().contains(A)) {
            VisitedAsA.put(A, new HashSet());
        }
        Iterator VA = ((Set)VisitedAsA.get(A)).iterator();
        while (VA.hasNext()) {
            Vector aux = (Vector)VA.next();
            if (!P.isTheSameAs((BasicMSC)aux.get(0), o)) continue;
            A_P = (BasicMSC)aux.get(1);
            if (dbg) {
                o.outln("Found that " + A.name + " has been used as A with P, so now using " + A_P.name + " as A_P");
            }
            if (aux.size() != 3) continue;
            Prev_P_A_P.add(aux.get(2));
            if (!dbg) continue;
            o.outln(" PREV In addition will remember to link Prev_P_A_P=" + ((BasicMSC)aux.get((int)2)).name + " to link with anything A_P is linked with");
        }
        if (!VisitedAsB.keySet().contains(B)) {
            VisitedAsB.put(B, new HashSet());
        }
        Iterator V = ((Set)VisitedAsB.get(B)).iterator();
        boolean Circular = false;
        while (V.hasNext()) {
            Vector aux = (Vector)V.next();
            if (!P.isTheSameAs((BasicMSC)aux.get(0), o)) continue;
            Circular = true;
            P_B = (BasicMSC)aux.get(1);
            if (dbg) {
                o.outln("Found that " + B.name + " has been visited as B with exactly P, so now using " + P_B.name + " as previous P_B");
            }
            if (aux.size() != 3) continue;
            Prev_P_B_P.add(aux.get(2));
            if (!dbg) continue;
            o.outln(" PREV In addition will remember to link Prev_P_B_P=" + ((BasicMSC)aux.get((int)2)).name + " FROM anything that is liked to P_B");
        }
        if (dbg) {
            o.outln("Add transitions '3'");
        }
        Iterator I = this.getbMSCs().iterator();
        while (I.hasNext()) {
            BasicMSC X = (BasicMSC)I.next();
            if (X == B || X == A || X == A_P || X == P_B || !this.getContinuations(X).contains(A)) continue;
            if (dbg) {
                o.outln("// Adding " + X.name + " -> " + A_P.name);
            }
            this.addRelation(X, A_P);
            if (!this.HasBeenPostponed(Postponed, X, A)) continue;
            this.MarkAsPostponed(Postponed, X, A_P, o);
        }
        if (this.getContinuationsInit().contains(A)) {
            if (dbg) {
                o.outln("// Adding Init -> " + A_P.name);
            }
            this.addRelationInit(A_P);
        }
        if (dbg) {
            o.outln("// Adding bMSC " + A_P.name);
        }
        this.addbMSC(A_P);
        if (dbg) {
            o.outln("// Adding bMSCs " + P_B.name);
        }
        this.addbMSC(P_B);
        if (dbg) {
            o.outln("Add transitions '1'");
        }
        if (this.getContinuations(A).contains(A)) {
            if (dbg) {
                o.outln("// Add relation " + A.name + " -> " + A_P.name);
            }
            this.addRelation(A, A_P);
            this.MarkAsPostponed(Postponed, A, A_P, o);
        }
        if (dbg) {
            o.outln("Add transitions '2'");
        }
        if (!Circular) {
            if (this.getContinuations(B).contains(B)) {
                if (dbg) {
                    o.outln("// Add relation " + P_B.name + " -> " + B.name);
                }
                this.addRelation(P_B, B);
            }
            if (dbg) {
                o.outln("// Add transitions '6'");
            }
            Iterator J = this.getContinuations(B).iterator();
            while (J.hasNext()) {
                BasicMSC Aux = (BasicMSC)J.next();
                if (Aux == B || Aux == A || Aux == A_P || Aux == P_B) continue;
                if (dbg) {
                    o.outln("// Add relation " + P_B.name + " -> " + Aux.name);
                }
                this.addRelation(P_B, Aux);
                if (!this.HasBeenPostponed(Postponed, B, Aux)) continue;
                this.MarkAsPostponed(Postponed, P_B, Aux, o);
            }
        }
        if (Circular) {
            if (VisitedAsA.keySet().contains(P_B)) {
                if (dbg) {
                    o.outln(String.valueOf(P_B.name) + " has been visited as A...so will add A_P to P_B-X and Prev_P_A_P to P_B-X");
                }
                Iterator VV = ((Set)VisitedAsA.get(P_B)).iterator();
                while (VV.hasNext()) {
                    Vector aux = (Vector)VV.next();
                    if (dbg) {
                        o.outln("Adding relation " + A_P.name + " to " + ((BasicMSC)aux.get((int)1)).name);
                    }
                    this.addRelation(A_P, (BasicMSC)aux.get(1));
                    this.MarkAsPostponed(Postponed, A_P, (BasicMSC)aux.get(1), o);
                    It_Prev_P_A_P = Prev_P_A_P.iterator();
                    while (It_Prev_P_A_P.hasNext()) {
                        PAP = (BasicMSC)It_Prev_P_A_P.next();
                        if (dbg) {
                            o.outln("PREV Adding relation " + PAP.name + " to " + ((BasicMSC)aux.get((int)1)).name);
                        }
                        this.addRelation(PAP, (BasicMSC)aux.get(1));
                        this.MarkAsPostponed(Postponed, PAP, (BasicMSC)aux.get(1), o);
                    }
                }
            } else if (dbg) {
                o.outln(String.valueOf(P_B.name) + " has not been visited as A ");
            }
        }
        if (Circular && A == P_B) {
            if (dbg) {
                o.outln("Because Circular and A=P_B, adding relation " + A_P.name + " to " + A_P.name);
            }
            this.addRelation(A_P, A_P);
            throw new Exception("Case that should never happen");
        }
        if (dbg) {
            o.outln("Adding relation " + A_P.name + " to " + P_B.name);
        }
        this.addRelation(A_P, P_B);
        this.MarkAsPostponed(Postponed, A_P, P_B, o);
        Iterator It_Prev_P_B_P = Prev_P_B_P.iterator();
        while (It_Prev_P_B_P.hasNext()) {
            BasicMSC PBP = (BasicMSC)It_Prev_P_B_P.next();
            if (dbg) {
                o.outln("Adding PREV relation " + A_P.name + " to " + PBP.name);
            }
            this.addRelation(A_P, PBP);
            this.MarkAsPostponed(Postponed, A_P, PBP, o);
        }
        It_Prev_P_A_P = Prev_P_A_P.iterator();
        while (It_Prev_P_A_P.hasNext()) {
            BasicMSC PAP2 = (BasicMSC)It_Prev_P_A_P.next();
            if (dbg) {
                o.outln("Adding PREV relation " + PAP2.name + " to " + P_B.name);
            }
            this.addRelation(PAP2, P_B);
            this.MarkAsPostponed(Postponed, PAP2, P_B, o);
            It_Prev_P_B_P = Prev_P_B_P.iterator();
            while (It_Prev_P_B_P.hasNext()) {
                BasicMSC PBP = (BasicMSC)It_Prev_P_B_P.next();
                if (dbg) {
                    o.outln("Adding PREV relation " + PAP2.name + " to " + PBP.name);
                }
                this.addRelation(PAP2, PBP);
                this.MarkAsPostponed(Postponed, PAP2, PBP, o);
            }
        }
        this.MarkAsPostponed(Postponed, A, B, o);
        if (!Circular) {
            if (dbg) {
                o.outln("Register that " + B.name + " has been visited as B that the result is " + P_B.name + ".");
            }
            v = new Vector<BasicMSC>(2);
            v.add(0, P);
            v.add(1, P_B);
            ((Set)VisitedAsB.get(B)).add(v);
        }
        if (dbg) {
            o.outln("Register that " + A.name + " has been visited as A that the result is " + A_P.name + ".");
        }
        v = new Vector(2);
        v.add(0, P);
        v.add(1, A_P);
        if (!VisitedAsA.keySet().contains(A)) {
            VisitedAsA.put(A, new HashSet());
        }
        ((Set)VisitedAsA.get(A)).add(v);
        if (dbg2) {
            o.outln("AppliedRuleSequence (" + Id + ") " + A.name + ", " + B.name);
        }
        if (P_B.getPostponables(P_B, o).isTheSameAs(P, o)) {
            if (dbg) {
                o.outln("Independent!");
            }
            this.MarkAsPostponed(Postponed, P_B, B, o);
            BasicMSC BClone = (BasicMSC)B.clone();
            BClone.name = String.valueOf(B.name) + "clone" + Id;
            this.addbMSC(BClone);
            this.addbMSC(P);
            this.addRelation(A_P, BClone);
            this.MarkAsPostponed(Postponed, A_P, BClone, o);
            It_Prev_P_A_P = Prev_P_A_P.iterator();
            while (It_Prev_P_A_P.hasNext()) {
                PAP = (BasicMSC)It_Prev_P_A_P.next();
                if (dbg) {
                    o.outln("PREV ! ");
                }
                this.addRelation(PAP, BClone);
                this.MarkAsPostponed(Postponed, PAP, BClone, o);
            }
            this.addRelation(BClone, BClone);
            this.MarkAsPostponed(Postponed, BClone, BClone, o);
            this.addRelation(BClone, P);
            this.MarkAsPostponed(Postponed, BClone, P, o);
            this.addRelation(P, B);
            this.MarkAsPostponed(Postponed, P, B, o);
            if (dbg) {
                o.outln("// Add transitions '6'");
            }
            Iterator J = this.getContinuations(B).iterator();
            while (J.hasNext()) {
                BasicMSC Aux = (BasicMSC)J.next();
                if (Aux == B || Aux == A || Aux == A_P || Aux == P_B || Aux == P || Aux == BClone) continue;
                if (dbg) {
                    o.outln("// Add relation " + P.name + " -> " + Aux.name);
                }
                this.addRelation(P, Aux);
            }
        } else if (dbg) {
            o.outln("Not Independent!");
        }
        return true;
    }

    private boolean ApplyRuleSequenceAndBack(BasicMSC A, BasicMSC B, Map Postponed, Map VisitedAsA, Map VisitedAsB, int Id, LTSOutput o) throws Exception {
        Iterator It_PrevB_P_A_P;
        Iterator It_Prev_P_B_P;
        BasicMSC PAP;
        BasicMSC PBP;
        Iterator It_PrevB_P_B_P;
        Iterator It_Prev_P_A_P;
        Vector aux;
        Iterator VV;
        BasicMSC Aux;
        Iterator J;
        BasicMSC X;
        Iterator I;
        Vector aux2;
        Iterator V;
        boolean dbg = true;
        boolean dbg2 = true;
        if (dbg) {
            o.outln("");
        }
        if (dbg) {
            o.outln("ApplyRuleSequenceAndBack " + A.name + ", " + B.name);
        }
        boolean CircularA = false;
        boolean CircularB = false;
        StringSet PostponablesA = new StringSet();
        HashSet Prev_P_A_P = new HashSet();
        HashSet Prev_P_B_P = new HashSet();
        HashSet PrevB_P_A_P = new HashSet();
        HashSet PrevB_P_B_P = new HashSet();
        BasicMSC A_P = (BasicMSC)A.clone();
        A_P.name = A.name + "_P" + Id;
        BasicMSC P_B = (BasicMSC)B.clone();
        P_B.name = "P_" + B.name + Id;
        BasicMSC P_B_P = new BasicMSC();
        P_B_P.copyComponents(B);
        BasicMSC PA = new BasicMSC();
        PA.copyComponents(A);
        boolean found = true;
        while (found) {
            found = false;
            Set FirstMoves = P_B.getFirstMoves(o);
            Set LastMoves = A_P.getLastMoves(o);
            Iterator LM = LastMoves.iterator();
            while (LM.hasNext() && !found) {
                Vector move = (Vector)LM.next();
                String C1 = (String)move.get(0);
                String label = (String)move.get(1);
                String C2 = (String)move.get(2);
                Iterator FM = FirstMoves.iterator();
                while (FM.hasNext() && !found) {
                    Vector m = (Vector)FM.next();
                    if (C1.equals((String)m.get(0)) || C1.equals((String)m.get(2)) || C2.equals((String)m.get(0)) || C2.equals((String)m.get(2))) continue;
                    if (dbg) {
                        o.outln("1-Found postponableA action " + label);
                    }
                    Vector Ids = A_P.getIdOfLastMessage(C1, label, C2);
                    int Id1 = (Integer)Ids.get(0);
                    int Id2 = (Integer)Ids.get(1);
                    if (B.hasEventId(Id1) || B.hasEventId(Id2)) continue;
                    A_P.removeLastMessage(C1, label, C2);
                    P_B.addMessage(C1, label, C2, Id1, Id2);
                    P_B_P.addMessage(C1, label, C2, Id1, Id2);
                    PA.addMessage(C1, label, C2, Id1, Id2);
                    PostponablesA.add(label);
                    found = true;
                }
            }
        }
        StringSet PostponablesB = new StringSet();
        BasicMSC B_P = (BasicMSC)B.clone();
        B_P.name = B.name + "_P" + Id;
        BasicMSC P_A = (BasicMSC)A.clone();
        P_A.name = "P_" + A.name + Id;
        BasicMSC P_A_P = new BasicMSC();
        P_A_P.copyComponents(A);
        BasicMSC PB = new BasicMSC();
        PB.copyComponents(B);
        boolean found2 = true;
        while (found2) {
            found2 = false;
            Set FirstMoves = P_A.getFirstMoves(o);
            Set LastMoves = B_P.getLastMoves(o);
            Iterator LM = LastMoves.iterator();
            while (LM.hasNext() && !found2) {
                Vector move = (Vector)LM.next();
                String C1 = (String)move.get(0);
                String label = (String)move.get(1);
                String C2 = (String)move.get(2);
                Iterator FM = FirstMoves.iterator();
                while (FM.hasNext() && !found2) {
                    Vector m = (Vector)FM.next();
                    if (C1.equals((String)m.get(0)) || C1.equals((String)m.get(2)) || C2.equals((String)m.get(0)) || C2.equals((String)m.get(2))) continue;
                    if (dbg) {
                        o.outln("2-Found postponableB action " + label);
                    }
                    Vector Ids = B_P.getIdOfLastMessage(C1, label, C2);
                    int Id1 = (Integer)Ids.get(0);
                    int Id2 = (Integer)Ids.get(1);
                    if (A.hasEventId(Id1) || A.hasEventId(Id2)) continue;
                    B_P.removeLastMessage(C1, label, C2);
                    P_A.addMessage(C1, label, C2, Id1, Id2);
                    P_A_P.addMessage(C1, label, C2, Id1, Id2);
                    PB.addMessage(C1, label, C2, Id1, Id2);
                    PostponablesB.add(label);
                    found2 = true;
                }
            }
        }
        if (PostponablesB.size() == 0 && PostponablesA.size() == 0) {
            this.MarkAsPostponed(Postponed, A, B, o);
            this.MarkAsPostponed(Postponed, B, A, o);
            return true;
        }
        if (!VisitedAsA.keySet().contains(A)) {
            VisitedAsA.put(A, new HashSet());
        }
        Iterator VA = ((Set)VisitedAsA.get(A)).iterator();
        while (VA.hasNext()) {
            Vector aux3 = (Vector)VA.next();
            if (!PA.isTheSameAs((BasicMSC)aux3.get(0), o)) continue;
            A_P = (BasicMSC)aux3.get(1);
            if (dbg) {
                o.outln("Found that " + A.name + " has been used as A with P, so using " + A_P.name + " as A_P. Size(" + aux3.size() + ")");
            }
            if (aux3.size() != 3) continue;
            Prev_P_A_P.add(aux3.get(2));
            if (!dbg) continue;
            o.outln("PREV remembering Prev_P_A_P=" + ((BasicMSC)aux3.get((int)2)).name + " in order to link with all things A_P is linked with");
        }
        if (!VisitedAsA.keySet().contains(B)) {
            VisitedAsA.put(B, new HashSet());
        }
        Iterator VB = ((Set)VisitedAsA.get(B)).iterator();
        while (VB.hasNext()) {
            Vector aux4 = (Vector)VB.next();
            if (!PB.isTheSameAs((BasicMSC)aux4.get(0), o)) continue;
            B_P = (BasicMSC)aux4.get(1);
            if (dbg) {
                o.outln("Found that " + B.name + " has been used as A with exactly P, so using " + B_P.name + " as B_P. Size(" + aux4.size() + ")");
            }
            if (aux4.size() != 3) continue;
            Prev_P_B_P.add(aux4.get(2));
            if (!dbg) continue;
            o.outln("PREV remembering Prev_P_B_P=" + ((BasicMSC)aux4.get((int)2)).name + " in order to link with all the things B_P is linked with");
        }
        if (PostponablesA.size() != 0) {
            if (dbg) {
                o.outln("3-PostponablesA is not empty");
            }
            if (!VisitedAsB.keySet().contains(B)) {
                VisitedAsB.put(B, new HashSet());
            }
            V = ((Set)VisitedAsB.get(B)).iterator();
            CircularB = false;
            while (V.hasNext() && !CircularB) {
                aux2 = (Vector)V.next();
                if (!PA.isTheSameAs((BasicMSC)aux2.get(0), o)) continue;
                if (dbg) {
                    o.outln("4-Circular!!");
                }
                P_B = (BasicMSC)aux2.get(1);
                CircularB = true;
                if (dbg) {
                    o.outln("Found that " + B.name + " has been visited as B with exactly P, so now using " + P_B.name + " as previous P_B");
                }
                if (aux2.size() != 3) continue;
                PrevB_P_B_P.add(aux2.get(2));
                if (!dbg) continue;
                o.outln(" PREV In addition will remember to link PrevB_P_B_P=" + ((BasicMSC)aux2.get((int)2)).name + " FROM anything that is liked to P_B");
            }
            if (dbg) {
                o.outln("5-Add transitions '3'");
            }
            I = this.getbMSCs().iterator();
            while (I.hasNext()) {
                X = (BasicMSC)I.next();
                if (X == B || X == A || X == A_P || X == B_P || X == P_B || X == P_A || !this.getContinuations(X).contains(A)) continue;
                if (dbg) {
                    o.outln("6-Adding " + X.name + " -> " + A_P.name);
                }
                this.addRelation(X, A_P);
                if (!this.HasBeenPostponed(Postponed, X, A)) continue;
                this.MarkAsPostponed(Postponed, X, A_P, o);
            }
            if (this.getContinuationsInit().contains(A)) {
                if (dbg) {
                    o.outln("7-Adding Init -> " + A_P.name);
                }
                this.addRelationInit(A_P);
            }
            if (dbg) {
                o.outln("8-Adding bMSC " + A_P.name);
            }
            this.addbMSC(A_P);
            if (!CircularB) {
                if (dbg) {
                    o.outln("9-Adding bMSC " + P_B.name);
                }
                this.addbMSC(P_B);
            }
            if (dbg) {
                o.outln("10-Add relation " + B.name + " -> " + A_P.name);
            }
            this.addRelation(B, A_P);
            this.MarkAsPostponed(Postponed, B, A_P, o);
            if (this.getContinuations(A).contains(A)) {
                if (dbg) {
                    o.outln("11-Add relation " + A.name + " -> " + A_P.name);
                }
                this.addRelation(A, A_P);
                this.MarkAsPostponed(Postponed, A, A_P, o);
            }
            if (this.getContinuations(B).contains(B)) {
                if (dbg) {
                    o.outln("12-Add relation " + P_B.name + " -> " + B.name);
                }
                this.addRelation(P_B, B);
            }
            if (dbg) {
                o.outln("13-Add relation " + P_B.name + " -> " + A.name);
            }
            this.addRelation(P_B, A);
            if (!CircularB) {
                this.MarkAsPostponed(Postponed, P_B, A, o);
            }
            if (!CircularB) {
                if (dbg) {
                    o.outln("14-Add transitions '6'");
                }
                J = this.getContinuations(B).iterator();
                while (J.hasNext()) {
                    Aux = (BasicMSC)J.next();
                    if (Aux == B || Aux == A || Aux == A_P || Aux == B_P || Aux == P_B || Aux == P_A) continue;
                    if (dbg) {
                        o.outln("15-Add relation " + P_B.name + " -> " + Aux.name);
                    }
                    this.addRelation(P_B, Aux);
                    if (!this.HasBeenPostponed(Postponed, B, Aux)) continue;
                    this.MarkAsPostponed(Postponed, P_B, Aux, o);
                }
            }
            if (CircularB && VisitedAsA.keySet().contains(P_B)) {
                VV = ((Set)VisitedAsA.get(P_B)).iterator();
                while (VV.hasNext()) {
                    aux = (Vector)VV.next();
                    if (dbg) {
                        o.outln("16-Adding relation " + A_P.name + " to " + ((BasicMSC)aux.get((int)1)).name);
                    }
                    this.addRelation(A_P, (BasicMSC)aux.get(1));
                    this.MarkAsPostponed(Postponed, A_P, (BasicMSC)aux.get(1), o);
                    It_Prev_P_A_P = Prev_P_A_P.iterator();
                    while (It_Prev_P_A_P.hasNext()) {
                        BasicMSC PAP2 = (BasicMSC)It_Prev_P_A_P.next();
                        if (dbg) {
                            o.outln("16,5-Adding PREV relation " + PAP2.name + " to " + ((BasicMSC)aux.get((int)1)).name);
                        }
                        this.addRelation(PAP2, (BasicMSC)aux.get(1));
                        this.MarkAsPostponed(Postponed, PAP2, (BasicMSC)aux.get(1), o);
                    }
                }
            }
            if (dbg) {
                o.outln("17-Adding relation " + A_P.name + " to " + P_B.name);
            }
            this.addRelation(A_P, P_B);
            It_PrevB_P_B_P = PrevB_P_B_P.iterator();
            while (It_PrevB_P_B_P.hasNext()) {
                PBP = (BasicMSC)It_PrevB_P_B_P.next();
                if (dbg) {
                    o.outln("Adding PREV relation " + A_P.name + " to " + PBP.name);
                }
                this.addRelation(A_P, PBP);
                this.MarkAsPostponed(Postponed, A_P, PBP, o);
            }
            this.MarkAsPostponed(Postponed, A_P, P_B, o);
            It_Prev_P_A_P = Prev_P_A_P.iterator();
            while (It_Prev_P_A_P.hasNext()) {
                PAP = (BasicMSC)It_Prev_P_A_P.next();
                if (dbg) {
                    o.outln("17,5-Adding PREV relation " + PAP.name + " to " + P_B.name);
                }
                this.addRelation(PAP, P_B);
                this.MarkAsPostponed(Postponed, PAP, P_B, o);
                It_PrevB_P_B_P = PrevB_P_B_P.iterator();
                while (It_PrevB_P_B_P.hasNext()) {
                    BasicMSC PBP2 = (BasicMSC)It_PrevB_P_B_P.next();
                    if (dbg) {
                        o.outln("Adding PREV relation " + PAP.name + " to " + PBP2.name);
                    }
                    this.addRelation(PAP, PBP2);
                    this.MarkAsPostponed(Postponed, PAP, PBP2, o);
                }
            }
            if (dbg) {
                o.outln("18-Adding relation " + P_B.name + " to " + A_P.name);
            }
            this.addRelation(P_B, A_P);
            this.MarkAsPostponed(Postponed, P_B, A_P, o);
        }
        if (PostponablesB.size() != 0) {
            if (dbg) {
                o.outln("21-PostponablesB is not empty");
            }
            if (!VisitedAsB.keySet().contains(A)) {
                VisitedAsB.put(A, new HashSet());
            }
            V = ((Set)VisitedAsB.get(A)).iterator();
            CircularA = false;
            while (V.hasNext() && !CircularA) {
                aux2 = (Vector)V.next();
                if (!PB.isTheSameAs((BasicMSC)aux2.get(0), o)) continue;
                P_A = (BasicMSC)aux2.get(1);
                CircularA = true;
                if (dbg) {
                    o.outln("22-Circular!!");
                }
                if (dbg) {
                    o.outln("Found that " + A.name + " has been visited as B with exactly P, so now using " + P_A.name + " as previous P_A");
                }
                if (aux2.size() != 3) continue;
                PrevB_P_A_P.add(aux2.get(2));
                if (!dbg) continue;
                o.outln(" PREV In addition will remember to link PrevB_P_A_P=" + ((BasicMSC)aux2.get((int)2)).name + " FROM anything that is liked to P_A");
            }
            I = this.getbMSCs().iterator();
            while (I.hasNext()) {
                X = (BasicMSC)I.next();
                if (X == B || X == A || X == A_P || X == B_P || X == P_B || X == P_A || !this.getContinuations(X).contains(B)) continue;
                if (dbg) {
                    o.outln("23-Adding " + X.name + " -> " + B_P.name);
                }
                this.addRelation(X, B_P);
                if (!this.HasBeenPostponed(Postponed, X, B)) continue;
                this.MarkAsPostponed(Postponed, X, B_P, o);
            }
            if (this.getContinuationsInit().contains(B)) {
                if (dbg) {
                    o.outln("24-Adding Init -> " + B_P.name);
                }
                this.addRelationInit(B_P);
            }
            if (dbg) {
                o.outln("25-Adding bMSC " + B_P.name);
            }
            this.addbMSC(B_P);
            if (!CircularA) {
                if (dbg) {
                    o.outln("26-Adding bMSC " + P_A.name);
                }
                this.addbMSC(P_A);
            }
            if (dbg) {
                o.outln("27- Add relation " + A.name + " -> " + B_P.name);
            }
            this.addRelation(A, B_P);
            this.MarkAsPostponed(Postponed, A, B_P, o);
            if (this.getContinuations(B).contains(B)) {
                if (dbg) {
                    o.outln("28- Add relation " + B.name + " -> " + B_P.name);
                }
                this.addRelation(B, B_P);
                this.MarkAsPostponed(Postponed, B, B_P, o);
            }
            if (this.getContinuations(A).contains(A)) {
                if (dbg) {
                    o.outln("29- Add relation " + P_A.name + " -> " + A.name);
                }
                this.addRelation(P_A, A);
            }
            if (dbg) {
                o.outln("30- Add relation " + P_A.name + " -> " + B.name);
            }
            this.addRelation(P_A, B);
            if (!CircularA) {
                this.MarkAsPostponed(Postponed, P_A, B, o);
            }
            if (!CircularA) {
                if (dbg) {
                    o.outln("31- Add transitions '4'");
                }
                J = this.getContinuations(A).iterator();
                while (J.hasNext()) {
                    Aux = (BasicMSC)J.next();
                    if (Aux == B || Aux == A || Aux == A_P || Aux == B_P || Aux == P_B || Aux == P_A) continue;
                    if (dbg) {
                        o.outln("32- Add relation " + P_A.name + " -> " + Aux.name);
                    }
                    this.addRelation(P_A, Aux);
                }
            }
            if (CircularA && VisitedAsA.keySet().contains(P_A)) {
                VV = ((Set)VisitedAsA.get(P_A)).iterator();
                while (VV.hasNext()) {
                    aux = (Vector)VV.next();
                    if (dbg) {
                        o.outln("33-Adding relation " + B_P.name + " to " + ((BasicMSC)aux.get((int)1)).name);
                    }
                    this.addRelation(B_P, (BasicMSC)aux.get(1));
                    this.MarkAsPostponed(Postponed, B_P, (BasicMSC)aux.get(1), o);
                    It_Prev_P_B_P = Prev_P_B_P.iterator();
                    while (It_Prev_P_B_P.hasNext()) {
                        BasicMSC PBP3 = (BasicMSC)It_Prev_P_B_P.next();
                        if (dbg) {
                            o.outln("33,5-Adding PREV relation " + PBP3.name + " to " + ((BasicMSC)aux.get((int)1)).name);
                        }
                        this.addRelation(PBP3, (BasicMSC)aux.get(1));
                        this.MarkAsPostponed(Postponed, PBP3, (BasicMSC)aux.get(1), o);
                    }
                }
            }
            if (dbg) {
                o.outln("34-Adding relation " + B_P.name + " to " + P_A.name);
            }
            this.addRelation(B_P, P_A);
            this.MarkAsPostponed(Postponed, B_P, P_A, o);
            It_PrevB_P_A_P = PrevB_P_A_P.iterator();
            while (It_PrevB_P_A_P.hasNext()) {
                PAP = (BasicMSC)It_PrevB_P_A_P.next();
                if (dbg) {
                    o.outln("Adding PREV relation " + B_P.name + " to " + PAP.name);
                }
                this.addRelation(B_P, PAP);
                this.MarkAsPostponed(Postponed, B_P, PAP, o);
            }
            It_Prev_P_B_P = Prev_P_B_P.iterator();
            while (It_Prev_P_B_P.hasNext()) {
                PBP = (BasicMSC)It_Prev_P_B_P.next();
                if (dbg) {
                    o.outln("34-Adding PREV relation " + PBP.name + " to " + P_A.name);
                }
                this.addRelation(PBP, P_A);
                this.MarkAsPostponed(Postponed, PBP, P_A, o);
                It_PrevB_P_A_P = PrevB_P_A_P.iterator();
                while (It_PrevB_P_A_P.hasNext()) {
                    BasicMSC PAP3 = (BasicMSC)It_PrevB_P_A_P.next();
                    if (dbg) {
                        o.outln("Adding PREV relation " + PBP.name + " to " + PAP3.name);
                    }
                    this.addRelation(PBP, PAP3);
                    this.MarkAsPostponed(Postponed, PBP, PAP3, o);
                }
            }
            if (dbg) {
                o.outln("35-Adding relation " + P_A.name + " to " + B_P.name);
            }
            this.addRelation(P_A, B_P);
            this.MarkAsPostponed(Postponed, P_A, B_P, o);
        }
        if (dbg) {
            o.outln("36-Register that " + A.name + " has been visited as B that the result is " + P_A.name + ".");
        }
        Vector<BasicMSC> v = new Vector<BasicMSC>(2);
        v.add(0, PB);
        v.add(1, P_A);
        if (PostponablesB.size() != 0 && PostponablesA.size() != 0) {
            v.ensureCapacity(3);
            v.add(2, P_A_P);
            if (dbg) {
                o.outln("Adding PREV not null !!! Name :" + P_A_P.name);
            }
        }
        if (!VisitedAsB.keySet().contains(A)) {
            VisitedAsB.put(A, new HashSet());
        }
        ((Set)VisitedAsB.get(A)).add(v);
        if (dbg) {
            o.outln("19-Register that " + B.name + " has been visited as B that the result is " + P_B.name + ".");
        }
        v = new Vector(2);
        v.add(0, PA);
        v.add(1, P_B);
        if (PostponablesB.size() != 0 && PostponablesA.size() != 0) {
            v.ensureCapacity(3);
            v.add(2, P_B_P);
            if (dbg) {
                o.outln("Adding PREV not null !!! Name :" + P_B_P.name);
            }
        }
        if (!VisitedAsB.keySet().contains(B)) {
            VisitedAsB.put(B, new HashSet());
        }
        ((Set)VisitedAsB.get(B)).add(v);
        if (dbg) {
            o.outln("37-Register that " + B.name + " has been visited as A that the result is " + B_P.name + ".");
        }
        v = new Vector(2);
        v.add(0, PB);
        v.add(1, B_P);
        if (PostponablesB.size() != 0 && PostponablesA.size() != 0) {
            v.ensureCapacity(3);
            v.add(2, P_B_P);
            if (dbg && P_B_P == null) {
                o.outln("Adding PREV null !!!");
            }
            if (dbg) {
                o.outln("Adding PREV not null !!! Name :" + P_B_P.name);
            }
        }
        if (!VisitedAsA.keySet().contains(B)) {
            VisitedAsA.put(B, new HashSet());
        }
        ((Set)VisitedAsA.get(B)).add(v);
        if (dbg) {
            o.outln("20-Register that " + A.name + " has been visited as A that the result is " + A_P.name + ".");
        }
        v = new Vector(2);
        v.add(0, PA);
        v.add(1, A_P);
        if (PostponablesB.size() != 0 && PostponablesA.size() != 0) {
            v.ensureCapacity(3);
            v.add(2, P_A_P);
            if (dbg && P_A_P == null) {
                o.outln("Adding PREV null !!!");
            }
            if (dbg) {
                o.outln("Adding PREV not null !!! Name: " + P_A_P.name);
            }
        }
        if (!VisitedAsA.keySet().contains(A)) {
            VisitedAsA.put(A, new HashSet());
        }
        ((Set)VisitedAsA.get(A)).add(v);
        if (PostponablesB.size() != 0 && PostponablesA.size() != 0) {
            BasicMSC PBP4;
            BasicMSC PAP4;
            P_A_P.append(A_P);
            P_A_P.name = "P_" + A.name + "_P" + Id;
            P_B_P.append(B_P);
            P_B_P.name = "P_" + B.name + "_P" + Id;
            if (dbg) {
                o.outln("38- Adding bMSC " + P_A_P.name);
            }
            this.addbMSC(P_A_P);
            if (dbg) {
                o.outln("39- Adding bMSC " + P_B_P.name);
            }
            this.addbMSC(P_B_P);
            if (dbg) {
                o.outln("40- Add relation " + A_P.name + " -> " + P_B_P.name);
            }
            this.addRelation(A_P, P_B_P);
            this.MarkAsPostponed(Postponed, A_P, P_B_P, o);
            It_Prev_P_A_P = Prev_P_A_P.iterator();
            while (It_Prev_P_A_P.hasNext()) {
                PAP4 = (BasicMSC)It_Prev_P_A_P.next();
                if (dbg) {
                    o.outln("40- Add PREV relation " + PAP4.name + " -> " + P_B_P.name);
                }
                this.addRelation(PAP4, P_B_P);
                this.MarkAsPostponed(Postponed, PAP4, P_B_P, o);
                Iterator It_Cont_PAP = this.getContinuations(PAP4).iterator();
                while (It_Cont_PAP.hasNext()) {
                    BasicMSC Cont_PAP = (BasicMSC)It_Cont_PAP.next();
                    if (dbg) {
                        o.outln("40,5- Add PREV relation " + P_A_P.name + " -> " + Cont_PAP.name);
                    }
                    this.addRelation(P_A_P, Cont_PAP);
                    this.MarkAsPostponed(Postponed, P_A_P, Cont_PAP, o);
                }
            }
            if (dbg) {
                o.outln("41- Add relation " + B_P.name + " -> " + P_A_P.name);
            }
            this.addRelation(B_P, P_A_P);
            this.MarkAsPostponed(Postponed, B_P, P_A_P, o);
            It_Prev_P_B_P = Prev_P_B_P.iterator();
            while (It_Prev_P_B_P.hasNext()) {
                PBP4 = (BasicMSC)It_Prev_P_B_P.next();
                if (dbg) {
                    o.outln("41- Add PREV relation " + PBP4.name + " -> " + P_A_P.name);
                }
                this.addRelation(PBP4, P_A_P);
                this.MarkAsPostponed(Postponed, PBP4, P_A_P, o);
                Iterator It_Cont_PBP = this.getContinuations(PBP4).iterator();
                while (It_Cont_PBP.hasNext()) {
                    BasicMSC Cont_PBP = (BasicMSC)It_Cont_PBP.next();
                    if (dbg) {
                        o.outln("41,5- Add PREV relation " + P_B_P.name + " -> " + Cont_PBP.name);
                    }
                    this.addRelation(P_B_P, Cont_PBP);
                    this.MarkAsPostponed(Postponed, P_B_P, Cont_PBP, o);
                }
            }
            if (dbg) {
                o.outln("42-Adding relation " + P_A_P.name + " to " + P_B_P.name);
            }
            this.addRelation(P_A_P, P_B_P);
            if (dbg) {
                o.outln("43-Adding relation " + P_A_P.name + " to " + P_B.name);
            }
            this.addRelation(P_A_P, P_B);
            It_PrevB_P_B_P = PrevB_P_B_P.iterator();
            while (It_PrevB_P_B_P.hasNext()) {
                PBP4 = (BasicMSC)It_PrevB_P_B_P.next();
                if (dbg) {
                    o.outln("Adding PREV relation " + P_A_P.name + " to " + PBP4.name);
                }
                this.addRelation(P_A_P, PBP4);
                this.MarkAsPostponed(Postponed, P_A_P, PBP4, o);
            }
            if (dbg) {
                o.outln("44-Adding relation " + P_B_P.name + " to " + P_A_P.name);
            }
            this.addRelation(P_B_P, P_A_P);
            if (dbg) {
                o.outln("45-Adding relation " + P_B_P.name + " to " + P_A.name);
            }
            this.addRelation(P_B_P, P_A);
            It_PrevB_P_A_P = PrevB_P_A_P.iterator();
            while (It_PrevB_P_A_P.hasNext()) {
                PAP4 = (BasicMSC)It_PrevB_P_A_P.next();
                if (dbg) {
                    o.outln("Adding PREV relation " + P_B_P.name + " to " + PAP4.name);
                }
                this.addRelation(P_B_P, PAP4);
                this.MarkAsPostponed(Postponed, P_B_P, PAP4, o);
            }
            this.MarkAsPostponed(Postponed, P_A_P, P_B_P, o);
            this.MarkAsPostponed(Postponed, P_A_P, P_B, o);
            this.MarkAsPostponed(Postponed, P_B_P, P_A_P, o);
            this.MarkAsPostponed(Postponed, P_B_P, P_A, o);
        }
        if (CircularA && B == P_A) {
            if (dbg) {
                o.outln("46-Adding relation " + B_P.name + " to " + B_P.name);
            }
            this.addRelation(B_P, B_P);
        }
        if (CircularB && A == P_B) {
            if (dbg) {
                o.outln("47-Adding relation " + A_P.name + " to " + A_P.name);
            }
            this.addRelation(A_P, A_P);
        }
        this.MarkAsPostponed(Postponed, A, B, o);
        this.MarkAsPostponed(Postponed, B, A, o);
        if (dbg2) {
            o.outln("48-AppliedRuleSequenceAndBack (" + Id + ") " + A.name + ", " + B.name);
        }
        return true;
    }

    public BasicMSC createbMSC(Vector trace, LTSOutput o) {
        boolean dbg = false;
        BasicMSC b = new BasicMSC();
        if (dbg) {
            o.outln("createBMSC...");
        }
        b.copyComponents((BasicMSC)this.getbMSCs().iterator().next());
        if (dbg) {
            o.outln("copied components");
        }
        Vector<String> inv = new Vector<String>();
        int pos = 0;
        Enumeration e = trace.elements();
        while (e.hasMoreElements()) {
            inv.add(pos, (String)e.nextElement());
            ++pos;
        }
        int i = pos - 1;
        while (i >= 0) {
            if (dbg) {
                o.outln("got element");
            }
            String lbl = (String)inv.get(i);
            b.addMessage(this.getSource(lbl, o), lbl, this.getTarget(lbl, o));
            if (dbg) {
                o.outln("added");
            }
            --i;
        }
        if (dbg) {
            o.outln("Finished trace");
        }
        return b;
    }

    public String getSource(String lbl, LTSOutput o) {
        Iterator I = this.getbMSCs().iterator();
        BasicMSC b = null;
        String source = null;
        boolean found = false;
        while (I.hasNext() && !found) {
            b = (BasicMSC)I.next();
            source = b.getSource(lbl);
            boolean bl = found = source != null;
        }
        if (!found) {
            o.outln("No component that can output " + lbl);
            throw new Error("No component that can output " + lbl);
        }
        return source;
    }

    public String getTarget(String lbl, LTSOutput o) {
        Iterator I = this.getbMSCs().iterator();
        BasicMSC b = null;
        String target = null;
        boolean found = false;
        while (I.hasNext() && !found) {
            b = (BasicMSC)I.next();
            target = b.getTarget(lbl);
            boolean bl = found = target != null;
        }
        if (!found) {
            o.outln("No component that can input " + lbl);
            throw new Error("No component that can input " + lbl);
        }
        return target;
    }

    public void addMissingComponents() {
        String name;
        Iterator J;
        BasicMSC B;
        StringSet names = new StringSet();
        Iterator I = this.getbMSCs().iterator();
        while (I.hasNext()) {
            B = (BasicMSC)I.next();
            J = B.components().iterator();
            while (J.hasNext()) {
                name = (String)J.next();
                names.add(name);
            }
        }
        I = this.getbMSCs().iterator();
        while (I.hasNext()) {
            B = (BasicMSC)I.next();
            J = names.iterator();
            while (J.hasNext()) {
                name = (String)J.next();
                if (B.getInstance(name) != null) continue;
                B.addInstance(name, new Instance());
            }
        }
    }

    public void print(LTSOutput Out) {
        BasicMSC b;
        Iterator I = this.getbMSCs().iterator();
        while (I.hasNext()) {
            b = (BasicMSC)I.next();
            b.print(Out);
        }
        Out.outln("hmsc;");
        I = this.getContinuationsInit().iterator();
        while (I.hasNext()) {
            b = (BasicMSC)I.next();
            Out.outln("Init -> " + b.name + ";");
        }
        I = this.getContinuationsFinal().iterator();
        while (I.hasNext()) {
            b = (BasicMSC)I.next();
            Out.outln(String.valueOf(b.name) + " -> Stop;");
        }
        Iterator J = this.getbMSCs().iterator();
        while (J.hasNext()) {
            BasicMSC c = (BasicMSC)J.next();
            I = this.getContinuations(c).iterator();
            while (I.hasNext()) {
                b = (BasicMSC)I.next();
                Out.outln(String.valueOf(c.name) + " -> " + b.name + ";");
            }
        }
        Out.outln("endhmsc");
    }
}

