/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.common.iface.LTSOutput;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import mscedit.BMSC;
import mscedit.Input;
import mscedit.Output;
import mscedit.Transition;
import mscedit.Visitor;
import synthesis.BasicMSC;
import synthesis.InputEvent;
import synthesis.Instance;
import synthesis.OutputEvent;
import synthesis.Specification;

public class SpecificationLoader
extends Visitor {
    private boolean dbg = false;
    private Specification S;
    private BasicMSC B;
    private boolean buildingNeg = false;
    private Instance I;
    private LTSOutput o;
    private Set Txs;
    boolean Error = false;
    String ErrorMSG = "DefaultError";

    public Specification getSpecification(mscedit.Specification Spec, LTSOutput out) throws Exception {
        this.o = out;
        try {
            Spec.apply(this);
        }
        catch (Exception e) {
            this.o.outln("Error Visiting MSC Specification");
            throw new Exception(e);
        }
        if (this.Error) {
            this.o.outln(this.ErrorMSG);
            throw new Exception();
        }
        if (this.dbg) {
            this.o.outln("Succesful parse");
        }
        this.S.addMissingComponents();
        try {
            this.S.checkConsistency();
        }
        catch (Exception e) {
            this.o.outln(e.toString());
            throw new Exception(e);
        }
        if (this.dbg) {
            this.o.outln("Succesful check");
        }
        this.S.eliminateEmptyScenarios(this.o);
        if (this.dbg) {
            this.o.outln("Succesful elimination");
        }
        if (this.dbg) {
            this.S.print(this.o);
        }
        return this.S;
    }

    public void inASpecification(mscedit.Specification node) {
        this.S = new Specification();
        this.Txs = new HashSet();
    }

    public void outASpecification(mscedit.Specification node) {
        BasicMSC Init = null;
        Init = new BasicMSC();
        if (this.S.getbMSCs().size() > 0) {
            Init.copyComponents((BasicMSC)this.S.getbMSCs().iterator().next());
        }
        Init.name = "Init";
        this.S.addbMSC(Init);
        this.S.addRelationInit(Init);
        Iterator I = this.Txs.iterator();
        while (I.hasNext()) {
            BasicMSC From;
            BasicMSC To;
            Vector v = (Vector)I.next();
            String SFrom = (String)v.get(0);
            String STo = (String)v.get(1);
            if (SFrom.equals("init") && STo.equals("init")) continue;
            if (SFrom.equals("init") && !STo.equals("init")) {
                try {
                    To = this.S.getBMsc(STo);
                }
                catch (Exception e) {
                    this.ErrorMSG = "bMSC '" + STo + "' appears in hMSC but has not been defined.";
                    this.Error = true;
                    return;
                }
                this.S.addRelation(Init, To);
                continue;
            }
            if (!SFrom.equals("init") && STo.equals("init")) {
                try {
                    From = this.S.getBMsc(SFrom);
                }
                catch (Exception e) {
                    this.ErrorMSG = "bMSC '" + SFrom + "' appears in hMSC but has not been defined.";
                    this.Error = true;
                    return;
                }
                this.S.addRelation(From, Init);
                continue;
            }
            try {
                From = this.S.getBMsc(SFrom);
            }
            catch (Exception e) {
                this.ErrorMSG = "bMSC '" + SFrom + "' appears in hMSC but has not been defined.";
                this.Error = true;
                return;
            }
            try {
                To = this.S.getBMsc(STo);
                this.S.addRelation(From, To);
            }
            catch (Exception e) {
                this.ErrorMSG = "bMSC '" + STo + "' appears in hMSC but has not been defined.";
                this.Error = true;
                return;
            }
        }
    }

    public void inABMSC(BMSC node) {
        this.B = new BasicMSC();
    }

    public void outABMSC(BMSC node) {
        this.B.name = node.getName();
        if (!this.buildingNeg) {
            if (!this.S.containsBMsc(this.B.name) && !this.B.name.equals("init")) {
                this.S.addbMSC(this.B);
            } else if (!this.B.name.equals("init")) {
                this.ErrorMSG = "bMSC '" + this.B.name + "' has been defined twice.";
                this.Error = true;
            }
        }
    }

    public void inAInstance(mscedit.Instance node) {
        this.I = new Instance();
    }

    public void outAInstance(mscedit.Instance node) {
        this.B.addInstance(node.getName(), this.I);
    }

    public void outAInput(Input node) {
        InputEvent e = new InputEvent(node.getName());
        e.setFrom(node.getFrom());
        this.I.appendEvent(e);
    }

    public void outAOutput(Output node) {
        OutputEvent e = new OutputEvent(node.getName());
        e.setTo(node.getTo());
        this.I.appendEvent(e);
    }

    public void outATransition(Transition node) {
        String SFrom = node.getFrom();
        String STo = node.getTo();
        Vector<String> v = new Vector<String>();
        v.add(0, SFrom);
        v.add(1, STo);
        this.Txs.add(v);
    }

    public void inANegativeBMSC(BMSC node) {
        this.buildingNeg = true;
    }

    public void outANegativeBMSC(BMSC node) {
        this.buildingNeg = false;
        String proscribed = node.getNegativeLink();
        String lbl = this.B.name;
        if (!this.S.containsBMsc(lbl)) {
            this.S.addBasicNegbMSC(lbl, this.B, proscribed);
        } else {
            this.ErrorMSG = "bMSC '" + this.B.name + "' has been defined twice.";
            this.Error = true;
        }
    }
}

