/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.TimePeriod;
import com.jrefinery.date.SerialDate;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Day
extends TimePeriod {
    protected static final DateFormat standardDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected static final DateFormat dateFormatShort = DateFormat.getDateInstance(3);
    protected static final DateFormat dateFormatMedium = DateFormat.getDateInstance(2);
    protected static final DateFormat dateFormatLong = DateFormat.getDateInstance(1);
    protected SerialDate serialDate;

    public Day() {
        this(new Date());
    }

    public Day(int n, int n2, int n3) {
        this.serialDate = SerialDate.createInstance(n, n2, n3);
    }

    public Day(SerialDate serialDate) {
        this.serialDate = serialDate;
    }

    public Day(Date date) {
        this(date, TimePeriod.DEFAULT_TIME_ZONE);
    }

    public Day(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        int n = calendar.get(5);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(1);
        this.serialDate = SerialDate.createInstance(n, n2, n3);
    }

    public SerialDate getSerialDate() {
        return this.serialDate;
    }

    public int getYear() {
        return this.serialDate.getYYYY();
    }

    public int getMonth() {
        return this.serialDate.getMonth();
    }

    public int getDayOfMonth() {
        return this.serialDate.getDayOfMonth();
    }

    public boolean equals(Object object) {
        if (object != null) {
            return this.serialDate.equals(object);
        }
        return false;
    }

    public TimePeriod previous() {
        int n = this.serialDate.toSerial();
        if (n > SerialDate.SERIAL_LOWER_BOUND) {
            SerialDate serialDate = SerialDate.createInstance(n - 1);
            return new Day(serialDate);
        }
        TimePeriod timePeriod = null;
        return timePeriod;
    }

    public TimePeriod next() {
        int n = this.serialDate.toSerial();
        if (n < SerialDate.SERIAL_UPPER_BOUND) {
            SerialDate serialDate = SerialDate.createInstance(n + 1);
            return new Day(serialDate);
        }
        TimePeriod timePeriod = null;
        return timePeriod;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Day) {
            Day day = (Day)object;
            n = -day.getSerialDate().compare(this.serialDate);
        } else {
            n = object instanceof TimePeriod ? 0 : 1;
        }
        return n;
    }

    public String toString() {
        return this.serialDate.toString();
    }

    public static Day parseDay(String string) {
        Day day = null;
        Date date = null;
        try {
            date = standardDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            try {
                date = dateFormatShort.parse(string);
            }
            catch (ParseException parseException2) {
                // empty catch block
            }
        }
        if (date != null) {
            day = new Day(date);
        }
        return day;
    }

    public long getStart(Calendar calendar) {
        int n = this.serialDate.getYYYY();
        int n2 = this.serialDate.getMonth();
        int n3 = this.serialDate.getDayOfMonth();
        calendar.clear();
        calendar.set(n, n2 - 1, n3, 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public long getEnd(Calendar calendar) {
        int n = this.serialDate.getYYYY();
        int n2 = this.serialDate.getMonth();
        int n3 = this.serialDate.getDayOfMonth();
        calendar.clear();
        calendar.set(n, n2 - 1, n3, 23, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = TimeZone.getAvailableIDs();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println(stringArray2[n]);
            ++n;
        }
        TimeZone timeZone = TimeZone.getTimeZone("Europe/Helsinki");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.clear();
        gregorianCalendar.set(2004, 2, 1, 0, 0, 0);
        System.out.println("Start of 29-Feb-2004 in Helsinki: " + gregorianCalendar.getTime().getTime());
        Date date = new Date(1016533950297L);
        gregorianCalendar.setTime(date);
        Day day = new Day(date);
        System.out.println("Day = " + day.toString());
        System.out.println("Start = " + day.getStart(timeZone));
        System.out.println("End = " + day.getEnd(timeZone));
        System.out.println("Offset = " + timeZone.getRawOffset());
    }
}

