/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.ui.about;

import com.jrefinery.ui.about.AboutPanel;
import com.jrefinery.ui.about.ContributorsPanel;
import com.jrefinery.ui.about.LibraryPanel;
import com.jrefinery.ui.about.ProjectInfo;
import com.jrefinery.ui.about.SystemPropertiesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class AboutFrame
extends JFrame {
    public static final Dimension PREFERRED_SIZE = new Dimension(400, 300);
    public static final Border STANDARD_BORDER = BorderFactory.createEmptyBorder(5, 5, 5, 5);
    protected ResourceBundle resources;
    protected String application;
    protected String version;
    protected String copyright;
    protected String info;
    protected List contributors;
    protected String licence;
    protected List libraries;

    public AboutFrame(String string, ProjectInfo projectInfo) {
        this(string, projectInfo.getName(), "Version " + projectInfo.getVersion(), projectInfo.getInfo(), projectInfo.getCopyright(), projectInfo.getLicenceText(), projectInfo.getContributors(), projectInfo.getLibraries());
    }

    public AboutFrame(String string, String string2, String string3, String string4, String string5, String string6, List list, List list2) {
        super(string);
        this.application = string2;
        this.version = string3;
        this.copyright = string5;
        this.info = string4;
        this.contributors = list;
        this.licence = string6;
        this.libraries = list2;
        String string7 = "com.jrefinery.ui.about.resources.AboutResources";
        this.resources = ResourceBundle.getBundle(string7);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(STANDARD_BORDER);
        JTabbedPane jTabbedPane = this.createTabs();
        jPanel.add(jTabbedPane);
        this.setContentPane(jPanel);
        this.pack();
    }

    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    private JTabbedPane createTabs() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = this.createAboutPanel();
        jPanel.setBorder(STANDARD_BORDER);
        String string = this.resources.getString("about-frame.tab.about");
        jTabbedPane.add(string, jPanel);
        SystemPropertiesPanel systemPropertiesPanel = new SystemPropertiesPanel();
        systemPropertiesPanel.setBorder(STANDARD_BORDER);
        String string2 = this.resources.getString("about-frame.tab.system");
        jTabbedPane.add(string2, systemPropertiesPanel);
        return jTabbedPane;
    }

    private JPanel createAboutPanel() {
        String string;
        JPanel jPanel;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        AboutPanel aboutPanel = new AboutPanel(this.application, this.version, this.copyright, this.info);
        boolean bl = false;
        JTabbedPane jTabbedPane = new JTabbedPane();
        if (this.contributors != null) {
            jPanel = new ContributorsPanel(this.contributors);
            jPanel.setBorder(STANDARD_BORDER);
            string = this.resources.getString("about-frame.tab.contributors");
            jTabbedPane.add(string, jPanel);
            bl = true;
        }
        if (this.licence != null) {
            jPanel = this.createLicencePanel();
            jPanel.setBorder(STANDARD_BORDER);
            string = this.resources.getString("about-frame.tab.licence");
            jTabbedPane.add(string, jPanel);
            bl = true;
        }
        if (this.libraries != null) {
            jPanel = new LibraryPanel(this.libraries);
            jPanel.setBorder(STANDARD_BORDER);
            string = this.resources.getString("about-frame.tab.libraries");
            jTabbedPane.add(string, jPanel);
            bl = true;
        }
        jPanel2.add((Component)aboutPanel, "North");
        if (bl) {
            jPanel2.add(jTabbedPane);
        }
        return jPanel2;
    }

    private JPanel createLicencePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea(this.licence);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setCaretPosition(0);
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jPanel.add(new JScrollPane(jTextArea));
        return jPanel;
    }
}

