/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.JFreeChart;
import com.keypoint.PngEncoder;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ChartUtilities {
    public static void writeChartAsPNG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2) throws IOException {
        BufferedImage bufferedImage = jFreeChart.createBufferedImage(n, n2);
        PngEncoder pngEncoder = new PngEncoder((Image)bufferedImage, false, 0, 9);
        byte[] byArray = pngEncoder.pngEncode();
        outputStream.write(byArray);
    }

    public static void saveChartAsPNG(File file, JFreeChart jFreeChart, int n, int n2) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        ChartUtilities.writeChartAsPNG(dataOutputStream, jFreeChart, n, n2);
        dataOutputStream.close();
    }

    public static void writeChartAsJPEG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2) throws IOException {
        BufferedImage bufferedImage = jFreeChart.createBufferedImage(n, n2);
        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)outputStream);
        JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
        jPEGEncodeParam.setQuality(1.0f, true);
        jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
    }

    public static void saveChartAsJPEG(File file, JFreeChart jFreeChart, int n, int n2) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        ChartUtilities.writeChartAsJPEG(bufferedOutputStream, jFreeChart, n, n2);
        ((OutputStream)bufferedOutputStream).close();
    }
}

