/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.event.AxisChangeEvent;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;

public class HorizontalNumberAxis
extends NumberAxis
implements HorizontalAxis {
    protected boolean verticalTickLabels;

    public HorizontalNumberAxis(String string) {
        this(string, AxisConstants.DEFAULT_AXIS_LABEL_FONT, 0.0, 1.0);
        this.autoRange = true;
    }

    public HorizontalNumberAxis(String string, Font font, double d, double d2) {
        this(string, font, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, false, true, AxisConstants.DEFAULT_TICK_STROKE, false, true, true, NumberAxis.DEFAULT_MINIMUM_AUTO_RANGE, d, d2, false, true, NumberAxis.DEFAULT_TICK_UNIT, true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, 0.0, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT);
    }

    public HorizontalNumberAxis(String string, Font font, Paint paint, Insets insets, boolean bl, Font font2, Paint paint2, Insets insets2, boolean bl2, boolean bl3, Stroke stroke, boolean bl4, boolean bl5, boolean bl6, Number number, double d, double d2, boolean bl7, boolean bl8, NumberTickUnit numberTickUnit, boolean bl9, Stroke stroke2, Paint paint3, boolean bl10, double d3, Stroke stroke3, Paint paint4) {
        super(string, font, paint, insets, bl, font2, paint2, insets2, bl3, stroke, bl4, bl5, bl6, number, d, d2, bl7, bl8, numberTickUnit, bl9, stroke2, paint3, bl10, d3, stroke3, paint4);
        this.verticalTickLabels = bl2;
    }

    public boolean getVerticalTickLabels() {
        return this.verticalTickLabels;
    }

    public void setVerticalTickLabels(boolean bl) {
        this.verticalTickLabels = bl;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    public double translateValueToJava2D(double d, Rectangle2D rectangle2D) {
        double d2 = this.minimumAxisValue;
        double d3 = this.maximumAxisValue;
        double d4 = rectangle2D.getX();
        double d5 = rectangle2D.getMaxX();
        if (this.inverted) {
            return d5 - (d - d2) / (d3 - d2) * (d5 - d4);
        }
        return d4 + (d - d2) / (d3 - d2) * (d5 - d4);
    }

    public double translateJava2DtoValue(float f, Rectangle2D rectangle2D) {
        double d = this.minimumAxisValue;
        double d2 = this.maximumAxisValue;
        double d3 = rectangle2D.getX();
        double d4 = rectangle2D.getMaxX();
        if (this.inverted) {
            return d2 - ((double)f - d3) / (d4 - d3) * (d2 - d);
        }
        return d + ((double)f - d3) / (d4 - d3) * (d2 - d);
    }

    protected void autoAdjustRange() {
        if (this.plot != null && this.plot instanceof HorizontalValuePlot) {
            double d;
            double d2;
            HorizontalValuePlot horizontalValuePlot = (HorizontalValuePlot)((Object)this.plot);
            Number number = horizontalValuePlot.getMaximumHorizontalDataValue();
            double d3 = 1.0;
            if (number != null) {
                d3 = number.doubleValue();
            }
            Number number2 = horizontalValuePlot.getMinimumHorizontalDataValue();
            double d4 = 0.0;
            if (number2 != null) {
                d4 = number2.doubleValue();
            }
            if ((d2 = d3 - d4) < (d = this.autoRangeMinimumSize.doubleValue())) {
                d3 = (d3 + d4 + d) / 2.0;
                d4 = (d3 + d4 - d) / 2.0;
            }
            if (this.autoRangeIncludesZero) {
                if (this.autoRangeStickyZero) {
                    d3 = d3 <= 0.0 ? 0.0 : (d3 += this.upperMargin * d2);
                    d4 = d4 >= 0.0 ? 0.0 : (d4 -= this.lowerMargin * d2);
                } else {
                    d3 = Math.max(0.0, d3 + this.upperMargin * d2);
                    d4 = Math.min(0.0, d4 - this.lowerMargin * d2);
                }
            } else if (this.autoRangeStickyZero) {
                d3 = d3 <= 0.0 ? Math.min(0.0, d3 + this.upperMargin * d2) : (d3 += this.upperMargin * d2);
                d4 = d4 >= 0.0 ? Math.max(0.0, d4 - this.lowerMargin * d2) : (d4 -= this.lowerMargin * d2);
            } else {
                d3 += this.upperMargin * d2;
                d4 -= this.lowerMargin * d2;
            }
            this.minimumAxisValue = d4;
            this.maximumAxisValue = d3;
        }
    }

    public void refreshTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        this.ticks.clear();
        graphics2D.setFont(this.tickLabelFont);
        if (this.autoTickUnitSelection) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangle2D2);
        }
        double d = this.tickUnit.getValue().doubleValue();
        int n = this.calculateVisibleTickCount();
        double d2 = this.calculateLowestVisibleTickValue();
        int n2 = 0;
        while (n2 < n) {
            double d3 = d2 + (double)n2 * d;
            double d4 = this.translateValueToJava2D(d3, rectangle2D2);
            String string = this.valueToString(d3);
            Rectangle2D rectangle2D3 = this.tickLabelFont.getStringBounds(string, graphics2D.getFontRenderContext());
            float f = 0.0f;
            float f2 = 0.0f;
            if (this.verticalTickLabels) {
                f = (float)(d4 + rectangle2D3.getHeight() / 2.0);
                f2 = (float)(rectangle2D2.getMaxY() + (double)this.tickLabelInsets.top + rectangle2D3.getWidth());
            } else {
                f = (float)(d4 - rectangle2D3.getWidth() / 2.0);
                f2 = (float)(rectangle2D2.getMaxY() + (double)this.tickLabelInsets.top + rectangle2D3.getHeight());
            }
            Tick tick = new Tick(new Double(d3), string, f, f2);
            this.ticks.add(tick);
            ++n2;
        }
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        float f;
        Object object;
        Object object2;
        if (this.label != null) {
            graphics2D.setFont(this.labelFont);
            graphics2D.setPaint(this.labelPaint);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            object2 = this.labelFont.getStringBounds(this.label, fontRenderContext);
            object = this.labelFont.getLineMetrics(this.label, fontRenderContext);
            f = (float)(rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0 - ((RectangularShape)object2).getWidth() / 2.0);
            float f2 = (float)(rectangle2D.getMaxY() - (double)this.labelInsets.bottom - (double)((LineMetrics)object).getDescent() - (double)((LineMetrics)object).getLeading());
            graphics2D.drawString(this.label, f, f2);
        }
        this.refreshTicks(graphics2D, rectangle2D, rectangle2D2);
        float f3 = (float)rectangle2D2.getMaxY();
        graphics2D.setFont(this.getTickLabelFont());
        object2 = this.ticks.iterator();
        while (object2.hasNext()) {
            object = (Tick)object2.next();
            f = (float)this.translateValueToJava2D(((Tick)object).getNumericalValue(), rectangle2D2);
            if (this.tickLabelsVisible) {
                graphics2D.setPaint(this.tickLabelPaint);
                if (this.verticalTickLabels) {
                    this.drawVerticalString(((Tick)object).getText(), graphics2D, ((Tick)object).getX(), ((Tick)object).getY());
                } else {
                    graphics2D.drawString(((Tick)object).getText(), ((Tick)object).getX(), ((Tick)object).getY());
                }
            }
            if (this.tickMarksVisible) {
                graphics2D.setStroke(this.getTickMarkStroke());
                Line2D.Float float_ = new Line2D.Float(f, f3 - 2.0f, f, f3 + 2.0f);
                graphics2D.draw(float_);
            }
            if (!this.gridLinesVisible) continue;
            graphics2D.setStroke(this.gridStroke);
            graphics2D.setPaint(this.gridPaint);
            Line2D.Float float_ = new Line2D.Float(f, (float)rectangle2D2.getMaxY(), f, (float)rectangle2D2.getMinY());
            graphics2D.draw(float_);
        }
    }

    public double reserveHeight(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D) {
        double d = 0.0;
        if (this.label != null) {
            LineMetrics lineMetrics = this.labelFont.getLineMetrics(this.label, graphics2D.getFontRenderContext());
            d = (float)this.labelInsets.top + lineMetrics.getHeight() + (float)this.labelInsets.bottom;
        }
        double d2 = this.tickLabelInsets.top + this.tickLabelInsets.bottom;
        if (this.tickLabelsVisible) {
            graphics2D.setFont(this.tickLabelFont);
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D);
            d2 += this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.verticalTickLabels);
        }
        return d + d2;
    }

    public Rectangle2D reserveAxisArea(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, double d) {
        double d2 = 0.0;
        if (this.label != null) {
            LineMetrics lineMetrics = this.labelFont.getLineMetrics(this.label, graphics2D.getFontRenderContext());
            d2 = (float)this.labelInsets.top + lineMetrics.getHeight() + (float)this.labelInsets.bottom;
        }
        double d3 = this.tickLabelInsets.top + this.tickLabelInsets.bottom;
        if (this.tickLabelsVisible) {
            graphics2D.setFont(this.tickLabelFont);
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D);
            d3 += this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.verticalTickLabels);
        }
        return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getMaxY(), rectangle2D.getWidth() - d, d2 + d3);
    }

    private void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        NumberTickUnit numberTickUnit;
        double d;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d2 = this.tickLabelInsets.left + this.tickLabelInsets.right;
        if (this.verticalTickLabels) {
            d2 += this.tickLabelFont.getStringBounds("123", fontRenderContext).getHeight();
        } else {
            d = this.tickLabelFont.getStringBounds(this.valueToString(this.minimumAxisValue), fontRenderContext).getWidth();
            double d3 = this.tickLabelFont.getStringBounds(this.valueToString(this.maximumAxisValue), fontRenderContext).getWidth();
            d2 += Math.max(d, d3);
        }
        d = this.translateValueToJava2D(0.0, rectangle2D2);
        NumberTickUnit numberTickUnit2 = (NumberTickUnit)this.standardTickUnits.getNearestTickUnit(this.tickUnit);
        double d4 = this.translateValueToJava2D(numberTickUnit2.getValue().doubleValue(), rectangle2D2);
        double d5 = Math.abs(d4 - d);
        double d6 = d2 / d5 * numberTickUnit2.value.doubleValue();
        NumberTickUnit numberTickUnit3 = new NumberTickUnit(new Double(d6), null);
        this.tickUnit = numberTickUnit = (NumberTickUnit)this.standardTickUnits.getNearestTickUnit(numberTickUnit3);
    }

    private double getMaxTickLabelHeight(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl) {
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d = 0.0;
        if (bl) {
            Iterator iterator = this.ticks.iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                Rectangle2D rectangle2D2 = font.getStringBounds(tick.getText(), fontRenderContext);
                if (!(rectangle2D2.getWidth() > d)) continue;
                d = rectangle2D2.getWidth();
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("Sample", fontRenderContext);
            d = lineMetrics.getHeight();
        }
        return d;
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof HorizontalValuePlot;
    }
}

