/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.TickUnits;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.event.AxisChangeEvent;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DecimalFormat;

public abstract class NumberAxis
extends ValueAxis {
    public static final boolean DEFAULT_AUTO_RANGE_INCLUDES_ZERO = true;
    public static final boolean DEFAULT_AUTO_RANGE_STICKY_ZERO = true;
    public static final double DEFAULT_UPPER_MARGIN = 0.05;
    public static final double DEFAULT_LOWER_MARGIN = 0.05;
    public static final Number DEFAULT_MINIMUM_AUTO_RANGE = new Double(1.0E-7);
    public static final NumberTickUnit DEFAULT_TICK_UNIT = new NumberTickUnit(new Double(1.0), new DecimalFormat("0"));
    protected boolean inverted;
    protected boolean autoRangeIncludesZero;
    protected boolean autoRangeStickyZero;
    protected Number autoRangeMinimumSize;
    protected double upperMargin;
    protected double lowerMargin;
    protected NumberTickUnit tickUnit;
    protected TickUnits standardTickUnits;

    protected NumberAxis(String string) {
        this(string, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_STROKE, true, true, true, DEFAULT_MINIMUM_AUTO_RANGE, 0.0, 1.0, false, true, DEFAULT_TICK_UNIT, true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, 0.0, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT);
    }

    protected NumberAxis(String string, Font font, Paint paint, Insets insets, boolean bl, Font font2, Paint paint2, Insets insets2, boolean bl2, Stroke stroke, boolean bl3, boolean bl4, boolean bl5, Number number, double d, double d2, boolean bl6, boolean bl7, NumberTickUnit numberTickUnit, boolean bl8, Stroke stroke2, Paint paint3, boolean bl9, double d3, Stroke stroke3, Paint paint4) {
        super(string, font, paint, insets, bl, font2, paint2, insets2, bl2, stroke, bl3, bl7, bl8, stroke2, paint3, bl9, d3, stroke3, paint4);
        if (d >= d2) {
            throw new IllegalArgumentException("NumberAxis(...): minimum axis value must be less than maximum axis value.");
        }
        if (number == null) {
            throw new IllegalArgumentException("NumberAxis(...): autoRangeMinimum cannot be null.");
        }
        this.autoRangeIncludesZero = bl4;
        this.autoRangeStickyZero = bl5;
        this.autoRangeMinimumSize = number;
        this.minimumAxisValue = d;
        this.maximumAxisValue = d2;
        this.anchorValue = 0.0;
        this.inverted = bl6;
        this.tickUnit = numberTickUnit;
        this.upperMargin = 0.05;
        this.lowerMargin = 0.05;
        this.standardTickUnits = TickUnits.createStandardTickUnits();
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean bl) {
        if (this.inverted != bl) {
            this.inverted = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean autoRangeIncludesZero() {
        return this.autoRangeIncludesZero;
    }

    public void setAutoRangeIncludesZero(boolean bl) {
        if (this.autoRangeIncludesZero != bl) {
            this.autoRangeIncludesZero = bl;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean autoRangeStickyZero() {
        return this.autoRangeStickyZero;
    }

    public void setAutoRangeStickyZero(boolean bl) {
        if (this.autoRangeStickyZero != bl) {
            this.autoRangeStickyZero = bl;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Number getAutoRangeMinimumSize() {
        return this.autoRangeMinimumSize;
    }

    public void setAutoRangeMinimumSize(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("NumberAxis.setAutoRangeMinimumSize(Number): null not permitted.");
        }
        if (this.autoRangeMinimumSize.doubleValue() != number.doubleValue()) {
            this.autoRangeMinimumSize = number;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double d) {
        this.upperMargin = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double d) {
        this.lowerMargin = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public TickUnits getStandardTickUnits() {
        return this.standardTickUnits;
    }

    public void setStandardTickUnits(TickUnits tickUnits) {
        this.standardTickUnits = tickUnits;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public NumberTickUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(NumberTickUnit numberTickUnit) {
        this.autoTickUnitSelection = false;
        this.tickUnit = numberTickUnit;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public String valueToString(double d) {
        return this.tickUnit.formatter.format(d);
    }

    public double calculateLowestVisibleTickValue() {
        double d = this.getTickUnit().getValue().doubleValue();
        double d2 = Math.ceil(this.minimumAxisValue / d);
        return d2 * d;
    }

    public double calculateHighestVisibleTickValue() {
        double d = this.getTickUnit().getValue().doubleValue();
        double d2 = Math.floor(this.maximumAxisValue / d);
        return d2 * d;
    }

    public int calculateVisibleTickCount() {
        double d = this.getTickUnit().getValue().doubleValue();
        return (int)(Math.floor(this.maximumAxisValue / d) - Math.ceil(this.minimumAxisValue / d) + 1.0);
    }
}

