/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.TickUnit;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TickUnits {
    protected List units = new ArrayList();

    public void add(TickUnit tickUnit) {
        this.units.add(tickUnit);
        Collections.sort(this.units);
    }

    public TickUnit getNearestTickUnit(TickUnit tickUnit) {
        int n = Collections.binarySearch(this.units, tickUnit);
        if (n >= 0) {
            return (TickUnit)this.units.get(n);
        }
        n = -(n + 1);
        return (TickUnit)this.units.get(Math.min(n, this.units.size() - 1));
    }

    public TickUnit getNearestTickUnit(Number number) {
        return this.getNearestTickUnit(new NumberTickUnit(number, null));
    }

    public static TickUnits createStandardTickUnits() {
        TickUnits tickUnits = new TickUnits();
        tickUnits.add(new NumberTickUnit(new Double(1.0E-7), new DecimalFormat("0.0000000")));
        tickUnits.add(new NumberTickUnit(new Double(1.0E-6), new DecimalFormat("0.000000")));
        tickUnits.add(new NumberTickUnit(new Double(1.0E-5), new DecimalFormat("0.00000")));
        tickUnits.add(new NumberTickUnit(new Double(1.0E-4), new DecimalFormat("0.0000")));
        tickUnits.add(new NumberTickUnit(new Double(0.001), new DecimalFormat("0.000")));
        tickUnits.add(new NumberTickUnit(new Double(0.01), new DecimalFormat("0.00")));
        tickUnits.add(new NumberTickUnit(new Double(0.1), new DecimalFormat("0.0")));
        tickUnits.add(new NumberTickUnit(new Long(1L), new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(new Long(10L), new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(new Long(100L), new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(new Long(1000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(10000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(100000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(1000000L), new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(new Long(10000000L), new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(new Long(100000000L), new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(new Long(1000000000L), new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(new Double(2.5E-7), new DecimalFormat("0.00000000")));
        tickUnits.add(new NumberTickUnit(new Double(2.5E-6), new DecimalFormat("0.0000000")));
        tickUnits.add(new NumberTickUnit(new Double(2.5E-5), new DecimalFormat("0.000000")));
        tickUnits.add(new NumberTickUnit(new Double(2.5E-4), new DecimalFormat("0.00000")));
        tickUnits.add(new NumberTickUnit(new Double(0.0025), new DecimalFormat("0.0000")));
        tickUnits.add(new NumberTickUnit(new Double(0.025), new DecimalFormat("0.000")));
        tickUnits.add(new NumberTickUnit(new Double(0.25), new DecimalFormat("0.00")));
        tickUnits.add(new NumberTickUnit(new Double(2.5), new DecimalFormat("0.0")));
        tickUnits.add(new NumberTickUnit(new Long(25L), new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(new Long(250L), new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(new Long(2500L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(25000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(250000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(2500000L), new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(new Long(25000000L), new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(new Long(250000000L), new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(new Long(2500000000L), new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(new Double(5.0E-7), new DecimalFormat("0.0000000")));
        tickUnits.add(new NumberTickUnit(new Double(5.0E-6), new DecimalFormat("0.000000")));
        tickUnits.add(new NumberTickUnit(new Double(5.0E-5), new DecimalFormat("0.00000")));
        tickUnits.add(new NumberTickUnit(new Double(5.0E-4), new DecimalFormat("0.0000")));
        tickUnits.add(new NumberTickUnit(new Double(0.005), new DecimalFormat("0.000")));
        tickUnits.add(new NumberTickUnit(new Double(0.05), new DecimalFormat("0.00")));
        tickUnits.add(new NumberTickUnit(new Double(0.5), new DecimalFormat("0.0")));
        tickUnits.add(new NumberTickUnit(new Long(5L), new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(new Long(50L), new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(new Long(500L), new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(new Long(5000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(50000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(500000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(5000000L), new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(new Long(50000000L), new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(new Long(500000000L), new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(new Long(5000000000L), new DecimalFormat("#,###,###,##0")));
        return tickUnits;
    }

    public static TickUnits createIntegerTickUnits() {
        TickUnits tickUnits = new TickUnits();
        tickUnits.add(new NumberTickUnit(new Long(1L), new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(new Long(2L), new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(new Long(5L), new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(new Long(10L), new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(new Long(20L), new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(new Long(50L), new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(new Long(100L), new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(new Long(200L), new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(new Long(500L), new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(new Long(1000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(2000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(5000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(10000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(20000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(50000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(100000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(200000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(500000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(1000000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(2000000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(5000000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(10000000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(20000000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(50000000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(100000000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(200000000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(500000000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(1000000000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(2000000000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(5000000000L), new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(new Long(10000000000L), new DecimalFormat("#,##0")));
        return tickUnits;
    }
}

