/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.HorizontalCategoryAxis;
import com.jrefinery.chart.HorizontalDateAxis;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.JFreeChartFrame;
import com.jrefinery.chart.JFreeChartInfo;
import com.jrefinery.chart.JFreeChartPanel;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.PiePlot;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.Spacer;
import com.jrefinery.chart.TextTitle;
import com.jrefinery.chart.TickUnits;
import com.jrefinery.chart.VerticalLogarithmicAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.combination.CombinedChart;
import com.jrefinery.chart.combination.CombinedPlot;
import com.jrefinery.chart.combination.OverlaidPlot;
import com.jrefinery.chart.data.MovingAveragePlotFitAlgorithm;
import com.jrefinery.chart.data.PlotFit;
import com.jrefinery.chart.demo.DemoDatasetFactory;
import com.jrefinery.chart.demo.DescriptionPanel;
import com.jrefinery.chart.demo.EmptyXYDataset;
import com.jrefinery.chart.demo.SampleXYDataset;
import com.jrefinery.chart.demo.SampleXYDataset2;
import com.jrefinery.chart.demo.SampleXYDatasetThread;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.CombinedDataset;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DatasetUtilities;
import com.jrefinery.data.HighLowDataset;
import com.jrefinery.data.IntervalXYDataset;
import com.jrefinery.data.PieDataset;
import com.jrefinery.data.SeriesDataset;
import com.jrefinery.data.SignalsDataset;
import com.jrefinery.data.SubSeriesDataset;
import com.jrefinery.data.TimeSeriesCollection;
import com.jrefinery.data.WindDataset;
import com.jrefinery.data.XYDataset;
import com.jrefinery.layout.LCBLayout;
import com.jrefinery.ui.JRefineryUtilities;
import com.jrefinery.ui.about.AboutFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class JFreeChartDemo
extends JFrame
implements ActionListener,
WindowListener {
    public static final String EXIT_COMMAND = "EXIT";
    public static final String ABOUT_COMMAND = "ABOUT";
    public static final String CHART_1_COMMAND = "HORIZONTAL_BAR_CHART";
    public static final String CHART_2_COMMAND = "HORIZONTAL_STACKED_BAR_CHART";
    public static final String CHART_3_COMMAND = "VERTICAL_BAR_CHART";
    public static final String CHART_4_COMMAND = "VERTICAL_3D_BAR_CHART";
    public static final String CHART_5_COMMAND = "VERTICAL_STACKED_BAR_CHART";
    public static final String CHART_6_COMMAND = "VERTICAL_STACKED_3D_BAR_CHART";
    public static final String CHART_7_COMMAND = "PIE_CHART_1";
    public static final String CHART_8_COMMAND = "PIE_CHART_2";
    public static final String CHART_9_COMMAND = "XY_PLOT";
    public static final String CHART_10_COMMAND = "TIME_SERIES_1_CHART";
    public static final String CHART_11_COMMAND = "TIME_SERIES_2_CHART";
    public static final String CHART_12_COMMAND = "TIME_SERIES_WITH_MA_CHART";
    public static final String CHART_13_COMMAND = "HIGH_LOW_CHART";
    public static final String CHART_14_COMMAND = "CANDLESTICK_CHART";
    public static final String CHART_15_COMMAND = "SIGNAL_CHART";
    public static final String CHART_16_COMMAND = "WIND_PLOT";
    public static final String CHART_17_COMMAND = "SCATTER_PLOT";
    public static final String CHART_18_COMMAND = "LINE_CHART";
    public static final String CHART_19_COMMAND = "VERTICAL_XY_BAR_CHART";
    public static final String CHART_20_COMMAND = "XY_PLOT_NULL";
    public static final String CHART_21_COMMAND = "XY_PLOT_ZERO";
    public static final String CHART_22_COMMAND = "TIME_SERIES_CHART_SCROLL";
    public static final String CHART_23_COMMAND = "SINGLE_SERIES_BAR_CHART";
    public static final String CHART_24_COMMAND = "DYNAMIC_CHART";
    public static final String CHART_25_COMMAND = "OVERLAID_CHART";
    public static final String CHART_26_COMMAND = "VERTICALLY_COMBINED_CHART";
    public static final String CHART_27_COMMAND = "HORIZONTALLY_COMBINED_CHART";
    public static final String CHART_28_COMMAND = "COMBINED_OVERLAID_CHART";
    public static final String CHART_29_COMMAND = "COMBINED_OVERLAID_DYNAMIC_CHART";
    public static final Dimension PREFERRED_SIZE = new Dimension(780, 400);
    private JFreeChartFrame horizontalBarChartFrame;
    private JFreeChartFrame horizontalStackedBarChartFrame;
    private JFreeChartFrame verticalBarChartFrame;
    private JFreeChartFrame verticalStackedBarChartFrame;
    private JFreeChartFrame vertical3DBarChartFrame;
    private JFreeChartFrame verticalStacked3DBarChartFrame;
    private JFreeChartFrame verticalXYBarChartFrame;
    private JFreeChartFrame lineChartFrame;
    private JFreeChartFrame pieChartOneFrame;
    private JFreeChartFrame pieChartTwoFrame;
    private JFreeChartFrame scatterPlotFrame;
    private JFreeChartFrame windPlotFrame;
    private JFreeChartFrame xyPlotFrame;
    private JFreeChartFrame xyPlotNullDataFrame;
    private JFreeChartFrame xyPlotZeroDataFrame;
    private JFreeChartFrame timeSeries1ChartFrame;
    private JFreeChartFrame timeSeries2ChartFrame;
    private JFreeChartFrame timeSeriesWithMAChartFrame;
    private JFreeChartFrame timeSeriesChartScrollFrame;
    private JFreeChartFrame highLowChartFrame;
    private JFreeChartFrame candlestickChartFrame;
    private JFreeChartFrame signalChartFrame;
    private JFreeChartFrame dynamicXYChartFrame;
    private JFreeChartFrame singleSeriesBarChartFrame;
    private JFreeChartFrame horizontallyCombinedChartFrame;
    private JFreeChartFrame verticallyCombinedChartFrame;
    private JFreeChartFrame combinedOverlaidChartFrame1;
    private JFreeChartFrame overlaidChartFrame;
    private JFreeChartFrame combinedAndOverlaidDynamicXYChartFrame;
    private AboutFrame aboutFrame;
    private JTabbedPane tabbedPane;
    private ResourceBundle resources;
    static /* synthetic */ Class class$com$jrefinery$chart$demo$JFreeChartDemo;

    public JFreeChartDemo() {
        super("JFreeChart 0.8.1 Demo");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JFreeChartDemo.this.dispose();
                System.exit(0);
            }
        });
        String string = "com.jrefinery.chart.demo.resources.DemoResources";
        this.resources = ResourceBundle.getBundle(string);
        JMenuBar jMenuBar = this.createMenuBar(this.resources);
        this.setJMenuBar(jMenuBar);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.createTabbedPane(this.resources));
        this.setContentPane(jPanel);
    }

    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(EXIT_COMMAND)) {
            this.attemptExit();
        } else if (string.equals(ABOUT_COMMAND)) {
            this.about();
        } else if (string.equals(CHART_1_COMMAND)) {
            this.displayHorizontalBarChart();
        } else if (string.equals(CHART_2_COMMAND)) {
            this.displayHorizontalStackedBarChart();
        } else if (string.equals(CHART_3_COMMAND)) {
            this.displayVerticalBarChart();
        } else if (string.equals(CHART_4_COMMAND)) {
            this.displayVertical3DBarChart();
        } else if (string.equals(CHART_5_COMMAND)) {
            this.displayVerticalStackedBarChart();
        } else if (string.equals(CHART_6_COMMAND)) {
            this.displayVerticalStacked3DBarChart();
        } else if (string.equals(CHART_7_COMMAND)) {
            this.displayPieChartOne();
        } else if (string.equals(CHART_8_COMMAND)) {
            this.displayPieChartTwo();
        } else if (string.equals(CHART_9_COMMAND)) {
            this.displayXYPlot();
        } else if (string.equals(CHART_10_COMMAND)) {
            this.displayTimeSeries1Chart();
        } else if (string.equals(CHART_11_COMMAND)) {
            this.displayTimeSeries2Chart();
        } else if (string.equals(CHART_12_COMMAND)) {
            this.displayTimeSeriesWithMAChart();
        } else if (string.equals(CHART_13_COMMAND)) {
            this.displayHighLowChart();
        } else if (string.equals(CHART_14_COMMAND)) {
            this.displayCandlestickChart();
        } else if (string.equals(CHART_15_COMMAND)) {
            this.displaySignalChart();
        } else if (string.equals(CHART_16_COMMAND)) {
            this.displayWindPlot();
        } else if (string.equals(CHART_17_COMMAND)) {
            this.displayScatterPlot();
        } else if (string.equals(CHART_18_COMMAND)) {
            this.displayLineChart();
        } else if (string.equals(CHART_19_COMMAND)) {
            this.displayVerticalXYBarChart();
        } else if (string.equals(CHART_20_COMMAND)) {
            this.displayNullXYPlot();
        } else if (string.equals(CHART_21_COMMAND)) {
            this.displayXYPlotZeroData();
        } else if (string.equals(CHART_22_COMMAND)) {
            this.displayTimeSeriesChartInScrollPane();
        } else if (string.equals(CHART_23_COMMAND)) {
            this.displaySingleSeriesBarChart();
        } else if (string.equals(CHART_24_COMMAND)) {
            this.displayDynamicXYChart();
        } else if (string.equals(CHART_25_COMMAND)) {
            this.displayOverlaidChart();
        } else if (string.equals(CHART_26_COMMAND)) {
            this.displayHorizontallyCombinedChart();
        } else if (string.equals(CHART_27_COMMAND)) {
            this.displayVerticallyCombinedChart();
        } else if (string.equals(CHART_28_COMMAND)) {
            this.displayCombinedAndOverlaidChart1();
        } else if (string.equals(CHART_29_COMMAND)) {
            this.displayCombinedAndOverlaidDynamicXYChart();
        }
    }

    private void attemptExit() {
        String string = this.resources.getString("dialog.exit.title");
        String string2 = this.resources.getString("dialog.exit.message");
        int n = JOptionPane.showConfirmDialog(this, string2, string, 0, 3);
        if (n == 0) {
            this.dispose();
            System.exit(0);
        }
    }

    private void displayHorizontalBarChart() {
        if (this.horizontalBarChartFrame == null) {
            String string = this.resources.getString("bar.horizontal.title");
            String string2 = this.resources.getString("bar.horizontal.domain");
            String string3 = this.resources.getString("bar.horizontal.range");
            CategoryDataset categoryDataset = DemoDatasetFactory.createCategoryDataset();
            JFreeChart jFreeChart = ChartFactory.createHorizontalBarChart(string, string2, string3, categoryDataset, true);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.orange));
            Plot plot = jFreeChart.getPlot();
            NumberAxis numberAxis = (NumberAxis)plot.getAxis(0);
            numberAxis.setCrosshairVisible(false);
            numberAxis.setInverted(true);
            this.horizontalBarChartFrame = new JFreeChartFrame(string, jFreeChart);
            this.horizontalBarChartFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.horizontalBarChartFrame);
            this.horizontalBarChartFrame.show();
        } else {
            this.horizontalBarChartFrame.show();
            this.horizontalBarChartFrame.requestFocus();
        }
    }

    private void displayHorizontalStackedBarChart() {
        if (this.horizontalStackedBarChartFrame == null) {
            String string = this.resources.getString("bar.horizontal-stacked.title");
            String string2 = this.resources.getString("bar.horizontal-stacked.domain");
            String string3 = this.resources.getString("bar.horizontal-stacked.range");
            CategoryDataset categoryDataset = DemoDatasetFactory.createCategoryDataset();
            JFreeChart jFreeChart = ChartFactory.createStackedHorizontalBarChart(string, string2, string3, categoryDataset, true);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
            Plot plot = jFreeChart.getPlot();
            this.horizontalStackedBarChartFrame = new JFreeChartFrame(string, jFreeChart);
            this.horizontalStackedBarChartFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.horizontalStackedBarChartFrame);
            this.horizontalStackedBarChartFrame.show();
        } else {
            this.horizontalStackedBarChartFrame.show();
            this.horizontalStackedBarChartFrame.requestFocus();
        }
    }

    private void displayVerticalBarChart() {
        if (this.verticalBarChartFrame == null) {
            String string = this.resources.getString("bar.vertical.title");
            String string2 = this.resources.getString("bar.vertical.domain");
            String string3 = this.resources.getString("bar.vertical.range");
            CategoryDataset categoryDataset = DemoDatasetFactory.createCategoryDataset();
            JFreeChart jFreeChart = ChartFactory.createVerticalBarChart(string, string2, string3, categoryDataset, true);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
            CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
            categoryPlot.setForegroundAlpha(0.9f);
            NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
            numberAxis.setStandardTickUnits(TickUnits.createIntegerTickUnits());
            this.verticalBarChartFrame = new JFreeChartFrame(string, jFreeChart);
            this.verticalBarChartFrame.getChartPanel().setToolTipGeneration(false);
            this.verticalBarChartFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.verticalBarChartFrame);
            this.verticalBarChartFrame.show();
        } else {
            this.verticalBarChartFrame.show();
            this.verticalBarChartFrame.requestFocus();
        }
    }

    private void displayVertical3DBarChart() {
        if (this.vertical3DBarChartFrame == null) {
            String string = this.resources.getString("bar.vertical3D.title");
            String string2 = this.resources.getString("bar.vertical3D.domain");
            String string3 = this.resources.getString("bar.vertical3D.range");
            CategoryDataset categoryDataset = DemoDatasetFactory.createCategoryDataset();
            JFreeChart jFreeChart = ChartFactory.createVerticalBarChart3D(string, string2, string3, categoryDataset, true);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
            CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
            categoryPlot.setForegroundAlpha(0.75f);
            NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
            this.vertical3DBarChartFrame = new JFreeChartFrame("Vertical 3D Bar Chart", jFreeChart);
            this.vertical3DBarChartFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.vertical3DBarChartFrame);
            this.vertical3DBarChartFrame.show();
        } else {
            this.vertical3DBarChartFrame.show();
            this.vertical3DBarChartFrame.requestFocus();
        }
    }

    private void displayVerticalStackedBarChart() {
        if (this.verticalStackedBarChartFrame == null) {
            String string = this.resources.getString("bar.vertical-stacked.title");
            String string2 = this.resources.getString("bar.vertical-stacked.domain");
            String string3 = this.resources.getString("bar.vertical-stacked.range");
            CategoryDataset categoryDataset = DemoDatasetFactory.createCategoryDataset();
            JFreeChart jFreeChart = ChartFactory.createStackedVerticalBarChart(string, string2, string3, categoryDataset, true);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
            Plot plot = jFreeChart.getPlot();
            this.verticalStackedBarChartFrame = new JFreeChartFrame(string, jFreeChart);
            this.verticalStackedBarChartFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.verticalStackedBarChartFrame);
            this.verticalStackedBarChartFrame.show();
        } else {
            this.verticalStackedBarChartFrame.show();
            this.verticalStackedBarChartFrame.requestFocus();
        }
    }

    private void displayVerticalStacked3DBarChart() {
        if (this.verticalStacked3DBarChartFrame == null) {
            String string = this.resources.getString("bar.vertical-stacked3D.title");
            String string2 = this.resources.getString("bar.vertical-stacked3D.domain");
            String string3 = this.resources.getString("bar.vertical-stacked3D.range");
            CategoryDataset categoryDataset = DemoDatasetFactory.createCategoryDataset();
            JFreeChart jFreeChart = ChartFactory.createStackedVerticalBarChart3D(string, string2, string3, categoryDataset, true);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
            Plot plot = jFreeChart.getPlot();
            this.verticalStacked3DBarChartFrame = new JFreeChartFrame(string, jFreeChart);
            this.verticalStacked3DBarChartFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.verticalStacked3DBarChartFrame);
            this.verticalStacked3DBarChartFrame.show();
        } else {
            this.verticalStacked3DBarChartFrame.show();
            this.verticalStacked3DBarChartFrame.requestFocus();
        }
    }

    private void displayPieChartOne() {
        if (this.pieChartOneFrame == null) {
            String string = this.resources.getString("pie.pie1.title");
            CategoryDataset categoryDataset = DemoDatasetFactory.createCategoryDataset();
            PieDataset pieDataset = DatasetUtilities.createPieDataset((CategoryDataset)categoryDataset, (int)0);
            JFreeChart jFreeChart = ChartFactory.createPieChart(string, pieDataset, true);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.orange));
            PiePlot piePlot = (PiePlot)jFreeChart.getPlot();
            piePlot.setCircular(false);
            piePlot.setRadiusPercent(0.6);
            piePlot.setExplodePercent(1, 1.0);
            this.pieChartOneFrame = new JFreeChartFrame(string, jFreeChart);
            this.pieChartOneFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.pieChartOneFrame);
            this.pieChartOneFrame.show();
        } else {
            this.pieChartOneFrame.show();
            this.pieChartOneFrame.requestFocus();
        }
    }

    private void displayPieChartTwo() {
        ImageIcon imageIcon = new ImageIcon((class$com$jrefinery$chart$demo$JFreeChartDemo == null ? (class$com$jrefinery$chart$demo$JFreeChartDemo = JFreeChartDemo.class$("com.jrefinery.chart.demo.JFreeChartDemo")) : class$com$jrefinery$chart$demo$JFreeChartDemo).getResource("gorilla.jpg"));
        Image image = imageIcon.getImage();
        if (this.pieChartTwoFrame == null) {
            String string = this.resources.getString("pie.pie2.title");
            CategoryDataset categoryDataset = DemoDatasetFactory.createCategoryDataset();
            Object e = categoryDataset.getCategories().get(1);
            PieDataset pieDataset = DatasetUtilities.createPieDataset((CategoryDataset)categoryDataset, e);
            JFreeChart jFreeChart = ChartFactory.createPieChart(string, pieDataset, true);
            jFreeChart.setLegend(null);
            jFreeChart.setBackgroundPaint(Color.lightGray);
            PiePlot piePlot = (PiePlot)jFreeChart.getPlot();
            piePlot.setSectionLabelType(5);
            piePlot.setBackgroundImage(image);
            piePlot.setBackgroundPaint(Color.white);
            piePlot.setBackgroundAlpha(0.6f);
            piePlot.setForegroundAlpha(0.75f);
            this.pieChartTwoFrame = new JFreeChartFrame(string, jFreeChart);
            this.pieChartTwoFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.pieChartTwoFrame);
            this.pieChartTwoFrame.show();
        } else {
            this.pieChartTwoFrame.show();
            this.pieChartTwoFrame.requestFocus();
        }
    }

    private void displayXYPlot() {
        if (this.xyPlotFrame == null) {
            String string = this.resources.getString("xyplot.sample1.title");
            String string2 = this.resources.getString("xyplot.sample1.domain");
            String string3 = this.resources.getString("xyplot.sample1.range");
            XYDataset xYDataset = DemoDatasetFactory.createSampleXYDataset();
            JFreeChart jFreeChart = ChartFactory.createXYChart(string, string2, string3, xYDataset, true);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.green));
            this.xyPlotFrame = new JFreeChartFrame(string, jFreeChart);
            this.xyPlotFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.xyPlotFrame);
            this.xyPlotFrame.show();
        } else {
            this.xyPlotFrame.show();
            this.xyPlotFrame.requestFocus();
        }
    }

    private void displayTimeSeries1Chart() {
        if (this.timeSeries1ChartFrame == null) {
            String string = this.resources.getString("timeseries.sample1.title");
            String string2 = this.resources.getString("timeseries.sample1.subtitle");
            String string3 = this.resources.getString("timeseries.sample1.domain");
            String string4 = this.resources.getString("timeseries.sample1.range");
            String string5 = this.resources.getString("timeseries.sample1.copyright");
            TimeSeriesCollection timeSeriesCollection = DemoDatasetFactory.createTimeSeriesCollection3();
            JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart(string, string3, string4, (XYDataset)timeSeriesCollection, true);
            TextTitle textTitle = new TextTitle(string2, new Font("SansSerif", 0, 12));
            textTitle.setSpacer(new Spacer(0, 0.05, 0.05, 0.05, 0.0));
            jFreeChart.addTitle(textTitle);
            TextTitle textTitle2 = new TextTitle(string5, new Font("SansSerif", 0, 9));
            textTitle2.setPosition(1);
            textTitle2.setHorizontalAlignment(2);
            jFreeChart.addTitle(textTitle2);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
            Plot plot = jFreeChart.getPlot();
            HorizontalDateAxis horizontalDateAxis = (HorizontalDateAxis)plot.getAxis(0);
            horizontalDateAxis.setVerticalTickLabels(true);
            this.timeSeries1ChartFrame = new JFreeChartFrame(string, jFreeChart);
            this.timeSeries1ChartFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.timeSeries1ChartFrame);
            ((Component)this.timeSeries1ChartFrame).setVisible(true);
        } else {
            ((Component)this.timeSeries1ChartFrame).setVisible(true);
            this.timeSeries1ChartFrame.requestFocus();
        }
    }

    private void displayTimeSeries2Chart() {
        if (this.timeSeries2ChartFrame == null) {
            String string = this.resources.getString("timeseries.sample2.title");
            String string2 = this.resources.getString("timeseries.sample2.subtitle");
            String string3 = this.resources.getString("timeseries.sample2.domain");
            String string4 = this.resources.getString("timeseries.sample2.range");
            TimeSeriesCollection timeSeriesCollection = DemoDatasetFactory.createTimeSeriesCollection4();
            JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart(string, string3, string4, (XYDataset)timeSeriesCollection, true);
            TextTitle textTitle = new TextTitle(string2, new Font("SansSerif", 1, 12));
            jFreeChart.addTitle(textTitle);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
            Plot plot = jFreeChart.getPlot();
            VerticalLogarithmicAxis verticalLogarithmicAxis = new VerticalLogarithmicAxis(string4);
            jFreeChart.getPlot().setVerticalAxis(verticalLogarithmicAxis);
            this.timeSeries2ChartFrame = new JFreeChartFrame(string, jFreeChart);
            this.timeSeries2ChartFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.timeSeries2ChartFrame);
            ((Component)this.timeSeries2ChartFrame).setVisible(true);
        } else {
            ((Component)this.timeSeries2ChartFrame).setVisible(true);
            this.timeSeries2ChartFrame.requestFocus();
        }
    }

    private void displayTimeSeriesWithMAChart() {
        if (this.timeSeriesWithMAChartFrame == null) {
            String string = this.resources.getString("timeseries.sample3.title");
            String string2 = this.resources.getString("timeseries.sample3.domain");
            String string3 = this.resources.getString("timeseries.sample3.range");
            String string4 = this.resources.getString("timeseries.sample3.subtitle");
            TimeSeriesCollection timeSeriesCollection = DemoDatasetFactory.createTimeSeriesCollection2();
            MovingAveragePlotFitAlgorithm movingAveragePlotFitAlgorithm = new MovingAveragePlotFitAlgorithm();
            movingAveragePlotFitAlgorithm.setPeriod(30);
            PlotFit plotFit = new PlotFit((XYDataset)timeSeriesCollection, movingAveragePlotFitAlgorithm);
            timeSeriesCollection = plotFit.getFit();
            JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart(string, string2, string3, (XYDataset)timeSeriesCollection, true);
            TextTitle textTitle = new TextTitle(string4, new Font("SansSerif", 1, 12));
            jFreeChart.addTitle(textTitle);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
            this.timeSeriesWithMAChartFrame = new JFreeChartFrame(string, jFreeChart);
            this.timeSeriesWithMAChartFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.timeSeriesWithMAChartFrame);
            this.timeSeriesWithMAChartFrame.show();
        } else {
            this.timeSeriesWithMAChartFrame.show();
            this.timeSeriesWithMAChartFrame.requestFocus();
        }
    }

    private void displayHighLowChart() {
        if (this.highLowChartFrame == null) {
            String string = this.resources.getString("timeseries.highlow.title");
            String string2 = this.resources.getString("timeseries.highlow.domain");
            String string3 = this.resources.getString("timeseries.highlow.range");
            String string4 = this.resources.getString("timeseries.highlow.subtitle");
            HighLowDataset highLowDataset = DemoDatasetFactory.createSampleHighLowDataset();
            JFreeChart jFreeChart = ChartFactory.createHighLowChart(string, string2, string3, highLowDataset, true);
            TextTitle textTitle = new TextTitle(string4, new Font("SansSerif", 1, 12));
            jFreeChart.addTitle(textTitle);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.magenta));
            this.highLowChartFrame = new JFreeChartFrame(string, jFreeChart);
            this.highLowChartFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.highLowChartFrame);
            this.highLowChartFrame.show();
        } else {
            this.highLowChartFrame.show();
            this.highLowChartFrame.requestFocus();
        }
    }

    private void displayCandlestickChart() {
        if (this.candlestickChartFrame == null) {
            String string = this.resources.getString("timeseries.candlestick.title");
            String string2 = this.resources.getString("timeseries.candlestick.domain");
            String string3 = this.resources.getString("timeseries.candlestick.range");
            String string4 = this.resources.getString("timeseries.candlestick.subtitle");
            HighLowDataset highLowDataset = DemoDatasetFactory.createSampleHighLowDataset();
            JFreeChart jFreeChart = ChartFactory.createCandlestickChart(string, string2, string3, highLowDataset, false);
            jFreeChart.getPlot().setSeriesPaint(new Paint[]{Color.blue});
            TextTitle textTitle = new TextTitle(string4, new Font("SansSerif", 1, 12));
            jFreeChart.addTitle(textTitle);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.green));
            this.candlestickChartFrame = new JFreeChartFrame(string, jFreeChart);
            this.candlestickChartFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.candlestickChartFrame);
            ((Component)this.candlestickChartFrame).setVisible(true);
        } else {
            ((Component)this.candlestickChartFrame).setVisible(true);
            this.candlestickChartFrame.requestFocus();
        }
    }

    private void displaySignalChart() {
        if (this.signalChartFrame == null) {
            String string = this.resources.getString("timeseries.signal.title");
            String string2 = this.resources.getString("timeseries.signal.domain");
            String string3 = this.resources.getString("timeseries.signal.range");
            String string4 = this.resources.getString("timeseries.signal.subtitle");
            SignalsDataset signalsDataset = DemoDatasetFactory.createSampleSignalDataset();
            JFreeChart jFreeChart = ChartFactory.createSignalChart(string, string2, string3, signalsDataset, true);
            TextTitle textTitle = new TextTitle(string4, new Font("SansSerif", 1, 12));
            jFreeChart.addTitle(textTitle);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
            this.signalChartFrame = new JFreeChartFrame(string, jFreeChart);
            this.signalChartFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.signalChartFrame);
            ((Component)this.signalChartFrame).setVisible(true);
        } else {
            ((Component)this.signalChartFrame).setVisible(true);
            this.signalChartFrame.requestFocus();
        }
    }

    private void displayWindPlot() {
        if (this.windPlotFrame == null) {
            String string = this.resources.getString("other.wind.title");
            String string2 = this.resources.getString("other.wind.domain");
            String string3 = this.resources.getString("other.wind.range");
            WindDataset windDataset = DemoDatasetFactory.createWindDataset1();
            JFreeChart jFreeChart = ChartFactory.createWindPlot(string, string2, string3, windDataset, true);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.green));
            this.windPlotFrame = new JFreeChartFrame(string, jFreeChart);
            this.windPlotFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.windPlotFrame);
            this.windPlotFrame.show();
        } else {
            this.windPlotFrame.show();
            this.windPlotFrame.requestFocus();
        }
    }

    private void displayScatterPlot() {
        if (this.scatterPlotFrame == null) {
            String string = this.resources.getString("other.scatter.title");
            String string2 = this.resources.getString("other.scatter.domain");
            String string3 = this.resources.getString("other.scatter.range");
            SampleXYDataset2 sampleXYDataset2 = new SampleXYDataset2();
            JFreeChart jFreeChart = ChartFactory.createScatterPlot(string, string2, string3, sampleXYDataset2, true);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.green));
            XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
            NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
            numberAxis.setAutoRangeIncludesZero(false);
            this.scatterPlotFrame = new JFreeChartFrame(string, jFreeChart);
            this.scatterPlotFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.scatterPlotFrame);
            this.scatterPlotFrame.show();
        } else {
            this.scatterPlotFrame.show();
            this.scatterPlotFrame.requestFocus();
        }
    }

    private void displayLineChart() {
        if (this.lineChartFrame == null) {
            String string = this.resources.getString("other.line.title");
            String string2 = this.resources.getString("other.line.domain");
            String string3 = this.resources.getString("other.line.range");
            CategoryDataset categoryDataset = DemoDatasetFactory.createCategoryDataset();
            JFreeChart jFreeChart = ChartFactory.createLineChart(string, string2, string3, categoryDataset, true);
            ImageIcon imageIcon = new ImageIcon((class$com$jrefinery$chart$demo$JFreeChartDemo == null ? (class$com$jrefinery$chart$demo$JFreeChartDemo = JFreeChartDemo.class$("com.jrefinery.chart.demo.JFreeChartDemo")) : class$com$jrefinery$chart$demo$JFreeChartDemo).getResource("gorilla.jpg"));
            jFreeChart.setBackgroundImage(imageIcon.getImage());
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.green));
            CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
            categoryPlot.setBackgroundAlpha(0.65f);
            HorizontalCategoryAxis horizontalCategoryAxis = (HorizontalCategoryAxis)categoryPlot.getDomainAxis();
            horizontalCategoryAxis.setVerticalCategoryLabels(true);
            this.lineChartFrame = new JFreeChartFrame(string, jFreeChart);
            this.lineChartFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.lineChartFrame);
            this.lineChartFrame.show();
        } else {
            this.lineChartFrame.show();
            this.lineChartFrame.requestFocus();
        }
    }

    private void displayVerticalXYBarChart() {
        if (this.verticalXYBarChartFrame == null) {
            String string = this.resources.getString("other.xybar.title");
            String string2 = this.resources.getString("other.xybar.domain");
            String string3 = this.resources.getString("other.xybar.range");
            TimeSeriesCollection timeSeriesCollection = DemoDatasetFactory.createTimeSeriesCollection1();
            JFreeChart jFreeChart = ChartFactory.createVerticalXYBarChart(string, string2, string3, (IntervalXYDataset)timeSeriesCollection, true);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
            this.verticalXYBarChartFrame = new JFreeChartFrame(string, jFreeChart);
            this.verticalXYBarChartFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.verticalXYBarChartFrame);
            this.verticalXYBarChartFrame.show();
        } else {
            this.verticalXYBarChartFrame.show();
            this.verticalXYBarChartFrame.requestFocus();
        }
    }

    private void displayNullXYPlot() {
        if (this.xyPlotNullDataFrame == null) {
            String string = this.resources.getString("test.null.title");
            String string2 = this.resources.getString("test.null.domain");
            String string3 = this.resources.getString("test.null.range");
            XYDataset xYDataset = null;
            JFreeChart jFreeChart = ChartFactory.createXYChart(string, string2, string3, xYDataset, true);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
            this.xyPlotNullDataFrame = new JFreeChartFrame(string, jFreeChart);
            this.xyPlotNullDataFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.xyPlotNullDataFrame);
            this.xyPlotNullDataFrame.show();
        } else {
            this.xyPlotNullDataFrame.show();
            this.xyPlotNullDataFrame.requestFocus();
        }
    }

    private void displayXYPlotZeroData() {
        if (this.xyPlotZeroDataFrame == null) {
            String string = this.resources.getString("test.zero.title");
            String string2 = this.resources.getString("test.zero.domain");
            String string3 = this.resources.getString("test.zero.range");
            EmptyXYDataset emptyXYDataset = new EmptyXYDataset();
            JFreeChart jFreeChart = ChartFactory.createXYChart(string, string2, string3, emptyXYDataset, true);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
            this.xyPlotZeroDataFrame = new JFreeChartFrame(string, jFreeChart);
            this.xyPlotZeroDataFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.xyPlotZeroDataFrame);
            this.xyPlotZeroDataFrame.show();
        } else {
            this.xyPlotZeroDataFrame.show();
            this.xyPlotZeroDataFrame.requestFocus();
        }
    }

    private void displayTimeSeriesChartInScrollPane() {
        if (this.timeSeriesChartScrollFrame == null) {
            String string = this.resources.getString("test.scroll.title");
            String string2 = this.resources.getString("test.scroll.domain");
            String string3 = this.resources.getString("test.scroll.range");
            String string4 = this.resources.getString("test.scroll.subtitle");
            TimeSeriesCollection timeSeriesCollection = DemoDatasetFactory.createTimeSeriesCollection2();
            JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart(string, string2, string3, (XYDataset)timeSeriesCollection, true);
            TextTitle textTitle = new TextTitle(string4, new Font("SansSerif", 1, 12));
            jFreeChart.addTitle(textTitle);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.gray));
            Plot plot = jFreeChart.getPlot();
            this.timeSeriesChartScrollFrame = new JFreeChartFrame(string, jFreeChart, true);
            this.timeSeriesChartScrollFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.timeSeriesChartScrollFrame);
            this.timeSeriesChartScrollFrame.show();
        } else {
            this.timeSeriesChartScrollFrame.show();
            this.timeSeriesChartScrollFrame.requestFocus();
        }
    }

    private void displaySingleSeriesBarChart() {
        if (this.singleSeriesBarChartFrame == null) {
            String string = this.resources.getString("test.single.title");
            String string2 = this.resources.getString("test.single.domain");
            String string3 = this.resources.getString("test.single.range");
            String string4 = this.resources.getString("test.single.subtitle1");
            String string5 = this.resources.getString("test.single.subtitle2");
            CategoryDataset categoryDataset = DemoDatasetFactory.createSingleSeriesCategoryDataset();
            JFreeChart jFreeChart = ChartFactory.createHorizontalBarChart(string, string2, string3, categoryDataset, true);
            jFreeChart.addTitle(new TextTitle(string4));
            jFreeChart.addTitle(new TextTitle(string5));
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
            this.singleSeriesBarChartFrame = new JFreeChartFrame(string, jFreeChart);
            JFreeChartPanel jFreeChartPanel = this.singleSeriesBarChartFrame.getChartPanel();
            jFreeChartPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
            this.singleSeriesBarChartFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.singleSeriesBarChartFrame);
            ((Component)this.singleSeriesBarChartFrame).setVisible(true);
        } else {
            this.singleSeriesBarChartFrame.show();
            this.xyPlotNullDataFrame.requestFocus();
        }
    }

    private void displayDynamicXYChart() {
        if (this.dynamicXYChartFrame == null) {
            String string = this.resources.getString("test.dynamic.title");
            String string2 = this.resources.getString("test.dynamic.domain");
            String string3 = this.resources.getString("test.dynamic.range");
            SampleXYDataset sampleXYDataset = new SampleXYDataset();
            JFreeChart jFreeChart = ChartFactory.createXYChart(string, string2, string3, sampleXYDataset, true);
            SampleXYDatasetThread sampleXYDatasetThread = new SampleXYDatasetThread(sampleXYDataset);
            this.dynamicXYChartFrame = new JFreeChartFrame(string, jFreeChart);
            this.dynamicXYChartFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.dynamicXYChartFrame);
            this.dynamicXYChartFrame.show();
            Thread thread = new Thread(sampleXYDatasetThread);
            thread.start();
        }
    }

    private void displayOverlaidChart() {
        if (this.overlaidChartFrame == null) {
            String string = this.resources.getString("combined.overlaid.title");
            String string2 = this.resources.getString("combined.overlaid.subtitle");
            String string3 = this.resources.getString("combined.overlaid.domain");
            String string4 = this.resources.getString("combined.overlaid.range");
            HighLowDataset highLowDataset = DemoDatasetFactory.createSampleHighLowDataset();
            MovingAveragePlotFitAlgorithm movingAveragePlotFitAlgorithm = new MovingAveragePlotFitAlgorithm();
            movingAveragePlotFitAlgorithm.setPeriod(5);
            PlotFit plotFit = new PlotFit((XYDataset)highLowDataset, movingAveragePlotFitAlgorithm);
            XYDataset xYDataset = plotFit.getFit();
            CombinedDataset combinedDataset = new CombinedDataset();
            combinedDataset.add((SeriesDataset)highLowDataset);
            combinedDataset.add((SeriesDataset)new SubSeriesDataset((SeriesDataset)xYDataset, 1));
            SubSeriesDataset subSeriesDataset = new SubSeriesDataset((SeriesDataset)combinedDataset, 0);
            SubSeriesDataset subSeriesDataset2 = new SubSeriesDataset((SeriesDataset)combinedDataset, 1);
            JFreeChart jFreeChart = null;
            HorizontalDateAxis horizontalDateAxis = new HorizontalDateAxis(string3);
            horizontalDateAxis.setCrosshairVisible(false);
            VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string4);
            verticalNumberAxis.setCrosshairVisible(false);
            CombinedPlot combinedPlot = new CombinedPlot((Axis)horizontalDateAxis, verticalNumberAxis);
            combinedPlot.add(ChartFactory.createCombinableHighLowChart(horizontalDateAxis, verticalNumberAxis, (Dataset)subSeriesDataset));
            combinedPlot.add(ChartFactory.createCombinableTimeSeriesChart(horizontalDateAxis, verticalNumberAxis, (Dataset)subSeriesDataset2));
            combinedPlot.adjustPlots();
            jFreeChart = new JFreeChart((Dataset)combinedDataset, combinedPlot, string, JFreeChartConstants.DEFAULT_TITLE_FONT, true);
            TextTitle textTitle = new TextTitle(string2, new Font("SansSerif", 1, 12));
            jFreeChart.addTitle(textTitle);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
            this.overlaidChartFrame = new JFreeChartFrame(string, jFreeChart);
            this.overlaidChartFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.overlaidChartFrame);
            this.overlaidChartFrame.show();
        } else {
            this.overlaidChartFrame.show();
            this.overlaidChartFrame.requestFocus();
        }
    }

    private void displayHorizontallyCombinedChart() {
        if (this.horizontallyCombinedChartFrame == null) {
            String string = this.resources.getString("combined.horizontal.title");
            String string2 = this.resources.getString("combined.horizontal.subtitle");
            String[] stringArray = this.resources.getStringArray("combined.horizontal.domains");
            String string3 = this.resources.getString("combined.horizontal.range");
            int[] nArray = new int[]{1, 1, 1};
            MovingAveragePlotFitAlgorithm movingAveragePlotFitAlgorithm = new MovingAveragePlotFitAlgorithm();
            movingAveragePlotFitAlgorithm.setPeriod(30);
            PlotFit plotFit = new PlotFit((XYDataset)DemoDatasetFactory.createTimeSeriesCollection2(), movingAveragePlotFitAlgorithm);
            XYDataset xYDataset = plotFit.getFit();
            CombinedDataset combinedDataset = new CombinedDataset();
            combinedDataset.add((SeriesDataset)xYDataset);
            SubSeriesDataset subSeriesDataset = new SubSeriesDataset((SeriesDataset)combinedDataset, 0);
            SubSeriesDataset subSeriesDataset2 = new SubSeriesDataset((SeriesDataset)combinedDataset, 1);
            JFreeChart jFreeChart = null;
            HorizontalDateAxis[] horizontalDateAxisArray = new HorizontalDateAxis[3];
            int n = 0;
            while (n < horizontalDateAxisArray.length) {
                horizontalDateAxisArray[n] = new HorizontalDateAxis(stringArray[n]);
                horizontalDateAxisArray[n].setCrosshairVisible(false);
                ++n;
            }
            VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
            verticalNumberAxis.setAutoRangeIncludesZero(false);
            verticalNumberAxis.setCrosshairVisible(false);
            CombinedPlot combinedPlot = new CombinedPlot((Axis)verticalNumberAxis, 0);
            CombinedChart combinedChart = ChartFactory.createCombinableXYChart(horizontalDateAxisArray[0], verticalNumberAxis, (Dataset)subSeriesDataset);
            combinedPlot.add(combinedChart, nArray[0]);
            combinedChart = ChartFactory.createCombinableTimeSeriesChart(horizontalDateAxisArray[1], verticalNumberAxis, (Dataset)combinedDataset);
            combinedPlot.add(combinedChart, nArray[1]);
            combinedChart = ChartFactory.createCombinableVerticalXYBarChart(horizontalDateAxisArray[2], verticalNumberAxis, (Dataset)subSeriesDataset);
            combinedPlot.add(combinedChart, nArray[2]);
            combinedPlot.adjustPlots();
            jFreeChart = new JFreeChart((Dataset)combinedDataset, combinedPlot, string, JFreeChartConstants.DEFAULT_TITLE_FONT, true);
            TextTitle textTitle = new TextTitle(string2, new Font("SansSerif", 1, 12));
            jFreeChart.addTitle(textTitle);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
            this.horizontallyCombinedChartFrame = new JFreeChartFrame(string, jFreeChart);
            this.horizontallyCombinedChartFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.horizontallyCombinedChartFrame);
            this.horizontallyCombinedChartFrame.show();
        } else {
            this.horizontallyCombinedChartFrame.show();
            this.horizontallyCombinedChartFrame.requestFocus();
        }
    }

    private void displayVerticallyCombinedChart() {
        if (this.verticallyCombinedChartFrame == null) {
            String string = this.resources.getString("combined.vertical.title");
            String string2 = this.resources.getString("combined.vertical.subtitle");
            String string3 = this.resources.getString("combined.vertical.domain");
            String[] stringArray = this.resources.getStringArray("combined.vertical.ranges");
            int[] nArray = new int[]{1, 1, 1, 1};
            MovingAveragePlotFitAlgorithm movingAveragePlotFitAlgorithm = new MovingAveragePlotFitAlgorithm();
            movingAveragePlotFitAlgorithm.setPeriod(30);
            PlotFit plotFit = new PlotFit((XYDataset)DemoDatasetFactory.createTimeSeriesCollection2(), movingAveragePlotFitAlgorithm);
            XYDataset xYDataset = plotFit.getFit();
            CombinedDataset combinedDataset = new CombinedDataset();
            combinedDataset.add((SeriesDataset)xYDataset);
            combinedDataset.add((SeriesDataset)DemoDatasetFactory.createSampleHighLowDataset());
            SubSeriesDataset subSeriesDataset = new SubSeriesDataset((SeriesDataset)combinedDataset, 0);
            SubSeriesDataset subSeriesDataset2 = new SubSeriesDataset((SeriesDataset)combinedDataset, 1);
            SubSeriesDataset subSeriesDataset3 = new SubSeriesDataset((SeriesDataset)combinedDataset, 2);
            CombinedDataset combinedDataset2 = new CombinedDataset(new SeriesDataset[]{subSeriesDataset});
            CombinedDataset combinedDataset3 = new CombinedDataset(new SeriesDataset[]{subSeriesDataset, subSeriesDataset2});
            CombinedDataset combinedDataset4 = new CombinedDataset(new SeriesDataset[]{subSeriesDataset3});
            JFreeChart jFreeChart = null;
            HorizontalDateAxis horizontalDateAxis = new HorizontalDateAxis(string3);
            horizontalDateAxis.setCrosshairVisible(false);
            NumberAxis[] numberAxisArray = new NumberAxis[4];
            int n = 0;
            while (n < numberAxisArray.length) {
                numberAxisArray[n] = new VerticalNumberAxis(stringArray[n]);
                if (n != 2) {
                    numberAxisArray[n].setAutoRangeIncludesZero(false);
                    numberAxisArray[n].setCrosshairVisible(false);
                }
                ++n;
            }
            CombinedPlot combinedPlot = new CombinedPlot((Axis)horizontalDateAxis, 1);
            CombinedChart combinedChart = ChartFactory.createCombinableXYChart(horizontalDateAxis, numberAxisArray[0], (Dataset)combinedDataset2);
            combinedPlot.add(combinedChart, nArray[0]);
            combinedChart = ChartFactory.createCombinableTimeSeriesChart(horizontalDateAxis, numberAxisArray[1], (Dataset)combinedDataset3);
            combinedPlot.add(combinedChart, nArray[1]);
            combinedChart = ChartFactory.createCombinableHighLowChart(horizontalDateAxis, numberAxisArray[2], (Dataset)combinedDataset4);
            combinedPlot.add(combinedChart, nArray[2]);
            combinedChart = ChartFactory.createCombinableVerticalXYBarChart(horizontalDateAxis, numberAxisArray[3], (Dataset)combinedDataset2);
            combinedPlot.add(combinedChart, nArray[3]);
            combinedPlot.adjustPlots();
            jFreeChart = new JFreeChart((Dataset)combinedDataset, combinedPlot, string, JFreeChartConstants.DEFAULT_TITLE_FONT, true);
            TextTitle textTitle = new TextTitle(string2, new Font("SansSerif", 1, 12));
            jFreeChart.addTitle(textTitle);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
            this.verticallyCombinedChartFrame = new JFreeChartFrame(string, jFreeChart);
            this.verticallyCombinedChartFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.verticallyCombinedChartFrame);
            this.verticallyCombinedChartFrame.show();
        } else {
            this.verticallyCombinedChartFrame.show();
            this.verticallyCombinedChartFrame.requestFocus();
        }
    }

    private void displayCombinedAndOverlaidChart1() {
        if (this.combinedOverlaidChartFrame1 == null) {
            String string = this.resources.getString("combined.combined-overlaid.title");
            String string2 = this.resources.getString("combined.combined-overlaid.subtitle");
            String string3 = this.resources.getString("combined.combined-overlaid.domain");
            String[] stringArray = this.resources.getStringArray("combined.combined-overlaid.ranges");
            int[] nArray = new int[]{1, 2, 2};
            HighLowDataset highLowDataset = DemoDatasetFactory.createSampleHighLowDataset();
            TimeSeriesCollection timeSeriesCollection = DemoDatasetFactory.createTimeSeriesCollection2();
            MovingAveragePlotFitAlgorithm movingAveragePlotFitAlgorithm = new MovingAveragePlotFitAlgorithm();
            movingAveragePlotFitAlgorithm.setPeriod(5);
            PlotFit plotFit = new PlotFit((XYDataset)highLowDataset, movingAveragePlotFitAlgorithm);
            XYDataset xYDataset = plotFit.getFit();
            movingAveragePlotFitAlgorithm = new MovingAveragePlotFitAlgorithm();
            movingAveragePlotFitAlgorithm.setPeriod(30);
            plotFit = new PlotFit((XYDataset)timeSeriesCollection, movingAveragePlotFitAlgorithm);
            XYDataset xYDataset2 = plotFit.getFit();
            CombinedDataset combinedDataset = new CombinedDataset();
            combinedDataset.add((SeriesDataset)timeSeriesCollection);
            combinedDataset.add((SeriesDataset)xYDataset2, 1);
            combinedDataset.add((SeriesDataset)highLowDataset);
            combinedDataset.add((SeriesDataset)xYDataset, 1);
            SubSeriesDataset subSeriesDataset = new SubSeriesDataset((SeriesDataset)combinedDataset, 0);
            SubSeriesDataset subSeriesDataset2 = new SubSeriesDataset((SeriesDataset)combinedDataset, 1);
            SubSeriesDataset subSeriesDataset3 = new SubSeriesDataset((SeriesDataset)combinedDataset, 2);
            SubSeriesDataset subSeriesDataset4 = new SubSeriesDataset((SeriesDataset)combinedDataset, 3);
            CombinedDataset combinedDataset2 = new CombinedDataset(new SeriesDataset[]{subSeriesDataset});
            CombinedDataset combinedDataset3 = new CombinedDataset(new SeriesDataset[]{subSeriesDataset, subSeriesDataset2});
            CombinedDataset combinedDataset4 = new CombinedDataset(new SeriesDataset[]{subSeriesDataset3, subSeriesDataset4});
            JFreeChart jFreeChart = null;
            int n = 3;
            HorizontalDateAxis horizontalDateAxis = new HorizontalDateAxis(string3);
            horizontalDateAxis.setCrosshairVisible(false);
            NumberAxis[] numberAxisArray = new NumberAxis[3];
            int n2 = 0;
            while (n2 < numberAxisArray.length) {
                numberAxisArray[n2] = new VerticalNumberAxis(stringArray[n2]);
                numberAxisArray[n2].setCrosshairVisible(false);
                if (n2 <= 1) {
                    numberAxisArray[n2].setAutoRangeIncludesZero(false);
                }
                ++n2;
            }
            CombinedPlot combinedPlot = new CombinedPlot((Axis)horizontalDateAxis, 1);
            CombinedChart combinedChart = ChartFactory.createCombinableXYChart(horizontalDateAxis, numberAxisArray[0], (Dataset)combinedDataset2);
            combinedPlot.add(combinedChart, nArray[0]);
            OverlaidPlot overlaidPlot = new OverlaidPlot((Axis)horizontalDateAxis, numberAxisArray[1]);
            overlaidPlot.add(ChartFactory.createCombinableTimeSeriesChart(horizontalDateAxis, numberAxisArray[1], (Dataset)subSeriesDataset));
            overlaidPlot.add(ChartFactory.createCombinableTimeSeriesChart(horizontalDateAxis, numberAxisArray[1], (Dataset)subSeriesDataset2));
            combinedChart = ChartFactory.createCombinableChart((Dataset)combinedDataset, overlaidPlot);
            combinedPlot.add(combinedChart, nArray[1]);
            overlaidPlot = new OverlaidPlot((Axis)horizontalDateAxis, numberAxisArray[2]);
            overlaidPlot.add(ChartFactory.createCombinableHighLowChart(horizontalDateAxis, numberAxisArray[2], (Dataset)subSeriesDataset3));
            overlaidPlot.add(ChartFactory.createCombinableTimeSeriesChart(horizontalDateAxis, numberAxisArray[2], (Dataset)subSeriesDataset4));
            combinedChart = ChartFactory.createCombinableChart((Dataset)combinedDataset, overlaidPlot);
            combinedPlot.add(combinedChart, nArray[2]);
            combinedPlot.adjustPlots();
            jFreeChart = new JFreeChart((Dataset)combinedDataset, combinedPlot, string, JFreeChartConstants.DEFAULT_TITLE_FONT, true);
            TextTitle textTitle = new TextTitle(string2, new Font("SansSerif", 1, 12));
            jFreeChart.addTitle(textTitle);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
            this.combinedOverlaidChartFrame1 = new JFreeChartFrame(string, jFreeChart);
            this.combinedOverlaidChartFrame1.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.combinedOverlaidChartFrame1);
            this.combinedOverlaidChartFrame1.show();
        } else {
            this.combinedOverlaidChartFrame1.show();
            this.combinedOverlaidChartFrame1.requestFocus();
        }
    }

    private void displayCombinedAndOverlaidDynamicXYChart() {
        if (this.combinedAndOverlaidDynamicXYChartFrame == null) {
            String string = this.resources.getString("combined.dynamic.title");
            String string2 = this.resources.getString("combined.dynamic.subtitle");
            String string3 = this.resources.getString("combined.dynamic.domain");
            String[] stringArray = this.resources.getStringArray("combined.dynamic.ranges");
            SampleXYDataset sampleXYDataset = new SampleXYDataset();
            SubSeriesDataset subSeriesDataset = new SubSeriesDataset((SeriesDataset)sampleXYDataset, 0);
            SubSeriesDataset subSeriesDataset2 = new SubSeriesDataset((SeriesDataset)sampleXYDataset, 1);
            CombinedDataset combinedDataset = new CombinedDataset();
            combinedDataset.add((SeriesDataset)subSeriesDataset);
            combinedDataset.add((SeriesDataset)subSeriesDataset2);
            HorizontalNumberAxis horizontalNumberAxis = new HorizontalNumberAxis(string3);
            horizontalNumberAxis.setTickMarksVisible(true);
            horizontalNumberAxis.setAutoRangeIncludesZero(false);
            horizontalNumberAxis.setCrosshairVisible(false);
            NumberAxis[] numberAxisArray = new NumberAxis[4];
            int n = 0;
            while (n < numberAxisArray.length) {
                numberAxisArray[n] = new VerticalNumberAxis(stringArray[n]);
                numberAxisArray[n].setAutoRangeIncludesZero(false);
                numberAxisArray[n].setCrosshairVisible(false);
                ++n;
            }
            JFreeChart jFreeChart = null;
            CombinedPlot combinedPlot = new CombinedPlot((Axis)horizontalNumberAxis, 1);
            CombinedChart combinedChart = ChartFactory.createCombinableXYChart(horizontalNumberAxis, numberAxisArray[0], (Dataset)subSeriesDataset);
            combinedPlot.add(combinedChart);
            combinedChart = ChartFactory.createCombinableXYChart(horizontalNumberAxis, numberAxisArray[0], (Dataset)subSeriesDataset2);
            combinedPlot.add(combinedChart);
            OverlaidPlot overlaidPlot = new OverlaidPlot((Axis)horizontalNumberAxis, numberAxisArray[1]);
            overlaidPlot.add(ChartFactory.createCombinableXYChart(horizontalNumberAxis, numberAxisArray[1], (Dataset)subSeriesDataset));
            overlaidPlot.add(ChartFactory.createCombinableXYChart(horizontalNumberAxis, numberAxisArray[1], (Dataset)subSeriesDataset2));
            combinedChart = ChartFactory.createCombinableChart((Dataset)combinedDataset, overlaidPlot);
            combinedPlot.add(combinedChart);
            combinedChart = ChartFactory.createCombinableXYChart(horizontalNumberAxis, numberAxisArray[2], (Dataset)combinedDataset);
            combinedPlot.add(combinedChart);
            combinedPlot.adjustPlots();
            jFreeChart = new JFreeChart((Dataset)sampleXYDataset, combinedPlot, string, JFreeChartConstants.DEFAULT_TITLE_FONT, true);
            this.combinedAndOverlaidDynamicXYChartFrame = new JFreeChartFrame(string, jFreeChart);
            TextTitle textTitle = new TextTitle(string2, new Font("SansSerif", 1, 12));
            jFreeChart.addTitle(textTitle);
            jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.cyan));
            this.combinedAndOverlaidDynamicXYChartFrame.pack();
            JRefineryUtilities.positionFrameRandomly((JFrame)this.combinedAndOverlaidDynamicXYChartFrame);
            this.combinedAndOverlaidDynamicXYChartFrame.show();
            SampleXYDatasetThread sampleXYDatasetThread = new SampleXYDatasetThread(sampleXYDataset);
            Thread thread = new Thread(sampleXYDatasetThread);
            thread.start();
        }
    }

    private void about() {
        String string = this.resources.getString("about.title");
        String string2 = this.resources.getString("about.version.label");
        if (this.aboutFrame == null) {
            this.aboutFrame = new AboutFrame(string, "JFreeChart", string2 + " " + "0.8.1", "http://www.object-refinery.com/jfreechart/index.html", "(C)opyright 2000-2002, Simba Management Limited and Contributors", "GNU LESSER GENERAL PUBLIC LICENSE\n\nVersion 2.1, February 1999\n\nCopyright (C) 1991, 1999 Free Software Foundation, Inc.\n59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\nEveryone is permitted to copy and distribute verbatim copies of this license document, but changing it is not allowed.\n\n[This is the first released version of the Lesser GPL.  It also counts as the successor of the GNU Library Public License, version 2, hence the version number 2.1.]\n\nPreamble\n\nThe licenses for most software are designed to take away your freedom to share and change it. By contrast, the GNU General Public Licenses are intended to guarantee your freedom to share and change free software--to make sure the software is free for all its users.\n\nThis license, the Lesser General Public License, applies to some specially designated software packages--typically libraries--of the Free Software Foundation and other authors who decide to use it. You can use it too, but we suggest you first think carefully about whether this license or the ordinary General Public License is the better strategy to use in any particular case, based on the explanations below.\n\nWhen we speak of free software, we are referring to freedom of use, not price. Our General Public Licenses are designed to make sure that you have the freedom to distribute copies of free software (and charge for this service if you wish); that you receive source code or can get it if you want it; that you can change the software and use pieces of it in new free programs; and that you are informed that you can do these things.\n\nTo protect your rights, we need to make restrictions that forbid distributors to deny you these rights or to ask you to surrender these rights. These restrictions translate to certain responsibilities for you if you distribute copies of the library or if you modify it.\n\nFor example, if you distribute copies of the library, whether gratis or for a fee, you must give the recipients all the rights that we gave you. You must make sure that they, too, receive or can get the source code. If you link other code with the library, you must provide complete object files to the recipients, so that they can relink them with the library after making changes to the library and recompiling it. And you must show them these terms so they know their rights.\n\nWe protect your rights with a two-step method: (1) we copyright the library, and (2) we offer you this license, which gives you legal permission to copy, distribute and/or modify the library.\n\nTo protect each distributor, we want to make it very clear that there is no warranty for the free library. Also, if the library is modified by someone else and passed on, the recipients should know that what they have is not the original version, so that the original author's reputation will not be affected by problems that might be introduced by others.\n\nFinally, software patents pose a constant threat to the existence of any free program. We wish to make sure that a company cannot effectively restrict the users of a free program by obtaining a restrictive license from a patent holder. Therefore, we insist that any patent license obtained for a version of the library must be consistent with the full freedom of use specified in this license.\n\nMost GNU software, including some libraries, is covered by the ordinary GNU General Public License. This license, the GNU Lesser General Public License, applies to certain designated libraries, and is quite different from the ordinary General Public License. We use this license for certain libraries in order to permit linking those libraries into non-free programs.\n\nWhen a program is linked with a library, whether statically or using a shared library, the combination of the two is legally speaking a combined work, a derivative of the original library. The ordinary General Public License therefore permits such linking only if the entire combination fits its criteria of freedom. The Lesser General Public License permits more lax criteria for linking other code with the library.\n\nWe call this license the \"Lesser\" General Public License because it does Less to protect the user's freedom than the ordinary General Public License. It also provides other free software developers Less of an advantage over competing non-free programs. These disadvantages are the reason we use the ordinary General Public License for many libraries. However, the Lesser license provides advantages in certain special circumstances.\n\nFor example, on rare occasions, there may be a special need to encourage the widest possible use of a certain library, so that it becomes a de-facto standard. To achieve this, non-free programs must be allowed to use the library. A more frequent case is that a free library does the same job as widely used non-free libraries. In this case, there is little to gain by limiting the free library to free software only, so we use the Lesser General Public License.\n\nIn other cases, permission to use a particular library in non-free programs enables a greater number of people to use a large body of free software. For example, permission to use the GNU C Library in non-free programs enables many more people to use the whole GNU operating system, as well as its variant, the GNU/Linux operating system.\n\nAlthough the Lesser General Public License is Less protective of the users' freedom, it does ensure that the user of a program that is linked with the Library has the freedom and the wherewithal to run that program using a modified version of the Library.\n\nThe precise terms and conditions for copying, distribution and modification follow. Pay close attention to the difference between a \"work based on the library\" and a \"work that uses the library\". The former contains code derived from the library, whereas the latter must be combined with the library in order to run.\n\nTERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION\n\n0. This License Agreement applies to any software library or other program which contains a notice placed by the copyright holder or other authorized party saying it may be distributed under the terms of this Lesser General Public License (also called \"this License\"). Each licensee is addressed as \"you\".\nA \"library\" means a collection of software functions and/or data prepared so as to be conveniently linked with application programs (which use some of those functions and data) to form executables.\n\nThe \"Library\", below, refers to any such software library or work which has been distributed under these terms. A \"work based on the Library\" means either the Library or any derivative work under copyright law: that is to say, a work containing the Library or a portion of it, either verbatim or with modifications and/or translated straightforwardly into another language. (Hereinafter, translation is included without limitation in the term \"modification\".)\n\n\"Source code\" for a work means the preferred form of the work for making modifications to it. For a library, complete source code means all the source code for all modules it contains, plus any associated interface definition files, plus the scripts used to control compilation and installation of the library.\n\nActivities other than copying, distribution and modification are not covered by this License; they are outside its scope. The act of running a program using the Library is not restricted, and output from such a program is covered only if its contents constitute a work based on the Library (independent of the use of the Library in a tool for writing it). Whether that is true depends on what the Library does and what the program that uses the Library does.\n1. You may copy and distribute verbatim copies of the Library's complete source code as you receive it, in any medium, provided that you conspicuously and appropriately publish on each copy an appropriate copyright notice and disclaimer of warranty; keep intact all the notices that refer to this License and to the absence of any warranty; and distribute a copy of this License along with the Library.\n\nYou may charge a fee for the physical act of transferring a copy, and you may at your option offer warranty protection in exchange for a fee.\n\n2. You may modify your copy or copies of the Library or any portion of it, thus forming a work based on the Library, and copy and distribute such modifications or work under the terms of Section 1 above, provided that you also meet all of these conditions:\n\n*\ta) The modified work must itself be a software library.\n*\tb) You must cause the files modified to carry prominent notices stating that you changed the files and the date of any change.\n*\tc) You must cause the whole of the work to be licensed at no charge to all third parties under the terms of this License.\n*\td) If a facility in the modified Library refers to a function or a table of data to be supplied by an application program that uses the facility, other than as an argument passed when the facility is invoked, then you must make a good faith effort to ensure that, in the event an application does not supply such function or table, the facility still operates, and performs whatever part of its purpose remains meaningful.\n\n(For example, a function in a library to compute square roots has a purpose that is entirely well-defined independent of the application. Therefore, Subsection 2d requires that any application-supplied function or table used by this function must be optional: if the application does not supply it, the square root function must still compute square roots.)\n\nThese requirements apply to the modified work as a whole. If identifiable sections of that work are not derived from the Library, and can be reasonably considered independent and separate works in themselves, then this License, and its terms, do not apply to those sections when you distribute them as separate works. But when you distribute the same sections as part of a whole which is a work based on the Library, the distribution of the whole must be on the terms of this License, whose permissions for other licensees extend to the entire whole, and thus to each and every part regardless of who wrote it.\n\nThus, it is not the intent of this section to claim rights or contest your rights to work written entirely by you; rather, the intent is to exercise the right to control the distribution of derivative or collective works based on the Library.\n\nIn addition, mere aggregation of another work not based on the Library with the Library (or with a work based on the Library) on a volume of a storage or distribution medium does not bring the other work under the scope of this License.\n\n3. You may opt to apply the terms of the ordinary GNU General Public License instead of this License to a given copy of the Library. To do this, you must alter all the notices that refer to this License, so that they refer to the ordinary GNU General Public License, version 2, instead of to this License. (If a newer version than version 2 of the ordinary GNU General Public License has appeared, then you can specify that version instead if you wish.) Do not make any other change in these notices.\n\nOnce this change is made in a given copy, it is irreversible for that copy, so the ordinary GNU General Public License applies to all subsequent copies and derivative works made from that copy.\n\nThis option is useful when you wish to copy part of the code of the Library into a program that is not a library.\n\n4. You may copy and distribute the Library (or a portion or derivative of it, under Section 2) in object code or executable form under the terms of Sections 1 and 2 above provided that you accompany it with the complete corresponding machine-readable source code, which must be distributed under the terms of Sections 1 and 2 above on a medium customarily used for software interchange.\n\nIf distribution of object code is made by offering access to copy from a designated place, then offering equivalent access to copy the source code from the same place satisfies the requirement to distribute the source code, even though third parties are not compelled to copy the source along with the object code.\n\n5. A program that contains no derivative of any portion of the Library, but is designed to work with the Library by being compiled or linked with it, is called a \"work that uses the Library\". Such a work, in isolation, is not a derivative work of the Library, and therefore falls outside the scope of this License.\n\nHowever, linking a \"work that uses the Library\" with the Library creates an executable that is a derivative of the Library (because it contains portions of the Library), rather than a \"work that uses the library\". The executable is therefore covered by this License. Section 6 states terms for distribution of such executables.\n\nWhen a \"work that uses the Library\" uses material from a header file that is part of the Library, the object code for the work may be a derivative work of the Library even though the source code is not. Whether this is true is especially significant if the work can be linked without the Library, or if the work is itself a library. The threshold for this to be true is not precisely defined by law.\n\nIf such an object file uses only numerical parameters, data structure layouts and accessors, and small macros and small inline functions (ten lines or less in length), then the use of the object file is unrestricted, regardless of whether it is legally a derivative work. (Executables containing this object code plus portions of the Library will still fall under Section 6.)\n\nOtherwise, if the work is a derivative of the Library, you may distribute the object code for the work under the terms of Section 6. Any executables containing that work also fall under Section 6, whether or not they are linked directly with the Library itself.\n\n6. As an exception to the Sections above, you may also combine or link a \"work that uses the Library\" with the Library to produce a work containing portions of the Library, and distribute that work under terms of your choice, provided that the terms permit modification of the work for the customer's own use and reverse engineering for debugging such modifications.\n\nYou must give prominent notice with each copy of the work that the Library is used in it and that the Library and its use are covered by this License. You must supply a copy of this License. If the work during execution displays copyright notices, you must include the copyright notice for the Library among them, as well as a reference directing the user to the copy of this License. Also, you must do one of these things:\n\n*\ta) Accompany the work with the complete corresponding machine-readable source code for the Library including whatever changes were used in the work (which must be distributed under Sections 1 and 2 above); and, if the work is an executable linked with the Library, with the complete machine-readable \"work that uses the Library\", as object code and/or source code, so that the user can modify the Library and then relink to produce a modified executable containing the modified Library. (It is understood that the user who changes the contents of definitions files in the Library will not necessarily be able to recompile the application to use the modified definitions.)\n*\tb) Use a suitable shared library mechanism for linking with the Library. A suitable mechanism is one that (1) uses at run time a copy of the library already present on the user's computer system, rather than copying library functions into the executable, and (2) will operate properly with a modified version of the library, if the user installs one, as long as the modified version is interface-compatible with the version that the work was made with.\n*\tc) Accompany the work with a written offer, valid for at least three years, to give the same user the materials specified in Subsection 6a, above, for a charge no more than the cost of performing this distribution.\n*\td) If distribution of the work is made by offering access to copy from a designated place, offer equivalent access to copy the above specified materials from the same place.\n*\te) Verify that the user has already received a copy of these materials or that you have already sent this user a copy.\n\nFor an executable, the required form of the \"work that uses the Library\" must include any data and utility programs needed for reproducing the executable from it. However, as a special exception, the materials to be distributed need not include anything that is normally distributed (in either source or binary form) with the major components (compiler, kernel, and so on) of the operating system on which the executable runs, unless that component itself accompanies the executable.\n\nIt may happen that this requirement contradicts the license restrictions of other proprietary libraries that do not normally accompany the operating system. Such a contradiction means you cannot use both them and the Library together in an executable that you distribute.\n\n7. You may place library facilities that are a work based on the Library side-by-side in a single library together with other library facilities not covered by this License, and distribute such a combined library, provided that the separate distribution of the work based on the Library and of the other library facilities is otherwise permitted, and provided that you do these two things:\n\n*\ta) Accompany the combined library with a copy of the same work based on the Library, uncombined with any other library facilities. This must be distributed under the terms of the Sections above.\n*\tb) Give prominent notice with the combined library of the fact that part of it is a work based on the Library, and explaining where to find the accompanying uncombined form of the same work.\n\n8. You may not copy, modify, sublicense, link with, or distribute the Library except as expressly provided under this License. Any attempt otherwise to copy, modify, sublicense, link with, or distribute the Library is void, and will automatically terminate your rights under this License. However, parties who have received copies, or rights, from you under this License will not have their licenses terminated so long as such parties remain in full compliance.\n\n9. You are not required to accept this License, since you have not signed it. However, nothing else grants you permission to modify or distribute the Library or its derivative works. These actions are prohibited by law if you do not accept this License. Therefore, by modifying or distributing the Library (or any work based on the Library), you indicate your acceptance of this License to do so, and all its terms and conditions for copying, distributing or modifying the Library or works based on it.\n\n10. Each time you redistribute the Library (or any work based on the Library), the recipient automatically receives a license from the original licensor to copy, distribute, link with or modify the Library subject to these terms and conditions. You may not impose any further restrictions on the recipients' exercise of the rights granted herein. You are not responsible for enforcing compliance by third parties with this License.\n\n11. If, as a consequence of a court judgment or allegation of patent infringement or for any other reason (not limited to patent issues), conditions are imposed on you (whether by court order, agreement or otherwise) that contradict the conditions of this License, they do not excuse you from the conditions of this License. If you cannot distribute so as to satisfy simultaneously your obligations under this License and any other pertinent obligations, then as a consequence you may not distribute the Library at all. For example, if a patent license would not permit royalty-free redistribution of the Library by all those who receive copies directly or indirectly through you, then the only way you could satisfy both it and this License would be to refrain entirely from distribution of the Library.\n\nIf any portion of this section is held invalid or unenforceable under any particular circumstance, the balance of the section is intended to apply, and the section as a whole is intended to apply in other circumstances.\n\nIt is not the purpose of this section to induce you to infringe any patents or other property right claims or to contest validity of any such claims; this section has the sole purpose of protecting the integrity of the free software distribution system which is implemented by public license practices. Many people have made generous contributions to the wide range of software distributed through that system in reliance on consistent application of that system; it is up to the author/donor to decide if he or she is willing to distribute software through any other system and a licensee cannot impose that choice.\n\nThis section is intended to make thoroughly clear what is believed to be a consequence of the rest of this License.\n\n12. If the distribution and/or use of the Library is restricted in certain countries either by patents or by copyrighted interfaces, the original copyright holder who places the Library under this License may add an explicit geographical distribution limitation excluding those countries, so that distribution is permitted only in or among countries not thus excluded. In such case, this License incorporates the limitation as if written in the body of this License.\n\n13. The Free Software Foundation may publish revised and/or new versions of the Lesser General Public License from time to time. Such new versions will be similar in spirit to the present version, but may differ in detail to address new problems or concerns.\n\nEach version is given a distinguishing version number. If the Library specifies a version number of this License which applies to it and \"any later version\", you have the option of following the terms and conditions either of that version or of any later version published by the Free Software Foundation. If the Library does not specify a license version number, you may choose any version ever published by the Free Software Foundation.\n\n14. If you wish to incorporate parts of the Library into other free programs whose distribution conditions are incompatible with these, write to the author to ask for permission. For software which is copyrighted by the Free Software Foundation, write to the Free Software Foundation; we sometimes make exceptions for this. Our decision will be guided by the two goals of preserving the free status of all derivatives of our free software and of promoting the sharing and reuse of software generally.\n\nNO WARRANTY\n\n15. BECAUSE THE LIBRARY IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE LIBRARY, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE LIBRARY \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE LIBRARY IS WITH YOU. SHOULD THE LIBRARY PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.\n\n16. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THE LIBRARY AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE LIBRARY (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE LIBRARY TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.\n\nEND OF TERMS AND CONDITIONS\n\n\nHow to Apply These Terms to Your New Libraries\n\nIf you develop a new library, and you want it to be of the greatest possible use to the public, we recommend making it free software that everyone can redistribute and change. You can do so by permitting redistribution under these terms (or, alternatively, under the terms of the ordinary General Public License).\n\nTo apply these terms, attach the following notices to the library.  It is safest to attach them to the start of each source file to most effectively convey the exclusion of warranty; and each file should have at least the \"copyright\" line and a pointer to where the full notice is found.\n\n<one line to give the library's name and a brief idea of what it does.>\nCopyright (C) <year>  <name of author>\n\nThis library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or (at your option) any later version.\n\nThis library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.\n\nYou should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n\nAlso add information on how to contact you by electronic and paper mail.\n\nYou should also get your employer (if you work as a programmer) or your school, if any, to sign a \"copyright disclaimer\" for the library, if necessary.  Here is a sample; alter the names:\n\nYoyodyne, Inc., hereby disclaims all copyright interest in the library `Frob' (a library for tweaking knobs) written by James Random Hacker.\n\n<signature of Ty Coon>, 1 April 1990\nTy Coon, President of Vice\n\nThat's all there is to it!\n", JFreeChartInfo.CONTRIBUTORS, JFreeChartInfo.LIBRARIES);
            this.aboutFrame.pack();
            JRefineryUtilities.centerFrameOnScreen((JFrame)this.aboutFrame);
        }
        this.aboutFrame.show();
        this.aboutFrame.requestFocus();
    }

    public static void main(String[] stringArray) {
        JFreeChartDemo jFreeChartDemo = new JFreeChartDemo();
        jFreeChartDemo.pack();
        JRefineryUtilities.centerFrameOnScreen((JFrame)jFreeChartDemo);
        ((Component)jFreeChartDemo).setVisible(true);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this.aboutFrame) {
            this.aboutFrame = null;
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private JMenuBar createMenuBar(ResourceBundle resourceBundle) {
        JMenuBar jMenuBar = new JMenuBar();
        String string = resourceBundle.getString("menu.file");
        Character c = (Character)resourceBundle.getObject("menu.file.mnemonic");
        JMenu jMenu = new JMenu(string, true);
        jMenu.setMnemonic(c.charValue());
        string = resourceBundle.getString("menu.file.exit");
        c = (Character)resourceBundle.getObject("menu.file.exit.mnemonic");
        JMenuItem jMenuItem = new JMenuItem(string, c.charValue());
        jMenuItem.setActionCommand(EXIT_COMMAND);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        string = resourceBundle.getString("menu.help");
        c = (Character)resourceBundle.getObject("menu.help.mnemonic");
        JMenu jMenu2 = new JMenu(string);
        jMenu2.setMnemonic(c.charValue());
        string = resourceBundle.getString("menu.help.about");
        c = (Character)resourceBundle.getObject("menu.help.about.mnemonic");
        JMenuItem jMenuItem2 = new JMenuItem(string, c.charValue());
        jMenuItem2.setActionCommand(ABOUT_COMMAND);
        jMenuItem2.addActionListener(this);
        jMenu2.add(jMenuItem2);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        return jMenuBar;
    }

    private JTabbedPane createTabbedPane(ResourceBundle resourceBundle) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        Font font = new Font("Dialog", 0, 12);
        JPanel jPanel = new JPanel((LayoutManager)new LCBLayout(20));
        jPanel.setPreferredSize(new Dimension(360, 20));
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel jPanel2 = new JPanel((LayoutManager)new LCBLayout(20));
        jPanel2.setPreferredSize(new Dimension(360, 20));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel jPanel3 = new JPanel((LayoutManager)new LCBLayout(20));
        jPanel3.setPreferredSize(new Dimension(360, 20));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel jPanel4 = new JPanel((LayoutManager)new LCBLayout(20));
        jPanel4.setPreferredSize(new Dimension(360, 20));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel jPanel5 = new JPanel((LayoutManager)new LCBLayout(20));
        jPanel5.setPreferredSize(new Dimension(360, 20));
        jPanel5.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel jPanel6 = new JPanel((LayoutManager)new LCBLayout(20));
        jPanel6.setPreferredSize(new Dimension(360, 20));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel jPanel7 = new JPanel((LayoutManager)new LCBLayout(20));
        jPanel7.setPreferredSize(new Dimension(360, 20));
        jPanel7.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        String string = resourceBundle.getString("charts.display");
        String string2 = resourceBundle.getString("chart1.title");
        String string3 = resourceBundle.getString("chart1.description");
        jPanel.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton.setActionCommand(CHART_1_COMMAND);
        jButton.addActionListener(this);
        jPanel.add(jButton);
        string2 = resourceBundle.getString("chart2.title");
        string3 = resourceBundle.getString("chart2.description");
        jPanel.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton2 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton2.setActionCommand(CHART_2_COMMAND);
        jButton2.addActionListener(this);
        jPanel.add(jButton2);
        string2 = resourceBundle.getString("chart3.title");
        string3 = resourceBundle.getString("chart3.description");
        jPanel.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton3 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton3.setActionCommand(CHART_3_COMMAND);
        jButton3.addActionListener(this);
        jPanel.add(jButton3);
        string2 = resourceBundle.getString("chart4.title");
        string3 = resourceBundle.getString("chart4.description");
        jPanel.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton4 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton4.setActionCommand(CHART_4_COMMAND);
        jButton4.addActionListener(this);
        jPanel.add(jButton4);
        string2 = resourceBundle.getString("chart5.title");
        string3 = resourceBundle.getString("chart5.description");
        jPanel.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton5 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton5.setActionCommand(CHART_5_COMMAND);
        jButton5.addActionListener(this);
        jPanel.add(jButton5);
        string2 = resourceBundle.getString("chart6.title");
        string3 = resourceBundle.getString("chart6.description");
        jPanel.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton6 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton6.setActionCommand(CHART_6_COMMAND);
        jButton6.addActionListener(this);
        jPanel.add(jButton6);
        string2 = resourceBundle.getString("chart7.title");
        string3 = resourceBundle.getString("chart7.description");
        jPanel2.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel2.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton7 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton7.setActionCommand(CHART_7_COMMAND);
        jButton7.addActionListener(this);
        jPanel2.add(jButton7);
        string2 = resourceBundle.getString("chart8.title");
        string3 = resourceBundle.getString("chart8.description");
        jPanel2.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel2.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton8 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton8.setActionCommand(CHART_8_COMMAND);
        jButton8.addActionListener(this);
        jPanel2.add(jButton8);
        string2 = resourceBundle.getString("chart9.title");
        string3 = resourceBundle.getString("chart9.description");
        jPanel3.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel3.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton9 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton9.setActionCommand(CHART_9_COMMAND);
        jButton9.addActionListener(this);
        jPanel3.add(jButton9);
        string2 = resourceBundle.getString("chart10.title");
        string3 = resourceBundle.getString("chart10.description");
        jPanel4.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel4.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton10 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton10.setActionCommand(CHART_10_COMMAND);
        jButton10.addActionListener(this);
        jPanel4.add(jButton10);
        string2 = resourceBundle.getString("chart11.title");
        string3 = resourceBundle.getString("chart11.description");
        jPanel4.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel4.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton11 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton11.setActionCommand(CHART_11_COMMAND);
        jButton11.addActionListener(this);
        jPanel4.add(jButton11);
        string2 = resourceBundle.getString("chart12.title");
        string3 = resourceBundle.getString("chart12.description");
        jPanel4.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel4.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton12 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton12.setActionCommand(CHART_12_COMMAND);
        jButton12.addActionListener(this);
        jPanel4.add(jButton12);
        string2 = resourceBundle.getString("chart13.title");
        string3 = resourceBundle.getString("chart13.description");
        jPanel4.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel4.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton13 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton13.setActionCommand(CHART_13_COMMAND);
        jButton13.addActionListener(this);
        jPanel4.add(jButton13);
        string2 = resourceBundle.getString("chart14.title");
        string3 = resourceBundle.getString("chart14.description");
        jPanel4.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel4.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton14 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton14.setActionCommand(CHART_14_COMMAND);
        jButton14.addActionListener(this);
        jPanel4.add(jButton14);
        string2 = resourceBundle.getString("chart15.title");
        string3 = resourceBundle.getString("chart15.description");
        jPanel4.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel4.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton15 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton15.setActionCommand(CHART_15_COMMAND);
        jButton15.addActionListener(this);
        jPanel4.add(jButton15);
        string2 = resourceBundle.getString("chart16.title");
        string3 = resourceBundle.getString("chart16.description");
        jPanel5.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel5.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton16 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton16.setActionCommand(CHART_16_COMMAND);
        jButton16.addActionListener(this);
        jPanel5.add(jButton16);
        string2 = resourceBundle.getString("chart17.title");
        string3 = resourceBundle.getString("chart17.description");
        jPanel5.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel5.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton17 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton17.setActionCommand(CHART_17_COMMAND);
        jButton17.addActionListener(this);
        jPanel5.add(jButton17);
        string2 = resourceBundle.getString("chart18.title");
        string3 = resourceBundle.getString("chart18.description");
        jPanel5.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel5.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton18 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton18.setActionCommand(CHART_18_COMMAND);
        jButton18.addActionListener(this);
        jPanel5.add(jButton18);
        string2 = resourceBundle.getString("chart19.title");
        string3 = resourceBundle.getString("chart19.description");
        jPanel5.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel5.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton19 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton19.setActionCommand(CHART_19_COMMAND);
        jButton19.addActionListener(this);
        jPanel5.add(jButton19);
        string2 = resourceBundle.getString("chart20.title");
        string3 = resourceBundle.getString("chart20.description");
        jPanel6.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel6.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton20 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton20.setActionCommand(CHART_20_COMMAND);
        jButton20.addActionListener(this);
        jPanel6.add(jButton20);
        string2 = resourceBundle.getString("chart21.title");
        string3 = resourceBundle.getString("chart21.description");
        jPanel6.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel6.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton21 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton21.setActionCommand(CHART_21_COMMAND);
        jButton21.addActionListener(this);
        jPanel6.add(jButton21);
        string2 = resourceBundle.getString("chart22.title");
        string3 = resourceBundle.getString("chart22.description");
        jPanel6.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel6.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton22 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton22.setActionCommand(CHART_22_COMMAND);
        jButton22.addActionListener(this);
        jPanel6.add(jButton22);
        string2 = resourceBundle.getString("chart23.title");
        string3 = resourceBundle.getString("chart23.description");
        jPanel6.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel6.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton23 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton23.setActionCommand(CHART_23_COMMAND);
        jButton23.addActionListener(this);
        jPanel6.add(jButton23);
        string2 = resourceBundle.getString("chart24.title");
        string3 = resourceBundle.getString("chart24.description");
        jPanel6.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel6.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton24 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton24.setActionCommand(CHART_24_COMMAND);
        jButton24.addActionListener(this);
        jPanel6.add(jButton24);
        string2 = resourceBundle.getString("chart25.title");
        string3 = resourceBundle.getString("chart25.description");
        jPanel7.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel7.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton25 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton25.setActionCommand(CHART_25_COMMAND);
        jButton25.addActionListener(this);
        jPanel7.add(jButton25);
        string2 = resourceBundle.getString("chart26.title");
        string3 = resourceBundle.getString("chart26.description");
        jPanel7.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel7.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton26 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton26.setActionCommand(CHART_26_COMMAND);
        jButton26.addActionListener(this);
        jPanel7.add(jButton26);
        string2 = resourceBundle.getString("chart27.title");
        string3 = resourceBundle.getString("chart27.description");
        jPanel7.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel7.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton27 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton27.setActionCommand(CHART_27_COMMAND);
        jButton27.addActionListener(this);
        jPanel7.add(jButton27);
        string2 = resourceBundle.getString("chart28.title");
        string3 = resourceBundle.getString("chart28.description");
        jPanel7.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel7.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton28 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton28.setActionCommand(CHART_28_COMMAND);
        jButton28.addActionListener(this);
        jPanel7.add(jButton28);
        string2 = resourceBundle.getString("chart29.title");
        string3 = resourceBundle.getString("chart29.description");
        jPanel7.add(JRefineryUtilities.createJLabel((String)string2, (Font)font));
        jPanel7.add(new DescriptionPanel(new JTextArea(string3)));
        JButton jButton29 = JRefineryUtilities.createJButton((String)string, (Font)font);
        jButton29.setActionCommand(CHART_29_COMMAND);
        jButton29.addActionListener(this);
        jPanel7.add(jButton29);
        String string4 = resourceBundle.getString("tab.bar");
        String string5 = resourceBundle.getString("tab.pie");
        String string6 = resourceBundle.getString("tab.xy");
        String string7 = resourceBundle.getString("tab.time");
        String string8 = resourceBundle.getString("tab.other");
        String string9 = resourceBundle.getString("tab.test");
        String string10 = resourceBundle.getString("tab.combined");
        jTabbedPane.add(string4, new JScrollPane(jPanel));
        jTabbedPane.add(string5, new JScrollPane(jPanel2));
        jTabbedPane.add(string6, new JScrollPane(jPanel3));
        jTabbedPane.add(string7, new JScrollPane(jPanel4));
        jTabbedPane.add(string8, new JScrollPane(jPanel5));
        jTabbedPane.add(string9, new JScrollPane(jPanel6));
        jTabbedPane.add(string10, new JScrollPane(jPanel7));
        return jTabbedPane;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

