/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.jdbc;

import com.jrefinery.data.Dataset;
import com.jrefinery.data.DatasetChangeEvent;
import com.jrefinery.data.DatasetChangeListener;
import com.jrefinery.data.RangeInfo;
import com.jrefinery.data.XYDataset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class JDBCChartAdapter
implements XYDataset,
RangeInfo {
    Connection connection;
    Statement statement;
    ResultSet resultSet;
    ResultSetMetaData metaData;
    String[] columnNames = new String[0];
    Vector rows = new Vector(0);
    protected double maxValue = 0.0;
    protected double minValue = 0.0;
    protected List listeners = new ArrayList();

    public JDBCChartAdapter(String string, String string2, String string3, String string4) {
        try {
            Class.forName(string2);
            System.out.println("Opening db connection");
            this.connection = DriverManager.getConnection(string, string3, string4);
            this.statement = this.connection.createStatement();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Cannot find the database driver classes.");
            System.err.println(classNotFoundException);
        }
        catch (SQLException sQLException) {
            System.err.println("Cannot connect to this database.");
            System.err.println(sQLException);
        }
    }

    public JDBCChartAdapter(Connection connection) {
        try {
            this.connection = connection;
            this.statement = this.connection.createStatement();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void executeQuery(String string) {
        Object object = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean[] blArray = null;
        if (this.connection == null || this.statement == null) {
            System.err.println("There is no database to execute the query.");
            return;
        }
        try {
            this.resultSet = this.statement.executeQuery(string);
            this.metaData = this.resultSet.getMetaData();
            n3 = this.metaData.getColumnCount();
            blArray = new boolean[n3];
            n = 0;
            while (n < n3) {
                try {
                    int n5 = this.metaData.getColumnType(n + 1);
                    switch (n5) {
                        case -7: 
                        case 2: 
                        case 4: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 91: 
                        case 93: {
                            ++n4;
                            blArray[n] = true;
                            break;
                        }
                        default: {
                            System.err.println("Unable to load column " + n + "(" + n5 + ")");
                            blArray[n] = false;
                            break;
                        }
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    blArray[n] = false;
                }
                ++n;
            }
            this.columnNames = new String[n4 - 1];
            n2 = 0;
            n = 1;
            while (n < n3) {
                if (blArray[n]) {
                    this.columnNames[n2] = this.metaData.getColumnLabel(n + 1);
                    ++n2;
                }
                ++n;
            }
            this.rows = new Vector();
            while (this.resultSet.next()) {
                Vector<Object> vector = new Vector<Object>();
                n = 0;
                while (n < n3) {
                    if (blArray[n]) {
                        object = this.resultSet.getObject(n + 1);
                        if (object instanceof Number) {
                            vector.addElement((Number)object);
                        } else if (object instanceof Date) {
                            vector.addElement(new Long(((Date)object).getTime()));
                        } else {
                            System.out.println("Unknown Data");
                            vector.addElement(object);
                        }
                    }
                    ++n;
                }
                this.rows.addElement(vector);
            }
            if (this.rows.size() == 0) {
                Vector<Integer> vector = new Vector<Integer>();
                n = 0;
                while (n < n3) {
                    if (blArray[n]) {
                        vector.addElement(new Integer(0));
                    }
                    ++n;
                }
                this.rows.addElement(vector);
            }
            if (this.rows.size() < 1) {
                this.maxValue = 0.0;
                this.minValue = 0.0;
            } else {
                Vector vector = (Vector)this.rows.elementAt(0);
                this.minValue = this.maxValue = ((Number)vector.get(1)).doubleValue();
                int n6 = 0;
                while (n6 < this.rows.size()) {
                    vector = (Vector)this.rows.elementAt(n6);
                    n = 1;
                    while (n < n3) {
                        double d = ((Number)vector.get(n)).doubleValue();
                        if (d < this.minValue) {
                            this.minValue = d;
                        }
                        if (d > this.maxValue) {
                            this.maxValue = d;
                        }
                        ++n;
                    }
                    ++n6;
                }
            }
            this.fireDatasetChanged();
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException);
        }
    }

    public Number getXValue(int n, int n2) {
        Vector vector = (Vector)this.rows.elementAt(n2);
        return (Number)vector.elementAt(0);
    }

    public Number getYValue(int n, int n2) {
        Vector vector = (Vector)this.rows.elementAt(n2);
        return (Number)vector.elementAt(n + 1);
    }

    public int getItemCount(int n) {
        return this.rows.size();
    }

    public int getSeriesCount() {
        return this.columnNames.length;
    }

    public String getSeriesName(int n) {
        if (n < this.columnNames.length && this.columnNames[n] != null) {
            return this.columnNames[n];
        }
        return "";
    }

    public int getLegendItemCount() {
        return this.getSeriesCount();
    }

    public String[] getLegendItemLabels() {
        return this.columnNames;
    }

    public void addChangeListener(DatasetChangeListener datasetChangeListener) {
        this.listeners.add(datasetChangeListener);
    }

    public void removeChangeListener(DatasetChangeListener datasetChangeListener) {
        this.listeners.remove(datasetChangeListener);
    }

    protected void fireDatasetChanged() {
        this.notifyListeners(new DatasetChangeEvent((Dataset)this));
    }

    protected void notifyListeners(DatasetChangeEvent datasetChangeEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DatasetChangeListener datasetChangeListener = (DatasetChangeListener)iterator.next();
            datasetChangeListener.datasetChanged(datasetChangeEvent);
        }
    }

    public Number getMinimumRangeValue() {
        return new Double(this.minValue);
    }

    public Number getMaximumRangeValue() {
        return new Double(this.maxValue);
    }

    public void close() {
        System.out.println("Closing db connection");
        try {
            this.resultSet.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

