/*
 * Decompiled with CFR 0.152.
 */
package simulationplugin.ui;

import javax.swing.JTextField;
import simulationplugin.ui.ValidatingDocument;

public class DoubleField
extends JTextField {
    public DoubleField() {
        this.setDocument(new ValidatingDocument(){

            public boolean validate(String string) {
                if (string.length() == 0) {
                    return true;
                }
                try {
                    Double.parseDouble(string);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        });
    }

    public void setValue(double d) {
        this.setText(Double.toString(d));
    }

    public double getValue() {
        try {
            return this.getText().length() == 0 ? 0.0 : Double.parseDouble(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("bad number format");
        }
    }
}

