/*
 * Decompiled with CFR 0.152.
 */
package simulationplugin.ui;

import javax.swing.JTextField;
import simulationplugin.ui.ValidatingDocument;

public class IntegerField
extends JTextField {
    public IntegerField() {
        this.setDocument(new ValidatingDocument(){

            public boolean validate(String string) {
                if (string.length() == 0) {
                    return true;
                }
                try {
                    Integer.parseInt(string);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        });
    }

    public void setValue(int n) {
        this.setText(Integer.toString(n));
    }

    public int getValue() {
        try {
            return this.getText().length() == 0 ? 0 : Integer.parseInt(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("bad number format");
        }
    }
}

