/*
 * Decompiled with CFR 0.152.
 */
package simulationplugin.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import simulationplugin.ui.MultiLayerPanel;
import simulationplugin.ui.SimulationWindow;
import simulationplugin.ui.WizardEventListener;
import simulationplugin.ui.WizardStep;

public class MultiStepWizard
extends JPanel {
    protected SimulationWindow parent;
    private final MultiLayerPanel stepDisplay;
    private final ButtonPanel buttons;
    private int currentStep = 0;
    private final GridBagLayout layout;
    private List steps = new ArrayList();
    private List listeners = new ArrayList();

    public MultiStepWizard(SimulationWindow simulationWindow) {
        this.parent = simulationWindow;
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        this.stepDisplay = new MultiLayerPanel();
        this.buttons = new ButtonPanel(simulationWindow.isBigFont());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.layout.setConstraints(this.buttons, gridBagConstraints);
        this.add(this.buttons);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.layout.setConstraints(this.stepDisplay, gridBagConstraints);
        this.add(this.stepDisplay);
        this.buttons.getBackButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiStepWizard.this.backStep();
            }
        });
        this.buttons.getNextButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiStepWizard.this.nextStep();
            }
        });
        this.buttons.getResetButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiStepWizard.this.reset();
            }
        });
    }

    private int getMaxSteps() {
        return this.steps.size() - 1;
    }

    public boolean isActive() {
        return this.currentStep > 0;
    }

    public void addWizardEventListener(WizardEventListener wizardEventListener) {
        if (wizardEventListener != null) {
            this.listeners.add(wizardEventListener);
        }
    }

    public void addStep(WizardStep wizardStep) {
        wizardStep.setParent(this);
        this.steps.add(wizardStep);
        this.stepDisplay.addLayer(wizardStep.getDisplayComponent());
        if (this.stepDisplay.getCurrentLayer() < 0) {
            this.stepDisplay.setCurrentLayer(this.currentStep);
        }
        this.updateButtons();
    }

    private void backStep() {
        ((WizardStep)this.steps.get(--this.currentStep)).prepare();
        this.stepDisplay.setCurrentLayer(this.currentStep);
        this.updateButtons();
    }

    void updateButtons() {
        WizardStep wizardStep = (WizardStep)this.steps.get(this.currentStep);
        WizardStep wizardStep2 = this.currentStep > 0 ? (WizardStep)this.steps.get(this.currentStep - 1) : null;
        this.buttons.getNextButton().setEnabled(wizardStep.nextEnabled());
        this.buttons.getBackButton().setEnabled(wizardStep2 == null ? false : wizardStep2.returnEnabled());
        this.buttons.getResetButton().setEnabled(wizardStep.resetEnabled());
    }

    private void nextStep() {
        WizardStep wizardStep = (WizardStep)this.steps.get(this.currentStep);
        wizardStep.doProcessing();
        if (++this.currentStep <= this.getMaxSteps()) {
            ((WizardStep)this.steps.get(this.currentStep)).prepare();
            this.stepDisplay.setCurrentLayer(this.currentStep);
            this.updateButtons();
        } else {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((WizardEventListener)iterator.next()).wizardCompleted();
            }
            this.currentStep = this.getMaxSteps();
        }
    }

    private void reset() {
        this.currentStep = 0;
        this.parent.reset();
    }

    private static class ButtonPanel
    extends JPanel {
        private JButton back;
        private JButton next;
        private JButton reset;

        JButton getBackButton() {
            return this.back;
        }

        JButton getNextButton() {
            return this.next;
        }

        JButton getResetButton() {
            return this.reset;
        }

        ButtonPanel(boolean bl) {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("icon/prev.gif"));
            if (imageIcon == null) {
                this.back = new JButton("Go Back");
                if (bl) {
                    this.back.setFont(SimulationWindow.BIG_FONT);
                }
            } else {
                this.back = new JButton(imageIcon);
                this.back.setBorder(BorderFactory.createEmptyBorder());
            }
            gridBagLayout.setConstraints(this.back, gridBagConstraints);
            this.add(this.back);
            this.reset = new JButton("Reset Simulation");
            if (bl) {
                this.reset.setFont(SimulationWindow.BIG_FONT);
            }
            gridBagLayout.setConstraints(this.reset, gridBagConstraints);
            this.add(this.reset);
            ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("icon/next.gif"));
            if (imageIcon2 == null) {
                this.next = new JButton("Advance");
                if (bl) {
                    this.next.setFont(SimulationWindow.BIG_FONT);
                }
            } else {
                this.next = new JButton(imageIcon2);
                this.next.setBorder(BorderFactory.createEmptyBorder());
            }
            gridBagLayout.setConstraints(this.next, gridBagConstraints);
            this.add(this.next);
        }
    }
}

