/*
 * Decompiled with CFR 0.152.
 */
package simulationplugin.ui;

import ic.doc.simulation.sim.Result;
import ic.doc.simulation.sim.ResultSet;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import simulationplugin.ui.ComponentFactory;
import simulationplugin.ui.ResultDisplayComponent;
import simulationplugin.ui.SimulationWindow;
import simulationplugin.ui.WizardStep;

public class ResultStep
extends WizardStep {
    private static final String TITLE = "Results";
    private static final String ALL = "All";
    private static final String NULL = "null";
    private DefaultListModel listModel;
    private JList list;
    private DefaultListModel resultSelect;
    private JList rsList;
    private JPanel resultDisplay;
    private CardLayout resultDisplayLayout;
    private final SimulationWindow parent;
    private final JComponent display;
    private Map results;

    public ResultStep(SimulationWindow simulationWindow) {
        this.parent = simulationWindow;
        this.results = new Hashtable();
        this.display = this.makeDisplay(simulationWindow.isBigFont());
    }

    public boolean nextEnabled() {
        return false;
    }

    public JComponent getDisplayComponent() {
        return this.display;
    }

    public void setResults(ResultSet[] resultSetArray) {
        Object object;
        this.clearResults();
        Iterator iterator = new TreeSet(resultSetArray[0].getMeasureNames()).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Result[] resultArray = new Result[resultSetArray.length];
            int n = 0;
            while (n < resultSetArray.length) {
                resultArray[n] = resultSetArray[n].getResult(string);
                ++n;
            }
            object = ResultDisplayComponent.make(resultArray, this.parent);
            ((ResultDisplayComponent)object).showResult(-1);
            this.results.put(string, object);
            this.resultDisplay.add((Component)((ResultDisplayComponent)object).getComponent(), string);
            this.listModel.addElement(string);
        }
        int n = 0;
        while (n < resultSetArray.length) {
            this.resultSelect.addElement(Integer.toString(n + 1));
            ++n;
        }
        try {
            object = (String)this.list.getSelectedValue();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            object = null;
        }
        if (object == null) {
            this.resultDisplayLayout.show(this.resultDisplay, NULL);
        } else {
            this.resultDisplayLayout.show(this.resultDisplay, (String)object);
        }
        this.rsList.setSelectedValue(ALL, true);
        this.list.setSelectedIndex(0);
    }

    private void clearResults() {
        this.resultDisplay.removeAll();
        this.resultDisplayLayout = new CardLayout();
        this.resultDisplay.setLayout(this.resultDisplayLayout);
        this.resultDisplay.add((Component)new JPanel(), NULL);
        this.resultDisplayLayout.show(this.resultDisplay, NULL);
        this.listModel.clear();
        this.resultSelect.clear();
        this.resultSelect.add(0, ALL);
        this.results.clear();
    }

    private JComponent makeDisplay(boolean bl) {
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.setSelectedIndex(0);
        this.list.addListSelectionListener(new SelectionListener());
        this.resultSelect = new DefaultListModel();
        this.resultSelect.add(0, ALL);
        this.rsList = new JList(this.resultSelect);
        this.rsList.setSelectionMode(0);
        this.rsList.setSelectedIndex(0);
        this.rsList.addListSelectionListener(new ResultSelectionListener());
        this.resultDisplay = new JPanel();
        this.resultDisplay.setBorder(ComponentFactory.makeBorder(""));
        this.clearResults();
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setBorder(ComponentFactory.makeBorder("Measure"));
        jPanel.add(jScrollPane);
        jScrollPane = new JScrollPane(this.rsList);
        jScrollPane.setBorder(ComponentFactory.makeBorder("Run"));
        jPanel.add(jScrollPane);
        JSplitPane jSplitPane = new JSplitPane(1, jPanel, this.resultDisplay);
        jSplitPane.setBorder(ComponentFactory.makeBorder(TITLE));
        jSplitPane.setDividerLocation(bl ? 250 : 150);
        return jSplitPane;
    }

    private class ResultSelectionListener
    implements ListSelectionListener {
        private ResultSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            String string;
            if (!listSelectionEvent.getValueIsAdjusting() && (string = (String)ResultStep.this.rsList.getSelectedValue()) != null) {
                int n = string.equals(ResultStep.ALL) ? -1 : Integer.parseInt(string) - 1;
                Iterator iterator = ResultStep.this.results.values().iterator();
                while (iterator.hasNext()) {
                    ((ResultDisplayComponent)iterator.next()).showResult(n);
                }
            }
        }
    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            block3: {
                if (listSelectionEvent.getValueIsAdjusting()) break block3;
                try {
                    String string = (String)ResultStep.this.list.getSelectedValue();
                    if (string == null) {
                        ResultStep.this.resultDisplayLayout.show(ResultStep.this.resultDisplay, ResultStep.NULL);
                        break block3;
                    }
                    ResultStep.this.resultDisplayLayout.show(ResultStep.this.resultDisplay, string);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
        }
    }
}

