/*
 * Decompiled with CFR 0.152.
 */
package simulationplugin.ui;

import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.JFreeChartPanel;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.VerticalXYBarRenderer;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.data.MovingAveragePlotFitAlgorithm;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.XYDataset;
import com.jrefinery.data.XYSeries;
import com.jrefinery.data.XYSeriesCollection;
import ic.doc.simulation.sim.ActionCounterResult;
import ic.doc.simulation.sim.HistogramResult;
import ic.doc.simulation.sim.MeasureResult;
import ic.doc.simulation.sim.Statistics;
import ic.doc.simulation.sim.TimeSeries;
import ic.doc.simulation.sim.Timer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import simulationplugin.ui.IntervalDataSet;

public class ComponentFactory {
    private static double max = 0.0;
    private static double min = Double.MAX_VALUE;
    public static final String COUNT = "Count";
    public static final String TIME = "Time";
    public static final String VALUE = "Value";
    public static final String MOV_AVG = "Moving Average";
    public static final String MEAN = "Mean";
    private static final int BIG_ROW_HEIGHT = 22;
    public static final DecimalFormat FORMAT = (DecimalFormat)NumberFormat.getInstance();
    private static final Border EMPTY_BORDER;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;

    private static double getPercentilePosition(HistogramResult histogramResult, double d) {
        double d2 = 0.0;
        int n = 0;
        while (n < histogramResult.getBucketCount()) {
            d2 += histogramResult.getBucketContent(n).doubleValue();
            ++n;
        }
        double d3 = 0.0;
        int n2 = 0;
        while (n2 < histogramResult.getBucketCount() && d3 / d2 < d) {
            d3 += histogramResult.getBucketContent(n2).doubleValue();
            ++n2;
        }
        double d4 = d3 / d2;
        double d5 = (d3 -= histogramResult.getBucketContent(n2).doubleValue()) / d2;
        double d6 = (d - d5) / (d4 - d5);
        return histogramResult.getHistogramLow() + ((double)n2 + d6) * (histogramResult.getHistogramHigh() - histogramResult.getHistogramLow()) / (double)histogramResult.getBucketCount();
    }

    public static JComponent makeHistogram(HistogramResult histogramResult, String string) {
        IntervalDataSet intervalDataSet = new IntervalDataSet(string);
        String string2 = histogramResult.getSource() instanceof Timer ? TIME : VALUE;
        String string3 = histogramResult.getSource() instanceof Timer ? COUNT : TIME;
        double d = histogramResult.getHistogramHigh();
        double d2 = histogramResult.getHistogramLow();
        int n = histogramResult.getBucketCount();
        double d3 = (d - d2) / (double)n;
        int n2 = 0;
        while (n2 < histogramResult.getBucketCount()) {
            intervalDataSet.add(new Double(d2 + (double)n2 * d3), new Double(d2 + (double)(n2 + 1) * d3), histogramResult.getBucketContent(n2));
            ++n2;
        }
        HorizontalNumberAxis horizontalNumberAxis = new HorizontalNumberAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        XYPlot xYPlot = new XYPlot((ValueAxis)horizontalNumberAxis, (ValueAxis)verticalNumberAxis);
        xYPlot.addVerticalLine((Number)new Double(histogramResult.getMean()), (Paint)Color.black);
        xYPlot.addVerticalLine((Number)new Double(ComponentFactory.getPercentilePosition(histogramResult, 0.95)), (Paint)Color.blue);
        horizontalNumberAxis.setMinimumAxisValue(d2);
        horizontalNumberAxis.setMaximumAxisValue(d);
        xYPlot.setXYItemRenderer((XYItemRenderer)new VerticalXYBarRenderer());
        JFreeChart jFreeChart = new JFreeChart((Dataset)intervalDataSet, (Plot)xYPlot, string, JFreeChartConstants.DEFAULT_TITLE_FONT, false);
        ComponentFactory.addBackground(jFreeChart);
        return ComponentFactory.makeChartPanel(jFreeChart);
    }

    public static JComponent makeTimeSeriesChart(MeasureResult measureResult, String string, double d, int n) {
        XYSeries xYSeries = ComponentFactory.makeSeries(measureResult);
        double d2 = min;
        min = Double.MAX_VALUE;
        double d3 = max;
        max = 0.0;
        if (n > 0) {
            xYSeries = ComponentFactory.movingAverage(xYSeries, n);
        }
        JFreeChart jFreeChart = ChartFactory.createXYChart((String)string, (String)TIME, (String)(n > 0 ? MOV_AVG : MEAN), (XYDataset)new XYSeriesCollection(xYSeries), (boolean)false);
        if (d > 0.0) {
            jFreeChart.getXYPlot().addVerticalLine((Number)new Double(d), (Paint)Color.black);
        }
        jFreeChart.getXYPlot().getRangeAxis().setAxisRange(d2 * 0.96, d3 * 1.04);
        ComponentFactory.addBackground(jFreeChart);
        return ComponentFactory.makeChartPanel(jFreeChart);
    }

    public static JComponent makeTimeSeriesChart(MeasureResult measureResult, String string, double d) {
        return ComponentFactory.makeTimeSeriesChart(measureResult, string, d, 0);
    }

    public static JComponent makeTimeSeriesChart(MeasureResult[] measureResultArray, double d, int n) {
        XYSeries xYSeries;
        String string = measureResultArray[0].getSource().getName() + " (all runs)";
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        int n2 = 0;
        while (n2 < measureResultArray.length) {
            xYSeries = ComponentFactory.makeSeries(measureResultArray[n2]);
            if (max > d3) {
                d3 = max;
            }
            if (min < d2) {
                d2 = min;
            }
            min = Double.MAX_VALUE;
            max = 0.0;
            xYSeries.setName("Run " + (n2 + 1));
            if (n > 0) {
                xYSeries = ComponentFactory.movingAverage(xYSeries, n);
            }
            xYSeriesCollection.addSeries(xYSeries);
            ++n2;
        }
        xYSeries = ChartFactory.createXYChart((String)string, (String)TIME, (String)(n > 0 ? MOV_AVG : MEAN), (XYDataset)xYSeriesCollection, (boolean)true);
        if (d > 0.0) {
            xYSeries.getXYPlot().addVerticalLine((Number)new Double(d), (Paint)Color.black);
        }
        xYSeries.getXYPlot().getRangeAxis().setAxisRange(d2 * 0.96, d3 * 1.04);
        ComponentFactory.addBackground((JFreeChart)xYSeries);
        return ComponentFactory.makeChartPanel((JFreeChart)xYSeries);
    }

    public static JComponent makeTimeSeriesChart(MeasureResult[] measureResultArray, double d) {
        return ComponentFactory.makeTimeSeriesChart(measureResultArray, d, 0);
    }

    private static JComponent makeChartPanel(JFreeChart jFreeChart) {
        return new JFreeChartPanel(jFreeChart, true, true, true, false, true){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() && this.popup != null) {
                    this.popup.show((Component)((Object)this), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() && this.popup != null) {
                    this.popup.show((Component)((Object)this), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
    }

    public static JComponent makeStatisticalSummary(final MeasureResult measureResult) {
        final JPanel jPanel = new JPanel(new GridLayout(0, 4, 0, 0));
        jPanel.add(new JLabel(MEAN));
        jPanel.add(new JLabel(FORMAT.format(measureResult.getMean())));
        jPanel.add(new JLabel("Minimum"));
        jPanel.add(new JLabel(FORMAT.format(measureResult.getMinimum())));
        jPanel.add(new JLabel("Variance"));
        jPanel.add(new JLabel(FORMAT.format(measureResult.getVariance())));
        jPanel.add(new JLabel("Maximum"));
        jPanel.add(new JLabel(FORMAT.format(measureResult.getMaximum())));
        final JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Copy statistics");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = measureResult.getSource().getName() + "\n" + "mean\t" + Double.toString(measureResult.getMean()) + "\n" + "variance\t" + Double.toString(measureResult.getVariance()) + "\n" + "minimum\t" + Double.toString(measureResult.getMinimum()) + "\n" + "maximum\t" + Double.toString(measureResult.getMaximum()) + "\n";
                Clipboard clipboard = jPopupMenu.getToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, stringSelection);
            }
        });
        jPopupMenu.add(jMenuItem);
        if (measureResult instanceof HistogramResult) {
            final int n = ((HistogramResult)measureResult).getUnderflows();
            final int n2 = ((HistogramResult)measureResult).getOverflows();
            jPanel.add(new JLabel("Underflows"));
            jPanel.add(new JLabel(Integer.toString(n)));
            jPanel.add(new JLabel("Overflows"));
            jPanel.add(new JLabel(Integer.toString(n2)));
            JMenuItem jMenuItem2 = new JMenuItem("Copy histogram data");
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HistogramResult histogramResult = (HistogramResult)measureResult;
                    double d = histogramResult.getHistogramLow();
                    double d2 = histogramResult.getHistogramHigh() - d;
                    int n3 = histogramResult.getBucketCount();
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("lower\tupper\tcount\n");
                    int n22 = 0;
                    while (n22 < n3) {
                        stringBuffer.append(d + (double)n22 * (d2 / (double)n3));
                        stringBuffer.append('\t');
                        stringBuffer.append(d + (double)(n22 + 1) * (d2 / (double)n3));
                        stringBuffer.append('\t');
                        stringBuffer.append(histogramResult.getBucketContent(n22));
                        stringBuffer.append('\n');
                        ++n22;
                    }
                    stringBuffer.append("underflows\t");
                    stringBuffer.append(n);
                    stringBuffer.append('\n');
                    stringBuffer.append("overflows\t");
                    stringBuffer.append(n2);
                    stringBuffer.append('\n');
                    Clipboard clipboard = jPopupMenu.getToolkit().getSystemClipboard();
                    StringSelection stringSelection = new StringSelection(stringBuffer.toString());
                    clipboard.setContents(stringSelection, stringSelection);
                }
            });
            jPopupMenu.add(jMenuItem2);
        }
        jPanel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(jPanel, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        return jPanel;
    }

    public static JComponent makeStatisticalSummary(MeasureResult[] measureResultArray, double d) {
        double d2;
        double d3;
        if (!(d > 0.0) || !(d < 1.0)) {
            throw new IllegalArgumentException("Confidence level must be between 0 and 1");
        }
        int n = measureResultArray.length - 1;
        double[] dArray = new double[measureResultArray.length];
        double[] dArray2 = new double[measureResultArray.length];
        double[] dArray3 = new double[measureResultArray.length];
        int n2 = 0;
        while (n2 < measureResultArray.length) {
            dArray[n2] = measureResultArray[n2].getMean();
            dArray2[n2] = measureResultArray[n2].getMinimum();
            dArray3[n2] = measureResultArray[n2].getMaximum();
            ++n2;
        }
        final JPanel jPanel = new JPanel(new GridLayout(0, 4, 2, 0));
        jPanel.add(new JLabel("Number of runs"));
        jPanel.add(new JLabel(Integer.toString(measureResultArray.length)));
        jPanel.add(new JLabel(""));
        jPanel.add(new JLabel(""));
        jPanel.add(new JLabel("Mean over runs"));
        double d4 = Statistics.mean((double[])dArray);
        jPanel.add(new JLabel(FORMAT.format(d4)));
        jPanel.add(new JLabel("Min. over runs"));
        jPanel.add(new JLabel(FORMAT.format(Statistics.minimum((double[])dArray2))));
        jPanel.add(new JLabel("Var. over runs"));
        double d5 = Statistics.variance((double[])dArray);
        jPanel.add(new JLabel(FORMAT.format(d5)));
        jPanel.add(new JLabel("Max. over runs"));
        jPanel.add(new JLabel(FORMAT.format(Statistics.maximum((double[])dArray3))));
        if (n > 0) {
            double d6 = Statistics.tQuantile((double)(d + 0.5 * (1.0 - d)), (int)n, (boolean)true);
            jPanel.add(new JLabel("Lower CI bound"));
            d3 = Statistics.tToX((double)(-d6), (double)d4, (double)d5, (int)(n + 1));
            jPanel.add(new JLabel(FORMAT.format(d3)));
            jPanel.add(new JLabel("Upper CI bound"));
            d2 = Statistics.tToX((double)d6, (double)d4, (double)d5, (int)(n + 1));
            jPanel.add(new JLabel(FORMAT.format(d2)));
        } else {
            d3 = 0.0;
            d2 = 0.0;
        }
        final StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(measureResultArray[0].getSource().getName());
        stringBuffer.append('\n');
        stringBuffer.append("run\tmean\tminimum\tmaximum\n");
        int n3 = 0;
        while (n3 < dArray.length) {
            stringBuffer.append(n3);
            stringBuffer.append('\t');
            stringBuffer.append(dArray[n3]);
            stringBuffer.append('\t');
            stringBuffer.append(dArray2[n3]);
            stringBuffer.append('\t');
            stringBuffer.append(dArray3[n3]);
            stringBuffer.append('\n');
            ++n3;
        }
        stringBuffer.append('\n');
        stringBuffer.append("Mean over runs\t");
        stringBuffer.append(d4);
        stringBuffer.append('\n');
        stringBuffer.append("Variance over runs\t");
        stringBuffer.append(d5);
        stringBuffer.append('\n');
        stringBuffer.append("Minimum over runs\t");
        stringBuffer.append(Statistics.minimum((double[])dArray2));
        stringBuffer.append('\n');
        stringBuffer.append("Maximum over runs\t");
        stringBuffer.append(Statistics.maximum((double[])dArray3));
        stringBuffer.append('\n');
        if (n > 0) {
            stringBuffer.append("Confidence interval lower bound\t");
            stringBuffer.append(d3);
            stringBuffer.append('\n');
            stringBuffer.append("Confidence interval upper bound\t");
            stringBuffer.append(d2);
            stringBuffer.append('\n');
        }
        final JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Copy statistics");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Clipboard clipboard = jPopupMenu.getToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(stringBuffer.toString());
                clipboard.setContents(stringSelection, stringSelection);
            }
        });
        jPopupMenu.add(jMenuItem);
        jPanel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(jPanel, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        return jPanel;
    }

    public static JComponent makeResult(ActionCounterResult actionCounterResult, boolean bl) {
        JTable jTable = new JTable(new ACResultModel(actionCounterResult));
        if (bl) {
            jTable.setRowHeight(22);
        }
        return new JScrollPane(jTable);
    }

    public static JComponent makeResult(ActionCounterResult[] actionCounterResultArray, boolean bl) {
        JTable jTable = new JTable(new ACResultSetModel(actionCounterResultArray));
        if (bl) {
            jTable.setRowHeight(22);
        }
        return new JScrollPane(jTable);
    }

    public static Border makeBorder(String string) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        return BorderFactory.createCompoundBorder(titledBorder, EMPTY_BORDER);
    }

    public static void addBackground(JFreeChart jFreeChart) {
        jFreeChart.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, Color.white, 100.0f, 200.0f, Color.blue.brighter(), true));
    }

    private static XYSeries movingAverage(XYSeries xYSeries, int n) {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        MovingAveragePlotFitAlgorithm movingAveragePlotFitAlgorithm = new MovingAveragePlotFitAlgorithm();
        XYSeries xYSeries2 = new XYSeries(xYSeries.getName());
        movingAveragePlotFitAlgorithm.setPeriod(n);
        movingAveragePlotFitAlgorithm.setXYDataset((XYDataset)xYSeriesCollection);
        int n2 = xYSeries.getItemCount();
        int n3 = 0;
        while (n3 < n2) {
            Number number = xYSeries.getXValue(n3);
            xYSeries2.add(number, movingAveragePlotFitAlgorithm.getY(0, number));
            ++n3;
        }
        return xYSeries2;
    }

    private static XYSeries makeSeries(MeasureResult measureResult) {
        XYSeries xYSeries = new XYSeries(measureResult.getSource().getName());
        TimeSeries timeSeries = measureResult.getSeries();
        timeSeries.rewind();
        while (timeSeries.hasMoreValues()) {
            double d = timeSeries.getValue();
            if (d > max) {
                max = d;
            }
            if (d < min) {
                min = d;
            }
            xYSeries.add(timeSeries.getTime(), d);
            timeSeries.next();
        }
        return xYSeries;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        FORMAT.applyPattern("##0.#####");
        EMPTY_BORDER = BorderFactory.createEmptyBorder(10, 10, 10, 10);
    }

    private static class ACResultSetModel
    extends AbstractTableModel {
        private final Object[][] data;
        private static final String[] colName = new String[]{"Event", "Total Count", "Mean Count"};
        private static final Class[] colClass = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ComponentFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = ComponentFactory.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Double == null ? (class$java$lang$Double = ComponentFactory.class$("java.lang.Double")) : class$java$lang$Double};

        ACResultSetModel(ActionCounterResult[] actionCounterResultArray) {
            this.data = new Object[actionCounterResultArray[0].getNames().size()][3];
            Iterator iterator = actionCounterResultArray[0].getNames().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.data[n][0] = string;
                double[] dArray = new double[actionCounterResultArray.length];
                int n2 = 0;
                while (n2 < actionCounterResultArray.length) {
                    dArray[n2] = actionCounterResultArray[n2].getCount(string);
                    ++n2;
                }
                this.data[n][1] = new Integer((int)Statistics.sum((double[])dArray));
                this.data[n][2] = new Double(Statistics.mean((double[])dArray));
                ++n;
            }
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            return colName[n];
        }

        public Class getColumnClass(int n) {
            return colClass[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }
    }

    private static class ACResultModel
    extends AbstractTableModel {
        private final Object[][] data;
        private static final String[] colName = new String[]{"Event", "Count"};
        private static final Class[] colClass = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ComponentFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = ComponentFactory.class$("java.lang.Integer")) : class$java$lang$Integer};

        ACResultModel(ActionCounterResult actionCounterResult) {
            this.data = new Object[actionCounterResult.getNames().size()][2];
            Iterator iterator = actionCounterResult.getNames().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.data[n][0] = string;
                this.data[n][1] = new Integer(actionCounterResult.getCount(string));
                ++n;
            }
        }

        public int getColumnCount() {
            return 2;
        }

        public Class getColumnClass(int n) {
            return colClass[n];
        }

        public String getColumnName(int n) {
            return colName[n];
        }

        public int getRowCount() {
            return this.data.length;
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

