/*
 * Decompiled with CFR 0.152.
 */
package simulationplugin.ui;

import ic.doc.simulation.sim.ChartablePerformanceMeasure;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import simulationplugin.ui.ComponentFactory;
import simulationplugin.ui.DoubleField;
import simulationplugin.ui.IntegerField;

public class HistogramBoundsControl {
    private final Collection boundsControls;
    private final Component mainDisplay;
    protected Dimension FIELD_SIZE;

    public HistogramBoundsControl(Dimension dimension, Collection collection) {
        this.FIELD_SIZE = dimension;
        this.boundsControls = new Vector();
        this.mainDisplay = this.makeHistogramBoundsControl(collection);
    }

    public Component getComponent() {
        return this.mainDisplay;
    }

    public void applySettings() {
        Iterator iterator = this.boundsControls.iterator();
        while (iterator.hasNext()) {
            ((BoundsControl)iterator.next()).applySettings();
        }
    }

    private JComponent makeHistogramBoundsControl(Collection collection) {
        final CardLayout cardLayout = new CardLayout();
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        final JPanel jPanel2 = new JPanel(cardLayout);
        final DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        final JList jList = new JList(defaultListModel);
        JScrollPane jScrollPane = new JScrollPane(jList);
        jPanel.setBorder(ComponentFactory.makeBorder("Histogram bounds"));
        jPanel2.add((Component)new JPanel(), "null");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                ChartablePerformanceMeasure chartablePerformanceMeasure = (ChartablePerformanceMeasure)iterator.next();
                BoundsControl boundsControl = new BoundsControl(this.FIELD_SIZE, chartablePerformanceMeasure);
                this.boundsControls.add(boundsControl);
                defaultListModel.addElement(chartablePerformanceMeasure.getName());
                jPanel2.add((Component)boundsControl.getComponent(), chartablePerformanceMeasure.getName());
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting() && defaultListModel.getSize() > 0) {
                    String string = (String)jList.getSelectedValue();
                    if (string == null) {
                        cardLayout.show(jPanel2, "null");
                    } else {
                        cardLayout.show(jPanel2, string);
                    }
                }
            }
        });
        jList.setSelectionMode(0);
        jList.setSelectedIndex(0);
        jPanel.add(jList);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private static class BoundsControl
    implements ItemListener {
        private final ChartablePerformanceMeasure target;
        private final JComponent component;
        private final DoubleField min;
        private final DoubleField max;
        private final IntegerField buckets;
        private final JCheckBox makeHistogram;
        private static final Vals DEFAULT = new Vals(false, 0.0, 10.0, 25);
        private static final Map defaults = new Hashtable();

        public BoundsControl(Dimension dimension, ChartablePerformanceMeasure chartablePerformanceMeasure) {
            this.target = chartablePerformanceMeasure;
            Vals vals = (Vals)defaults.get(chartablePerformanceMeasure.getName());
            if (vals == null) {
                vals = DEFAULT;
            }
            this.min = new DoubleField();
            this.min.setValue(vals.low);
            this.min.setMinimumSize(dimension);
            this.min.setPreferredSize(dimension);
            this.max = new DoubleField();
            this.max.setValue(vals.high);
            this.max.setMinimumSize(dimension);
            this.max.setPreferredSize(dimension);
            this.buckets = new IntegerField();
            this.buckets.setValue(vals.num);
            this.buckets.setMinimumSize(dimension);
            this.buckets.setPreferredSize(dimension);
            this.makeHistogram = new JCheckBox();
            this.makeHistogram.addItemListener(this);
            this.min.setEnabled(vals.make);
            this.max.setEnabled(vals.make);
            this.buckets.setEnabled(vals.make);
            this.makeHistogram.setSelected(vals.make);
            this.component = new JPanel(new GridLayout(4, 2));
            this.component.add(new JLabel("Make histogram"));
            this.component.add(this.makeHistogram);
            this.component.add(new JLabel("Number of buckets"));
            this.component.add(this.buckets);
            this.component.add(new JLabel("Minimum value"));
            this.component.add(this.min);
            this.component.add(new JLabel("Maximum value"));
            this.component.add(this.max);
        }

        public JComponent getComponent() {
            return this.component;
        }

        public void applySettings() {
            if (this.makeHistogram.isSelected()) {
                this.target.setHistogramRange(this.min.getValue(), this.max.getValue(), this.buckets.getValue());
            }
            Vals vals = new Vals(this.makeHistogram.isSelected(), this.min.getValue(), this.max.getValue(), this.buckets.getValue());
            defaults.put(this.target.getName(), vals);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = this.makeHistogram.isSelected();
            this.min.setEnabled(bl);
            this.max.setEnabled(bl);
            this.buckets.setEnabled(bl);
        }

        private static class Vals {
            final boolean make;
            final double low;
            final double high;
            final int num;

            Vals(boolean bl, double d, double d2, int n) {
                this.make = bl;
                this.low = d;
                this.high = d2;
                this.num = n;
            }
        }
    }
}

