/*
 * Decompiled with CFR 0.152.
 */
package simulationplugin.ui;

import ic.doc.simulation.sim.MeasureResult;
import ic.doc.simulation.sim.Result;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import simulationplugin.ui.ComponentFactory;
import simulationplugin.ui.ResultDisplayComponent;

public class MeasureDisplayComponent
extends ResultDisplayComponent {
    private static final Dimension CHART_MIN = new Dimension(240, 160);
    private double transientResetTime;
    private int movAvgPeriod;
    private double confidenceLevel;

    public MeasureDisplayComponent(Result[] resultArray, double d, double d2) {
        this(resultArray, d, d2, 0);
    }

    public MeasureDisplayComponent(Result[] resultArray, double d, double d2, int n) {
        super(resultArray);
        this.confidenceLevel = d;
        this.transientResetTime = d2;
        this.movAvgPeriod = n;
    }

    private JComponent makeAllResultsDisplay() {
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        Result[] resultArray = this.getResults();
        MeasureResult[] measureResultArray = new MeasureResult[resultArray.length];
        System.arraycopy(resultArray, 0, measureResultArray, 0, resultArray.length);
        JComponent jComponent = ComponentFactory.makeTimeSeriesChart(measureResultArray, this.transientResetTime, this.movAvgPeriod);
        jPanel.add(jComponent);
        jPanel.add(ComponentFactory.makeStatisticalSummary(measureResultArray, this.confidenceLevel));
        return jPanel;
    }

    public Component makeDisplay(Result result, int n) {
        if (n == -1) {
            return this.makeAllResultsDisplay();
        }
        return this.makeOneResultDisplay((MeasureResult)result, n);
    }

    protected JComponent makeOneResultDisplay(MeasureResult measureResult, int n) {
        String string = measureResult.getSource().getName() + " (run " + (n + 1) + ")";
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        JComponent jComponent = ComponentFactory.makeTimeSeriesChart(measureResult, string, this.transientResetTime, this.movAvgPeriod);
        jPanel.add(jComponent);
        JComponent jComponent2 = ComponentFactory.makeStatisticalSummary(measureResult);
        jPanel.add(jComponent2);
        return jPanel;
    }
}

