/*
 * Decompiled with CFR 0.152.
 */
package simulationplugin.ui;

import ic.doc.simulation.sim.ChartablePerformanceMeasure;
import ic.doc.simulation.sim.PerformanceMeasure;
import ic.doc.simulation.sim.SimulationOptions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import simulationplugin.ui.ComponentFactory;
import simulationplugin.ui.DoubleField;
import simulationplugin.ui.HistogramBoundsControl;
import simulationplugin.ui.IntegerField;
import simulationplugin.ui.LongField;
import simulationplugin.ui.SimulationWindow;
import simulationplugin.ui.WizardStep;

public class OptionsStep
extends WizardStep {
    private static final String TITLE = "Options";
    private static final double LABEL_WEIGHT = 0.8;
    private static final double FIELD_WEIGHT = 0.2;
    private final Dimension FIELD_SIZE;
    private final Dimension LIST_SIZE;
    private JComponent display = null;
    private static SimulationOptions options = new SimulationOptions();
    private DoubleField runLength;
    private DoubleField transientReset;
    private LongField zenoThreshold;
    private IntegerField samplePoints;
    private IntegerField movingAveragePeriod;
    private HistogramBoundsControl boundsControl;
    private NumberFormat runLengthFormat;
    private GridBagLayout layout;
    private BatchOpts batchOpts;
    private SimulationWindow parent;
    private static boolean defaultSingle = false;
    private static int defaultDF = 2;
    private static double defaultCL = 0.95;
    private JList pmList;

    public OptionsStep(SimulationWindow simulationWindow) {
        this.parent = simulationWindow;
        this.runLengthFormat = NumberFormat.getNumberInstance();
        this.runLengthFormat.setParseIntegerOnly(true);
        if (!simulationWindow.isBigFont()) {
            this.FIELD_SIZE = new Dimension(60, 20);
            this.LIST_SIZE = new Dimension(200, 50);
        } else {
            this.FIELD_SIZE = new Dimension(100, 30);
            this.LIST_SIZE = new Dimension(300, 50);
        }
        this.display = this.makeDisplay();
    }

    public JComponent getDisplayComponent() {
        return this.display;
    }

    public boolean nextEnabled() {
        return this.validate();
    }

    public boolean returnEnabled() {
        return false;
    }

    public boolean resetEnabled() {
        return false;
    }

    public void prepare() {
    }

    public void doProcessing() {
        this.parent.setSimulationOptions(options);
        this.boundsControl.applySettings();
    }

    private JComponent makeDisplay() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        gridBagConstraints.fill = 1;
        Component component = this.makeSimulationOptions();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        jPanel.add(component);
        this.batchOpts = new BatchOpts();
        this.batchOpts.setBorder(ComponentFactory.makeBorder("Batch management"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.batchOpts, gridBagConstraints);
        jPanel.add(this.batchOpts);
        component = this.makeGraphingOptions();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        jPanel.add(component);
        this.boundsControl = new HistogramBoundsControl(this.FIELD_SIZE, this.parent.getSimulation().getPerformanceMeasures());
        component = this.boundsControl.getComponent();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        jPanel.add(component);
        return jPanel;
    }

    private JComponent makeSimulationOptions() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        this.layout = new GridBagLayout();
        jPanel.setLayout(this.layout);
        jPanel.setBorder(ComponentFactory.makeBorder("Simulation Options"));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        JLabel jLabel = new JLabel("Run length");
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.layout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        jLabel = new JLabel("Transient reset time");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.layout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        jLabel = new JLabel("Zeno threshold");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.layout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        this.runLength = this.makeRunLengthField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.runLength.setMinimumSize(this.FIELD_SIZE);
        this.runLength.setPreferredSize(this.FIELD_SIZE);
        this.layout.setConstraints(this.runLength, gridBagConstraints);
        jPanel.add(this.runLength);
        this.transientReset = this.makeTransientResetField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.transientReset.setMinimumSize(this.FIELD_SIZE);
        this.transientReset.setPreferredSize(this.FIELD_SIZE);
        this.layout.setConstraints(this.transientReset, gridBagConstraints);
        jPanel.add(this.transientReset);
        this.zenoThreshold = this.makeZenoThresholdField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.zenoThreshold.setMinimumSize(this.FIELD_SIZE);
        this.zenoThreshold.setPreferredSize(this.FIELD_SIZE);
        this.layout.setConstraints(this.zenoThreshold, gridBagConstraints);
        jPanel.add(this.zenoThreshold);
        return jPanel;
    }

    private DoubleField makeRunLengthField() {
        final DoubleField doubleField = new DoubleField();
        doubleField.setValue(options.getRunLength());
        doubleField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                options.setRunLength(doubleField.getValue());
                OptionsStep.this.updateWizard();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                options.setRunLength(doubleField.getValue());
                OptionsStep.this.updateWizard();
            }
        });
        return doubleField;
    }

    private DoubleField makeTransientResetField() {
        final DoubleField doubleField = new DoubleField();
        doubleField.setValue(options.getTransientResetTime());
        doubleField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                options.setTransientResetTime(doubleField.getValue());
                OptionsStep.this.updateWizard();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                options.setTransientResetTime(doubleField.getValue());
                OptionsStep.this.updateWizard();
            }
        });
        return doubleField;
    }

    private LongField makeZenoThresholdField() {
        final LongField longField = new LongField();
        longField.setValue(options.getZenoThreshold());
        longField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                long l = longField.getValue();
                try {
                    options.setZenoThreshold(l);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    options.setZenoThreshold(1L);
                }
                OptionsStep.this.updateWizard();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                long l = longField.getValue();
                try {
                    options.setZenoThreshold(l);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    options.setZenoThreshold(1L);
                }
                OptionsStep.this.updateWizard();
            }
        });
        return longField;
    }

    private JComponent makeGraphingOptions() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(ComponentFactory.makeBorder("Graphing"));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        JComponent jComponent = new JLabel("Average type");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        jComponent = new JLabel("Number of sample points");
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        JLabel jLabel = new JLabel("Moving average period (samples)");
        jComponent = jLabel;
        jLabel.setEnabled(options.isMovingAverage());
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        jComponent = new JLabel("Select measures to show during progress");
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        jComponent = this.makeAverageTypeSelect(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        this.samplePoints = this.makeSamplePointsField();
        jComponent = this.samplePoints;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        jComponent.setMinimumSize(this.FIELD_SIZE);
        jComponent.setPreferredSize(this.FIELD_SIZE);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        this.movingAveragePeriod = this.makeMovingAverageField();
        jComponent = this.movingAveragePeriod;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        jComponent.setMinimumSize(this.FIELD_SIZE);
        jComponent.setPreferredSize(this.FIELD_SIZE);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        jComponent = this.makeProgressMeasuresSelect();
        jComponent.setPreferredSize(this.LIST_SIZE);
        jComponent.setMinimumSize(this.LIST_SIZE);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        return jPanel;
    }

    private JComponent makeAverageTypeSelect(final JLabel jLabel) {
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        final JRadioButton jRadioButton = new JRadioButton("Moving average");
        JRadioButton jRadioButton2 = new JRadioButton("Running average");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                options.setMovingAverage(actionEvent.getSource() == jRadioButton);
                if (OptionsStep.this.movingAveragePeriod != null) {
                    OptionsStep.this.movingAveragePeriod.setEnabled(options.isMovingAverage());
                    jLabel.setEnabled(options.isMovingAverage());
                }
            }
        };
        jRadioButton.addActionListener(actionListener);
        jRadioButton2.addActionListener(actionListener);
        if (options.isMovingAverage()) {
            jRadioButton.setSelected(true);
        } else {
            jRadioButton2.setSelected(true);
        }
        jPanel.add(jRadioButton);
        jPanel.add(jRadioButton2);
        return jPanel;
    }

    private IntegerField makeMovingAverageField() {
        final IntegerField integerField = new IntegerField();
        integerField.setValue(options.getMovingAveragePeriod());
        integerField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                int n = integerField.getValue();
                options.setMovingAveragePeriod(n);
                OptionsStep.this.updateWizard();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                int n = integerField.getValue();
                options.setMovingAveragePeriod(n);
                OptionsStep.this.updateWizard();
            }
        });
        integerField.setEnabled(options.isMovingAverage());
        return integerField;
    }

    private IntegerField makeSamplePointsField() {
        final IntegerField integerField = new IntegerField();
        integerField.setValue(options.getNumberOfSamplePoints());
        integerField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                int n = integerField.getValue();
                options.setNumberOfSamplePoints(n);
                OptionsStep.this.updateWizard();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                int n = integerField.getValue();
                options.setNumberOfSamplePoints(n);
                OptionsStep.this.updateWizard();
            }
        });
        return integerField;
    }

    private JComponent makeProgressMeasuresSelect() {
        Object object;
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        this.pmList = new JList(defaultListModel);
        Iterator iterator = this.parent.getSimulation().getPerformanceMeasures().iterator();
        while (iterator.hasNext()) {
            object = (PerformanceMeasure)iterator.next();
            if (!(object instanceof ChartablePerformanceMeasure)) continue;
            defaultListModel.addElement(object.getName());
        }
        this.pmList.setSelectionMode(2);
        object = new int[defaultListModel.getSize()];
        int n = 0;
        while (n < defaultListModel.getSize()) {
            object[n] = (PerformanceMeasure)n;
            ++n;
        }
        this.pmList.setSelectedIndices((int[])object);
        return new JScrollPane(this.pmList);
    }

    Collection getProgressMeasureNames() {
        Object[] objectArray = this.pmList.getSelectedValues();
        Vector<Object> vector = new Vector<Object>();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                vector.add(objectArray[n]);
                ++n;
            }
        }
        return vector;
    }

    int getNumberOfRuns() {
        return this.batchOpts.isSingleRun() ? 1 : this.batchOpts.degreesOfFreedom() + 1;
    }

    int getDegreesOfFreedom() {
        return this.batchOpts.isSingleRun() ? 0 : this.batchOpts.degreesOfFreedom();
    }

    double getConfidenceLevel() {
        return this.batchOpts.confidenceLevel();
    }

    private boolean validate() {
        try {
            return this.runLength.getValue() > 0.0 && this.transientReset.getValue() >= 0.0 && this.transientReset.getValue() <= this.runLength.getValue() && this.zenoThreshold.getValue() > 0L && this.samplePoints.getValue() > this.movingAveragePeriod.getValue() && this.movingAveragePeriod.getValue() > 0 && this.batchOpts.valid();
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    Dimension getFieldSize() {
        return this.FIELD_SIZE;
    }

    private class BatchOpts
    extends JPanel {
        private final JRadioButton single;
        private final JRadioButton batched;
        private final JLabel dfLab;
        private final IntegerField df;
        private final JLabel clLab;
        private final DoubleField cl;
        private final DocumentListener listener = new DocumentListener(this){
            private final /* synthetic */ BatchOpts this$1;
            {
                this.this$1 = batchOpts;
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                BatchOpts.access$100(this.this$1).updateWizard();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                BatchOpts.access$100(this.this$1).updateWizard();
            }
        };

        BatchOpts() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            ButtonGroup buttonGroup = new ButtonGroup();
            ActionListener actionListener = new ActionListener(this){
                private final /* synthetic */ BatchOpts this$1;
                {
                    this.this$1 = batchOpts;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    BatchOpts.access$200(this.this$1);
                    BatchOpts.access$100(this.this$1).updateWizard();
                }
            };
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 0.0;
            this.single = new JRadioButton("Single run");
            this.single.addActionListener(actionListener);
            buttonGroup.add(this.single);
            gridBagLayout.setConstraints(this.single, gridBagConstraints);
            this.add(this.single);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            this.batched = new JRadioButton("Produce confidence intervals");
            this.batched.addActionListener(actionListener);
            buttonGroup.add(this.batched);
            gridBagLayout.setConstraints(this.batched, gridBagConstraints);
            this.add(this.batched);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            this.dfLab = new JLabel("Degrees of freedom");
            gridBagLayout.setConstraints(this.dfLab, gridBagConstraints);
            this.add(this.dfLab);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            this.clLab = new JLabel("Confidence level");
            gridBagLayout.setConstraints(this.clLab, gridBagConstraints);
            this.add(this.clLab);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 13;
            this.df = new IntegerField();
            this.df.setMinimumSize(OptionsStep.this.FIELD_SIZE);
            this.df.setPreferredSize(OptionsStep.this.FIELD_SIZE);
            gridBagLayout.setConstraints(this.df, gridBagConstraints);
            this.add(this.df);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            this.cl = new DoubleField();
            this.cl.setMinimumSize(OptionsStep.this.FIELD_SIZE);
            this.cl.setPreferredSize(OptionsStep.this.FIELD_SIZE);
            gridBagLayout.setConstraints(this.cl, gridBagConstraints);
            this.add(this.cl);
            this.setValues(defaultSingle, defaultDF, defaultCL);
            this.setEnabling();
            this.df.getDocument().addDocumentListener(this.listener);
            this.cl.getDocument().addDocumentListener(this.listener);
        }

        boolean isSingleRun() {
            return defaultSingle = this.single.isSelected();
        }

        int degreesOfFreedom() {
            return defaultDF = this.df.getValue();
        }

        double confidenceLevel() {
            return defaultCL = this.cl.getValue();
        }

        void setValues(boolean bl, int n, double d) {
            if (bl) {
                this.single.setSelected(true);
            } else {
                this.batched.setSelected(true);
            }
            this.df.setValue(n);
            this.cl.setValue(d);
        }

        boolean valid() {
            return this.isSingleRun() || this.degreesOfFreedom() > 0 && this.confidenceLevel() > 0.0 && this.confidenceLevel() < 1.0;
        }

        private void setEnabling() {
            boolean bl = !this.isSingleRun();
            this.df.setEnabled(bl);
            this.dfLab.setEnabled(bl);
            this.cl.setEnabled(bl);
            this.clLab.setEnabled(bl);
        }

        static /* synthetic */ OptionsStep access$100(BatchOpts batchOpts) {
            return batchOpts.OptionsStep.this;
        }

        static /* synthetic */ void access$200(BatchOpts batchOpts) {
            batchOpts.setEnabling();
        }
    }
}

