/*
 * Decompiled with CFR 0.152.
 */
package simulationplugin.ui;

import ic.doc.simulation.sim.Result;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import simulationplugin.ui.ActionCounterDisplayComponent;
import simulationplugin.ui.HistogramDisplayComponent;
import simulationplugin.ui.MeasureDisplayComponent;
import simulationplugin.ui.SimulationWindow;

public abstract class ResultDisplayComponent {
    private final Result[] results;
    private JPanel display;
    private CardLayout layout;
    public static final int ALL = -1;
    static /* synthetic */ Class class$ic$doc$simulation$sim$HistogramResult;
    static /* synthetic */ Class class$ic$doc$simulation$sim$MeasureResult;
    static /* synthetic */ Class class$ic$doc$simulation$sim$ActionCounterResult;

    protected ResultDisplayComponent(Result[] resultArray) {
        this.results = resultArray;
    }

    private final void makeDisplay() {
        if (this.display != null) {
            return;
        }
        this.layout = new CardLayout();
        this.display = new JPanel(this.layout);
        this.display.add(this.makeDisplay(null, -1), Integer.toString(-1));
        int n = 0;
        while (n < this.results.length) {
            this.display.add(this.makeDisplay(this.results[n], n), Integer.toString(n));
            ++n;
        }
    }

    public final Result[] getResults() {
        return this.results;
    }

    public final void showResult(int n) {
        if (this.display == null) {
            this.makeDisplay();
        }
        this.layout.show(this.display, Integer.toString(n));
    }

    protected abstract Component makeDisplay(Result var1, int var2);

    public final JComponent getComponent() {
        if (this.display == null) {
            this.makeDisplay();
        }
        return this.display;
    }

    public static ResultDisplayComponent make(Result[] resultArray, SimulationWindow simulationWindow) {
        Class<?> clazz;
        boolean bl = simulationWindow.getSimulation().getOptions().isMovingAverage();
        int n = simulationWindow.getSimulation().getOptions().getMovingAveragePeriod();
        double d = simulationWindow.getOptionsStep().getConfidenceLevel();
        double d2 = simulationWindow.getSimulationOptions().getTransientResetTime();
        if ((class$ic$doc$simulation$sim$HistogramResult == null ? (class$ic$doc$simulation$sim$HistogramResult = ResultDisplayComponent.class$("ic.doc.simulation.sim.HistogramResult")) : class$ic$doc$simulation$sim$HistogramResult).isAssignableFrom(clazz = resultArray[0].getClass())) {
            return bl ? new HistogramDisplayComponent(resultArray, d, d2, n) : new HistogramDisplayComponent(resultArray, d, d2);
        }
        if ((class$ic$doc$simulation$sim$MeasureResult == null ? (class$ic$doc$simulation$sim$MeasureResult = ResultDisplayComponent.class$("ic.doc.simulation.sim.MeasureResult")) : class$ic$doc$simulation$sim$MeasureResult).isAssignableFrom(clazz)) {
            return bl ? new MeasureDisplayComponent(resultArray, d, d2, n) : new MeasureDisplayComponent(resultArray, d, d2);
        }
        if ((class$ic$doc$simulation$sim$ActionCounterResult == null ? (class$ic$doc$simulation$sim$ActionCounterResult = ResultDisplayComponent.class$("ic.doc.simulation.sim.ActionCounterResult")) : class$ic$doc$simulation$sim$ActionCounterResult).isAssignableFrom(clazz)) {
            return new ActionCounterDisplayComponent(resultArray, simulationWindow.isBigFont());
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

