/*
 * Decompiled with CFR 0.152.
 */
package simulationplugin.ui;

import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.StochasticAutomata;
import ic.doc.simulation.sim.IntegrityCheck;
import ic.doc.simulation.sim.Simulation;
import ic.doc.simulation.sim.SimulationException;
import ic.doc.simulation.sim.SimulationOptions;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import simulationplugin.SimulationPlugin;
import simulationplugin.ui.MultiStepWizard;
import simulationplugin.ui.OptionsStep;
import simulationplugin.ui.ResultStep;
import simulationplugin.ui.SimulationStep;
import simulationplugin.ui.WizardEventListener;

public class SimulationWindow
extends JComponent
implements WizardEventListener {
    public static final Font SMALL_FONT = new Font("Monospaced", 0, 12);
    public static final Font BIG_FONT = new Font("Monospaced", 0, 18);
    private boolean reset = false;
    private boolean bigfont = false;
    private SimulationPlugin parent;
    private MultiStepWizard wizard;
    private JPanel empty;
    private StochasticAutomata aut;
    private LTSOutput output;
    private OptionsStep optionsStep;
    private SimulationStep simStep;
    private ResultStep resultStep;
    private Hashtable savedFonts = null;
    private SimulationOptions simOptions;
    private Simulation sim;
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(0, 5, 0, 0);

    public SimulationWindow(StochasticAutomata stochasticAutomata, LTSOutput lTSOutput, SimulationPlugin simulationPlugin) {
        this.aut = stochasticAutomata;
        this.output = lTSOutput;
        this.parent = simulationPlugin;
        this.setLayout(new GridLayout());
        this.updateDisplay();
    }

    public void reset() {
        this.reset = true;
        this.simStep.abort();
        this.parent.selected();
    }

    private void replace(Hashtable hashtable, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(stringArray[n], UIManager.getFont(stringArray[n]));
            UIManager.put(stringArray[n], BIG_FONT);
            ++n;
        }
    }

    private void restore() {
        if (this.savedFonts != null) {
            Enumeration enumeration = this.savedFonts.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                UIManager.put(k, this.savedFonts.get(k));
            }
        }
        this.savedFonts = null;
    }

    public void updateDisplay() {
        if (!this.reset && this.wizard != null && this.wizard.isActive()) {
            return;
        }
        this.reset = false;
        this.removeAll();
        this.restore();
        if (this.bigfont) {
            this.savedFonts = new Hashtable();
            this.replace(this.savedFonts, new String[]{"TitledBorder.font", "Label.font", "List.font", "Button.font", "TextField.font", "RadioButton.font", "ProgressBar.font", "Table.font", "TableHeader.font"});
        }
        if (this.aut == null) {
            String string = new String("To run a simulation, you must have an extended system loaded and compiled.\nThis means your system needs to have at least one clock to delay a transition. To make a simulation useful, you need to have at least one measure.\nIf you compile the system without composing, the simulation occurs \"on the fly\". If you compose the system beforehand, the composed system is directly simulated. You should find that the former is much slower than the latter.");
            JTextArea jTextArea = new JTextArea(string);
            jTextArea.setEditable(false);
            jTextArea.setFont(this.bigfont ? BIG_FONT : SMALL_FONT);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setBorder(this.createBorder());
            JScrollPane jScrollPane = new JScrollPane(jTextArea, 21, 31);
            this.add(jScrollPane);
        } else {
            this.checkIntegrity(this.aut);
            this.sim = new Simulation(this.aut, this.output);
            this.simStep = new SimulationStep(this);
            this.optionsStep = new OptionsStep(this);
            this.resultStep = new ResultStep(this);
            this.wizard = new MultiStepWizard(this);
            this.wizard.addStep(this.optionsStep);
            this.wizard.addStep(this.simStep);
            this.wizard.addStep(this.resultStep);
            this.wizard.addWizardEventListener(this);
            this.wizard.setBorder(this.createBorder());
            this.setBorder(BorderFactory.createEtchedBorder());
            this.add(this.wizard);
        }
        this.repaint();
    }

    public void updateStochasticAutomata(StochasticAutomata stochasticAutomata) {
        boolean bl;
        boolean bl2 = bl = this.aut != stochasticAutomata;
        if (bl) {
            this.aut = this.checkSimulationAbility(stochasticAutomata) ? stochasticAutomata : null;
        }
        if (this.reset || bl || this.wizard == null || !this.wizard.isActive()) {
            this.updateDisplay();
        }
    }

    public void wizardCompleted() {
        this.updateDisplay();
    }

    private void checkIntegrity(StochasticAutomata stochasticAutomata) {
        IntegrityCheck integrityCheck = new IntegrityCheck(stochasticAutomata);
        if (integrityCheck.violationFound()) {
            Map map = integrityCheck.getViolations();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Integrity violations found!\n\n");
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append("Performance measure ");
                stringBuffer.append(string);
                stringBuffer.append(" has freely occuring event '");
                stringBuffer.append((String)map.get(string));
                stringBuffer.append("'\n");
            }
            this.output.out(stringBuffer.toString());
            throw new SimulationException(404);
        }
    }

    OptionsStep getOptionsStep() {
        return this.optionsStep;
    }

    SimulationStep getSimulationStep() {
        return this.simStep;
    }

    ResultStep getResultStep() {
        return this.resultStep;
    }

    SimulationOptions getSimulationOptions() {
        return this.simOptions;
    }

    void setSimulationOptions(SimulationOptions simulationOptions) {
        this.simOptions = simulationOptions;
    }

    Simulation getSimulation() {
        return this.sim;
    }

    Border createBorder() {
        return EMPTY_BORDER;
    }

    StochasticAutomata getStochasticAutomata() {
        return this.aut;
    }

    LTSOutput getLTSOutput() {
        return this.output;
    }

    private boolean checkSimulationAbility(StochasticAutomata stochasticAutomata) {
        return stochasticAutomata != null && stochasticAutomata.getMaxClockIdentifier() >= 0 && stochasticAutomata.getMeasureNames() != null;
    }

    public void setBigFont(boolean bl) {
        this.bigfont = bl;
    }

    public boolean isBigFont() {
        return this.bigfont;
    }
}

