/*
 * Decompiled with CFR 0.152.
 */
package webplugin;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import webplugin.Action;
import webplugin.Fluent;
import webplugin.FluentDec;
import webplugin.Role;

class FluentContainer {
    private static final int s_port = 1235;
    private static FluentContainer s_instance = new FluentContainer();
    private Set o_fluents = new HashSet();
    private Set o_actions = new HashSet();
    private Set o_roles = new HashSet();
    private Set o_controlled = new HashSet();
    private Map o_cache = new HashMap();
    private Map o_session = new HashMap();

    private FluentContainer() {
    }

    public static FluentContainer getInstance() {
        return s_instance;
    }

    Map getSession() {
        return this.o_session;
    }

    void add(Role p_role) {
        this.o_roles.add(p_role);
        List x_fluentdecs = p_role.getFluentDecs();
        Iterator i = x_fluentdecs.iterator();
        while (i.hasNext()) {
            this.o_fluents.add(((FluentDec)i.next()).newInstance());
        }
        List x_acts = p_role.getControlledActions();
        Iterator i2 = x_acts.iterator();
        while (i2.hasNext()) {
            this.o_controlled.add(i2.next());
        }
    }

    Role getRole(String p_name) {
        for (Role x_role : this.o_roles) {
            if (!x_role.getName().equals(p_name)) continue;
            return x_role;
        }
        return null;
    }

    Set getRoles() {
        return this.o_roles;
    }

    void add(Fluent p_fl) {
        this.o_fluents.add(p_fl);
    }

    void removeAllFluents() {
        this.o_fluents.clear();
    }

    void add(Action p_act) {
        System.out.println("Adding action to fluentcontainer : " + p_act.getName());
        this.o_actions.add(p_act);
    }

    void removeAllActions() {
        this.o_actions.clear();
    }

    void removeAllRoles() {
        this.o_roles.clear();
    }

    void clearSession() {
        this.o_session.clear();
    }

    Fluent getFluent(String p_name) {
        for (Fluent x_fluent : this.o_fluents) {
            if (!x_fluent.getName().equals(p_name)) continue;
            return x_fluent;
        }
        return null;
    }

    Action getAction(String p_act) {
        for (Action x_action : this.o_actions) {
            if (!x_action.getName().equals(p_act)) continue;
            System.out.println("Retrieving action from fluentcontainer : " + p_act);
            return x_action;
        }
        return null;
    }

    Set getAllControlledActions() {
        return this.o_controlled;
    }

    void update(String p_event) {
        Iterator i = this.o_fluents.iterator();
        while (i.hasNext()) {
            ((Fluent)i.next()).update(p_event);
        }
    }

    Object checkCache(Object p_key) {
        return this.o_cache.get(p_key);
    }

    void updateCache(Object p_key, Object p_val) {
        this.o_cache.put(p_key, p_val);
    }

    String getBaseURL(String p_role) {
        try {
            return "http://" + InetAddress.getLocalHost().getHostAddress() + ":" + 1235 + "?role=" + p_role;
        }
        catch (Exception p_e) {
            System.err.println(p_e);
            return "";
        }
    }
}

