/*
 * Decompiled with CFR 0.152.
 */
package Pandora.Help;

import Pandora.LogicParser.Formula.Exists;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Or;
import Pandora.NDRules.NDRule;

public class HelpMessages {
    public NDRule rule;
    public Formula formula;
    public String and_elimination;
    public String and_elimination_input_right;
    public String and_elimination_input_left;
    public String or_elimination_forwards;
    public String or_introduction_forwards_input_right;
    public String or_introduction_forwards_input_left;
    public String thereexists_introduction_backwards;
    public String thereexists_introduction_backwards_no_constants;
    public String thereexists_introduction_forwards_input;
    public String forall_elimination_backwards_input;
    public String forall_elimination_backwards_specify;
    public String forall_elimination_backwards_specify_input;
    public String forall_elimination_forwards;
    public static final String tm = "TrustMe rule:\n\nForwards:\n1. Select an empty line and click TM\n2. You may now select the lines that you have used for\nthe justification of inserting a new formula\n3. Type the formula you would like to add to the proof\n\nBackwards:\n1. Select a goal line and click TM\n2. You may now select the lines that you have used for\nthe justification of inserting a new goal\n3. Type the formula you would like to add to the proof\nas the new goal, the formula will then appear along with\nthe line numbers which were used as justification.";
    public static final String tm_backwards = "TrustMe rule:\n\nYou are using this rule backwards:\n1. You may now select the lines that you have used for\nthe justification of inserting a new goal\n2. Type the formula you would like to add to the proof\nas the new goal, the formula will then appear along with\nthe line numbers which were used as justification.\n\nFor other uses click the help button";
    public static final String tm_forwards = "TrustMe rule:\n\nYou are using this rule forwards:\n1. You may now select the lines that you have used for\nthe justification of inserting a new formula\n2. Type the formula you would like to add to the proof";
    public static final String tm_tick = "TrustMe-Tick rule:\n\nForwards:\nTM-Tick cannot be applied forwards\n\nBackwards:\n1. Select a goal line and click TM\u221a\n2. You may now select the lines of the proof that you\nhave used to justify or deduce that the goal line selected\nin step 1 follows on from the last proof line above it.\n3. The proof step and it's corresponding sub-proofs are\ncompleted, i.e. the empty line is removed and \"something\"\nwill turn green.";
    public static final String tm_tick_backwards = "TrustMe-Tick rule:\n\n1. You may now select the lines of the proof that you\nhave used to justify or deduce that the goal line selected\nin step 1 follows on from the last proof line above it.\n2. The proof step and it's corresponding sub-proofs are\ncompleted, i.e. the empty line is removed and \"something\"\nwill turn green.";
    public static final String or_introduction_backwards = "Since you have a disjunction as a goal, you can\nassume that one of the sides is true and therefore\nuse it as your new goal, pressing either left or\nright will display the corresponding formula as\nyour new goal.";
    public static final String or_introduction_forwards = "On which side of the disjunction should the current\ngoal appear?\n__________________________________________\n\nIn effect, you are specifying the formula from which\nyour current goal can be derived by \u2228 introduction.\nThis step is not often used, refer to the heuristics.\n\n";
    public static final String implies_introduction_forwards = "Input the conclusion you would like to be derived by Arrow Introduction Forwards\n__________________________________________________________________________________\n\nHint: If you want to use this rule to derive x \u2192 y (the formula you are asked\nto input in this screen) you will have to complete the proof from x to y.\n\n";
    public static final String not_introduction = "Input the conclusion you would like to be derived by Not Introduction Forwards\n________________________________________________________________________________\n\nHint: If you want to use this rule to derive \u00acx (the formula you are asked\nto input in this screen) you will have to complete the proof from x to \u22a5.\n\n";
    public static final String falsity_elimination_forwards = "Input the formula you would like to introduce\n___________________________________\n\nHint: Since falsity implies anything you may\ninput whatever formula you want provided it is\nin the signature of your proof\n\n";
    public static final String iff_introduction = "Input the conclusion you would like to be derived by IFF Introduction Forwards\n_________________________________________________________________________________\n\nHint: If you want to use this rule to derive x \u2194 y (the formula you are asked\nto input in this screen) you will have to complete the proof from x to y\n\n";
    public static final String pc = "Input the conclusion you would like to be derived by PC Introduction Forwards\n________________________________________________________________________________\n\nHint: If you want to use this rule to derive x (the formula you are asked\nto input in this screen) you will have to complete the proof from \u00acx to \u22a5.\n\n";
    public static final String em = "Input the formula you wish to apply the law on\n____________________________________\n\nHint: p results in p \u2228 \u00acp and \n        \u00acp results in \u00acp \u2228 p \n\n";
    public static final String reflexivity_forwards = "Input the term you would like to apply reflexivity to\n_____________________________________________________\n\nHint: Provided a constant exists in your signature,\napplying reflexivity to it will produce a new goal\nline of the form a = a or with function symbols such\nas P(a) = P(a)\n\n";
    public static final String reflexivity_forwards_no_constants = "Input the term you would like to apply reflexivity to\n_____________________________________________________\n\nHint: Provided a constant exists in your signature,\napplying reflexivity to it will produce a new goal\nline of the form a = a or with function symbols such\nas P(a) = P(a)\n\nIt appears that you do not have a constant in your\nsignature, to add a constant click on the Options\nmenu > add to signature > constants\n\nAt the top of the rules pane a text field will appear\nin which you can add a constant of your choice\n\n";
    public static final String lemma_forwards_backwards = "Enter the formula you would like to add as a lemma\n_______________________________________\n\nHint: A new goal (which you need to specify in this\nscreen) and an empty line will appear in the middle\nof your proof as a lemma which you need to prove\n\n";
    public static final String forall_introduction_forwards = "Input the Formula you'd like to be derived by For All Introduction Forwards\n___________________________________________________________________________\n\nHint: if you REALLY want to use this rule to derive \u2200x(P(x)) (the formula\nyou are asked to input in this screen) you will have to complete the proof\nfrom sk1 to P(sk1)\n\n";
    public static final String thereexists_introduction_forwards_optional = "(Optionally) input the There Exists formula you'd like to introduce\n_____________________________________________________________\n\nHint: if you have P(a,b) for example, you can deduce \u2203u(P(u,b)) or even\n\u2203u\u2203v(P(u,v)) for more help see the manual entry, for simple cases with one\nvariable click ok to skip to the next screen\n\n";
    public static final String thereexists_introduction_forwards_specify = "Specify the term to substitute the new Exists variable for\n___________________________________________\n\nHint: The term which you select in this screen must be in\nthe formula you selected and must be unbounded, the\nformula you selected will then be nested inside a \u2203\nformula, in the next screen you will need to specify\nthe name of the variable of the \u2203 formula\n\n";
    public static final String thereexists_introduction_forwards_specify_input = "Input the name of the new Exists variable\n______________________________\n\nHint: Entering z will display a \u2203z formula and\nall instances of the term you selected in\nthe previous screen will be replaced by the\nnew variable\n\n";
    public static final String thereexist_elimination_forwards = "Input the conclusion you'd like to be derived by There Exists Elimination Forwards\n____________________________________________________________________________________\n\nHint: If you want to use this rule to derive \u2203x(P(x)) (the formula you are asked\nto input in this screen) you will have to complete the proof from P(sk1) to \u2203x(P(x))\n\n";
    public static final String forall_elimination_backwards_optional = "(Optionally) input the For All formula you'd like to appear as the new goal\n_____________________________________________________________________________\n\nHint: if you have P(a,b) for example, you can deduce \u2200u(P(u,b)) or even\n\u2200u\u2200v(P(u,v)) for more help see the manual entry, for simple cases with\none variable click ok to skip to the next screen\n\n";
    public static final String and = "For example P \u2227 Q.";
    public static final String or = "For example P \u2228 Q";
    public static final String arrow = "For example P \u2192 Q.";
    public static final String iff = "For example P \u2194 Q.";
    public static final String falsity = "For example \u22a5";
    public static final String truth = "For example \u22a4";
    public static final String not = "For example P and \u00acP";
    public static final String notElim_backwards = "A goal \u22a5 could be derived from previous goal (Eg X) using \u00acE, \n if \u00acX had already been given or derived. \u00acE backwards \nallows you to select back a previous derived or given formula \n\u00acX and generates X as the new goal.";
    public static final String notnot = "For example \u00ac\u00acP.";
    public static final String thereExists = "For example \u2203P.";
    public static final String subs_forwards = "For equality susbstition forwards two equations need to be selected.\nThe first of the equations needs to be an equality, say s1=s2. When\nsubstituting the first equation into the second you will be given an\noption to replace all occurences of s1 in the second equation by s2 \nor vice versa and you will also be given an option to replace only the\nyou require to be replaced.";
    public static final String subs_backwards = "For equality substitution backwards the goalline needs to be selected \nfirst then the equality say s1=s2, which is used to substitute the either\nthe occurences of s1 in the goal by s2 or vice versa. There will also be \nan option to replace all or enter the formula that must be the new goal,\nif there are multiple occurences of s1 or s2 in the goal.";
    public static final String foralltick_backwards = "Lets look at an example which would succeed when for all elimination\ntick (backwards) is used, \u2200x\u2200y(p(x,f(y))) <derived line> \nand p(a,f(b)) <goal line>, but it would not succeed if the derived \nline is \u2200x(p(x,f(x))) since x can't be unified to both a and b.";

    public HelpMessages(NDRule nDRule) {
        this.rule = nDRule;
        this.and_elimination = "On which side of the conjunction should " + this.displayFormula() + " appear\n" + "___________________________________________________\n\n" + "In effect, you are specifying the formula from which\n" + "your current goal can be derived by \u2227 elimination.\n" + "This step is not often used, refer to the heuristics.\n\n";
        this.forall_elimination_backwards_input = "Input the name of the new Exists variable\n_________________________________________\n\nHint:\n\n" + this.displayFormula() + "\n\n will now be nested inside a \u2200 formula,\n" + "in this screen you need to specify the name of the\n" + "variable of the \u2200 formula, for example entering z\n" + "will display\n\n\u2200z(" + this.displayFormula() + ")\n\n";
        this.forall_elimination_backwards_specify = "Specify the term to substitute the new Exists variable for\n___________________________________________________________\n\nHint: The term which you select in this screen must be\nin the formula:\n\n" + this.displayFormula() + "\n\nmust be unbounded, the formula you selected will then\n" + "be nested inside a \u2200 formula, in the next screen you will\n" + "need to specify the name of the variable of the \u2200 formula\n\n";
        this.forall_elimination_backwards_specify_input = "Input the name of the new Exists variable\n___________________________________\n\nHint: Entering z will display a \u2200z formula and\nall instances of the term you selected in\nthe previous screen will be replaced by the\nnew variable\n\n";
    }

    public HelpMessages(Formula formula) {
        this.formula = formula;
        this.and_elimination_input_right = "Input the formula you would like to appear on the other side of the conjunction\n__________________________________________________________________________________\n\nFor example, provided it is in your signature, inputting \"P(a)\" will return:\nP(a) \u2227 " + this.displayFormula(formula) + "\n\n";
        this.and_elimination_input_left = "Input the formula you would like to appear on the other side of the conjunction\n__________________________________________________________________________________\n\nFor example, provided it is in your signature, inputting \"P(a)\" will return:\n" + this.displayFormula(formula) + " \u2227 P(a)\n\n";
        this.or_introduction_forwards_input_right = "Input the formula you would like to appear on the other side of the disjunction\n___________________________________________________________________\n\nFor example, provided it is in your signature, inputting \"P(a)\" will return:\nP(a) \u2228 " + this.displayFormula(formula) + "\n\n";
        this.or_introduction_forwards_input_left = "Input the formula you would like to appear on the other side of the disjunction\n__________________________________________________________________________________\n\nFor example, provided it is in your signature, inputting \"P(a)\" will return:\n" + this.displayFormula(formula) + " \u2228 P(a)\n\n";
        if (formula instanceof Or) {
            this.or_elimination_forwards = "Input the conclusion you would like to be derived by Or Elimination Forwards\n______________________________________________________________________________\n\nHint: To derive a goal G by \u2228 elimination using " + this.displayFormula(formula) + " means to\n" + "derive G from " + this.displayFormula(formula.getLeft()) + " and G from " + this.displayFormula(formula.getRight()) + ", you now have to specify G.\n\n";
        }
        if (formula instanceof Exists) {
            Formula formula2 = (Exists)formula.regenerate();
            int n = this.count(formula2);
            if (n == 1) {
                formula2 = ((Exists)formula2).getFormula();
            } else {
                for (int i = n; i > 0; --i) {
                    formula2 = ((Exists)formula2).getFormula();
                }
            }
            this.thereexists_introduction_backwards = "\n_____________________________________________________________________\n\nHint: Provided a constant exists in your signature, applying \u2203I will\ngive a new goal line:\n\n" + this.displayFormula(formula2) + "\n\nin which the bound variable will be replaced by the constant you\n" + "input in this screen\n\n";
            this.thereexists_introduction_backwards_no_constants = "\n_____________________________________________________________________\n\nHint: Provided a constant exists in your signature, applying \u2203I will\ngive a new goal line:\n\n" + this.displayFormula(formula2) + "\n\nin which the bound variable will be replaced by the constant you\n" + "input in this screen\n\n" + "It appears that you do not have a constant in your\n" + "signature, to add a constant click on the Options\n" + "menu > add to signature > constants\n\n" + "At the top of the rules pane a text field will appear\n" + "in which you can add a constant of your choice\n\n";
        }
        this.thereexists_introduction_forwards_input = "Input the name of the new Exists variable\n________________________________\n\nHint: " + this.displayFormula(formula) + " will now be" + "nested inside a \u2203 formula, in this screen\n" + "you need to specify the name of the variable\n" + "of the \u2203 formula, for example entering z will\n" + "display \u2203z(" + this.displayFormula(formula) + ")\n\n";
        this.forall_elimination_forwards = "______________________________________________________________________\n\nHint: Provided a constant exists in your signature, if you want to\napply \u2200E, it will remove the \u2200 from:\n\n" + this.displayFormula(formula) + "\n\n" + "and replace the variable with the constant you specify in this screen\n\n";
    }

    private int count(Formula formula) {
        int n = 0;
        if (formula instanceof Exists) {
            Formula formula2 = ((Exists)formula).getFormula();
            ++n;
            n += this.count(formula2);
        }
        return n;
    }

    public String displayFormula() {
        return this.rule.firstLine.getFormula().display();
    }

    public String displayFormula(Formula formula) {
        return formula.display();
    }

    public Formula getFormula(NDRule nDRule) {
        return nDRule.firstLine.getFormula();
    }
}

