/*
 * Decompiled with CFR 0.152.
 */
package Pandora.LogicParser.Formula;

import Pandora.LogicParser.Formula.Atom;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Not;
import Pandora.LogicParser.Formula.Quantifier;
import Pandora.LogicParser.Formula.Term;
import Pandora.LogicParser.Formula.Var;
import Pandora.PanSignature;
import Pandora.View;
import java.util.List;

public class And
extends Formula {
    private Formula left;
    private Formula right;

    public And(Formula formula, Formula formula2) {
        this.left = formula;
        this.right = formula2;
        this.setAtoms();
        formula.setTuples(this.tuples);
        formula2.setTuples(this.tuples);
    }

    @Override
    public void setAtoms() {
        if (this.left instanceof Atom) {
            this.atoms.add((Atom)this.left);
        } else {
            this.atoms.addAll(this.left.getAtoms());
        }
        if (this.right instanceof Atom) {
            this.atoms.add((Atom)this.right);
        } else {
            this.atoms.addAll(this.right.getAtoms());
        }
    }

    @Override
    public Formula getLeft() {
        return this.left;
    }

    @Override
    public Formula getRight() {
        return this.right;
    }

    @Override
    public String display() {
        String string = this.left.display();
        String string2 = this.right.display();
        if (!View.showBrackets) {
            if (this.higher(this.left)) {
                string = "(" + this.left.display() + ")";
            }
            if (this.higher(this.right)) {
                string2 = "(" + this.right.display() + ")";
            }
        } else {
            string = this.left instanceof Atom || this.left instanceof Not ? this.left.display() : "(" + this.left.display() + ")";
            string2 = this.right instanceof Atom || this.right instanceof Not ? this.right.display() : "(" + this.right.display() + ")";
        }
        return string + " \u2227 " + string2;
    }

    @Override
    public boolean checkSub(Term term, Term term2, Formula formula) {
        boolean bl = false;
        if (formula instanceof And) {
            And and = (And)formula;
            boolean bl2 = this.left.checkSub(term, term2, and.getLeft());
            boolean bl3 = this.right.checkSub(term, term2, and.getRight());
            bl = bl2 && bl3;
        }
        return bl;
    }

    @Override
    public Formula subAll(Term term, Term term2) {
        Formula formula = this.left.subAll(term, term2);
        Formula formula2 = this.right.subAll(term, term2);
        return new And(formula, formula2);
    }

    @Override
    public void setVars(Var var) {
        Quantifier quantifier;
        this.left.setVars(var);
        this.right.setVars(var);
        this.newVars.add(var);
        if (this.left instanceof Quantifier) {
            quantifier = (Quantifier)this.left;
            quantifier.getVar().setVars(var);
        }
        if (this.right instanceof Quantifier) {
            quantifier = (Quantifier)this.right;
            quantifier.getVar().setVars(var);
        }
    }

    @Override
    public String clashes(PanSignature panSignature) {
        String string = this.left.clashes(panSignature);
        if (string.contains(this.error)) {
            return string;
        }
        string = this.right.clashes(panSignature);
        return string;
    }

    @Override
    public void addToSignature(PanSignature panSignature) {
        this.left.addToSignature(panSignature);
        this.right.addToSignature(panSignature);
    }

    @Override
    public List<Term> getTerms() {
        List<Term> list = this.left.getTerms();
        List<Term> list2 = this.right.getTerms();
        int n = list.size();
        list.addAll(n, list2);
        return this.concatNoDup(list);
    }

    @Override
    public Formula s() {
        Formula formula = this.left.s();
        Formula formula2 = this.right.s();
        return new And(formula, formula2);
    }

    @Override
    public Formula regenerate() {
        Formula formula = this.left.regenerate();
        Formula formula2 = this.right.regenerate();
        return new And(formula, formula2);
    }

    @Override
    public int getPrecedence() {
        return 3;
    }
}

