/*
 * Decompiled with CFR 0.152.
 */
package Pandora.LogicParser.Formula;

import Pandora.LogicParser.Formula.Equals;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Function;
import Pandora.LogicParser.Formula.Predicate;
import Pandora.LogicParser.Formula.SimpleTerm;
import Pandora.LogicParser.Formula.Term;
import Pandora.LogicParser.Formula.Var;
import Pandora.PanSignature;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Atom
extends Formula {
    private String name;

    public Atom(String string) {
        this.name = string;
        this.setAtoms();
    }

    public String getName() {
        return this.name;
    }

    public int getArity() {
        return 0;
    }

    @Override
    public String display() {
        return this.name;
    }

    @Override
    public void setAtoms() {
        this.atoms.add(this);
    }

    public boolean clashes(Atom atom) {
        return this.name.equals(atom.getName()) && this.getArity() != atom.getArity();
    }

    public boolean clashes(Term term) {
        return this.name.equals(term.getName());
    }

    @Override
    public String clashes(PanSignature panSignature) {
        Predicate predicate;
        String string = "";
        List<Atom> list = panSignature.getPredicates();
        List<SimpleTerm> list2 = panSignature.getConstants();
        List<Function> list3 = panSignature.getFunctions();
        List<Var> list4 = panSignature.getVariables();
        for (Atom serializable2 : list) {
            if (!this.clashes(serializable2)) continue;
            string = "\u2718Predicate " + this.name + "/" + this.getArity() + " clashes with previously declared predicate " + serializable2.getName() + "/" + serializable2.getArity();
            return string;
        }
        for (SimpleTerm simpleTerm : list2) {
            if (!this.clashes(simpleTerm)) continue;
            string = "\u2718Predicate " + this.name + "/" + this.getArity() + " clashes with previously declared constant " + simpleTerm.getName();
            return string;
        }
        for (Function function : list3) {
            if (!this.clashes(function)) continue;
            string = "\u2718Predicate " + this.name + "/" + this.getArity() + " clashes with previously declared function " + function.getName() + "/" + function.getArity();
            return string;
        }
        for (Var var : list4) {
            if (!this.clashes(var)) continue;
            string = "\u2718Predicate " + this.name + "/" + this.getArity() + " clashes with previously declared variable " + var.getName();
            return string;
        }
        if (!this.name.equals("") && !this.isIn(panSignature)) {
            list.add(this);
        }
        if (this instanceof Predicate && (predicate = (Predicate)this).getParams().get(0) != null) {
            for (Term term : predicate.getParams()) {
                string = term.clashes(panSignature);
                if (!string.contains(this.error)) continue;
                return string;
            }
        }
        return string;
    }

    public boolean equals(Atom atom) {
        return this.name.equals(atom.getName()) && this.getArity() == atom.getArity();
    }

    public boolean isIn(PanSignature panSignature) {
        List<Atom> list = panSignature.getPredicates();
        for (Atom atom : list) {
            if (!this.equals(atom)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkSub(Term term, Term term2, Formula formula) {
        boolean bl = false;
        if (formula instanceof Atom) {
            Atom atom = (Atom)formula;
            bl = this.equals(atom);
        }
        return bl;
    }

    @Override
    public Formula subAll(Term term, Term term2) {
        return new Atom(this.name);
    }

    @Override
    public void setVars(Var var) {
        this.newVars.add(var);
    }

    @Override
    public void addToSignature(PanSignature panSignature) {
        if (!(this instanceof Equals) && !this.isIn(panSignature)) {
            panSignature.getPredicates().add(this);
        }
        if (this instanceof Predicate) {
            Predicate predicate = (Predicate)this;
            for (Term term : predicate.getParams()) {
                term.addToSignature(panSignature);
            }
        }
    }

    @Override
    public List<Term> getTerms() {
        List<Term> list = Collections.synchronizedList(new LinkedList());
        return list;
    }

    @Override
    public Formula s() {
        return new Atom(this.name);
    }

    @Override
    public Formula regenerate() {
        return new Atom(this.name);
    }

    @Override
    public int getPrecedence() {
        return 1;
    }
}

