/*
 * Decompiled with CFR 0.152.
 */
package Pandora.LogicParser.Formula;

import Pandora.LogicParser.Formula.Atom;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Quantifier;
import Pandora.LogicParser.Formula.Term;
import Pandora.LogicParser.Formula.Var;
import Pandora.PanSignature;

public class Forall
extends Quantifier {
    private Var var;
    private Formula formula;

    public Forall(Var var, Formula formula) {
        this.var = var;
        this.formula = formula;
        this.setAtoms();
        this.setVars(var);
        formula.setTuples(this.tuples);
    }

    @Override
    public Var getVar() {
        return this.var;
    }

    @Override
    public Formula getFormula() {
        return this.formula;
    }

    @Override
    public String display() {
        return "\u2200" + this.var.display() + "[" + this.formula.display() + "]";
    }

    @Override
    public void setAtoms() {
        if (this.formula instanceof Atom) {
            this.atoms.add((Atom)this.formula);
        } else {
            this.atoms.addAll(this.formula.getAtoms());
        }
    }

    @Override
    public void setVars(Var var) {
        if (!var.isInVars(this.newVars)) {
            this.newVars.add(var);
        }
        this.formula.setVars(var);
        if (this.formula instanceof Quantifier) {
            Quantifier quantifier = (Quantifier)this.formula;
            quantifier.getVar().setVars(var);
        }
    }

    @Override
    public boolean checkSub(Term term, Term term2, Formula formula) {
        if (!(formula instanceof Forall)) {
            return false;
        }
        Forall forall = (Forall)formula;
        if (!this.var.equals(forall.getVar())) {
            return false;
        }
        Formula formula2 = forall.getFormula();
        return this.formula.checkSub(term, term2, formula2);
    }

    @Override
    public Formula subAll(Term term, Term term2) {
        Formula formula = this.formula.subAll(term, term2);
        return new Forall(this.var, formula);
    }

    @Override
    public void addToSignature(PanSignature panSignature) {
        if (!this.var.isIn(panSignature)) {
            panSignature.getVariables().add(this.var);
        }
        this.formula.addToSignature(panSignature);
    }

    @Override
    public Formula s() {
        Formula formula = this.formula.s();
        return new Forall(this.var, formula);
    }

    @Override
    public Formula regenerate() {
        Formula formula = this.formula.regenerate();
        return new Forall(this.var, formula);
    }
}

