/*
 * Decompiled with CFR 0.152.
 */
package Pandora.LogicParser.Formula;

import Pandora.LogicParser.Formula.Atom;
import Pandora.LogicParser.Formula.Term;
import Pandora.LogicParser.Formula.Tuple;
import Pandora.LogicParser.Formula.Var;
import Pandora.PanSignature;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class Formula
implements Serializable {
    List<Atom> atoms = Collections.synchronizedList(new LinkedList());
    List<Var> newVars = Collections.synchronizedList(new LinkedList());
    List<Term> terms = Collections.synchronizedList(new LinkedList());
    String error = "\u2718";
    List<Tuple> tuples = new LinkedList<Tuple>();

    public Term map(Term term, List<Tuple> list) {
        for (Tuple tuple : list) {
            if (!term.equals(tuple.getFirst())) continue;
            return tuple.getSecond();
        }
        return null;
    }

    public abstract String display();

    public List<Atom> getAtoms() {
        return this.atoms;
    }

    public List<Var> getVars() {
        return this.newVars;
    }

    public abstract void setAtoms();

    public abstract void setVars(Var var1);

    public Formula sub(Term term, Term term2, Formula formula) throws Exception {
        if (formula == null) {
            return this.subAll(term, term2);
        }
        return this.check(term, term2, formula);
    }

    public Formula check(Term term, Term term2, Formula formula) throws Exception {
        if (this.checkSub(term, term2, formula)) {
            return formula;
        }
        throw new Exception("The formula you entered: " + formula.display() + "\ncannot be reached from the formula: " + this.display() + "\nby substituting occurrences of " + term.display() + " by occurrences of " + term2.display() + "!");
    }

    public abstract boolean checkSub(Term var1, Term var2, Formula var3);

    public abstract Formula subAll(Term var1, Term var2);

    public abstract String clashes(PanSignature var1);

    public abstract void addToSignature(PanSignature var1);

    public abstract List<Term> getTerms();

    public List<Term> concatNoDup(List<Term> list) {
        List<Term> list2 = Collections.synchronizedList(new LinkedList());
        for (Term term : list) {
            if (term.isIn(list2)) continue;
            list2.add(term);
        }
        return list2;
    }

    public void showTuples() {
        Iterator<Tuple> iterator = this.tuples.iterator();
        System.out.println(this.display() + " Tuples");
        while (iterator.hasNext()) {
            Tuple tuple = iterator.next();
            System.out.println("Tuple: ( " + tuple.getFirst().display() + ", " + tuple.getSecond().display() + " )");
        }
    }

    public void setTuples(List<Tuple> list) {
        this.tuples = list;
    }

    public List<Tuple> getTuples() {
        return this.tuples;
    }

    public abstract Formula regenerate();

    public abstract Formula s();

    public void setLeft(Formula formula) {
    }

    public void setRight(Formula formula) {
    }

    public Formula getLeft() {
        return null;
    }

    public Formula getRight() {
        return null;
    }

    public abstract int getPrecedence();

    public boolean higher(Formula formula) {
        return this.getPrecedence() < formula.getPrecedence();
    }

    public boolean isBracketed(String string) {
        return string.startsWith("(") && string.endsWith(")");
    }
}

