/*
 * Decompiled with CFR 0.152.
 */
package Pandora.LogicParser.Formula;

import Pandora.LogicParser.Formula.Atom;
import Pandora.LogicParser.Formula.SimpleTerm;
import Pandora.LogicParser.Formula.Term;
import Pandora.LogicParser.Formula.Var;
import Pandora.PanSignature;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class Function
extends Term {
    private String name;
    private Vector<Term> params;
    private int arity;

    public Function(String string, Vector<Term> vector) {
        this.name = string;
        this.params = vector;
        this.arity = vector.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getArity() {
        return this.arity;
    }

    public Vector<Term> getParams() {
        return this.params;
    }

    @Override
    public String display() {
        String string = this.name;
        if (this.arity != 0) {
            string = string + "(";
            for (Term term : this.params) {
                string = string + term.display() + ",";
            }
            char c = string.charAt(string.length() - 1);
            string = string.substring(0, string.length() - 1) + ")";
        }
        return string;
    }

    @Override
    public boolean equals(Term term) {
        return term instanceof Function && this.name.equals(((Function)term).getName()) && this.paramsEqual((Function)term);
    }

    public boolean paramsEqual(Function function) {
        Vector<Term> vector = function.getParams();
        if (this.arity != function.getArity()) {
            return false;
        }
        Iterator<Term> iterator = vector.iterator();
        for (Term term : this.params) {
            Term term2;
            if (term.equals(term2 = iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Term sub(Term term, Term term2) {
        if (this.equals(term)) {
            return term2;
        }
        Vector<Term> vector = new Vector<Term>();
        for (Term term3 : this.params) {
            Term term4 = term3.sub(term, term2);
            vector.add(term4);
        }
        return new Function(this.name, vector);
    }

    @Override
    public Function clone() {
        Vector<Term> vector = new Vector<Term>();
        Iterator<Term> iterator = this.params.iterator();
        while (iterator.hasNext()) {
            Term term = iterator.next().clone();
            vector.add(term);
        }
        return new Function(this.name, vector);
    }

    public boolean clashes(Atom atom) {
        return this.name.equals(atom.getName());
    }

    public boolean clashes(Term term) {
        if (term instanceof Function) {
            Function function = (Function)term;
            return this.name.equals(function.getName()) && this.arity != function.getArity();
        }
        return this.name.equals(term.getName());
    }

    @Override
    public String clashes(PanSignature panSignature) {
        List<Atom> list = panSignature.getPredicates();
        List<SimpleTerm> list2 = panSignature.getConstants();
        List<Function> list3 = panSignature.getFunctions();
        List<Var> list4 = panSignature.getVariables();
        String string = "";
        if (!this.isIn(panSignature)) {
            for (Atom serializable : list) {
                if (!this.clashes(serializable)) continue;
                string = "\u2718Function " + this.name + "/" + this.getArity() + " clashes with previously declared predicate " + serializable.getName() + "/" + serializable.getArity();
                return string;
            }
            for (SimpleTerm simpleTerm : list2) {
                if (!this.clashes(simpleTerm)) continue;
                string = "\u2718Function " + this.name + "/" + this.getArity() + " clashes with previously declared constant " + simpleTerm.getName();
                return string;
            }
            for (Var var : list4) {
                if (!this.clashes(var)) continue;
                string = "\u2718Function " + this.name + "/" + this.getArity() + " clashes with previously declared variable " + var.getName();
                return string;
            }
            for (Function function : list3) {
                if (!this.clashes(function)) continue;
                string = "\u2718Function " + this.name + "/" + this.getArity() + " clashes with previously declared function " + function.getName() + "/" + function.getArity();
                return string;
            }
            if (!this.isIn(panSignature)) {
                list3.add(this);
            }
        }
        Iterator<Serializable> iterator = this.params.iterator();
        if (this.params.get(0) != null) {
            while (iterator.hasNext()) {
                Term term = (Term)iterator.next();
                String string2 = term.clashes(panSignature);
                if (!string2.contains("\u2718")) continue;
                return string2;
            }
        }
        return string;
    }

    public boolean equivalent(Function function) {
        return this.name.equals(function.getName()) && this.getArity() == function.getArity();
    }

    @Override
    public boolean isIn(PanSignature panSignature) {
        List<Function> list = panSignature.getFunctions();
        for (Function function : list) {
            if (!this.equivalent(function)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setVars(Var var) {
        if (!var.isInVars(this.newVars)) {
            this.newVars.add(var);
        }
        for (Term term : this.params) {
            term.setVars(var);
        }
    }

    @Override
    public void addToSignature(PanSignature panSignature) {
        if (!this.isIn(panSignature)) {
            panSignature.getFunctions().add(this);
        }
        for (Term term : this.params) {
            term.addToSignature(panSignature);
        }
    }

    public List<Term> getTerms() {
        List<Term> list = Collections.synchronizedList(new LinkedList());
        for (Term term : this.params) {
            list.add(term);
            if (!(term instanceof Function)) continue;
            Function function = (Function)term;
            List<Term> list2 = function.getTerms();
            list.addAll(list2);
        }
        return this.concatNoDup(list);
    }
}

