/*
 * Decompiled with CFR 0.152.
 */
package Pandora.LogicParser.Formula;

import Pandora.LogicParser.Formula.Atom;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Function;
import Pandora.LogicParser.Formula.Term;
import Pandora.LogicParser.Formula.Tuple;
import Pandora.LogicParser.Formula.Var;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class Predicate
extends Atom {
    private String name;
    private Vector<Term> params;
    private int arity;
    private Term boundTerm;

    public Predicate(String string, Vector<Term> vector) {
        super(string);
        this.name = string;
        this.params = vector;
        this.arity = vector.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    public Vector<Term> getParams() {
        return this.params;
    }

    public void setParams(Vector<Term> vector) {
        this.params = vector;
    }

    @Override
    public String display() {
        String string = this.name;
        if (this.arity != 0) {
            string = string + "(";
            for (Term term : this.params) {
                string = string + term.display() + ",";
            }
            char c = string.charAt(string.length() - 1);
            string = string.substring(0, string.length() - 1) + ")";
        }
        return string;
    }

    public Predicate clone() {
        Vector<Term> vector = new Vector<Term>();
        Iterator<Term> iterator = this.params.iterator();
        while (iterator.hasNext()) {
            Term term = iterator.next().clone();
            vector.add(term);
        }
        return new Predicate(this.name, vector);
    }

    public boolean equals(Predicate predicate) {
        return this.name.equals(predicate.getName()) && this.arity == predicate.getArity();
    }

    @Override
    public boolean checkSub(Term term, Term term2, Formula formula) {
        boolean bl = true;
        if (formula instanceof Predicate && this.equals((Predicate)formula)) {
            Predicate predicate = (Predicate)formula;
            bl = term != null ? this.check2(term, term2, predicate) : this.subVar(predicate);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean check2(Term term, Term term2, Predicate predicate) {
        Iterator<Term> iterator = this.params.iterator();
        Iterator<Term> iterator2 = predicate.getParams().iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Term term3;
            Term term4;
            Term term5 = iterator.next();
            if (term5.equals(term4 = iterator2.next()) || term4.equals(term3 = term5.sub(term, term2))) continue;
            return false;
        }
        return true;
    }

    public boolean subVar(Predicate predicate) {
        Iterator<Term> iterator = this.params.iterator();
        Iterator<Term> iterator2 = predicate.getParams().iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Serializable serializable;
            Term term;
            Term term2 = iterator.next();
            if (term2.equals(term = iterator2.next())) continue;
            Term term3 = this.map(term, this.tuples);
            if (term3 != null) {
                if (term3.equals(term2)) continue;
                return false;
            }
            if (term.isInVars(predicate.getVars())) {
                serializable = new Tuple(term, term2);
                this.tuples.add(serializable);
                continue;
            }
            if (term2 instanceof Function && term instanceof Function) {
                serializable = (Function)term2;
                Function function = (Function)term;
                if (this.checkFunc((Function)serializable, function)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean checkFunc(Function function, Function function2) {
        if (!function.equivalent(function2)) {
            return false;
        }
        Iterator<Term> iterator = function.getParams().iterator();
        Iterator<Term> iterator2 = function2.getParams().iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Serializable serializable;
            Term term;
            Term term2 = iterator.next();
            if (term2.equals(term = iterator2.next())) continue;
            Term term3 = this.map(term, this.tuples);
            if (term3 != null) {
                if (term3.equals(term2)) continue;
                return false;
            }
            if (term.isInVars(function2.getVars())) {
                serializable = new Tuple(term, term2);
                this.tuples.add(serializable);
                continue;
            }
            if (term2 instanceof Function && term instanceof Function) {
                serializable = (Function)term2;
                Function function3 = (Function)term;
                if (this.checkFunc((Function)serializable, function3)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public Formula subAll(Term term, Term term2) {
        Vector<Term> vector = new Vector<Term>();
        for (Term term3 : this.params) {
            Term term4 = term3.sub(term, term2);
            vector.add(term4);
        }
        return new Predicate(this.name, vector);
    }

    @Override
    public void setVars(Var var) {
        if (!var.isInVars(this.newVars)) {
            this.newVars.add(var);
        }
        for (Term term : this.params) {
            term.setVars(var);
        }
    }

    @Override
    public List<Term> getTerms() {
        List<Term> list = Collections.synchronizedList(new LinkedList());
        for (Term term : this.params) {
            list.add(term);
            if (!(term instanceof Function)) continue;
            Function function = (Function)term;
            List<Term> list2 = function.getTerms();
            list.addAll(list2);
        }
        return this.concatNoDup(list);
    }

    @Override
    public Formula regenerate() {
        return new Predicate(this.name, this.params);
    }
}

