/*
 * Decompiled with CFR 0.152.
 */
package Pandora.LogicParser.Formula;

import Pandora.LogicParser.Formula.Atom;
import Pandora.LogicParser.Formula.Function;
import Pandora.LogicParser.Formula.SkTerm;
import Pandora.LogicParser.Formula.Term;
import Pandora.LogicParser.Formula.Var;
import Pandora.PanSignature;
import java.util.Iterator;
import java.util.List;

public class SimpleTerm
extends Term {
    private String name;

    public SimpleTerm(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Term sub(Term term, Term term2) {
        if (this.equals(term)) {
            return term2;
        }
        return this;
    }

    @Override
    public String display() {
        return this.name;
    }

    @Override
    public boolean equals(Term term) {
        return (term instanceof SimpleTerm || term instanceof SkTerm) && this.name.equals(term.getName()) || term instanceof Function && this.funcEquals(((Function)term).getVars());
    }

    private boolean funcEquals(List<Var> list) {
        Iterator<Var> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().getName();
            if (!this.name.equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIn(PanSignature panSignature) {
        List<SimpleTerm> list = panSignature.getConstants();
        for (SimpleTerm object2 : list) {
            if (!this.equals(object2)) continue;
            return true;
        }
        List<SimpleTerm> list2 = panSignature.getSkolems();
        for (SimpleTerm simpleTerm : list2) {
            if (!this.equals(simpleTerm)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SimpleTerm clone() {
        return new SimpleTerm(this.name);
    }

    public boolean clashes(Atom atom) {
        return this.name.equals(atom.getName());
    }

    public boolean clashes(Term term) {
        return this.name.equals(term.getName());
    }

    @Override
    public String clashes(PanSignature panSignature) {
        boolean bl = true;
        List<Atom> list = panSignature.getPredicates();
        List<SimpleTerm> list2 = panSignature.getConstants();
        List<Function> list3 = panSignature.getFunctions();
        List<Var> list4 = panSignature.getVariables();
        String string = "";
        System.out.println("checking " + this.display());
        for (SimpleTerm serializable : list2) {
            if (!this.name.equals(serializable.getName())) continue;
            return "";
        }
        for (Atom atom : list) {
            if (!this.clashes(atom)) continue;
            string = "\u2718Constant " + this.name + " clashes with previously declared predicate " + atom.getName() + "/" + atom.getArity();
            return string;
        }
        for (Function function : list3) {
            if (!this.clashes(function)) continue;
            string = "\u2718Constant " + this.name + " clashes with previously declared function " + function.getName() + "/" + function.getArity();
            return string;
        }
        for (Var var : list4) {
            if (!this.clashes(var)) continue;
            if (!var.isInVars(this.newVars)) {
                string = "\u2718Constant " + this.name + " clashes with previously declared variable " + var.getName();
                return string;
            }
            bl = false;
        }
        if (bl) {
            list2.add(this);
            System.out.println("added " + this.display());
        }
        return string;
    }

    @Override
    public void setVars(Var var) {
        this.newVars.add(var);
    }

    @Override
    public void addToSignature(PanSignature panSignature) {
        Var var;
        if (!this.isIn(panSignature) && !(var = new Var(this.name)).isIn(panSignature)) {
            panSignature.getConstants().add(this);
        }
    }
}

