/*
 * Decompiled with CFR 0.152.
 */
package Pandora.LogicParser.Formula;

import Pandora.LogicParser.Formula.SimpleTerm;
import Pandora.LogicParser.Formula.Term;
import Pandora.LogicParser.Formula.Var;
import Pandora.PanSignature;
import java.util.List;

public class SkTerm
extends Term {
    private String name;

    public SkTerm(String string) {
        this.name = string;
    }

    @Override
    public Term sub(Term term, Term term2) {
        return this;
    }

    @Override
    public boolean isIn(PanSignature panSignature) {
        return false;
    }

    @Override
    public String display() {
        return this.name;
    }

    @Override
    public Term clone() {
        return this;
    }

    @Override
    public String clashes(PanSignature panSignature) {
        if (this.name.contains("()")) {
            return "\u2718Reserved Word (" + this.name.substring(0, this.name.length() - 2) + ") !";
        }
        List<SimpleTerm> list = panSignature.getSkolems();
        if (!this.isInList(list)) {
            return "\u2718Reserved Word (" + this.name + ") !";
        }
        return "";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setVars(Var var) {
    }

    @Override
    public void addToSignature(PanSignature panSignature) {
    }

    public boolean isInList(List<SimpleTerm> list) {
        for (SimpleTerm simpleTerm : list) {
            if (!this.name.equals(simpleTerm.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Term term) {
        return (term instanceof SkTerm || term instanceof SimpleTerm) && this.name.equals(term.getName());
    }
}

