/*
 * Decompiled with CFR 0.152.
 */
package Pandora.LogicParser.Formula;

import Pandora.LogicParser.Formula.Atom;
import Pandora.LogicParser.Formula.Function;
import Pandora.LogicParser.Formula.SimpleTerm;
import Pandora.LogicParser.Formula.Term;
import Pandora.PanSignature;
import java.util.List;

public class Var
extends Term {
    private String name;

    public Var(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Term sub(Term term, Term term2) {
        if (this.equals(term)) {
            return term2;
        }
        return this;
    }

    @Override
    public String display() {
        return this.name;
    }

    @Override
    public boolean equals(Term term) {
        return term instanceof Var && this.name.equals(((Var)term).getName());
    }

    @Override
    public boolean isIn(PanSignature panSignature) {
        List<Var> list = panSignature.getVariables();
        for (Var var : list) {
            if (!this.equals(var)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setVars(Var var) {
        if (!var.isInVars(this.newVars)) {
            this.newVars.add(var);
        }
    }

    @Override
    public Var clone() {
        return new Var(this.name);
    }

    public boolean clashes(Atom atom) {
        return this.name.equals(atom.getName());
    }

    public boolean clashes(Term term) {
        return this.name.equals(term.getName());
    }

    @Override
    public String clashes(PanSignature panSignature) {
        String string = "\u2718";
        List<Atom> list = panSignature.getPredicates();
        List<SimpleTerm> list2 = panSignature.getConstants();
        List<Function> list3 = panSignature.getFunctions();
        List<Var> list4 = panSignature.getVariables();
        String string2 = "";
        for (Var serializable : list4) {
            if (!this.name.equals(serializable.getName())) continue;
            if (this.isInVars(this.newVars)) {
                return string + "Nested variables!";
            }
            System.out.println("not nested ");
            return "";
        }
        for (SimpleTerm simpleTerm : list2) {
            if (!this.clashes(simpleTerm)) continue;
            string2 = "\u2718Variable " + this.name + " clashes with previously declared Constant " + simpleTerm.getName();
            return string2;
        }
        for (Atom atom : list) {
            if (!this.clashes(atom)) continue;
            string2 = "\u2718Variable " + this.name + " clashes with previously declared predicate " + atom.getName() + "/" + atom.getArity();
            return string2;
        }
        for (Function function : list3) {
            if (!this.clashes(function)) continue;
            string2 = "\u2718Variable " + this.name + " clashes with previously declared function " + function.getName() + "/" + function.getArity();
            return string2;
        }
        list4.add(this);
        return string2;
    }

    @Override
    public void addToSignature(PanSignature panSignature) {
        if (!this.isIn(panSignature)) {
            panSignature.getVariables().add(this);
        }
    }
}

