/*
 * Decompiled with CFR 0.152.
 */
package Pandora;

import Pandora.LogicParser.Formula.Unknown;
import Pandora.NDRules.AndElim;
import Pandora.NDRules.AndIntro;
import Pandora.NDRules.EM;
import Pandora.NDRules.ExistsElim;
import Pandora.NDRules.ExistsIntro;
import Pandora.NDRules.FalsityElim;
import Pandora.NDRules.FalsityIntro;
import Pandora.NDRules.ForallArrowElim;
import Pandora.NDRules.ForallArrowIntro;
import Pandora.NDRules.ForallElim;
import Pandora.NDRules.ForallIntro;
import Pandora.NDRules.ForallTick;
import Pandora.NDRules.IffElim;
import Pandora.NDRules.IffElimDerived;
import Pandora.NDRules.IffIntro;
import Pandora.NDRules.IffIntroDerived;
import Pandora.NDRules.ImpliesElim;
import Pandora.NDRules.ImpliesIntro;
import Pandora.NDRules.Instantiate;
import Pandora.NDRules.Lemma;
import Pandora.NDRules.NDRule;
import Pandora.NDRules.NotElim;
import Pandora.NDRules.NotIntro;
import Pandora.NDRules.NotNot;
import Pandora.NDRules.OrElim;
import Pandora.NDRules.OrIntro;
import Pandora.NDRules.PC;
import Pandora.NDRules.Reflexivity;
import Pandora.NDRules.Substitution;
import Pandora.NDRules.TM;
import Pandora.NDRules.TMTick;
import Pandora.NDRules.Tick;
import Pandora.NDRules.TopIntro;
import Pandora.ProofBox;
import Pandora.ProofLine;

public class NDRuleController {
    private NDRule currentNDRule = null;
    private ProofLine firstLine = null;
    private ProofBox proof;

    public NDRuleController(String string, ProofLine proofLine, ProofBox proofBox) {
        this.firstLine = proofLine;
        this.proof = proofBox;
        this.createRule(string);
    }

    private void createRule(String string) {
        if (string.equals("\u2192E")) {
            this.currentNDRule = new ImpliesElim(this.proof);
        } else if (string.equals("\u2192I")) {
            this.currentNDRule = new ImpliesIntro(this.proof);
        } else if (string.equals("\u2227I")) {
            this.currentNDRule = new AndIntro(this.proof);
        } else if (string.equals("\u2227E")) {
            this.currentNDRule = new AndElim(this.proof);
        } else if (string.equals("\u221a")) {
            this.currentNDRule = new Tick(this.proof);
        } else if (string.equals("TM\u221a")) {
            this.currentNDRule = new TMTick(this.proof);
        } else if (string.equals("TM")) {
            this.currentNDRule = new TM(this.proof);
        } else if (string.equals("Lemma")) {
            this.currentNDRule = new Lemma(this.proof);
        } else if (string.equals("\u2228E")) {
            this.currentNDRule = new OrElim(this.proof);
        } else if (string.equals("\u2228I")) {
            this.currentNDRule = new OrIntro(this.proof);
        } else if (string.equals("\u2194I")) {
            this.currentNDRule = new IffIntro(this.proof);
        } else if (string.equals("\u2194E")) {
            this.currentNDRule = new IffElim(this.proof);
        } else if (string.equals("\u00acI")) {
            this.currentNDRule = new NotIntro(this.proof);
        } else if (string.equals("\u00acE")) {
            this.currentNDRule = new NotElim(this.proof);
        } else if (string.equals("PC")) {
            this.currentNDRule = new PC(this.proof);
        } else if (string.equals("\u00ac\u00ac")) {
            this.currentNDRule = new NotNot(this.proof);
        } else if (string.equals("\u22a5I")) {
            this.currentNDRule = new FalsityIntro(this.proof);
        } else if (string.equals("\u22a5E")) {
            this.currentNDRule = new FalsityElim(this.proof);
        } else if (string.equals("EM")) {
            this.currentNDRule = new EM(this.proof);
        } else if (string.equals("\u2194I2")) {
            this.currentNDRule = new IffIntroDerived(this.proof);
        } else if (string.equals("\u2194E2")) {
            this.currentNDRule = new IffElimDerived(this.proof);
        } else if (string.equals("Reflexivity")) {
            this.currentNDRule = new Reflexivity(this.proof);
        } else if (string.equals("=Sub")) {
            this.currentNDRule = new Substitution(this.proof);
        } else if (string.equals("\u2203I")) {
            this.currentNDRule = new ExistsIntro(this.proof);
        } else if (string.equals("\u2203E")) {
            this.currentNDRule = new ExistsElim(this.proof);
        } else if (string.equals("\u2200I")) {
            this.currentNDRule = new ForallIntro(this.proof);
        } else if (string.equals("\u2200E")) {
            this.currentNDRule = new ForallElim(this.proof);
        } else if (string.equals("\u2200E\u221a")) {
            this.currentNDRule = new ForallTick(this.proof);
        } else if (string.equals("\u2200\u2192E")) {
            this.currentNDRule = new ForallArrowElim(this.proof);
        } else if (string.equals("\u2200\u2192I")) {
            this.currentNDRule = new ForallArrowIntro(this.proof);
        } else if (string.equals("inst")) {
            this.currentNDRule = new Instantiate(this.proof);
        } else if (string.equals("\u22a4I")) {
            this.currentNDRule = new TopIntro(this.proof);
        }
    }

    public void initialise() throws Exception {
        this.currentNDRule.addInputLine(this.firstLine);
    }

    public boolean haveAll() {
        return this.currentNDRule.haveAll();
    }

    public void apply() throws Exception {
        this.currentNDRule.check();
        this.currentNDRule.apply();
    }

    public void addLine(ProofLine proofLine) throws Exception {
        if (!proofLine.getJustification().getSymbol().equals("")) {
            if (!(this.currentNDRule instanceof Tick)) {
                if (proofLine.getFormula() instanceof Unknown) {
                    throw new Exception("An unknown formula cannot be used in this rule, it must have been unified first.");
                }
                this.currentNDRule.addLine(proofLine);
            } else {
                this.currentNDRule.addLine(proofLine);
            }
        } else {
            throw new Exception("The empty line cannot be selected at this point.");
        }
    }
}

