/*
 * Decompiled with CFR 0.152.
 */
package Pandora.NDRules;

import Pandora.Help.ErrorMessages;
import Pandora.Help.HelpFrame;
import Pandora.Help.HelpMessages;
import Pandora.Justification;
import Pandora.LogicParser.Formula.And;
import Pandora.LogicParser.Formula.Formula;
import Pandora.NDRules.NDRule;
import Pandora.ProofBox;
import Pandora.ProofLine;
import Pandora.ProofWindow;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;

public class AndElim
extends NDRule {
    private ProofLine forwardLine = null;
    private Vector<Formula> formVec = new Vector();

    public AndElim(ProofBox proofBox) {
        super(proofBox);
    }

    @Override
    public void addLine(ProofLine proofLine) throws Exception {
        if (this.isForwards) {
            if (this.forwardLine != null) {
                this.proof.deselectAll();
                throw new Exception("The correct number of lines have already been selected for this method.");
            }
        } else {
            this.proof.deselectAll();
            throw new Exception("The correct number of lines have already been selected for this method.");
        }
        this.forwardLine = proofLine;
    }

    @Override
    public boolean haveAll() {
        return this.firstLine != null && (!this.isForwards || this.isForwards && this.forwardLine != null);
    }

    @Override
    public void check() throws Exception {
        Formula formula;
        if (this.isForwards && !((formula = this.forwardLine.getFormula()) instanceof And)) {
            this.proof.deselectAll();
            throw new Exception(ErrorMessages.and_forwards);
        }
    }

    @Override
    public void apply() throws Exception {
        if (this.isForwards) {
            this.applyForwards();
        } else {
            this.applyBackwards();
        }
    }

    private void applyBackwards() throws Exception {
        HelpMessages helpMessages = new HelpMessages(this.firstLine.getFormula());
        boolean bl = true;
        boolean bl2 = false;
        String string = "\u2227";
        String string2 = this.firstLine.getFormula().display();
        ProofWindow proofWindow = this.proof.getParentWindow();
        Object[] objectArray = new Object[]{"<html>Left<br>" + string2 + " " + string + " ?</html>", "<html>Right<br> ? " + string + " " + string2 + " </html>", "Help"};
        boolean bl3 = false;
        while (!bl3) {
            int n = JOptionPane.showOptionDialog(proofWindow.view, "On which side of the conjunction should " + string2 + " appear?", "Input Required", 1, 3, null, objectArray, objectArray[0]);
            if (n == 0) {
                bl = true;
                bl3 = true;
                continue;
            }
            if (n == 1) {
                bl = false;
                bl3 = true;
                continue;
            }
            if (n == 2) {
                HelpFrame.launch(helpMessages.and_elimination);
                continue;
            }
            bl2 = true;
            bl3 = true;
        }
        if (!bl2) {
            helpMessages = new HelpMessages(this.firstLine.getFormula());
            if (bl) {
                Formula formula = this.getNewFormula("", helpMessages.and_elimination_input_left);
                if (formula != null) {
                    this.actualApplyBackwards(formula, bl);
                }
            } else {
                Formula formula = this.getNewFormula("", helpMessages.and_elimination_input_right);
                if (formula != null) {
                    this.actualApplyBackwards(formula, bl);
                }
            }
        }
    }

    private int count(Formula formula) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (formula instanceof And) {
            Formula formula2 = ((And)formula).getLeft();
            Formula formula3 = ((And)formula).getRight();
            if (formula2 instanceof And) {
                n2 = this.count(formula2);
                ++n;
            }
            if (formula3 instanceof And) {
                n3 = this.count(formula3);
                ++n;
            }
            n += n2 + n3;
        }
        return n;
    }

    private void applyForwards() {
        int n;
        Object[] objectArray;
        ProofWindow proofWindow = this.proof.getParentWindow();
        int n2 = this.count(this.forwardLine.getFormula());
        boolean bl = false;
        if (n2 != 0) {
            objectArray = new Object[]{"Remove all at once", "Skip"};
            n = JOptionPane.showOptionDialog(proofWindow.view, "Do you wish to eliminate all conjunctions?", "Remove All", 0, 3, null, objectArray, objectArray[0]);
            if (n == 0) {
                this.breakdownAll(proofWindow, this.forwardLine.getFormula(), n2);
                if (!this.formVec.isEmpty()) {
                    Iterator<Formula> iterator = this.formVec.iterator();
                    while (iterator.hasNext()) {
                        this.breakdown(proofWindow, iterator.next(), 0);
                    }
                }
            } else if (n == 1) {
                bl = true;
            }
        }
        if (bl || n2 == 0) {
            objectArray = new Object[]{"<html><center>Left<br>" + this.forwardLine.getFormula().getLeft().display() + "</center></html>", "<html><center>Right<br>" + this.forwardLine.getFormula().getRight().display() + "</center></html>", "<html><center>Both<br>" + this.forwardLine.getFormula().getLeft().display() + " ,  " + this.forwardLine.getFormula().getRight().display() + "</center></html>"};
            n = JOptionPane.showOptionDialog(proofWindow.view, "Which side of the And Formula should be derived?", "Input Required", 1, 3, null, objectArray, objectArray[2]);
            if (n == 0) {
                this.breakdown(proofWindow, ((And)this.forwardLine.getFormula()).getLeft(), 0);
            } else if (n == 1) {
                this.breakdown(proofWindow, ((And)this.forwardLine.getFormula()).getRight(), 0);
            } else if (n == 2) {
                this.breakboth(proofWindow, this.forwardLine.getFormula());
            }
        }
    }

    private void breakdownAll(ProofWindow proofWindow, Formula formula, int n) {
        if (formula instanceof And) {
            this.breakdownAll(proofWindow, ((And)formula).getLeft(), n);
            this.breakdownAll(proofWindow, ((And)formula).getRight(), n);
        } else {
            this.formVec.add(formula);
        }
    }

    private void breakboth(ProofWindow proofWindow, Formula formula) {
        Formula formula2 = ((And)this.forwardLine.getFormula()).getLeft();
        Formula formula3 = ((And)this.forwardLine.getFormula()).getRight();
        List<ProofLine> list = Collections.synchronizedList(new LinkedList());
        list.add(this.forwardLine);
        Justification justification = new Justification("\u2227E", list);
        ProofLine proofLine = new ProofLine(formula2, justification, proofWindow, this.proof);
        ProofLine proofLine2 = new ProofLine(formula3, justification, proofWindow, this.proof);
        int n = this.proof.getIndex(this.firstLine);
        this.proof.addItem(n, proofLine2);
        this.proof.addItem(n, proofLine);
        proofWindow.commitSaveState();
    }

    private void breakdown(ProofWindow proofWindow, Formula formula, int n) {
        List<ProofLine> list = Collections.synchronizedList(new LinkedList());
        list.add(this.forwardLine);
        Justification justification = new Justification("\u2227E", list);
        ProofLine proofLine = new ProofLine(formula, justification, proofWindow, this.proof);
        int n2 = this.proof.getIndex(this.firstLine);
        this.proof.addItem(n2, proofLine);
        if (n == 0) {
            proofWindow.commitSaveState();
        }
    }

    private void actualApplyBackwards(Formula formula, boolean bl) {
        ProofWindow proofWindow = this.proof.getParentWindow();
        Formula formula2 = this.firstLine.getFormula();
        And and = bl ? new And(formula2, formula) : new And(formula, formula2);
        ProofLine proofLine = new ProofLine((Formula)and, "<goal>", proofWindow, this.proof);
        int n = this.proof.getIndex(this.firstLine);
        this.proof.addItem(n, proofLine);
        List<ProofLine> list = Collections.synchronizedList(new LinkedList());
        list.add(proofLine);
        Justification justification = new Justification("\u2227E", list);
        ProofLine proofLine2 = this.firstLine;
        proofLine2.setJustification(justification);
        proofWindow.commitSaveState();
    }
}

