/*
 * Decompiled with CFR 0.152.
 */
package Pandora.NDRules;

import Pandora.Help.ErrorMessages;
import Pandora.Justification;
import Pandora.LogicParser.Formula.And;
import Pandora.LogicParser.Formula.Formula;
import Pandora.NDRules.NDRule;
import Pandora.ProofBox;
import Pandora.ProofLine;
import Pandora.ProofWindow;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class AndIntro
extends NDRule {
    private ProofLine forwardLineLeft = null;
    private ProofLine forwardLineRight = null;

    public AndIntro(ProofBox proofBox) {
        super(proofBox);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void addLine(ProofLine proofLine) throws Exception {
        if (!this.isForwards) {
            this.proof.deselectAll();
            throw new Exception("The correct number of lines have already been selected for this method.");
        }
        if (this.forwardLineLeft == null) {
            this.forwardLineLeft = proofLine;
            return;
        }
        if (this.forwardLineRight == null) {
            this.forwardLineRight = proofLine;
            return;
        }
        this.proof.deselectAll();
        throw new Exception("The correct number of lines have already been selected for this method.");
    }

    @Override
    public boolean haveAll() {
        return this.firstLine != null && (!this.isForwards || this.isForwards && this.forwardLineLeft != null && this.forwardLineRight != null);
    }

    @Override
    public void check() throws Exception {
        if (this.haveAll() && !this.isForwards) {
            this.checkBackwards();
        }
    }

    private void checkBackwards() throws Exception {
        ProofLine proofLine = this.firstLine;
        Formula formula = proofLine.getFormula();
        if (!(formula instanceof And)) {
            this.proof.deselectAll();
            throw new Exception(ErrorMessages.and);
        }
    }

    @Override
    public void apply() throws Exception {
        if (this.isForwards) {
            this.applyForwards();
        } else {
            this.applyBackwards();
        }
    }

    private void applyBackwards() {
        ProofWindow proofWindow = this.proof.getParentWindow();
        Formula formula = ((And)this.firstLine.getFormula()).getLeft();
        Formula formula2 = ((And)this.firstLine.getFormula()).getRight();
        ProofBox proofBox = new ProofBox(proofWindow, this.proof);
        ProofLine proofLine = new ProofLine(null, "", proofWindow, proofBox);
        ProofLine proofLine2 = new ProofLine(formula, "<goal>", proofWindow, proofBox);
        proofBox.addItem(proofLine);
        proofBox.addItem(proofLine2);
        ProofBox proofBox2 = proofBox.setNextBox();
        ProofLine proofLine3 = new ProofLine(null, "", proofWindow, proofBox2);
        ProofLine proofLine4 = new ProofLine(formula2, "<goal>", proofWindow, proofBox2);
        proofBox2.addItem(proofLine3);
        proofBox2.addItem(proofLine4);
        proofBox.setDashedBox(true);
        proofBox2.setDashedBox(true);
        int n = this.proof.getIndex(this.firstLine);
        this.proof.addItem(n, proofBox);
        List<ProofLine> list = Collections.synchronizedList(new LinkedList());
        list.add(proofLine2);
        list.add(proofLine4);
        Justification justification = new Justification("\u2227I", list);
        this.firstLine.setJustification(justification);
        proofWindow.commitSaveState();
    }

    private void applyForwards() {
        int n;
        ProofWindow proofWindow = this.proof.getParentWindow();
        Formula formula = this.forwardLineLeft.getFormula();
        Formula formula2 = this.forwardLineRight.getFormula();
        And and = new And(formula, formula2);
        List<ProofLine> list = Collections.synchronizedList(new LinkedList());
        int n2 = this.forwardLineLeft.getLineNum();
        if (n2 > (n = this.forwardLineRight.getLineNum())) {
            list.add(this.forwardLineRight);
            list.add(this.forwardLineLeft);
        } else {
            list.add(this.forwardLineLeft);
            list.add(this.forwardLineRight);
        }
        Justification justification = new Justification("\u2227I", list);
        ProofLine proofLine = new ProofLine((Formula)and, justification, proofWindow, this.proof);
        int n3 = this.proof.getIndex(this.firstLine);
        this.proof.addItem(n3, proofLine);
        proofWindow.commitSaveState();
    }
}

