/*
 * Decompiled with CFR 0.152.
 */
package Pandora.NDRules;

import Pandora.Justification;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Not;
import Pandora.LogicParser.Formula.Or;
import Pandora.NDRules.NDRule;
import Pandora.ProofBox;
import Pandora.ProofLine;
import Pandora.ProofWindow;

public class EM
extends NDRule {
    public EM(ProofBox proofBox) {
        super(proofBox);
    }

    @Override
    public void addLine(ProofLine proofLine) throws Exception {
    }

    @Override
    public boolean haveAll() {
        return this.firstLine != null;
    }

    @Override
    public void check() throws Exception {
    }

    @Override
    public void apply() throws Exception {
        if (this.isForwards) {
            this.applyForwards();
        } else {
            this.applyBackwards();
        }
    }

    private void applyForwards() throws Exception {
        ProofWindow proofWindow = this.proof.getParentWindow();
        Formula formula = this.getNewFormula("", "Input the formula you wish to apply the law on\n____________________________________\n\nHint: p results in p \u2228 \u00acp and \n        \u00acp results in \u00acp \u2228 p \n\n");
        if (formula != null) {
            Or or = null;
            or = formula instanceof Not ? new Or(formula, this.removeNot(formula)) : new Or(formula, new Not(formula));
            ProofLine proofLine = new ProofLine((Formula)or, "EM", proofWindow, this.proof);
            int n = this.proof.getIndex(this.firstLine);
            this.proof.addItem(n, proofLine);
            proofWindow.commitSaveState();
        }
    }

    private Formula removeNot(Formula formula) {
        Formula formula2 = ((Not)formula).getFormula();
        return formula2;
    }

    private void applyBackwards() throws Exception {
        ProofWindow proofWindow = this.proof.getParentWindow();
        Formula formula = this.firstLine.getFormula();
        if (formula instanceof Or) {
            Formula formula2;
            Formula formula3 = ((Or)formula).getLeft();
            if (!EM.contradictory(formula3, formula2 = ((Or)formula).getRight())) {
                this.proof.deselectAll();
                throw new Exception("This rule can only be applied backwards on an Or formula (of the form p \u2228 \u00acp )");
            }
        } else {
            this.proof.deselectAll();
            throw new Exception("This rule can only be applied backwards on an Or formula (of the form p \u2228 \u00acp )");
        }
        Justification justification = new Justification("EM", null);
        this.firstLine.setJustification(justification);
        proofWindow.commitSaveState();
    }

    public static boolean contradictory(Formula formula, Formula formula2) {
        if (formula instanceof Not && !(formula2 instanceof Not)) {
            Formula formula3 = ((Not)formula).getFormula();
            return formula3.display().equals(formula2.display());
        }
        if (formula2 instanceof Not && !(formula instanceof Not)) {
            Formula formula4 = ((Not)formula2).getFormula();
            return formula4.display().equals(formula.display());
        }
        if (formula instanceof Not && formula2 instanceof Not) {
            Formula formula5 = ((Not)formula).getFormula();
            Formula formula6 = ((Not)formula2).getFormula();
            return EM.contradictory(formula5, formula6);
        }
        return false;
    }
}

