/*
 * Decompiled with CFR 0.152.
 */
package Pandora.NDRules;

import Pandora.Help.ErrorMessages;
import Pandora.Help.HelpMessages;
import Pandora.Justification;
import Pandora.LogicParser.Formula.Atom;
import Pandora.LogicParser.Formula.Exists;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Function;
import Pandora.LogicParser.Formula.Predicate;
import Pandora.LogicParser.Formula.Quantifier;
import Pandora.LogicParser.Formula.SimpleTerm;
import Pandora.LogicParser.Formula.Term;
import Pandora.LogicParser.Formula.Tuple;
import Pandora.LogicParser.Formula.Var;
import Pandora.LogicParser.ParseController;
import Pandora.NDRules.NDRule;
import Pandora.PanSignature;
import Pandora.ProofBox;
import Pandora.ProofItem;
import Pandora.ProofLine;
import Pandora.ProofWindow;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;

public class ExistsIntro
extends NDRule {
    private ProofLine existsLine;
    private boolean skip = false;
    int count = 0;

    public ExistsIntro(ProofBox proofBox) {
        super(proofBox);
    }

    @Override
    public void addLine(ProofLine proofLine) throws Exception {
        if (this.isForwards) {
            if (this.existsLine != null) {
                this.proof.deselectAll();
                throw new Exception("The correct number of lines have already been selected for this method.");
            }
        } else {
            this.proof.deselectAll();
            throw new Exception("The correct number of lines have already been selected for this method.");
        }
        this.existsLine = proofLine;
    }

    @Override
    public boolean haveAll() {
        return this.firstLine != null && (!this.isForwards || this.isForwards && this.existsLine != null);
    }

    @Override
    public void check() throws Exception {
        Formula formula;
        if (this.haveAll() && !this.isForwards && !((formula = this.firstLine.getFormula()) instanceof Exists)) {
            this.proof.deselectAll();
            throw new Exception(ErrorMessages.thereExists);
        }
    }

    @Override
    public void apply() throws Exception {
        if (this.isForwards) {
            this.applyForwards();
        } else {
            this.applyBackwards();
        }
    }

    private void applyForwards() throws Exception {
        Serializable serializable;
        Serializable serializable2;
        Object object;
        HelpMessages helpMessages = new HelpMessages(this.existsLine.getFormula());
        ProofWindow proofWindow = this.proof.getParentWindow();
        PanSignature panSignature = this.proof.getSignature();
        Formula formula = null;
        Formula formula2 = this.getNewFormula("", "(Optionally) input the There Exists formula you'd like to introduce\n_____________________________________________________________\n\nHint: if you have P(a,b) for example, you can deduce \u2203u(P(u,b)) or even\n\u2203u\u2203v(P(u,v)) for more help see the manual entry, for simple cases with one\nvariable click ok to skip to the next screen\n\n");
        if (!this.skip && formula2 != null && this.checkVarSub(formula2)) {
            formula = formula2;
        } else if (this.skip) {
            object = this.existsLine.getFormula();
            if (((Formula)object).getTerms().size() != 0) {
                serializable2 = this.getTerm("", "Specify the term to substitute the new Exists variable for\n___________________________________________\n\nHint: The term which you select in this screen must be in\nthe formula you selected and must be unbounded, the\nformula you selected will then be nested inside a \u2203\nformula, in the next screen you will need to specify\nthe name of the variable of the \u2203 formula\n\n", (Formula)object);
                if (serializable2 != null && (serializable = this.getVar("", "Input the name of the new Exists variable\n______________________________\n\nHint: Entering z will display a \u2203z formula and\nall instances of the term you selected in\nthe previous screen will be replaced by the\nnew variable\n\n", (Formula)object)) != null) {
                    Formula formula3 = ((Formula)object).subAll((Term)serializable2, (Term)serializable);
                    formula = new Exists((Var)serializable, formula3);
                }
            } else {
                serializable2 = this.getVar("", helpMessages.thereexists_introduction_forwards_input, (Formula)object);
                if (serializable2 != null) {
                    serializable = ((Formula)object).subAll((Term)serializable2, (Term)serializable2);
                    formula = new Exists((Var)serializable2, (Formula)serializable);
                }
            }
        }
        if (formula != null) {
            object = Collections.synchronizedList(new LinkedList());
            object.add(this.existsLine);
            serializable2 = new Justification("\u2203I", (List<ProofLine>)object);
            serializable = new ProofLine(formula, (Justification)serializable2, proofWindow, this.proof);
            int n = this.proof.getIndex(this.firstLine);
            this.proof.addItem(n, (ProofItem)serializable);
            proofWindow.commitSaveState();
        }
    }

    private int count(Formula formula) {
        int n = 0;
        if (formula instanceof Exists) {
            Formula formula2 = ((Exists)formula).getFormula();
            ++n;
            n += this.count(formula2);
        }
        return n;
    }

    public boolean checkVarSub(Formula formula) throws Exception {
        Formula formula2 = this.existsLine.getFormula();
        String string = formula.display();
        boolean bl = false;
        if (formula instanceof Exists) {
            this.count = this.count(formula);
            for (int i = 1; i <= this.count; ++i) {
                formula = ((Exists)formula).getFormula();
            }
        } else {
            this.proof.deselectAll();
            throw new Exception("The formula introduced by There Exists Introduction(forwards) must be a There Exists Formula!");
        }
        bl = formula2.checkSub(null, null, formula);
        formula2.setTuples(new LinkedList<Tuple>());
        if (bl) {
            return bl;
        }
        this.proof.deselectAll();
        throw new Exception("Input formula: " + string + "\ncannot be reached by There Exists Introduction(forwards)\nfrom formula " + formula2.display());
    }

    private void applyBackwards() throws Exception {
        try {
            Object[] objectArray;
            Object object;
            boolean bl = false;
            ProofWindow proofWindow = this.proof.getParentWindow();
            Exists exists = (Exists)this.firstLine.getFormula();
            Formula formula = exists;
            Formula formula2 = null;
            HelpMessages helpMessages = new HelpMessages(formula);
            this.count = this.count(exists);
            if (this.count > 1) {
                object = "In the selected formula " + exists.display() + "\nYou can either remove All the Exists quantifiers OR remove the outer most one.\n\nIf you choose to remove all of them,\nyou will be asked for a term to substitute for every variable\n\nWhat would you like to do?";
                int n = JOptionPane.showOptionDialog(proofWindow.view, object, "Input Required", 0, 3, null, objectArray = new Object[]{"Remove All", "Remove One"}, objectArray[1]);
                if (n == 0) {
                    for (int i = 1; i <= this.count && !this.skip; ++i) {
                        List<Term> list = ((Quantifier)formula).getAllTerms();
                        SimpleTerm simpleTerm = new SimpleTerm(((Exists)formula).getVar().getName());
                        if (simpleTerm.isIn(list)) {
                            PanSignature panSignature = this.proof.getSignature();
                            String string = "";
                            string = panSignature.getConstants().isEmpty() ? helpMessages.thereexists_introduction_backwards_no_constants : helpMessages.thereexists_introduction_backwards;
                            Term term = this.getNewTerm("", "Specify the term which you wish to have substituted for variable " + simpleTerm.display() + string, null);
                            if (term != null) {
                                formula = formula.subAll(simpleTerm, term);
                                formula = ((Exists)formula).getFormula();
                                continue;
                            }
                            this.skip = true;
                            continue;
                        }
                        formula = ((Exists)formula).getFormula();
                    }
                    if (!this.skip) {
                        formula2 = formula;
                    }
                } else if (n == 1) {
                    bl = true;
                }
            }
            if (this.count == 1 || bl) {
                object = ((Quantifier)formula).getAllTerms();
                objectArray = new SimpleTerm(exists.getVar().getName());
                Formula formula3 = exists.getFormula();
                if (objectArray.isIn((List<Term>)object)) {
                    Term term = this.getNewTerm("", "Specify the term which you wish to have substituted for variable " + exists.getVar().display() + helpMessages.thereexists_introduction_backwards, null);
                    if (term != null) {
                        formula2 = formula3.subAll((Term)objectArray, term);
                    }
                } else {
                    formula2 = formula3;
                }
            }
            if (formula2 != null) {
                object = new ProofLine(formula2, "<goal>", proofWindow, this.proof);
                int n = this.proof.getIndex(this.firstLine);
                this.proof.addItem(n, (ProofItem)object);
                List<ProofLine> list = Collections.synchronizedList(new LinkedList());
                list.add((ProofLine)object);
                Justification justification = new Justification("\u2203I", list);
                this.firstLine.setJustification(justification);
                proofWindow.commitSaveState();
            }
        }
        catch (Exception exception) {
            this.proof.deselectAll();
            throw exception;
        }
    }

    public boolean checkSignature(Term term) {
        PanSignature panSignature = this.proof.getSignature();
        PanSignature panSignature2 = panSignature.clone();
        this.check = term.clashes(panSignature2);
        if (this.check.contains(this.error)) {
            return false;
        }
        this.newSignature = panSignature.compare(panSignature2);
        return this.newSignature.isEmpty();
    }

    protected Term getTerm(String string, String string2, Formula formula) {
        ProofWindow proofWindow = this.proof.getParentWindow();
        PanSignature panSignature = this.proof.getSignature();
        Term term = null;
        boolean bl = false;
        Object[] objectArray = null;
        String string3 = (String)JOptionPane.showInputDialog(proofWindow.view, string2, "Input Required", 3, null, objectArray, string);
        if (string3 == null) {
            bl = true;
        } else {
            ParseController parseController = new ParseController(string3);
            Formula formula2 = parseController.parseLine();
            if (formula2 == null) {
                term = this.errorWindow("The Term you entered could not be parsed!\nWhat would you like to do?", string3, string2, formula, 1);
            } else {
                Object object;
                if (formula2 instanceof Atom) {
                    if (formula2 instanceof Predicate) {
                        object = (Predicate)formula2;
                        term = new Function(((Predicate)object).getName(), ((Predicate)object).getParams());
                    } else {
                        term = new SimpleTerm(((Atom)formula2).getName());
                    }
                } else {
                    term = this.errorWindow("Invalid Term!!", string3, string2, formula, 1);
                }
                if (term != null && !term.isIn((List<Term>)(object = formula.getTerms()))) {
                    String string4 = "The term " + term.display() + " does not occur free in the formula " + formula.display() + "\nWhat would you like to do?";
                    term = this.errorWindow(string4, string3, string2, formula, 1);
                }
            }
        }
        return term;
    }

    protected Term getNewTerm(String string, String string2, Formula formula) {
        ProofWindow proofWindow = this.proof.getParentWindow();
        PanSignature panSignature = this.proof.getSignature();
        Term term = null;
        boolean bl = false;
        Object[] objectArray = null;
        String string3 = (String)JOptionPane.showInputDialog(proofWindow.view, string2, "Input Required", 3, null, objectArray, string);
        if (string3 == null) {
            bl = true;
        } else {
            ParseController parseController = new ParseController(string3);
            Formula formula2 = parseController.parseLine();
            if (formula2 == null) {
                term = this.errorWindow("The Term you entered could not be parsed!\nWhat would you like to do?", string3, string2, formula, 0);
            } else {
                if (formula2 instanceof Atom) {
                    if (formula2 instanceof Predicate) {
                        Predicate predicate = (Predicate)formula2;
                        term = new Function(predicate.getName(), predicate.getParams());
                    } else {
                        term = new SimpleTerm(((Atom)formula2).getName());
                    }
                } else {
                    term = this.errorWindow("Invalid Term!!", string3, string2, formula, 0);
                }
                if (term != null) {
                    boolean bl2 = this.checkSignature(term);
                    if (!bl2) {
                        if (this.check.contains(this.error)) {
                            term = this.errorWindow(this.check, string3, string2, formula, 0);
                        } else {
                            String string4 = "Input Term : " + term.display() + "\nThe Following are not in the signature! What would you like to do? \n\n" + this.newSignature.show();
                            term = this.errorWindow(string4, string3, string2, formula, 0);
                        }
                    } else {
                        return term;
                    }
                }
            }
        }
        return term;
    }

    protected Var getVar(String string, String string2, Formula formula) {
        ProofWindow proofWindow = this.proof.getParentWindow();
        PanSignature panSignature = this.proof.getSignature();
        Var var = null;
        boolean bl = false;
        Object[] objectArray = null;
        String string3 = (String)JOptionPane.showInputDialog(proofWindow.view, string2, "Input Required", 3, null, objectArray, string);
        if (string3 == null) {
            bl = true;
        } else {
            ParseController parseController = new ParseController(string3);
            Formula formula2 = parseController.parseLine();
            if (formula2 == null) {
                String string4 = "The Variable name you entered could not be parsed!";
                var = (Var)this.errorWindow(string4, string3, string2, formula, 2);
            } else if (formula2 instanceof Atom && !(formula2 instanceof Predicate)) {
                var = new Var(((Atom)formula2).getName());
                if (var.isInVars(formula.getVars())) {
                    String string5 = "Nested Variable: " + var.display();
                    var = (Var)this.errorWindow(string5, string3, string2, formula, 2);
                }
                this.check = var.clashes(panSignature);
                if (this.check.contains(this.error)) {
                    var = (Var)this.errorWindow(this.check, string3, string2, formula, 2);
                }
            } else {
                var = (Var)this.errorWindow("Invalid Variable name !!", string3, string2, formula, 2);
            }
        }
        return var;
    }

    private Term errorWindow(String string, String string2, String string3, Formula formula, int n) {
        Term term = null;
        ProofWindow proofWindow = this.proof.getParentWindow();
        Object[] objectArray = new Object[]{"Edit Term", "Cancel"};
        int n2 = JOptionPane.showOptionDialog(proofWindow.view, string, "Error", 0, 3, null, objectArray, objectArray[0]);
        if (n2 == 0) {
            if (n == 0) {
                return this.getNewTerm(string2, string3, formula);
            }
            if (n == 1) {
                return this.getTerm(string2, string3, formula);
            }
            if (n == 2) {
                return this.getVar(string2, string3, formula);
            }
        }
        return term;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Formula getNewFormula(String string, String string2) throws Exception {
        ProofWindow proofWindow = this.proof.getParentWindow();
        PanSignature panSignature = this.proof.getSignature();
        Formula formula = null;
        boolean bl = false;
        Object[] objectArray = null;
        String string3 = (String)JOptionPane.showInputDialog(proofWindow.view, string2, "Input Required", 3, null, objectArray, string);
        if (string3 == null) {
            bl = true;
        } else if (string3.equals("")) {
            this.skip = true;
            return null;
        }
        if (bl) return formula;
        ParseController parseController = new ParseController(string3);
        Formula formula2 = parseController.parseLine();
        if (formula2 == null && !string3.equals("")) {
            this.proof.deselectAll();
            throw new Exception("The formula you entered could not be parsed.");
        }
        if (formula2 == null) return formula;
        boolean bl2 = this.checkSignature(formula2);
        if (bl2) return formula2;
        if (this.check.contains(this.error)) {
            Object[] objectArray2 = new Object[]{"Edit Formula", "Cancel"};
            int n = JOptionPane.showOptionDialog(proofWindow.view, "Input Formula : " + formula2.display() + "\n" + this.check + "\nWhat would you like to do? \n\n", "Error", 0, 3, null, objectArray2, objectArray2[0]);
            if (n == 0) {
                try {
                    return this.getNewFormula(string3, string2);
                }
                catch (Exception exception) {
                    this.proof.deselectAll();
                    throw exception;
                }
            }
            if (n != 1) return formula;
        }
        Object[] objectArray3 = new Object[]{"Edit Formula", "Cancel"};
        int n = JOptionPane.showOptionDialog(proofWindow.view, "Input Formula : " + formula2.display() + "\nThe Following are not in the signature! What would you like to do? \n\n" + this.newSignature.show(), "Input Required", 0, 3, null, objectArray3, objectArray3[0]);
        if (n == 0) {
            try {
                return this.getNewFormula(string3, string2);
            }
            catch (Exception exception) {
                this.proof.deselectAll();
                throw exception;
            }
        }
        if (n != 2) return formula;
        return formula;
    }
}

