/*
 * Decompiled with CFR 0.152.
 */
package Pandora.NDRules;

import Pandora.Justification;
import Pandora.LogicParser.Formula.False;
import Pandora.LogicParser.Formula.Formula;
import Pandora.NDRules.NDRule;
import Pandora.ProofBox;
import Pandora.ProofLine;
import Pandora.ProofWindow;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class FalsityElim
extends NDRule {
    ProofLine forwardLine = null;

    public FalsityElim(ProofBox proofBox) {
        super(proofBox);
    }

    @Override
    public void addLine(ProofLine proofLine) throws Exception {
        if (this.isForwards) {
            if (this.forwardLine != null) {
                this.proof.deselectAll();
                throw new Exception("The correct number of lines has already been entered for this rule!");
            }
        } else {
            this.proof.deselectAll();
            throw new Exception("The correct number of lines has already been entered for this rule!");
        }
        this.forwardLine = proofLine;
    }

    @Override
    public boolean haveAll() {
        return this.firstLine != null && (!this.isForwards || this.isForwards && this.forwardLine != null);
    }

    @Override
    public void check() throws Exception {
        Formula formula;
        if (this.isForwards && !((formula = this.forwardLine.getFormula()) instanceof False)) {
            this.proof.deselectAll();
            throw new Exception("The non-empty line selected in Falsity Elimination (forwards) must be a Bottom formula (\u22a5)");
        }
    }

    @Override
    public void apply() throws Exception {
        if (this.isForwards) {
            this.applyForwards();
        } else {
            this.applyBackwards();
        }
    }

    private void applyForwards() throws Exception {
        ProofWindow proofWindow = this.proof.getParentWindow();
        Formula formula = null;
        try {
            formula = this.getNewFormula("", "Input the formula you would like to introduce\n___________________________________\n\nHint: Since falsity implies anything you may\ninput whatever formula you want provided it is\nin the signature of your proof\n\n");
        }
        catch (Exception exception) {
            this.proof.deselectAll();
            throw exception;
        }
        if (formula != null) {
            List<ProofLine> list = Collections.synchronizedList(new LinkedList());
            list.add(this.forwardLine);
            Justification justification = new Justification("\u22a5E", list);
            ProofLine proofLine = new ProofLine(formula, "\u22a5E", proofWindow, this.proof);
            proofLine.setJustification(justification);
            int n = this.proof.getIndex(this.firstLine);
            this.proof.addItem(n, proofLine);
            proofWindow.commitSaveState();
        }
    }

    private void applyBackwards() {
        ProofWindow proofWindow = this.proof.getParentWindow();
        ProofLine proofLine = new ProofLine((Formula)new False(), "<goal>", proofWindow, this.proof);
        int n = this.proof.getIndex(this.firstLine);
        this.proof.addItem(n, proofLine);
        List<ProofLine> list = Collections.synchronizedList(new LinkedList());
        list.add(proofLine);
        Justification justification = new Justification("\u22a5E", list);
        this.firstLine.setJustification(justification);
        proofWindow.commitSaveState();
    }
}

