/*
 * Decompiled with CFR 0.152.
 */
package Pandora.NDRules;

import Pandora.Help.ErrorMessages;
import Pandora.Help.HelpMessages;
import Pandora.Justification;
import Pandora.LogicParser.Formula.Atom;
import Pandora.LogicParser.Formula.Forall;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Function;
import Pandora.LogicParser.Formula.Predicate;
import Pandora.LogicParser.Formula.Quantifier;
import Pandora.LogicParser.Formula.SimpleTerm;
import Pandora.LogicParser.Formula.Term;
import Pandora.LogicParser.Formula.Tuple;
import Pandora.LogicParser.Formula.Var;
import Pandora.LogicParser.ParseController;
import Pandora.NDRules.NDRule;
import Pandora.PanSignature;
import Pandora.ProofBox;
import Pandora.ProofItem;
import Pandora.ProofLine;
import Pandora.ProofWindow;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;

public class ForallElim
extends NDRule {
    private ProofLine forallLine;
    private boolean skip = false;
    int count = 0;

    public ForallElim(ProofBox proofBox) {
        super(proofBox);
    }

    @Override
    public void addLine(ProofLine proofLine) throws Exception {
        if (this.isForwards) {
            if (this.forallLine != null) {
                this.proof.deselectAll();
                throw new Exception("The correct number of lines have already been selected for this method.");
            }
        } else {
            this.proof.deselectAll();
            throw new Exception("The correct number of lines have already been selected for this method.");
        }
        this.forallLine = proofLine;
    }

    @Override
    public boolean haveAll() {
        return this.firstLine != null && (!this.isForwards || this.isForwards && this.forallLine != null);
    }

    @Override
    public void check() throws Exception {
        Formula formula;
        if (this.haveAll() && this.isForwards && !((formula = this.forallLine.getFormula()) instanceof Forall)) {
            this.proof.deselectAll();
            throw new Exception("The line selected to apply For All Elimination (forwards) must be a For All formula");
        }
    }

    @Override
    public void apply() throws Exception {
        if (this.isForwards) {
            this.applyForwards();
        } else {
            this.applyBackwards();
        }
    }

    private void applyForwards() throws Exception {
        try {
            Object object;
            Object[] objectArray;
            Object object2;
            HelpMessages helpMessages = new HelpMessages(this.forallLine.getFormula());
            boolean bl = false;
            ProofWindow proofWindow = this.proof.getParentWindow();
            Forall forall = (Forall)this.forallLine.getFormula();
            Formula formula = forall;
            Formula formula2 = null;
            this.count = this.count(forall);
            if (this.count > 1) {
                object2 = "In the selected formula " + forall.display() + "\nYou can either Eliminate All the For All quantifiers OR Eliminate the outer most one.\n\nIf you choose to Eliminate all of the quantifiers,\nyou will be asked for a term to substitute for each variable\n\nWhat would you like to do?";
                int n = JOptionPane.showOptionDialog(proofWindow.view, object2, "Input Required", 0, 3, null, objectArray = new Object[]{"Eliminate All", "Eliminate One"}, objectArray[1]);
                if (n == 0) {
                    object = ((Quantifier)formula).getAllTerms();
                    for (int i = 1; i <= this.count && !this.skip; ++i) {
                        SimpleTerm simpleTerm = new SimpleTerm(((Forall)formula).getVar().getName());
                        if (simpleTerm.isIn((List<Term>)object)) {
                            Term term = this.getNewTerm("", "Specify the term which you wish to have substituted for variable " + simpleTerm.display() + helpMessages.forall_elimination_forwards, null);
                            if (term != null) {
                                formula = formula.subAll(simpleTerm, term);
                                formula = ((Forall)formula).getFormula();
                                continue;
                            }
                            this.skip = true;
                            continue;
                        }
                        formula = ((Forall)formula).getFormula();
                    }
                    if (!this.skip) {
                        formula2 = formula;
                    }
                } else if (n == 1) {
                    bl = true;
                }
            }
            if (this.count == 1 || bl) {
                object2 = ((Quantifier)formula).getAllTerms();
                objectArray = new SimpleTerm(forall.getVar().getName());
                Formula formula3 = forall.getFormula();
                if (objectArray.isIn((List<Term>)object2)) {
                    object = this.getNewTerm("", "Specify the term which you wish to have substituted for variable " + forall.getVar().display() + "\n\n" + helpMessages.forall_elimination_forwards, null);
                    if (object != null) {
                        formula2 = formula3.subAll((Term)objectArray, (Term)object);
                    }
                } else {
                    formula2 = formula3;
                }
            }
            if (formula2 != null) {
                object2 = Collections.synchronizedList(new LinkedList());
                object2.add(this.forallLine);
                objectArray = new Justification("\u2200E", (List<ProofLine>)object2);
                ProofLine proofLine = new ProofLine(formula2, (Justification)objectArray, proofWindow, this.proof);
                int n = this.proof.getIndex(this.firstLine);
                this.proof.addItem(n, proofLine);
                proofWindow.commitSaveState();
            }
        }
        catch (Exception exception) {
            this.proof.deselectAll();
            throw exception;
        }
    }

    public void show(List<Term> list) {
        System.out.println("TERMSSSSSSSSS: ");
        for (Term term : list) {
            System.out.println("Term: " + term.display());
        }
    }

    private int count(Formula formula) {
        int n = 0;
        if (formula instanceof Forall) {
            Formula formula2 = ((Forall)formula).getFormula();
            ++n;
            n += this.count(formula2);
        }
        return n;
    }

    public boolean checkVarSub(Formula formula) throws Exception {
        Formula formula2 = this.firstLine.getFormula();
        boolean bl = false;
        String string = formula.display();
        if (formula instanceof Forall) {
            this.count = this.count(formula);
            for (int i = 1; i <= this.count; ++i) {
                formula = ((Forall)formula).getFormula();
            }
        } else {
            this.proof.deselectAll();
            throw new Exception(ErrorMessages.forAllElim_backwards);
        }
        bl = formula2.checkSub(null, null, formula);
        formula2.setTuples(new LinkedList<Tuple>());
        if (bl) {
            return bl;
        }
        this.proof.deselectAll();
        throw new Exception("Formula " + formula2.display() + "\ncannot be reached by For All Elimination(backwards)\nfrom formula " + string);
    }

    private void applyBackwards() throws Exception {
        Serializable serializable;
        Object object;
        Serializable serializable2;
        HelpMessages helpMessages = new HelpMessages(this);
        ProofWindow proofWindow = this.proof.getParentWindow();
        Formula formula = null;
        PanSignature panSignature = this.proof.getSignature();
        Formula formula2 = this.getNewFormula("", "(Optionally) input the For All formula you'd like to appear as the new goal\n_____________________________________________________________________________\n\nHint: if you have P(a,b) for example, you can deduce \u2200u(P(u,b)) or even\n\u2200u\u2200v(P(u,v)) for more help see the manual entry, for simple cases with\none variable click ok to skip to the next screen\n\n");
        if (!this.skip && formula2 != null && this.checkVarSub(formula2)) {
            formula = formula2;
        } else if (this.skip) {
            serializable2 = this.firstLine.getFormula();
            if (((Formula)serializable2).getTerms().size() != 0) {
                object = this.getTerm("", helpMessages.forall_elimination_backwards_specify, (Formula)serializable2);
                if (object != null && (serializable = this.getVar("", helpMessages.forall_elimination_backwards_specify_input, (Formula)serializable2)) != null) {
                    Formula formula3 = ((Formula)serializable2).subAll((Term)object, (Term)serializable);
                    formula = new Forall((Var)serializable, formula3);
                }
            } else {
                object = this.getVar("", helpMessages.forall_elimination_backwards_input, (Formula)serializable2);
                if (object != null) {
                    serializable = ((Formula)serializable2).subAll((Term)object, (Term)object);
                    formula = new Forall((Var)object, (Formula)serializable);
                }
            }
        }
        if (formula != null) {
            serializable2 = new ProofLine(formula, "<goal>", proofWindow, this.proof);
            object = Collections.synchronizedList(new LinkedList());
            object.add(serializable2);
            serializable = new Justification("\u2200E", (List<ProofLine>)object);
            this.firstLine.setJustification((Justification)serializable);
            int n = this.proof.getIndex(this.firstLine);
            this.proof.addItem(n, (ProofItem)serializable2);
            proofWindow.commitSaveState();
        }
    }

    public boolean checkSignature(Term term) {
        PanSignature panSignature = this.proof.getSignature();
        PanSignature panSignature2 = panSignature.clone();
        this.check = term.clashes(panSignature2);
        if (this.check.contains(this.error)) {
            return false;
        }
        this.newSignature = panSignature.compare(panSignature2);
        return this.newSignature.isEmpty();
    }

    protected Term getTerm(String string, String string2, Formula formula) {
        ProofWindow proofWindow = this.proof.getParentWindow();
        PanSignature panSignature = this.proof.getSignature();
        Term term = null;
        boolean bl = false;
        Object[] objectArray = null;
        String string3 = (String)JOptionPane.showInputDialog(proofWindow.view, string2, "Input Required", 3, null, objectArray, string);
        if (string3 == null) {
            bl = true;
        } else {
            ParseController parseController = new ParseController(string3);
            Formula formula2 = parseController.parseLine();
            if (formula2 == null) {
                term = this.errorWindow("The Term you entered could not be parsed!\nWhat would you like to do?", string3, string2, formula, 1);
            } else {
                Object object;
                if (formula2 instanceof Atom) {
                    if (formula2 instanceof Predicate) {
                        object = (Predicate)formula2;
                        term = new Function(((Predicate)object).getName(), ((Predicate)object).getParams());
                    } else {
                        term = new SimpleTerm(((Atom)formula2).getName());
                    }
                } else {
                    term = this.errorWindow("Invalid Term!!", string3, string2, formula, 1);
                }
                if (term != null && !term.isIn((List<Term>)(object = formula.getTerms()))) {
                    String string4 = "The term " + term.display() + " does not occur free in the formula " + formula.display() + "\nWhat would you like to do?";
                    term = this.errorWindow(string4, string3, string2, formula, 1);
                }
            }
        }
        return term;
    }

    protected Term getNewTerm(String string, String string2, Formula formula) {
        ProofWindow proofWindow = this.proof.getParentWindow();
        PanSignature panSignature = this.proof.getSignature();
        Term term = null;
        boolean bl = false;
        Object[] objectArray = null;
        String string3 = (String)JOptionPane.showInputDialog(proofWindow.view, string2, "Input Required", 3, null, objectArray, string);
        if (string3 == null) {
            bl = true;
        } else {
            ParseController parseController = new ParseController(string3);
            Formula formula2 = parseController.parseLine();
            if (formula2 == null) {
                term = this.errorWindow("The Term you entered could not be parsed!\nWhat would you like to do?", string3, string2, formula, 0);
            } else {
                if (formula2 instanceof Atom) {
                    if (formula2 instanceof Predicate) {
                        Predicate predicate = (Predicate)formula2;
                        term = new Function(predicate.getName(), predicate.getParams());
                    } else {
                        term = new SimpleTerm(((Atom)formula2).getName());
                    }
                } else {
                    term = this.errorWindow("Invalid Term!!", string3, string2, formula, 0);
                }
                if (term != null) {
                    boolean bl2 = this.checkSignature(term);
                    if (!bl2) {
                        if (this.check.contains(this.error)) {
                            term = this.errorWindow(this.check, string3, string2, formula, 0);
                        } else {
                            String string4 = "Input Term : " + term.display() + "\nThe Following are not in the signature! What would you like to do? \n\n" + this.newSignature.show();
                            term = this.errorWindow(string4, string3, string2, formula, 0);
                        }
                    } else {
                        return term;
                    }
                }
            }
        }
        return term;
    }

    protected Var getVar(String string, String string2, Formula formula) {
        ProofWindow proofWindow = this.proof.getParentWindow();
        PanSignature panSignature = this.proof.getSignature();
        Var var = null;
        boolean bl = false;
        Object[] objectArray = null;
        String string3 = (String)JOptionPane.showInputDialog(proofWindow.view, string2, "Input Required", 3, null, objectArray, string);
        if (string3 == null) {
            bl = true;
        } else {
            ParseController parseController = new ParseController(string3);
            Formula formula2 = parseController.parseLine();
            if (formula2 == null) {
                String string4 = "The Variable name you entered could not be parsed!";
                var = (Var)this.errorWindow(string4, string3, string2, formula, 2);
            } else if (formula2 instanceof Atom && !(formula2 instanceof Predicate)) {
                var = new Var(((Atom)formula2).getName());
                if (var.isInVars(formula.getVars())) {
                    String string5 = "Nested Variable: " + var.display();
                    var = (Var)this.errorWindow(string5, string3, string2, formula, 2);
                }
                this.check = var.clashes(panSignature);
                if (this.check.contains(this.error)) {
                    var = (Var)this.errorWindow(this.check, string3, string2, formula, 2);
                }
            } else {
                var = (Var)this.errorWindow("Invalid Variable name !!", string3, string2, formula, 2);
            }
        }
        return var;
    }

    private Term errorWindow(String string, String string2, String string3, Formula formula, int n) {
        Term term = null;
        ProofWindow proofWindow = this.proof.getParentWindow();
        Object[] objectArray = new Object[]{"Edit Term", "Cancel"};
        int n2 = JOptionPane.showOptionDialog(proofWindow.view, string, "Error", 0, 3, null, objectArray, objectArray[0]);
        if (n2 == 0) {
            if (n == 0) {
                return this.getNewTerm(string2, string3, formula);
            }
            if (n == 1) {
                return this.getTerm(string2, string3, formula);
            }
            if (n == 2) {
                return this.getVar(string2, string3, formula);
            }
        }
        return term;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Formula getNewFormula(String string, String string2) throws Exception {
        ProofWindow proofWindow = this.proof.getParentWindow();
        PanSignature panSignature = this.proof.getSignature();
        Formula formula = null;
        boolean bl = false;
        Object[] objectArray = null;
        String string3 = (String)JOptionPane.showInputDialog(proofWindow.view, string2, "Input Required", 3, null, objectArray, string);
        if (string3 == null) {
            bl = true;
        } else if (string3.equals("")) {
            this.skip = true;
            return null;
        }
        if (bl) return formula;
        ParseController parseController = new ParseController(string3);
        Formula formula2 = parseController.parseLine();
        if (formula2 == null && !string3.equals("")) {
            this.proof.deselectAll();
            throw new Exception("The formula you entered could not be parsed.");
        }
        if (formula2 == null) return formula;
        boolean bl2 = this.checkSignature(formula2);
        if (bl2) return formula2;
        if (this.check.contains(this.error)) {
            Object[] objectArray2 = new Object[]{"Edit Formula", "Cancel"};
            int n = JOptionPane.showOptionDialog(proofWindow.view, "Input Formula : " + formula2.display() + "\n" + this.check + "\nWhat would you like to do? \n\n", "Error", 0, 3, null, objectArray2, objectArray2[0]);
            if (n == 0) {
                try {
                    return this.getNewFormula(string3, string2);
                }
                catch (Exception exception) {
                    this.proof.deselectAll();
                    throw exception;
                }
            }
            if (n != 1) return formula;
        }
        Object[] objectArray3 = new Object[]{"Edit Formula", "Cancel"};
        int n = JOptionPane.showOptionDialog(proofWindow.view, "Input Formula : " + formula2.display() + "\nThe Following are not in the signature! What would you like to do? \n\n" + this.newSignature.show(), "Input Required", 0, 3, null, objectArray3, objectArray3[0]);
        if (n == 0) {
            try {
                return this.getNewFormula(string3, string2);
            }
            catch (Exception exception) {
                this.proof.deselectAll();
                throw exception;
            }
        }
        if (n != 2) return formula;
        return formula;
    }
}

