/*
 * Decompiled with CFR 0.152.
 */
package Pandora.NDRules;

import Pandora.Help.ErrorMessages;
import Pandora.Justification;
import Pandora.LogicParser.Formula.Atom;
import Pandora.LogicParser.Formula.Forall;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.SimpleTerm;
import Pandora.LogicParser.Formula.Term;
import Pandora.LogicParser.ParseController;
import Pandora.NDRules.NDRule;
import Pandora.PanSignature;
import Pandora.ProofBox;
import Pandora.ProofItem;
import Pandora.ProofLine;
import Pandora.ProofWindow;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;

public class ForallIntro
extends NDRule {
    private int count = 0;

    public ForallIntro(ProofBox proofBox) {
        super(proofBox);
    }

    @Override
    public void addLine(ProofLine proofLine) throws Exception {
        this.proof.deselectAll();
        throw new Exception("The correct number of lines have already been selected for this method.");
    }

    @Override
    public boolean haveAll() {
        return this.firstLine != null;
    }

    @Override
    public void check() throws Exception {
        Formula formula;
        if (this.haveAll() && !this.isForwards && !((formula = this.firstLine.getFormula()) instanceof Forall)) {
            this.proof.deselectAll();
            throw new Exception(ErrorMessages.forAllIntro_backwards);
        }
    }

    @Override
    public void apply() throws Exception {
        if (this.isForwards) {
            this.applyForwards();
        } else {
            this.applyBackwards();
        }
    }

    private void applyForwards() throws Exception {
        ProofWindow proofWindow = this.proof.getParentWindow();
        Formula formula = this.getNewFormula("", "Input the Formula you'd like to be derived by For All Introduction Forwards\n___________________________________________________________________________\n\nHint: if you REALLY want to use this rule to derive \u2200x(P(x)) (the formula\nyou are asked to input in this screen) you will have to complete the proof\nfrom sk1 to P(sk1)\n\n");
        if (formula != null) {
            Serializable serializable;
            Object object;
            Object object2;
            this.count = this.count(formula);
            Forall forall = (Forall)formula;
            String string = "";
            boolean bl = false;
            Atom atom = null;
            Formula formula2 = forall;
            ProofBox proofBox = new ProofBox(proofWindow, this.proof);
            if (this.count > 1) {
                object2 = "In the entered formula " + formula.display() + "\nYou can either remove All the Forall quantifiers at once or remove the outer most one.\nWhat would you like to do?";
                int n = JOptionPane.showOptionDialog(proofWindow.view, object2, "Input Required", 0, 3, null, object = new Object[]{"Rmove All", "Remove One"}, object[1]);
                if (n == 0) {
                    for (int i = 1; i <= this.count; ++i) {
                        int n2 = this.proof.getParentWindow().mainProofBox.skolem++;
                        serializable = new SimpleTerm("sk" + n2);
                        SimpleTerm simpleTerm = new SimpleTerm(((Forall)formula2).getVar().getName());
                        string = string + "sk" + n2 + ",";
                        formula2 = formula2.subAll(simpleTerm, (Term)serializable);
                        formula2 = ((Forall)formula2).getFormula();
                        proofBox.getMainSignature().getSkolems().add((SimpleTerm)serializable);
                    }
                    atom = new Atom(string.substring(0, string.length() - 1));
                } else if (n == 1) {
                    bl = true;
                }
            }
            if (this.count == 1 || bl) {
                int n = this.proof.getParentWindow().mainProofBox.skolem++;
                object = new SimpleTerm("sk" + n);
                SimpleTerm simpleTerm = new SimpleTerm(forall.getVar().getName());
                formula2 = forall.getFormula().subAll(simpleTerm, (Term)object);
                atom = new Atom("sk" + n);
                proofBox.getMainSignature().getSkolems().add((SimpleTerm)object);
            }
            if (atom != null) {
                object2 = new ProofLine(atom, "\u2200Iconst", proofWindow, this.proof);
                object = new ProofLine(null, "", proofWindow, this.proof);
                ProofLine proofLine = new ProofLine(formula2, "<goal>", proofWindow, this.proof);
                List<ProofLine> list = Collections.synchronizedList(new LinkedList());
                list.add((ProofLine)object2);
                list.add(proofLine);
                Justification justification = new Justification("\u2200I", list);
                serializable = new ProofLine(formula, justification, proofWindow, this.proof);
                proofBox.addItem((ProofItem)object2);
                proofBox.addItem((ProofItem)object);
                proofBox.addItem(proofLine);
                int n = this.proof.getIndex(this.firstLine);
                this.proof.addItem(n, (ProofItem)serializable);
                this.proof.addItem(n, proofBox);
                proofWindow.commitSaveState();
            }
        }
    }

    private int count(Formula formula) {
        int n = 0;
        if (formula instanceof Forall) {
            Formula formula2 = ((Forall)formula).getFormula();
            ++n;
            n += this.count(formula2);
        }
        return n;
    }

    private void applyBackwards() throws Exception {
        try {
            Serializable serializable;
            int n;
            Object object;
            Object object2;
            ProofWindow proofWindow = this.proof.getParentWindow();
            Forall forall = (Forall)this.firstLine.getFormula();
            this.count = this.count(forall);
            boolean bl = false;
            ProofBox proofBox = new ProofBox(proofWindow, this.proof);
            String string = "";
            Atom atom = null;
            Formula formula = forall;
            if (this.count > 1) {
                object2 = "In the selected formula " + forall.display() + "\nYou can either remove All the Forall quantifiers at once or remove the outer most one.\nWhat would you like to do?";
                int n2 = JOptionPane.showOptionDialog(proofWindow.view, object2, "Input Required", 0, 3, null, object = new Object[]{"Remove All", "Remove One"}, object[1]);
                if (n2 == 0) {
                    for (n = 1; n <= this.count; ++n) {
                        int n3 = this.proof.getParentWindow().mainProofBox.skolem++;
                        serializable = new SimpleTerm("sk" + n3);
                        SimpleTerm simpleTerm = new SimpleTerm(((Forall)formula).getVar().getName());
                        string = string + "sk" + n3 + ",";
                        formula = formula.subAll(simpleTerm, (Term)serializable);
                        formula = ((Forall)formula).getFormula();
                        proofBox.getMainSignature().getSkolems().add((SimpleTerm)serializable);
                    }
                    atom = new Atom(string.substring(0, string.length() - 1));
                } else if (n2 == 1) {
                    bl = true;
                }
            }
            if (this.count == 1 || bl) {
                int n4 = this.proof.getParentWindow().mainProofBox.skolem++;
                object = new SimpleTerm("sk" + n4);
                SimpleTerm simpleTerm = new SimpleTerm(forall.getVar().getName());
                formula = forall.getFormula().subAll(simpleTerm, (Term)object);
                atom = new Atom("sk" + n4);
                proofBox.getMainSignature().getSkolems().add((SimpleTerm)object);
            }
            if (atom != null) {
                object2 = new ProofLine(atom, "\u2200Iconst", proofWindow, this.proof);
                object = new ProofLine(null, "", proofWindow, this.proof);
                ProofLine proofLine = new ProofLine(formula, "<goal>", proofWindow, this.proof);
                proofBox.addItem((ProofItem)object2);
                proofBox.addItem((ProofItem)object);
                proofBox.addItem(proofLine);
                n = this.proof.getIndex(this.firstLine);
                this.proof.addItem(n, proofBox);
                List<ProofLine> list = Collections.synchronizedList(new LinkedList());
                list.add((ProofLine)object2);
                list.add(proofLine);
                serializable = new Justification("\u2200I", list);
                this.firstLine.setJustification((Justification)serializable);
                proofWindow.commitSaveState();
            }
        }
        catch (Exception exception) {
            this.proof.deselectAll();
            throw exception;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Formula getNewFormula(String string, String string2) throws Exception {
        ProofWindow proofWindow = this.proof.getParentWindow();
        PanSignature panSignature = this.proof.getSignature();
        Formula formula = null;
        boolean bl = false;
        String string3 = null;
        Object[] objectArray = null;
        String string4 = (String)JOptionPane.showInputDialog(proofWindow.view, string2, "Input Required", 3, null, objectArray, string);
        if (string4 == null) {
            bl = true;
        } else {
            string3 = string4;
        }
        if (bl) return formula;
        ParseController parseController = new ParseController(string3);
        Formula formula2 = parseController.parseLine();
        if (formula2 == null) {
            this.proof.deselectAll();
            throw new Exception("The formula you entered could not be parsed.");
        }
        if (formula2 instanceof Forall) {
            boolean bl2 = this.checkSignature(formula2);
            if (bl2) return formula2;
            if (this.check.contains(this.error)) {
                Object[] objectArray2 = new Object[]{"Edit Formula", "Cancel"};
                int n = JOptionPane.showOptionDialog(proofWindow.view, "Input Formula : " + formula2.display() + "\n" + this.check + "\nWhat would you like to do? \n\n", "Error", 0, 3, null, objectArray2, objectArray2[0]);
                if (n == 0) {
                    try {
                        return this.getNewFormula(string3, string2);
                    }
                    catch (Exception exception) {
                        this.proof.deselectAll();
                        throw exception;
                    }
                }
                if (n != 1) return formula;
            }
            Object[] objectArray3 = new Object[]{"Edit Formula", "Cancel"};
            int n = JOptionPane.showOptionDialog(proofWindow.view, "Input Formula : " + formula2.display() + "\nThe Following are not in the signature! What would you like to do? \n\n" + this.newSignature.show(), "Input Required", 0, 3, null, objectArray3, objectArray3[0]);
            if (n == 0) {
                try {
                    return this.getNewFormula(string3, string2);
                }
                catch (Exception exception) {
                    this.proof.deselectAll();
                    throw exception;
                }
            }
            if (n != 1) return formula;
        }
        Object[] objectArray4 = new Object[]{"Try Again", "Cancel"};
        int n = JOptionPane.showOptionDialog(proofWindow.view, "The formula to be derived by For All Introduction forwards must be a For All formula !", "Invalid Input", 0, 3, null, objectArray4, objectArray4[0]);
        if (n == 0) {
            try {
                return this.getNewFormula(string3, string2);
            }
            catch (Exception exception) {
                this.proof.deselectAll();
                throw exception;
            }
        }
        if (n != 1) return formula;
        return formula;
    }
}

