/*
 * Decompiled with CFR 0.152.
 */
package Pandora.NDRules;

import Pandora.Help.ErrorFrame;
import Pandora.Help.ErrorMessages;
import Pandora.Justification;
import Pandora.LogicParser.Formula.Forall;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Tuple;
import Pandora.NDRules.NDRule;
import Pandora.ProofBox;
import Pandora.ProofLine;
import Pandora.ProofWindow;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ForallTick
extends NDRule {
    private ProofLine forallLine;
    private boolean skip = false;
    int count = 0;

    public ForallTick(ProofBox proofBox) {
        super(proofBox);
    }

    @Override
    public void addInputLine(ProofLine proofLine) throws Exception {
        if (!proofLine.getJustification().getSymbol().equals("<goal>")) {
            this.proof.deselectAll();
            throw new Exception(ErrorMessages.forAllTick);
        }
        this.firstLine = proofLine;
        this.isForwards = false;
    }

    @Override
    public void addLine(ProofLine proofLine) throws Exception {
        if (this.isForwards || this.forallLine != null) {
            this.proof.deselectAll();
            throw new Exception("The correct number of lines have already been selected for this method.");
        }
        this.forallLine = proofLine;
    }

    @Override
    public boolean haveAll() {
        return this.firstLine != null && !this.isForwards && this.forallLine != null;
    }

    @Override
    public void check() throws Exception {
        Formula formula;
        if (this.haveAll() && !this.isForwards && !((formula = this.forallLine.getFormula()) instanceof Forall)) {
            this.proof.deselectAll();
            throw new Exception(ErrorMessages.forAllTick_backwards);
        }
    }

    @Override
    public void apply() throws Exception {
        if (this.isForwards) {
            this.proof.deselectAll();
            throw new Exception(ErrorMessages.forAllTick);
        }
        this.applyBackwards();
    }

    private void applyForwards() {
    }

    private int count(Formula formula) {
        int n = 0;
        if (formula instanceof Forall) {
            Formula formula2 = ((Forall)formula).getFormula();
            ++n;
            n += this.count(formula2);
        }
        return n;
    }

    public boolean checkVarSub(Formula formula, Formula formula2) throws Exception {
        boolean bl = false;
        if (formula2 instanceof Forall) {
            this.count = this.count(formula2);
            for (int i = 1; i <= this.count; ++i) {
                formula2 = ((Forall)formula2).getFormula();
            }
        } else {
            this.proof.deselectAll();
            throw new Exception(ErrorMessages.forAllElim_backwards);
        }
        bl = formula.checkSub(null, null, formula2);
        formula.setTuples(new LinkedList<Tuple>());
        return bl;
    }

    private void applyBackwards() throws Exception {
        Formula formula;
        ProofWindow proofWindow = this.proof.getParentWindow();
        Formula formula2 = this.firstLine.getFormula();
        boolean bl = this.checkVarSub(formula2, formula = this.forallLine.getFormula());
        if (bl) {
            List<ProofLine> list = Collections.synchronizedList(new LinkedList());
            list.add(this.forallLine);
            Justification justification = new Justification("\u2200E", list);
            this.firstLine.setJustification(justification);
            proofWindow.commitSaveState();
        } else {
            this.proof.deselectAll();
            ErrorFrame.launch("The formula: " + formula2.display() + "\ncannot be reached by For All Tick (backwards)\nfrom the formula: " + formula.display(), "Lets look at an example which would succeed when for all elimination\ntick (backwards) is used, \u2200x\u2200y(p(x,f(y))) <derived line> \nand p(a,f(b)) <goal line>, but it would not succeed if the derived \nline is \u2200x(p(x,f(x))) since x can't be unified to both a and b.");
        }
    }
}

