/*
 * Decompiled with CFR 0.152.
 */
package Pandora.NDRules;

import Pandora.Help.ErrorMessages;
import Pandora.Justification;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Iff;
import Pandora.NDRules.NDRule;
import Pandora.ProofBox;
import Pandora.ProofLine;
import Pandora.ProofWindow;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class IffElim
extends NDRule {
    private ProofLine iffLine = null;
    private ProofLine forwardLine = null;

    public IffElim(ProofBox proofBox) {
        super(proofBox);
    }

    @Override
    public void addLine(ProofLine proofLine) throws Exception {
        if (this.iffLine == null) {
            this.iffLine = proofLine;
        } else if (this.isForwards && this.forwardLine == null) {
            this.forwardLine = proofLine;
        } else {
            this.proof.deselectAll();
            throw new Exception("The correct number of lines have already been selected for this method.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void correctLines() throws Exception {
        Formula formula = this.iffLine.getFormula();
        if (formula instanceof Iff && this.isForwards) {
            ProofLine proofLine = this.iffLine;
            this.iffLine = this.forwardLine;
            this.forwardLine = proofLine;
            return;
        }
        if (!this.isForwards) {
            this.proof.deselectAll();
            throw new Exception(ErrorMessages.iff_backwards);
        }
        if (this.forwardLine.getFormula() instanceof Iff) {
            ProofLine proofLine = this.iffLine;
            this.iffLine = this.forwardLine;
            this.forwardLine = proofLine;
            return;
        }
        this.proof.deselectAll();
        throw new Exception(ErrorMessages.iff_backwards);
    }

    @Override
    public void check() throws Exception {
        try {
            this.correctLines();
            if (this.haveAll()) {
                if (this.isForwards) {
                    this.checkForwards();
                } else {
                    this.checkBackwards();
                }
            }
        }
        catch (Exception exception) {
            this.proof.deselectAll();
            throw exception;
        }
    }

    @Override
    public boolean haveAll() {
        return this.iffLine != null && this.firstLine != null && (!this.isForwards || this.isForwards && this.forwardLine != null);
    }

    private void checkBackwards() throws Exception {
        if (!(this.iffLine.getFormula() instanceof Iff)) {
            this.proof.deselectAll();
            throw new Exception(ErrorMessages.iff);
        }
        Formula formula = ((Iff)this.iffLine.getFormula()).getRight();
        Formula formula2 = ((Iff)this.iffLine.getFormula()).getLeft();
        Formula formula3 = this.firstLine.getFormula();
        if (!formula3.display().equals(formula.display()) && !formula3.display().equals(formula2.display())) {
            this.proof.deselectAll();
            throw new Exception("The goal line must be the same as either the left or the right hand side of the IFF formula!");
        }
    }

    private int count(Formula formula) {
        return formula.getAtoms().size();
    }

    private void checkForwards() throws Exception {
        Serializable serializable;
        if (!(this.iffLine.getFormula() instanceof Iff) && !(this.forwardLine.getFormula() instanceof Iff)) {
            this.proof.deselectAll();
            throw new Exception(ErrorMessages.iff);
        }
        int n = this.count(this.iffLine.getFormula());
        int n2 = this.count(this.forwardLine.getFormula());
        if (!(this.iffLine.getFormula() instanceof Iff)) {
            serializable = this.iffLine;
            this.iffLine = this.forwardLine;
            this.forwardLine = serializable;
        } else if (n < n2) {
            serializable = this.iffLine;
            this.iffLine = this.forwardLine;
            this.forwardLine = serializable;
        }
        serializable = ((Iff)this.iffLine.getFormula()).getLeft();
        Formula formula = ((Iff)this.iffLine.getFormula()).getRight();
        Formula formula2 = this.forwardLine.getFormula();
        if (!formula2.display().equals(formula.display()) && !formula2.display().equals(((Formula)serializable).display())) {
            this.proof.deselectAll();
            throw new Exception("The second line must be the same as either the left or the right hand side of the IFF formula!");
        }
    }

    @Override
    public void apply() throws Exception {
        if (this.isForwards) {
            this.applyForwards();
        } else {
            this.applyBackwards();
        }
    }

    private void applyBackwards() {
        Formula formula = ((Iff)this.iffLine.getFormula()).getLeft();
        Formula formula2 = ((Iff)this.iffLine.getFormula()).getRight();
        ProofWindow proofWindow = this.proof.getParentWindow();
        ProofLine proofLine = null;
        if (this.firstLine.getFormula().display().equals(formula.display())) {
            proofLine = new ProofLine(formula2, "<goal>", proofWindow, this.proof);
        } else if (this.firstLine.getFormula().display().equals(formula2.display())) {
            proofLine = new ProofLine(formula, "<goal>", proofWindow, this.proof);
        }
        int n = this.proof.getIndex(this.firstLine);
        this.proof.addItem(n, proofLine);
        List<ProofLine> list = Collections.synchronizedList(new LinkedList());
        list.add(this.iffLine);
        list.add(proofLine);
        Justification justification = new Justification("\u2194E", list);
        this.firstLine.setJustification(justification);
        proofWindow.commitSaveState();
    }

    private void applyForwards() {
        Formula formula = ((Iff)this.iffLine.getFormula()).getLeft();
        Formula formula2 = ((Iff)this.iffLine.getFormula()).getRight();
        ProofWindow proofWindow = this.proof.getParentWindow();
        ProofLine proofLine = null;
        if (this.forwardLine.getFormula().display().equals(formula.display())) {
            proofLine = new ProofLine(formula2, "\u2194E", proofWindow, this.proof);
        } else if (this.forwardLine.getFormula().display().equals(formula2.display())) {
            proofLine = new ProofLine(formula, "\u2194E", proofWindow, this.proof);
        }
        List<ProofLine> list = Collections.synchronizedList(new LinkedList());
        int n = this.proof.getIndex(this.iffLine);
        int n2 = this.proof.getIndex(this.forwardLine);
        if (n < n2) {
            list.add(this.iffLine);
            list.add(this.forwardLine);
        } else {
            list.add(this.forwardLine);
            list.add(this.iffLine);
        }
        Justification justification = new Justification("\u2194E", list);
        proofLine.setJustification(justification);
        int n3 = this.proof.getIndex(this.firstLine);
        this.proof.addItem(n3, proofLine);
        proofWindow.commitSaveState();
    }
}

