/*
 * Decompiled with CFR 0.152.
 */
package Pandora.NDRules;

import Pandora.Justification;
import Pandora.LogicParser.Formula.And;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Iff;
import Pandora.LogicParser.Formula.Not;
import Pandora.LogicParser.Formula.Or;
import Pandora.NDRules.NDRule;
import Pandora.ProofBox;
import Pandora.ProofLine;
import Pandora.ProofWindow;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class IffElimDerived
extends NDRule {
    ProofLine forwardLine = null;

    public IffElimDerived(ProofBox proofBox) {
        super(proofBox);
    }

    @Override
    public void addLine(ProofLine proofLine) throws Exception {
        if (this.isForwards) {
            if (this.forwardLine != null) {
                this.proof.deselectAll();
                throw new Exception("The correct number of lines has already been input for this rule !");
            }
        } else {
            this.proof.deselectAll();
            throw new Exception("The correct number of lines has already been input for this rule !");
        }
        this.forwardLine = proofLine;
    }

    @Override
    public boolean haveAll() {
        return this.firstLine != null && (!this.isForwards || this.isForwards && this.forwardLine != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check() throws Exception {
        if (!this.isForwards) {
            Formula formula = this.firstLine.getFormula();
            if (formula instanceof Or) {
                Formula formula2 = ((Or)formula).getLeft();
                Formula formula3 = ((Or)formula).getRight();
                if (formula2 instanceof And && formula3 instanceof And) {
                    Formula formula4 = ((And)formula2).getLeft();
                    Formula formula5 = ((And)formula2).getRight();
                    Formula formula6 = ((And)formula3).getLeft();
                    Formula formula7 = ((And)formula3).getRight();
                    if (IffElimDerived.contradictory(formula4, formula6) && IffElimDerived.contradictory(formula5, formula7) && formula6 instanceof Not && formula7 instanceof Not) return;
                    this.proof.deselectAll();
                    throw new Exception("The second formula selected must be of the form a\u2227b \u2228 \u00aca\u2227\u00acb");
                }
                this.proof.deselectAll();
                throw new Exception("The second formula selected must be of the form a\u2227b \u2228 \u00aca\u2227\u00acb");
            }
            this.proof.deselectAll();
            throw new Exception("The second formula selected must be of the form a\u2227b \u2228 \u00aca\u2227\u00acb");
        }
        Formula formula = this.forwardLine.getFormula();
        if (formula instanceof Iff) return;
        this.proof.deselectAll();
        throw new Exception("An Iff line must be selected to apply this rule.");
    }

    public static boolean contradictory(Formula formula, Formula formula2) {
        if (formula instanceof Not && !(formula2 instanceof Not)) {
            Formula formula3 = ((Not)formula).getFormula();
            return formula3.display().equals(formula2.display());
        }
        if (formula2 instanceof Not && !(formula instanceof Not)) {
            Formula formula4 = ((Not)formula2).getFormula();
            return formula4.display().equals(formula.display());
        }
        if (formula instanceof Not && formula2 instanceof Not) {
            Formula formula5 = ((Not)formula).getFormula();
            Formula formula6 = ((Not)formula2).getFormula();
            return IffElimDerived.contradictory(formula5, formula6);
        }
        return false;
    }

    @Override
    public void apply() throws Exception {
        if (this.isForwards) {
            this.applyForwards();
        } else {
            this.applyBackwards();
        }
    }

    private void applyBackwards() {
        ProofWindow proofWindow = this.proof.getParentWindow();
        Formula formula = this.firstLine.getFormula();
        Formula formula2 = ((Or)formula).getLeft();
        Formula formula3 = ((And)formula2).getLeft();
        Formula formula4 = ((And)formula2).getRight();
        Iff iff = new Iff(formula3, formula4);
        ProofLine proofLine = new ProofLine((Formula)iff, "<goal>", proofWindow, this.proof);
        List<ProofLine> list = Collections.synchronizedList(new LinkedList());
        list.add(proofLine);
        Justification justification = new Justification("\u2194E2", list);
        this.firstLine.setJustification(justification);
        int n = this.proof.getIndex(this.firstLine);
        this.proof.addItem(n, proofLine);
        proofWindow.commitSaveState();
    }

    private void applyForwards() throws Exception {
        Formula formula = ((Iff)this.forwardLine.getFormula()).getLeft();
        Formula formula2 = ((Iff)this.forwardLine.getFormula()).getRight();
        ProofWindow proofWindow = this.proof.getParentWindow();
        Or or = new Or(new And(formula, formula2), new And(new Not(formula), new Not(formula2)));
        ProofLine proofLine = new ProofLine((Formula)or, "\u2194E", proofWindow, this.proof);
        List<ProofLine> list = Collections.synchronizedList(new LinkedList());
        list.add(this.forwardLine);
        Justification justification = new Justification("\u2194E2", list);
        proofLine.setJustification(justification);
        int n = this.proof.getIndex(this.firstLine);
        this.proof.addItem(n, proofLine);
        proofWindow.commitSaveState();
    }
}

