/*
 * Decompiled with CFR 0.152.
 */
package Pandora.NDRules;

import Pandora.Help.ErrorMessages;
import Pandora.Justification;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Implies;
import Pandora.NDRules.NDRule;
import Pandora.ProofBox;
import Pandora.ProofLine;
import Pandora.ProofWindow;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ImpliesElim
extends NDRule {
    private ProofLine impliesLine = null;
    private ProofLine forwardLine = null;
    private boolean normalBackwards = true;

    public ImpliesElim(ProofBox proofBox) {
        super(proofBox);
    }

    @Override
    public void addLine(ProofLine proofLine) throws Exception {
        if (this.impliesLine == null) {
            this.impliesLine = proofLine;
        } else if (this.isForwards) {
            if (this.forwardLine == null) {
                this.forwardLine = proofLine;
            }
        } else {
            this.proof.deselectAll();
            throw new Exception("The correct number of lines have already been selected for this method.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void correctLines() throws Exception {
        Formula formula = this.impliesLine.getFormula();
        if (formula instanceof Implies) {
            if (!this.isForwards) return;
            Formula formula2 = this.forwardLine.getFormula();
            ProofLine proofLine = this.impliesLine;
            this.impliesLine = this.forwardLine;
            this.forwardLine = proofLine;
            return;
        }
        if (!this.isForwards) {
            this.proof.deselectAll();
            throw new Exception(ErrorMessages.arrow);
        }
        if (this.forwardLine.getFormula() instanceof Implies) {
            ProofLine proofLine = this.impliesLine;
            this.impliesLine = this.forwardLine;
            this.forwardLine = proofLine;
            return;
        }
        this.proof.deselectAll();
        throw new Exception(ErrorMessages.arrow);
    }

    @Override
    public void check() throws Exception {
        try {
            this.correctLines();
            if (this.haveAll()) {
                if (this.isForwards) {
                    this.checkForwards();
                } else {
                    this.checkBackwards();
                }
            }
        }
        catch (Exception exception) {
            this.proof.deselectAll();
            throw exception;
        }
    }

    @Override
    public boolean haveAll() {
        return this.impliesLine != null && this.firstLine != null && (!this.isForwards || this.isForwards && this.forwardLine != null);
    }

    private void checkBackwards() throws Exception {
        if (!(this.impliesLine.getFormula() instanceof Implies)) {
            this.proof.deselectAll();
            throw new Exception(ErrorMessages.arrow);
        }
        Formula formula = ((Implies)this.impliesLine.getFormula()).getRight();
        Formula formula2 = this.firstLine.getFormula();
        if (!formula2.display().equals(formula.display())) {
            this.normalBackwards = false;
        }
    }

    private int count(Formula formula) {
        return formula.getAtoms().size();
    }

    private void checkForwards() throws Exception {
        Serializable serializable;
        if (!(this.impliesLine.getFormula() instanceof Implies) && !(this.forwardLine.getFormula() instanceof Implies)) {
            throw new Exception(ErrorMessages.arrow);
        }
        int n = this.count(this.impliesLine.getFormula());
        int n2 = this.count(this.forwardLine.getFormula());
        if (!(this.impliesLine.getFormula() instanceof Implies)) {
            serializable = this.impliesLine;
            this.impliesLine = this.forwardLine;
            this.forwardLine = serializable;
        } else if (n < n2) {
            serializable = this.impliesLine;
            this.impliesLine = this.forwardLine;
            this.forwardLine = serializable;
        }
        serializable = ((Implies)this.impliesLine.getFormula()).getLeft();
        Formula formula = this.forwardLine.getFormula();
        if (!formula.display().equals(((Formula)serializable).display())) {
            this.proof.deselectAll();
            throw new Exception("The elimination line must equal the left hand side of the implication.");
        }
    }

    @Override
    public void apply() throws Exception {
        if (this.isForwards) {
            this.applyForwards();
        } else {
            this.applyBackwards();
        }
    }

    private void applyBackwards() {
        if (this.normalBackwards) {
            Formula formula = ((Implies)this.impliesLine.getFormula()).getLeft();
            ProofWindow proofWindow = this.proof.getParentWindow();
            ProofLine proofLine = new ProofLine(formula, "<goal>", proofWindow, this.proof);
            int n = this.proof.getIndex(this.firstLine);
            this.proof.addItem(n, proofLine);
            List<ProofLine> list = Collections.synchronizedList(new LinkedList());
            list.add(this.impliesLine);
            list.add(proofLine);
            Justification justification = new Justification("\u2192E", list);
            this.firstLine.setJustification(justification);
            proofWindow.commitSaveState();
        } else {
            Formula formula = ((Implies)this.impliesLine.getFormula()).getLeft();
            Formula formula2 = ((Implies)this.impliesLine.getFormula()).getRight();
            ProofWindow proofWindow = this.proof.getParentWindow();
            ProofLine proofLine = new ProofLine(formula, "<goal>", proofWindow, this.proof);
            List<ProofLine> list = Collections.synchronizedList(new LinkedList());
            list.add(this.impliesLine);
            list.add(proofLine);
            Justification justification = new Justification("\u2192E", list);
            ProofLine proofLine2 = new ProofLine(formula2, justification, proofWindow, this.proof);
            ProofLine proofLine3 = new ProofLine(null, "", proofWindow, this.proof);
            int n = this.proof.getIndex(this.firstLine);
            this.proof.addItem(n, proofLine3);
            this.proof.addItem(n, proofLine2);
            this.proof.addItem(n, proofLine);
            proofWindow.commitSaveState();
        }
    }

    private void applyForwards() {
        Formula formula = ((Implies)this.impliesLine.getFormula()).getRight();
        List<ProofLine> list = Collections.synchronizedList(new LinkedList());
        list.add(this.impliesLine);
        list.add(this.forwardLine);
        Justification justification = new Justification("\u2192E", list);
        ProofWindow proofWindow = this.proof.getParentWindow();
        ProofLine proofLine = new ProofLine(formula, justification, proofWindow, this.proof);
        int n = this.proof.getIndex(this.firstLine);
        this.proof.addItem(n, proofLine);
        proofWindow.commitSaveState();
    }
}

